/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObjDefaultImpl;
import com.trs.components.common.publish.domain.PublishServer;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskDispatcher;
import com.trs.components.common.publish.domain.taskdispatch.IPublishTaskMgr;
import com.trs.components.common.publish.persistent.element.IPublishContent;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.taskdispatch.PublishTask;
import com.trs.components.metadata.center.MetaViewData;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.wcm.content.domain.AppendixMgr;
import com.trs.components.wcm.content.domain.DocReplyMgr;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.domain.IContentSynMgr;
import com.trs.components.wcm.content.domain.RelationMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChannelSyn;
import com.trs.components.wcm.content.persistent.ChannelSyns;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.ChnlDocs;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.DocumentSyn;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyBitsValue;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Report;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ContentSynMgr
implements IContentSynMgr,
IObjectLCListenerOnAdd,
IObjectLCListenerOnModify {
    private static Logger logger = Logger.getLogger(ContentSynMgr.class);
    private DocumentMgr m_currDocumentMgr = null;
    private AppendixMgr m_oAppendixMgr = null;
    private DocReplyMgr m_oDocReplyMgr = null;
    private RelationMgr m_oRelationMgr = (RelationMgr)DreamFactory.createObjectById("RelationMgr");

    public ContentSynMgr() {
        this.m_oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
        this.m_oDocReplyMgr = (DocReplyMgr)DreamFactory.createObjectById("DocReplyMgr");
    }

    @Override
    public void synContent(String _sSynType, Document _document) throws WCMException {
        this.synContent(_sSynType, _document, true);
    }

    @Override
    public void synContent(String _sSynType, Channel _channel, Document _document, boolean _bIgnorePublishAction) throws WCMException {
        if (_channel == null || _document == null) {
            return;
        }
        int nSrcChannelId = _channel.getId();
        ChnlDoc chnldoc = ChnlDoc.findByDocAndChnl(_document, _channel);
        if (chnldoc == null) {
            return;
        }
        WCMFilter filter = new WCMFilter("", "SRCCHANNEL=?", "");
        filter.addSearchValues(nSrcChannelId);
        ChannelSyns syns = ChannelSyns.openWCMObjs(null, filter);
        if (syns.isEmpty()) {
            return;
        }
        int nSize = syns.size();
        for (int oI = 0; oI < nSize; ++oI) {
            ChannelSyn syn = (ChannelSyn)syns.getAt(oI);
            this.synContent(_sSynType, _channel, _document, syn, _bIgnorePublishAction);
        }
    }

    @Override
    public void synContent(String _sSynType, Document _document, boolean _bIgnorePublishAction) throws WCMException {
        int nSrcChannelId = _document.getChannelId();
        if (nSrcChannelId <= 0) {
            return;
        }
        Channel oSrcChannel = _document.getChannel();
        if (oSrcChannel == null) {
            return;
        }
        WCMFilter filter = new WCMFilter("", "SRCCHANNEL=?", "");
        filter.addSearchValues(nSrcChannelId);
        ChannelSyns syns = ChannelSyns.openWCMObjs(null, filter);
        if (syns.isEmpty()) {
            return;
        }
        _sSynType = _sSynType.toUpperCase();
        int nSize = syns.size();
        for (int oI = 0; oI < nSize; ++oI) {
            ChannelSyn syn = (ChannelSyn)syns.getAt(oI);
            this.synContent(_sSynType, oSrcChannel, _document, syn, _bIgnorePublishAction);
        }
    }

    private void synContent(String _sSynType, Channel _oSrcChannel, Document _document, ChannelSyn _syn, boolean _bIgnorePublishAction) throws WCMException {
        logger.debug((Object)("do syn[" + _document + "] ...."));
        if (_syn == null) {
            return;
        }
        logger.debug((Object)("to channel[ID=" + _syn.getToChannelId() + "]"));
        CMyDateTime now = CMyDateTime.now();
        if (_syn.getStartTime().compareTo(now) > 0L || _syn.getEndTime().compareTo(now) < 0L) {
            return;
        }
        logger.debug((Object)"synContent.1");
        if (_syn.getDocStartTime().compareTo(_document.getCrTime()) > 0L) {
            return;
        }
        logger.debug((Object)"synContent.2");
        String sSynTypes = _syn.getPropertyAsString("SynTypes", "NEW").toUpperCase();
        _sSynType = _sSynType.toUpperCase();
        if (("," + sSynTypes + ",").indexOf("," + _sSynType + ",") < 0) {
            return;
        }
        logger.debug((Object)"synContent.3");
        Channel toChannel = _syn.getToChannel();
        if (toChannel == null || toChannel.isDeleted()) {
            return;
        }
        logger.debug((Object)"synContent.4");
        if (_sSynType.equals("MODIFY")) {
            String sStatusIds = _syn.getStatusIds();
            if (("," + sStatusIds + ",").indexOf("," + _document.getStatusId() + ",") < 0) {
                return;
            }
        }
        String sWhereSQL = _syn.getWhereSql();
        if (!this.isMeetWith(_document.getId(), sWhereSQL)) {
            return;
        }
        int nType = _syn.getTransmitType();
        Document oNewDocument = this.transmitDocument(_document, _oSrcChannel, toChannel, nType);
        if (!_bIgnorePublishAction && this.isDoPublish(_syn, _sSynType)) {
            this.publishNewContent(toChannel, oNewDocument);
        }
    }

    private void recordTransmited(int _nTargetChannelId, int _nSynDocumentId) throws WCMException {
        DocumentSyn docsyn = new DocumentSyn();
        docsyn.setChannelId(_nTargetChannelId);
        docsyn.setDocumentId(_nSynDocumentId);
        docsyn.insert();
    }

    private DocumentMgr getDocumentMgr() {
        if (this.m_currDocumentMgr != null) {
            return this.m_currDocumentMgr;
        }
        this.m_currDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        return this.m_currDocumentMgr;
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        logger.debug((Object)("do syn[Type=" + _oObjAdded.getWCMType() + "]......"));
        try {
            switch (_oObjAdded.getWCMType()) {
                case 614: {
                    ChnlDoc chnlDoc = (ChnlDoc)_oObjAdded;
                    if (chnlDoc.getStatusId() == 1028) {
                        return;
                    }
                    logger.debug((Object)("DOCKIND=" + chnlDoc.getPropertyAsInt("DOCKIND", 0)));
                    if (chnlDoc.getPropertyAsInt("DOCKIND", 0) == 0) {
                        this.synContent("NEW", chnlDoc.getChannel(), chnlDoc.getDocument(), true);
                    }
                    break;
                }
                default: {
                    if (_oObjAdded instanceof CMSObjDefaultImpl && _oObjAdded.getDbTableName().startsWith("WCMMetaTable")) {
                        this.synContent("NEW", (CMSObjDefaultImpl)_oObjAdded);
                    }
                    break;
                }
            }
        }
        catch (Throwable e) {
            logger.error((Object)"Fail to syn content", e);
        }
    }

    @Override
    public void synContent(String _sSynType, CMSObjDefaultImpl _oMetaData) throws WCMException {
        int nMetaDataId = _oMetaData.getPropertyAsInt("MetaDataId", 0);
        Document document = Document.findById(nMetaDataId, "DocId,DocStatus,DocType,DocKind,DocChannel,CrUser,CrTime,SiteId,DocRelTime,SrcSiteId,CRDEPT,DocVersion");
        if (document.getStatusId() == 1028) {
            return;
        }
        int nSrcChannelId = _oMetaData.getPropertyAsInt("ChannelId", 0);
        if (nSrcChannelId <= 0) {
            return;
        }
        Channel oSrcChannel = Channel.findById(nSrcChannelId);
        if (oSrcChannel == null) {
            return;
        }
        WCMFilter filter = new WCMFilter("", "SRCCHANNEL=?", "");
        filter.addSearchValues(nSrcChannelId);
        ChannelSyns syns = ChannelSyns.openWCMObjs(null, filter);
        if (syns.isEmpty()) {
            return;
        }
        _sSynType = _sSynType.toUpperCase();
        int nSize = syns.size();
        for (int oI = 0; oI < nSize; ++oI) {
            ChannelSyn syn = (ChannelSyn)syns.getAt(oI);
            this.synContent(_sSynType, oSrcChannel, _oMetaData, document, syn);
        }
    }

    private void synContent(String _sSynType, Channel _oSrcChannel, CMSObjDefaultImpl _oMetaData, Document _document, ChannelSyn _syn) throws WCMException {
        if (_syn == null) {
            return;
        }
        CMyDateTime now = CMyDateTime.now();
        if (_syn.getStartTime().compareTo(now) > 0L || _syn.getEndTime().compareTo(now) < 0L) {
            return;
        }
        if (_syn.getDocStartTime().compareTo(_oMetaData.getCrTime()) > 0L) {
            return;
        }
        String sSynTypes = _syn.getPropertyAsString("SynTypes", "NEW").toUpperCase();
        _sSynType = _sSynType.toUpperCase();
        if (("," + sSynTypes + ",").indexOf("," + _sSynType + ",") < 0) {
            return;
        }
        Channel toChannel = _syn.getToChannel();
        if (toChannel == null || toChannel.isDeleted()) {
            return;
        }
        if (_sSynType.equals("MODIFY")) {
            String sStatusIds = _syn.getStatusIds();
            if (("," + sStatusIds + ",").indexOf("," + _document.getStatusId() + ",") < 0) {
                return;
            }
        }
        String sWhereSQL = _syn.getWhereSql();
        if (!this.isMeetWith(_document.getId(), sWhereSQL)) {
            return;
        }
        int nType = _syn.getTransmitType();
        Document oNewDocument = this.transmitDocument(_document, _oSrcChannel, toChannel, nType);
        if (this.isDoPublish(_syn, _sSynType)) {
            this.publishNewContent(toChannel, oNewDocument);
        }
    }

    private void publishNewContent(Channel _toChannel, Document _oNewDocument) throws WCMException {
        IPublishFolder folder = (IPublishFolder)PublishElementFactory.makeElementFrom(_toChannel);
        IPublishContent content = PublishElementFactory.makeContentFrom(_oNewDocument, folder);
        boolean bIgnoreDestRestrict = ConfigServer.getServer().getSysConfigValue("PUB_CONT_IGONRE_DEST_RESTRICT", "false").trim().equalsIgnoreCase("true");
        boolean bNeedStatusCheck = ConfigServer.getServer().getSysConfigValue("DIRECTPUB_STATUS_CHECK", "false").trim().equalsIgnoreCase("true");
        if (bIgnoreDestRestrict && !bNeedStatusCheck) {
            IPublishFolder channel = content.getFolder();
            if (!channel.canDoDetailPageTask() && content.getDetailTemplate() == null) {
                throw new WCMException(I18NMessage.get(PublishServer.class, "PublishServer.label7", "\u6240\u5728\u7684Folder[") + channel.getInfo() + I18NMessage.get(PublishServer.class, "PublishServer.label8", "]\u4e0d\u5141\u8bb8\u53d1\u5e03\u7ec6\u89c8\uff01"));
            }
        } else {
            content.validateCanDoPub();
        }
        IPublishTaskMgr m_taskManager = (IPublishTaskMgr)DreamFactory.createObjectById("IPublishTaskMgr");
        IPublishTaskDispatcher m_taskDispatcher = (IPublishTaskDispatcher)DreamFactory.createObjectById("IPublishTaskDispatcher");
        PublishTask task = m_taskManager.createContentPublishTask(content, 3);
        if (task == null) {
            return;
        }
        m_taskDispatcher.pushTask(task);
    }

    private boolean isDoPublish(ChannelSyn _syn, String _sCurrSynType) {
        if (!_sCurrSynType.equals("PUBLISH")) {
            return false;
        }
        int nOperAfter = _syn.getPropertyAsInt("OperAfter", 0);
        CMyBitsValue oBitsValue = new CMyBitsValue(nOperAfter);
        return oBitsValue.getBit(0);
    }

    private Document copyMetaViewData(int _nSrcMetaDataId, Document _document, Channel _toChannel) throws WCMException {
        MetaViewData metaViewData = MetaViewData.findById(_nSrcMetaDataId);
        return this.copyMetaViewData(metaViewData, _document, _toChannel);
    }

    private Document copyMetaViewData(MetaViewData _oMetaViewData, Document _document, Channel _toChannel) throws WCMException {
        boolean bDocumentInFlowOnCopy;
        User currUser = ContextHelper.getLoginUser();
        int nSrcMetaDataId = _oMetaViewData.getMetaDataId();
        MetaViewData newMetaViewData = (MetaViewData)_oMetaViewData.cloneToNewObj();
        MetaView view = _oMetaViewData.getMetaView();
        newMetaViewData.setMetaView(view);
        newMetaViewData.setProperty("channelId", _toChannel.getId());
        if (view.isMultiTable()) {
            String sTableName = "WCMMetaRelation" + view.getId();
            CMSObjDefaultImpl oRelationTablePO = new CMSObjDefaultImpl(sTableName, "MetaDataId");
            boolean bFind = oRelationTablePO.loadById(nSrcMetaDataId, null);
            if (bFind) {
                Enumeration<String> enPropNames = oRelationTablePO.getProperties().keys();
                while (enPropNames.hasMoreElements()) {
                    String sPropName = enPropNames.nextElement();
                    if (!sPropName.startsWith("WCMMetaTable".toUpperCase())) continue;
                    newMetaViewData.setProperty(sPropName, oRelationTablePO.getProperty(sPropName));
                }
            }
            IMetaDataDefCacheMgr m_oDataDefCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
            HashMap hFields = m_oDataDefCacheMgr.getMetaViewFields(view.getId());
            for (MetaViewField field : hFields.values()) {
                if (field == null || field.isFromMainTable()) continue;
                newMetaViewData.removeProperty(field.getName());
            }
        }
        newMetaViewData.save(currUser);
        Document newDoc = Document.findById(newMetaViewData.getId(), "DocId,DocStatus,DocType,DocKind,DocChannel,DocVersion, CrUser,CrTime,SiteId");
        if (newDoc != null && (bDocumentInFlowOnCopy = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("DOCUMENT_INFLOW_ONCOPY", "false")))) {
            WCMProcessServiceHelper.startDocumentInFlow(currUser, newDoc, true);
        }
        if (_oMetaViewData.getId() != newMetaViewData.getId()) {
            AppendixMgr oAppendixMgr = (AppendixMgr)DreamFactory.createObjectById("AppendixMgr");
            oAppendixMgr.copyAppendixes(_document, newDoc);
        }
        return newDoc;
    }

    @Override
    public void synContent(String _sSynType, MetaViewData _oMetaData) throws WCMException {
        logger.debug((Object)"synContent.MetaViewData.1");
        Document document = _oMetaData.getDocument();
        if (document.getStatusId() == 1028) {
            return;
        }
        int nSrcChannelId = _oMetaData.getChannelId();
        if (nSrcChannelId <= 0) {
            return;
        }
        Channel oSrcChannel = Channel.findById(nSrcChannelId);
        if (oSrcChannel == null) {
            return;
        }
        logger.debug((Object)"synContent.MetaViewData.2");
        WCMFilter filter = new WCMFilter("", "SRCCHANNEL=?", "");
        filter.addSearchValues(nSrcChannelId);
        ChannelSyns syns = ChannelSyns.openWCMObjs(null, filter);
        if (syns.isEmpty()) {
            return;
        }
        _sSynType = _sSynType.toUpperCase();
        int nSize = syns.size();
        for (int oI = 0; oI < nSize; ++oI) {
            ChannelSyn syn = (ChannelSyn)syns.getAt(oI);
            this.synContent(_sSynType, oSrcChannel, _oMetaData, document, syn);
        }
    }

    private void synContent(String _sSynType, Channel _oSrcChannel, MetaViewData _oMetaData, Document _document, ChannelSyn _syn) throws WCMException {
        if (_syn == null) {
            return;
        }
        logger.debug((Object)"synContent.MetaViewData.syn.1");
        CMyDateTime now = CMyDateTime.now();
        if (_syn.getStartTime().compareTo(now) > 0L || _syn.getEndTime().compareTo(now) < 0L) {
            return;
        }
        if (_syn.getDocStartTime().compareTo(_oMetaData.getCrTime()) > 0L) {
            return;
        }
        logger.debug((Object)"synContent.MetaViewData.syn.2");
        String sSynTypes = _syn.getPropertyAsString("SynTypes", "NEW").toUpperCase();
        _sSynType = _sSynType.toUpperCase();
        if (("," + sSynTypes + ",").indexOf("," + _sSynType + ",") < 0) {
            return;
        }
        logger.debug((Object)"synContent.MetaViewData.syn.3");
        Channel toChannel = _syn.getToChannel();
        if (toChannel == null || toChannel.isDeleted()) {
            return;
        }
        int nMetaDataId = _oMetaData.getPropertyAsInt("MetaDataId", 0);
        if (_sSynType.equals("MODIFY")) {
            String sStatusIds = _syn.getStatusIds();
            if (("," + sStatusIds + ",").indexOf("," + _document.getStatusId() + ",") < 0) {
                return;
            }
        }
        logger.debug((Object)"synContent.MetaViewData.syn.4");
        if (DocumentSyn.isSyned(toChannel.getId(), nMetaDataId)) {
            return;
        }
        logger.debug((Object)"synContent.MetaViewData.syn.5");
        String sWhereSQL = _syn.getWhereSql();
        if (!this.isMeetWith(nMetaDataId, sWhereSQL)) {
            return;
        }
        DocumentMgr documentMgr = this.getDocumentMgr();
        Document oNewDocument = _document;
        int nType = _syn.getTransmitType();
        switch (nType) {
            case 1: {
                oNewDocument = this.copyMetaViewData(_oMetaData, _document, toChannel);
                break;
            }
            case 2: {
                documentMgr.quoteTo(_document, toChannel);
                break;
            }
            case 3: {
                documentMgr.mirrorTo(_document, toChannel);
                break;
            }
            default: {
                logger.error((Object)("auto transmit documents failed,caused by invalid transmit type[" + nType + "]!"));
            }
        }
        logger.debug((Object)"synContent.MetaViewData.syn.6");
        if (this.isDoPublish(_syn, _sSynType)) {
            this.publishNewContent(toChannel, oNewDocument);
        }
        logger.debug((Object)"synContent.MetaViewData.syn.7");
        this.recordTransmited(toChannel.getId(), _oMetaData.getMetaDataId());
    }

    private boolean isMeetWith(int _nDocId, String _sWhereSQL) throws WCMException {
        if (CMyString.isEmpty(_sWhereSQL)) {
            return true;
        }
        String sQueryExistsSQL = "select 1 from WCMDocument where DocId=? and (" + _sWhereSQL + ")";
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(sQueryExistsSQL + "\nDocId:" + _nDocId));
        }
        int nResult = DBManager.getDBManager().sqlExecuteIntQuery(sQueryExistsSQL, new int[]{_nDocId});
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\n nResult: " + nResult));
        }
        return nResult == 1;
    }

    @Override
    public void synContent(ChannelSyn _syn) throws WCMException {
        Channel oSrcChannel = _syn.getSrcChannel();
        if (oSrcChannel == null) {
            throw new WCMException("\u88ab\u540c\u6b65\u7684\u680f\u76ee\u4e0d\u5b58\u5728\uff01[\u680f\u76eeID=" + _syn.getSrcChannelId() + "]");
        }
        Channel toChannel = _syn.getToChannel();
        if (toChannel == null) {
            throw new WCMException("\u540c\u6b65\u76ee\u6807\u680f\u76ee\u4e0d\u5b58\u5728\uff01[\u680f\u76eeID=" + _syn.getToChannelId() + "]");
        }
        if (toChannel.isDeleted()) {
            return;
        }
        CMyDateTime dtDocStartTime = _syn.getDocStartTime();
        String sSynTypes = _syn.getPropertyAsString("SynTypes", "NEW,").toUpperCase();
        String sStatusIds = null;
        sStatusIds = ("," + sSynTypes + ",").indexOf("," + "NEW".toUpperCase() + ",") >= 0 ? null : (("," + sSynTypes + ",").indexOf("," + "MODIFY".toUpperCase() + ",") >= 0 ? _syn.getStatusIds() : (sSynTypes.equals("PUBLISH".toUpperCase()) ? String.valueOf(10) : null));
        String sWhereSQL = _syn.getWhereSql();
        StringBuffer whereBuff = new StringBuffer(256);
        whereBuff.append("ChnlId=? and CrTime>=? and ");
        if (CMyString.isEmpty(sStatusIds)) {
            whereBuff.append("DocStatus>=1");
        } else {
            whereBuff.append("DocStatus in (");
            whereBuff.append(sStatusIds);
            whereBuff.append(')');
        }
        whereBuff.append(" and not exists(select 1 from WCMDOCSYN t where ");
        whereBuff.append("t.ChnlId=? and t.DocId=WCMCHNLDOC.DocId)");
        if (!CMyString.isEmpty(sWhereSQL)) {
            whereBuff.append(" and exists(select 1 from WCMDocument where (");
            whereBuff.append(sWhereSQL);
            whereBuff.append(") and WCMDocument.DocId=WCMChnlDoc.DocId)");
        }
        WCMFilter filter = new WCMFilter("WCMCHNLDOC", "", "");
        filter.setWhere(whereBuff.toString());
        filter.addSearchValues(oSrcChannel.getId());
        filter.addSearchValues(dtDocStartTime);
        filter.addSearchValues(toChannel.getId());
        String sOrderBy = "DocOrder desc";
        filter.setOrder(sOrderBy);
        filter.setSelect("RECID,DOCID");
        ChnlDocs chnldocs = new ChnlDocs(null);
        chnldocs.open(filter);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)filter);
        }
        if (chnldocs.isEmpty()) {
            return;
        }
        int size = chnldocs.size();
        int nTransmitType = _syn.getTransmitType();
        String sSelectFields = nTransmitType == 1 ? "*" : "DOCID,DocTitle,DocType,DocKeyWords,DocStatus,DocKind,DocChannel,SiteId,SrcSiteId,CrDept,DocPeople,DocRelTime, DocSource,DocSourceName,CrUser,CrTime,ATTACHPIC";
        for (int i = size - 1; i >= 0; --i) {
            ChnlDoc chnldoc = (ChnlDoc)chnldocs.getAt(i);
            if (chnldoc == null) continue;
            int nDocId = chnldoc.getDocId();
            Document document = Document.findById(nDocId, sSelectFields);
            this.transmitDocument(document, oSrcChannel, toChannel, nTransmitType);
        }
    }

    private Document transmitDocument(Document _document, Channel _oSrcChannel, Channel _toChannel, int _nTransmitType) throws WCMException {
        logger.debug((Object)"transmitDocument.....");
        DocumentMgr documentMgr = this.getDocumentMgr();
        if (DocumentSyn.isSyned(_toChannel.getId(), _document.getId())) {
            return _document;
        }
        logger.debug((Object)"transmitDocument.1");
        logger.debug((Object)("[TransmitType=" + _nTransmitType + "]"));
        Report result = null;
        Document newDocument = _document;
        switch (_nTransmitType) {
            case 1: {
                if (_document.getKindId() > 0) {
                    newDocument = this.copyMetaViewData(_document.getId(), _document, _toChannel);
                    break;
                }
                newDocument = documentMgr.copyDocument(_document, _oSrcChannel, _toChannel);
                if (newDocument == null || newDocument.getId() == _document.getId()) break;
                this.m_oAppendixMgr.copyAppendixes(_document, newDocument);
                this.m_oRelationMgr.copyRelations(_document, newDocument);
                this.m_oDocReplyMgr.copyDocReplys(_document, newDocument);
                break;
            }
            case 2: {
                logger.debug((Object)"transmitDocument.2");
                result = documentMgr.quoteTo(_document, _oSrcChannel, _toChannel);
                logger.debug((Object)"transmitDocument.3");
                break;
            }
            case 3: {
                result = documentMgr.mirrorTo(_document, _oSrcChannel, _toChannel);
                break;
            }
            default: {
                logger.error((Object)("auto transmit documents failed,caused by invalid transmit type[" + _nTransmitType + "]!"));
            }
        }
        if (result != null) {
            logger.debug((Object)result);
        }
        this.recordTransmited(_toChannel.getId(), _document.getId());
        return newDocument;
    }

    @Override
    public void notifyOnModifyObj(BaseObj objModified, int eventType) throws WCMException {
        try {
            switch (objModified.getWCMType()) {
                case 614: {
                    ChnlDoc chnlDoc = (ChnlDoc)objModified;
                    if (chnlDoc.getStatusId() == 1028) {
                        return;
                    }
                    if (!chnlDoc.isChangeProperty("ChnlId")) {
                        return;
                    }
                    logger.debug((Object)("DOCKIND=" + chnlDoc.getPropertyAsInt("DOCKIND", 0)));
                    if (chnlDoc.getPropertyAsInt("DOCKIND", 0) == 0) {
                        Channel newChannel = Channel.findById(chnlDoc.getNewPropertyAsInt("ChnlId", 0));
                        this.synContent("NEW", newChannel, chnlDoc.getDocument(), true);
                    }
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Throwable e) {
            logger.error((Object)"Fail to syn content", e);
        }
    }
}

