/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.wcm.content.domain;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.ChnlDoc;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;

public class ChnlDocLCListenerForRecordNotEntity
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel {
    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        if (!(_oObjAdded instanceof ChnlDoc)) {
            return;
        }
        String sValue = ConfigServer.getServer().getSysConfigValue("RECORD_NOT_ENTITY", "false");
        if (sValue.equalsIgnoreCase("false")) {
            return;
        }
        ChnlDoc oChnlDoc = (ChnlDoc)_oObjAdded;
        if (oChnlDoc.getModal() == 1) {
            return;
        }
        this.add(oChnlDoc.getDocument(), oChnlDoc);
    }

    private void add(Document oDocument, ChnlDoc oChnlDoc) throws WCMException {
        User currUser = ContextHelper.getLoginUser();
        Channel oChannel = oChnlDoc.getChannel();
        StringBuffer sbValue = new StringBuffer(100);
        sbValue.append("{").append(currUser.getName());
        sbValue.append(":").append(oChannel.getId());
        sbValue.append(":").append(oChannel.getName());
        sbValue.append("}");
        boolean bLink = oChnlDoc.getModal() == 2;
        String sFieldName = bLink ? "DOCLINKTO" : "DOCMIRRORTO";
        String sOldValue = CMyString.showNull(oDocument.getPropertyAsString(sFieldName));
        String sNewValue = sOldValue + sbValue.toString();
        String strSQL = "update WCMDOCUMENT set " + sFieldName + "=? where " + "DOCID" + "=?";
        Object[] parameters = new Object[]{sNewValue, new Integer(oDocument.getId())};
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{strSQL}, parameters);
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        if (!(_oObjDeleted instanceof ChnlDoc)) {
            return;
        }
        String sValue = ConfigServer.getServer().getSysConfigValue("RECORD_NOT_ENTITY", "false");
        if (sValue.equalsIgnoreCase("false")) {
            return;
        }
        ChnlDoc oChnlDoc = (ChnlDoc)_oObjDeleted;
        if (oChnlDoc.getModal() == 1) {
            return;
        }
        this.delete(oChnlDoc.getDocument(), oChnlDoc);
    }

    private void delete(Document oDocument, ChnlDoc oChnlDoc) throws WCMException {
        boolean bLink = oChnlDoc.getModal() == 2;
        String sFieldName = bLink ? "DOCLINKTO" : "DOCMIRRORTO";
        String sFieldValue = oDocument.getPropertyAsString(sFieldName);
        if (CMyString.isEmpty(sFieldValue)) {
            return;
        }
        User currUser = ContextHelper.getLoginUser();
        int nChannelId = oChnlDoc.getChannelId();
        StringBuffer sbPattern = new StringBuffer(100);
        sbPattern.append("\\{").append(currUser.getName());
        sbPattern.append(":").append(nChannelId);
        sbPattern.append("[^\\}]+\\}");
        sFieldValue = sFieldValue.replaceAll(sbPattern.toString(), "");
        String strSQL = "update WCMDOCUMENT set " + sFieldName + "=? where " + "DOCID" + "=?";
        Object[] parameters = new Object[]{sFieldValue, new Integer(oDocument.getId())};
        DBManager.getDBManager().sqlExecuteUpdate(new String[]{strSQL}, parameters);
    }
}

