/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.components.stat.HostObjHitsCount;
import com.trs.components.stat.IHitsCountHandler;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Document;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SiteHitsCountHandler
implements IHitsCountHandler {
    private Map hostHitsCountMap;
    private String hitsTime;
    private static Logger logger = Logger.getLogger(SiteHitsCountHandler.class);

    @Override
    public void handle(BaseObj obj, Map properties) throws WCMException {
        WebSite site;
        if (obj instanceof Document) {
            site = ((Document)obj).getChannel().getSite();
        } else if (obj instanceof Channel) {
            site = ((Channel)obj).getSite();
        } else if (obj instanceof WebSite) {
            site = (WebSite)obj;
        } else {
            return;
        }
        this.hitsTime = (String)properties.get("hitsTime");
        if (this.hostHitsCountMap == null) {
            this.hostHitsCountMap = new HashMap();
        }
        int nAllCount = 0;
        Integer allCount = (Integer)this.hostHitsCountMap.get(site);
        if (allCount != null) {
            nAllCount = allCount;
        }
        int nCount = Integer.parseInt((String)properties.get("hitsCount"));
        nAllCount += nCount;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\u8ffd\u52a0\u7684\u70b9\u51fb\u91cf\u60c5\u51b5\uff1a\nobj[" + site + "],all[" + nAllCount + "],current[" + nCount + "]"));
        }
        this.hostHitsCountMap.put(site, new Integer(nAllCount));
    }

    @Override
    public void notifyComplete() {
        if (this.hostHitsCountMap == null) {
            return;
        }
        for (Map.Entry entry : this.hostHitsCountMap.entrySet()) {
            WebSite site = (WebSite)entry.getKey();
            Integer count = (Integer)entry.getValue();
            try {
                HostObjHitsCount hostHitsCount = new HostObjHitsCount();
                hostHitsCount.setHostId(site.getId());
                hostHitsCount.setHostType(103);
                hostHitsCount.setObjCrTime(site.getCrTime());
                hostHitsCount.setObjCrUser(site.getCrUserName());
                hostHitsCount.setSpecial(false);
                hostHitsCount.setPropertyWithString("hitsTime", this.hitsTime);
                hostHitsCount.setHitsCount(count);
                hostHitsCount.save();
            }
            catch (Exception e) {
                logger.error((Object)("\u8bbe\u7f6e\u7ad9\u70b9\u5bf9\u8c61[" + site + "]\u7684\u70b9\u51fb\u91cf\u4fe1\u606f\u65f6\u5931\u8d25"), (Throwable)e);
            }
        }
    }
}

