/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.stat;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.cms.content.CMSObj;
import com.trs.components.stat.BaseStatHandler;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class DocStatHandler4SiteOfGroup
extends BaseStatHandler {
    private int nCrUserIndex = -1;
    private int nGroupId = 0;
    private User noAdminUserOrGroupAdmin = null;

    public DocStatHandler4SiteOfGroup(int _nGroupId) throws WCMException {
        this.nGroupId = _nGroupId;
        Group group = Group.findById(_nGroupId);
        Users users = group.getUsers(null);
        for (int i = 0; i < users.size(); ++i) {
            User ouser = (User)users.getAt(i);
            if (group.isAdministrator(ouser) || ouser.isAdministrator()) continue;
            this.noAdminUserOrGroupAdmin = ouser;
            break;
        }
    }

    @Override
    public void visitStatItem(ResultSet resultSet, int index) throws WCMException {
        int nSQLIndex = index;
        try {
            int nDataCount = resultSet.getInt(1);
            boolean bStatByChannel = false;
            String sStatByChannel = ConfigServer.getServer().getSysConfigValue("STAT_BY_CHANNELEDITAUTH", "false");
            if (sStatByChannel != null && "true".equalsIgnoreCase(sStatByChannel.trim())) {
                bStatByChannel = true;
            }
            if (ContextHelper.getLoginUser().isAdministrator()) {
                bStatByChannel = false;
            }
            if (bStatByChannel) {
                int siteid = resultSet.getInt(2);
                WebSite site = WebSite.findById(siteid);
                if (this.noAdminUserOrGroupAdmin == null) {
                    return;
                }
                if (AuthServer.hasRight(this.noAdminUserOrGroupAdmin, (CMSObj)site, 31)) {
                    String sKey = this.makeGroupKey(null, resultSet);
                    int nExistCount = this.getValue(nSQLIndex, sKey);
                    this.setValue(nSQLIndex, sKey, nDataCount += nExistCount);
                    this.addMajorObject(resultSet.getString(2));
                }
                return;
            }
            String sCrUser = resultSet.getString(this.nCrUserIndex);
            Groups oRelGroups = this.makeCurrRelGroups(sCrUser);
            int nSize = oRelGroups.size();
            for (int i = 0; i < nSize; ++i) {
                Group currGroup = (Group)oRelGroups.getAt(i);
                if (currGroup == null || currGroup.getId() != this.nGroupId) continue;
                String sKey = this.makeGroupKey(currGroup, resultSet);
                int nExistCount = this.getValue(nSQLIndex, sKey);
                this.setValue(nSQLIndex, sKey, nDataCount += nExistCount);
                this.addMajorObject(resultSet.getString(2));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void visitStart(ResultSet resultSet, int nSQLIndex) throws WCMException {
        super.visitStart(resultSet, nSQLIndex);
        try {
            ResultSetMetaData metaData = resultSet.getMetaData();
            int nColumnCount = metaData.getColumnCount();
            for (int i = 2; i <= nColumnCount; ++i) {
                if (!"CRUSER".equals(metaData.getColumnName(i).toUpperCase())) continue;
                this.nCrUserIndex = i;
                break;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private String makeGroupKey(Group group, ResultSet resultSet) throws SQLException {
        ResultSetMetaData metaData = resultSet.getMetaData();
        int nSiteId = resultSet.getInt(2);
        int nColumnCount = metaData.getColumnCount();
        String[] keys = new String[nColumnCount - 2];
        keys[0] = String.valueOf(nSiteId);
        for (int i = 1; i < nColumnCount - 2; ++i) {
            keys[i] = resultSet.getString(i + 2);
        }
        return this.makeKey(keys);
    }

    private Groups makeCurrRelGroups(String _sLowerCaseUserName) throws WCMException {
        Groups oCurrRelGroups = null;
        oCurrRelGroups = new Groups(null);
        User oCurrUser = User.findByName(_sLowerCaseUserName);
        if (oCurrUser == null) {
            return oCurrRelGroups;
        }
        Groups groups = oCurrUser.getGroups();
        int nSize = groups.size();
        for (int i = 0; i < nSize; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null) continue;
            for (Group parent = group; parent != null; parent = parent.getParent()) {
                oCurrRelGroups.addElement(parent);
            }
        }
        return oCurrRelGroups;
    }
}

