/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service.util;

import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class WCMJSPChecker {
    private static int RESPONSECODE_OK = 200;
    private static List _jsps = new ArrayList();
    private String _jsprooturi;
    private String _host = "localhost";
    private int _port = 80;
    private String _cookie;
    private String _username;
    private String _password;
    private String _authPage = "/j_security_check";
    protected Logger logger = Logger.getLogger(this.getClass());
    private boolean m_bNeedStore = false;
    private String m_sCheckPath = null;
    private String m_sApplicationRootPath = null;
    private String m_sApplicationName = null;

    public WCMJSPChecker(String jsprooturi) {
        this._jsprooturi = jsprooturi;
    }

    public WCMJSPChecker(String _sApplicationRootPath, String _sCheckPath, String host, int port, String _sApplicationName) {
        this.m_sApplicationRootPath = CMyString.setStrEndWith(_sApplicationRootPath, File.separatorChar);
        this.m_sCheckPath = _sCheckPath == null || (_sCheckPath = _sCheckPath.trim()).length() == 0 ? "" : CMyString.setStrEndWith(_sCheckPath, File.separatorChar);
        this.m_sApplicationName = _sApplicationName;
        this._jsprooturi = this.m_sApplicationRootPath + this.m_sCheckPath;
        this._host = host;
        this._port = port;
    }

    public void setAuthDetail(String username, String password, String authPage) {
        this._username = username;
        this._password = password;
        this._authPage = authPage;
    }

    public void setResult(boolean needStore) {
        this.m_bNeedStore = needStore;
    }

    public void run() {
        this.logger.debug((Object)"loading jsp file source...");
        _jsps.clear();
        List jsps = this.loadJsps(this._jsprooturi);
        this.logger.debug((Object)("_jsprooturi:" + this._jsprooturi));
        this.logger.debug((Object)"loaded,checking the files...");
        try {
            this._cookie = this.getCookie();
            this.logger.debug((Object)this._cookie);
        }
        catch (Exception e) {
            this.logger.error((Object)"Connect failed", (Throwable)e);
            throw new RuntimeException(e);
        }
        int numBad = 0;
        ArrayList<String> badJsps = new ArrayList<String>();
        for (int i = 0; i < jsps.size(); ++i) {
            String file = null;
            try {
                file = (String)jsps.get(i);
                int respCode = this.getResponseCodeForHttp(file);
                if (respCode == RESPONSECODE_OK) continue;
                this.logger.info((Object)("Error: " + file + "---RespCode=" + respCode));
                badJsps.add(file);
                ++numBad;
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("Error: " + file), (Throwable)e);
                badJsps.add(file);
                ++numBad;
            }
        }
        this.logger.info((Object)"============ done!");
        try {
            this.storeBadJsps(badJsps);
        }
        catch (Exception e) {
            this.logger.error((Object)"produce a summary file failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private List loadJsps(String jsprooturi) {
        FileService file = new FileService(jsprooturi);
        FileStore[] files = file.listFiles();
        FileStore tmp = null;
        if (files == null) {
            return _jsps;
        }
        for (int i = 0; i < files.length; ++i) {
            tmp = files[i];
            if (tmp.isDirectory()) {
                this.loadJsps(tmp.getPath());
                continue;
            }
            if (!tmp.getName().endsWith("jsp")) continue;
            String path = tmp.getPath();
            path = path.substring(this.m_sApplicationRootPath.length());
            path = path.replace('\\', '/');
            if (CMyString.isEmpty(this.m_sApplicationName)) {
                _jsps.add("/" + path);
                continue;
            }
            _jsps.add("/" + this.m_sApplicationName + "/" + path);
        }
        return _jsps;
    }

    private String getCookie() throws Exception {
        String cookieLine = null;
        Socket socket = new Socket(this._host, this._port);
        PrintWriter out = new PrintWriter(new OutputStreamWriter(socket.getOutputStream()));
        String target = this._authPage;
        out.print("POST " + target + " HTTP/1.0\r\n");
        out.print("Connection: close\r\n");
        out.print("Host: " + this._host + "\r\n");
        out.print("ContentTypeConfig-type: application/x-www-form-urlencoded\r\n");
        String postString = "j_username=" + this._username + "&j_password=" + this._password;
        out.print("ContentTypeConfig-length: " + postString.length() + "\r\n");
        out.print("\r\n");
        out.print(postString + "\r\n");
        out.print("\r\n");
        out.flush();
        BufferedReader buffreader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        String line = null;
        while ((line = buffreader.readLine()) != null) {
            this.logger.debug((Object)line);
            if (line.trim().length() == 0) break;
            if (!line.toLowerCase().startsWith("set-cookie:")) continue;
            cookieLine = line.substring("Set-Cookie:".length()).trim();
            int semicolon = cookieLine.indexOf(";");
            if (semicolon == -1) break;
            cookieLine = cookieLine.substring(0, semicolon).trim();
            break;
        }
        buffreader.close();
        out.close();
        socket.close();
        return cookieLine;
    }

    protected int getResponseCode(String file) throws Exception {
        int respCode = -1;
        Socket s = new Socket(this._host, this._port);
        PrintWriter out = new PrintWriter(new OutputStreamWriter(s.getOutputStream()));
        String target = file + "?jsp_precompile=true";
        out.print("GET " + target + " HTTP/1.0\r\n");
        out.print("Cookie: " + this._cookie + "\r\n");
        out.print("Connection: close\r\n");
        out.print("Host: " + this._host + "\r\n");
        out.print("\r\n");
        out.flush();
        BufferedReader buffreader = new BufferedReader(new InputStreamReader(s.getInputStream()));
        String line = buffreader.readLine();
        if (line != null) {
            StringTokenizer st = new StringTokenizer(line.trim());
            st.nextToken();
            respCode = Integer.parseInt(st.nextToken());
        }
        while ((line = buffreader.readLine()) != null && line.trim().length() != 0) {
        }
        StringBuffer buf = new StringBuffer();
        while ((line = buffreader.readLine()) != null) {
            buf.append(line).append("\n");
        }
        buffreader.close();
        out.close();
        s.close();
        return respCode;
    }

    private void storeBadJsps(List badJsps) throws Exception {
        if (this.m_bNeedStore) {
            this.logger.debug((Object)"creating summary file:badjsps.xml");
            String result = "./badjsps.txt";
            StringBuffer sbContent = new StringBuffer();
            sbContent.append("amount of badjsps:" + badJsps.size() + "\n");
            for (int i = 0; i < badJsps.size(); ++i) {
                sbContent.append((String)badJsps.get(i));
                sbContent.append("\n");
            }
            CMyFile.writeFile(result, sbContent.toString());
            this.logger.debug((Object)"done,you can check the summary file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getResponseCodeForHttp(String file) throws Exception {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("open " + file + " ..."));
        }
        HttpURLConnection urlconn = null;
        try {
            String target = file + "?jsp_precompile=true";
            URL url = new URL("http", this._host, this._port, target);
            urlconn = (HttpURLConnection)url.openConnection();
            urlconn.connect();
            int respCode = urlconn.getResponseCode();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("open " + file + ".ResponseCode=" + respCode));
            }
            int n = respCode;
            return n;
        }
        finally {
            try {
                if (urlconn != null) {
                    urlconn.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }
}

