/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.center.xml.MetaViewDataImporter;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.io.OutputStream;
import org.apache.log4j.Logger;

public class MetaDataImportService {
    private static Logger logger = Logger.getLogger(MetaDataImportService.class);
    private MetaView m_oMetaView;

    public String importMetaData(byte[] _pImportFileContent, String _sFileExt, String _sIdType, String _sId) {
        if ("C".equalsIgnoreCase(_sIdType)) {
            int nChnlId = Integer.parseInt(_sId);
            IMetaViewEmployerMgr mgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
            MetaView view = null;
            try {
                Channel channel = Channel.findById(nChnlId);
                view = mgr.getViewOfEmployer(channel);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.importMetaData(_pImportFileContent, _sFileExt, view);
        }
        return this.importMetaData(_pImportFileContent, _sFileExt, _sId);
    }

    public String importMetaData(byte[] _pImportFileContent, String _sFileExt) {
        return this.importMetaData(_pImportFileContent, _sFileExt, this.getView(0));
    }

    public String importMetaData(byte[] _pImportFileConent, String _sFileExt, String _sViewId) {
        int nId = Integer.parseInt(_sViewId);
        return this.importMetaData(_pImportFileConent, _sFileExt, this.getView(nId));
    }

    private String importMetaData(byte[] _pImportFileContent, String _sFileExt, MetaView _view) {
        String assertMessage = this.assertViewNotNull(_view);
        if (assertMessage != null) {
            return assertMessage;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"importDocuments...");
        }
        ContextHelper.initContext(User.getSystem());
        String sFileName = null;
        Reports aReports = new Reports("\u5bfc\u5165\u6587\u6863");
        try {
            sFileName = this.writeFile(_pImportFileContent, _sFileExt);
        }
        catch (Throwable e) {
            logger.error((Object)("\u4fdd\u5b58\u6587\u4ef6[" + sFileName + "]\u5931\u8d25\uff01"), e);
            aReports.setTitle("\u4ece\u6587\u4ef6[" + sFileName + "]\u4e2d\u5bfc\u5165\u6587\u6863\uff01");
            aReports.addFailedReport("\u4fdd\u5b58\u6587\u4ef6[" + sFileName + "]\u5931\u8d25\uff01", e);
            return aReports.toXML();
        }
        try {
            MetaViewDataImporter aImporter = new MetaViewDataImporter(User.getSystem(), _view, null);
            aImporter.setImportToCurrChannel(false);
            aImporter.setImportByChnlName(false);
            aReports = aImporter.importFromFile(1, sFileName, null);
            if (logger.isDebugEnabled() || !aReports.getFailedReporter().isEmpty() || !aReports.getWarnedReporter().isEmpty()) {
                logger.info((Object)"\u5bfc\u5165\u51fa\u73b0\u8b66\u544a\u6216\u8005\u5931\u8d25\uff01\u6216\u8005\u662f\u7531\u4e8e\u8c03\u8bd5\u5f00\u5173\u6253\u5f00\u4e86\uff01");
                logger.info((Object)("Success=[" + aReports.getSucessedReporter().size() + "]Fail=[" + aReports.getFailedReporter().size() + "]Warning=[" + aReports.getWarnedReporter().size() + "]"));
                logger.info((Object)aReports.toXML());
            }
        }
        catch (Throwable e) {
            logger.error((Object)("\u4ece\u6587\u4ef6[" + sFileName + "]\u4e2d\u5bfc\u5165\u6587\u6863\u5931\u8d25\uff01"), e);
            aReports.setTitle("\u4ece\u6587\u4ef6[" + sFileName + "]\u4e2d\u5bfc\u5165\u6587\u6863\uff01");
            aReports.addFailedReport("\u4ece\u6587\u4ef6[" + sFileName + "]\u4e2d\u5bfc\u5165\u6587\u6863\u5931\u8d25\uff01", e);
            return aReports.toXML();
        }
        return aReports.toXML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writeFile(byte[] _pFileContent, String _sFileExt) throws Exception {
        OutputStream fos = null;
        try {
            String sFileName = FilesMan.getFilesMan().getNextFilePathName("U0", _sFileExt);
            fos = new FileService(sFileName).getOutputStream();
            fos.write(_pFileContent);
            String string = sFileName;
            return string;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public String importMetaDataByFile(String _sUserName, String _sFileName, String _sIdType, String _sId) {
        if ("C".equalsIgnoreCase(_sIdType)) {
            int nChnlId = Integer.parseInt(_sId);
            IMetaViewEmployerMgr mgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
            MetaView view = null;
            try {
                Channel channel = Channel.findById(nChnlId);
                view = mgr.getViewOfEmployer(channel);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.importMetaDataByFile(_sUserName, _sFileName, view);
        }
        return this.importMetaDataByFile(_sUserName, _sFileName, _sId);
    }

    public String importMetaDataByFile(String _sUserName, String _sFileName, String _sViewId) {
        int nId = Integer.parseInt(_sViewId);
        return this.importMetaDataByFile(_sUserName, _sFileName, this.getView(nId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String importMetaDataByFile(String _sUserName, String _sFileName, MetaView _view) {
        String assertMessage = this.assertViewNotNull(_view);
        if (assertMessage != null) {
            return assertMessage;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("importDocumentsByLocalFile...[UserName=" + _sUserName + ", sFileName=" + _sFileName + "]"));
        }
        Reports aReports = new Reports("\u5bfc\u5165\u6587\u6863");
        String sFileName = _sFileName;
        if (!CMyFile.fileExists(sFileName)) {
            String sImportFileStoragePath = null;
            try {
                sImportFileStoragePath = ConfigServer.getServer().getSysConfigValue("IMPORT_FILE_PATH_META", "d:\\temp\\");
            }
            catch (Throwable e) {
                String sErrorInfo = "\u5185\u5bb9\u7ba1\u7406\u7cfb\u7edf\u7cfb\u7edf\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u51fa\u73b0\u5f02\u5e38\uff01\u786e\u8ba4\u7cfb\u7edf\u662f\u5426\u6b63\u5728\u542f\u52a8";
                logger.error((Object)sErrorInfo);
                aReports.setTitle("\u4ece\u6587\u4ef6[" + sFileName + "]\u4e2d\u5bfc\u5165\u6587\u6863\u5931\u8d25\u2014\u2014\u83b7\u53d6\u914d\u7f6e\u5f02\u5e38\uff01");
                aReports.addFailedReport(sErrorInfo, e);
                return aReports.toXML();
            }
            sImportFileStoragePath = CMyString.setStrEndWith(sImportFileStoragePath, File.separatorChar);
            if (!CMyFile.pathExists(sImportFileStoragePath)) {
                String sErrorInfo = "\u5185\u5bb9\u7ba1\u7406\u7cfb\u7edf\u7cfb\u7edf\u4e2d\u4fdd\u5b58SOAP\u5bfc\u5165\u6587\u4ef6\u76ee\u5f55\u914d\u7f6e\u5f97\u4e0d\u5bf9\uff01\u60a8\u53ef\u80fd\u6ca1\u6709\u914d\u7f6e\u6216\u8005\u914d\u7f6e\u9519\u8bef[\u9ed8\u8ba4\u503c=d:\\temp\\,\u5f53\u524d\u503c=" + sImportFileStoragePath + "]";
                logger.error((Object)sErrorInfo);
                aReports.setTitle("\u4ece\u6587\u4ef6[" + sFileName + "]\u4e2d\u5bfc\u5165\u6587\u6863\u5931\u8d25\u2014\u2014\u8def\u5f84\u4e0d\u5b58\u5728\uff01");
                aReports.addFailedReport(sErrorInfo, null);
                return aReports.toXML();
            }
            sFileName = CMyFile.extractFileName(sFileName);
            sFileName = sImportFileStoragePath + sFileName;
            if (!CMyFile.fileExists(sFileName)) {
                String sErrorInfo = "\u60a8\u6307\u5b9a\u7684\u5bfc\u5165\u6587\u4ef6\u5728\u5185\u5bb9\u7ba1\u7406\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff01\u8bf7\u68c0\u67e5\u63d0\u4ea4\u6570\u636e\u6bb5\u7684\u76ee\u5f55\u914d\u7f6e\u548c\u5185\u5bb9\u7ba1\u7406\u7cfb\u7edf\u914d\u7f6e\u4e00\u81f4[\u5f53\u524d\u6587\u4ef6=" + sFileName + "]";
                logger.error((Object)sErrorInfo);
                aReports.setTitle("\u4ece\u6587\u4ef6[" + sFileName + "]\u4e2d\u5bfc\u5165\u6587\u6863\u5931\u8d25\u2014\u2014\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
                aReports.addFailedReport(sErrorInfo, null);
                return aReports.toXML();
            }
        }
        User currUser = null;
        if (CMyString.isEmpty(_sUserName)) {
            currUser = User.getSystem();
        } else {
            try {
                currUser = User.findByName(_sUserName.trim());
                if (currUser == null) {
                    logger.error((Object)("\u5f53\u524d\u4f20\u5165\u7684\u7528\u6237[" + _sUserName + "]\u65e0\u6548\uff01"));
                    currUser = User.getSystem();
                }
            }
            catch (Exception e) {
                currUser = User.getSystem();
            }
        }
        ContextHelper.initContext(currUser);
        try {
            MetaViewDataImporter aImporter = new MetaViewDataImporter(User.getSystem(), _view, null);
            aImporter.setImportToCurrChannel(false);
            aReports = aImporter.importFromFile(1, sFileName, null);
            if (logger.isDebugEnabled() || !aReports.getFailedReporter().isEmpty() || !aReports.getWarnedReporter().isEmpty()) {
                logger.info((Object)"\u5bfc\u5165\u51fa\u73b0\u8b66\u544a\u6216\u8005\u5931\u8d25\uff01\u6216\u8005\u662f\u7531\u4e8e\u8c03\u8bd5\u5f00\u5173\u6253\u5f00\u4e86\uff01");
                logger.info((Object)("Success=[" + aReports.getSucessedReporter().size() + "]Fail=[" + aReports.getFailedReporter().size() + "]Warning=[" + aReports.getWarnedReporter().size() + "]"));
                logger.info((Object)aReports.toXML());
            }
        }
        catch (Throwable e) {
            logger.error((Object)("\u4ece\u6587\u4ef6[" + sFileName + "]\u4e2d\u5bfc\u5165\u6587\u6863\u5931\u8d25\uff01"), e);
            aReports.setTitle("\u4ece\u6587\u4ef6[" + sFileName + "]\u4e2d\u5bfc\u5165\u6587\u6863\uff01");
            aReports.addFailedReport("\u4ece\u6587\u4ef6[" + sFileName + "]\u4e2d\u5bfc\u5165\u6587\u6863\u5931\u8d25\uff01", e);
            String string = aReports.toXML();
            return string;
        }
        finally {
            ContextHelper.clear();
        }
        return aReports.toXML();
    }

    private String assertViewNotNull(MetaView view) {
        if (view != null) {
            return null;
        }
        Reports reports = new Reports("MetaView unfound.");
        reports.addFailedReport("MetaView==null", null);
        return reports.toXML();
    }

    public String importMetaDataByFile(String _sUserName, String _sFileName) {
        return this.importMetaDataByFile(_sUserName, _sFileName, this.getView(0));
    }

    private MetaView getView(int _nId) {
        try {
            if (_nId > 0) {
                return MetaView.findById(_nId);
            }
            if (this.m_oMetaView == null) {
                int id = 0;
                try {
                    id = Integer.parseInt(ConfigServer.getServer().getInitProperty("METAVIEWID_FOR_RADAR"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_oMetaView = MetaView.findById(id);
            }
            return this.m_oMetaView;
        }
        catch (Exception e) {
            return null;
        }
    }
}

