/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.service;

import com.trs.DreamFactory;
import com.trs.ajaxservice.JSONHelper;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.domain.IDepartmentMgr;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.content.WCMSystemObject;
import com.trs.cms.process.xml.FlowImporter;
import com.trs.components.metadata.MetaDataConstants;
import com.trs.components.metadata.center.IMetaViewEmployerMgr;
import com.trs.components.metadata.definition.ClassInfo;
import com.trs.components.metadata.definition.ClassInfoUtil;
import com.trs.components.metadata.definition.ClassInfos;
import com.trs.components.metadata.definition.IMetaDataDefCacheMgr;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDBField;
import com.trs.components.metadata.definition.MetaDBFields;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaDBTables;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.MetaViewFieldGroup;
import com.trs.components.metadata.definition.MetaViewFields;
import com.trs.components.metadata.definition.MetaViews;
import com.trs.components.metadata.definition.xml.MetaDataDDLImporter;
import com.trs.components.metadata.definition.xml.MetaViewExporter;
import com.trs.components.metadata.service.ClassInfoToChannelHelper;
import com.trs.components.metadata.service.ClassInfoToGroupCreator;
import com.trs.components.metadata.service.MetaViewImporter;
import com.trs.components.metadata.service.SynChildrenExecutorForViewEmploy;
import com.trs.components.metadata.service.ViewRangeConstants;
import com.trs.components.metadata.service.WCMFilterMakerForContainsChildren;
import com.trs.components.metadata.service.util.WCMJSPChecker;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.AttributesString;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Reports;
import com.trs.infra.util.database.FieldInfo;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.ISelfDefinedServiceProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Logger;

public class MetaDataDefServiceProvider
implements ISelfDefinedServiceProvider {
    public static final int POSITION_BEFORE = 1;
    public static final int POSITION_AFTER = 0;
    private IMetaDataDefMgr m_oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
    private IMetaViewEmployerMgr m_oMetaViewEmployerMgr = (IMetaViewEmployerMgr)DreamFactory.createObjectById("IMetaViewEmployerMgr");
    private static Logger m_oLogger = Logger.getLogger(MetaDataDefServiceProvider.class);

    public MetaDBTable saveDBTableInfo(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nOwnerType = _methodContext.getValue("OwnerType", 1);
        int nOwnerId = _methodContext.getValue("OwnerId", 1);
        MetaDBTable oDBTableInfo = null;
        int nObjectId = _methodContext.getObjectId();
        if (nObjectId == 0) {
            oDBTableInfo = MetaDBTable.createNewInstance();
            int nChannelId = _methodContext.getValue("ChannelId", 0);
            if (nChannelId > 0) {
                nOwnerType = 101;
                nOwnerId = nChannelId;
            }
            CMSObj owner = this.findOwner(nOwnerType, nOwnerId);
            this.validateRight(loginUser, owner);
            oDBTableInfo.setOwner(nOwnerType, nOwnerId);
        } else {
            oDBTableInfo = this.findDBTableInfo(nObjectId);
            this.validateRight(loginUser, oDBTableInfo);
            oDBTableInfo.validCanEditAndLock(loginUser);
        }
        String[] pLogicFields = new String[]{"ObjectId"};
        oDBTableInfo = (MetaDBTable)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, oDBTableInfo, pLogicFields);
        return this.m_oMetaDataDefMgr.save(loginUser, oDBTableInfo);
    }

    public MetaDBField saveDBFieldInfo(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        MetaDBTable oDBTableInfo = null;
        MetaDBField oDBFieldInfo = null;
        int nObjectId = _methodContext.getObjectId();
        if (nObjectId == 0) {
            oDBTableInfo = this.findDBTableInfo(_methodContext.getValue("TableInfoId", 0));
            oDBFieldInfo = MetaDBField.createNewInstance();
        } else {
            oDBFieldInfo = MetaDBField.findById(nObjectId);
            if (oDBFieldInfo == null) {
                throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label1", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u5143\u6570\u636e\u5b57\u6bb5\uff01[Id=") + nObjectId + "]");
            }
            oDBTableInfo = this.findDBTableInfo(oDBFieldInfo.getTableId());
            oDBFieldInfo.validCanEditAndLock(loginUser);
        }
        this.validateRight(loginUser, oDBTableInfo);
        String[] pLogicFields = new String[]{"ObjectId"};
        oDBFieldInfo = (MetaDBField)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, oDBFieldInfo, pLogicFields);
        return this.m_oMetaDataDefMgr.save(loginUser, oDBTableInfo, oDBFieldInfo);
    }

    public MetaDBTables queryDBTableInfos(MethodContext _oMethodContext) throws WCMException {
        User loginUser = this.getLoginUser();
        int iViewId = _oMethodContext.getValue("viewId", 0);
        int iChannelId = _oMethodContext.getValue("channelId", 0);
        MetaView oMetaView = null;
        if (iViewId != 0) {
            oMetaView = MetaView.findById(iViewId);
        } else if (iChannelId != 0) {
            oMetaView = this.m_oMetaViewEmployerMgr.getViewOfEmployer(Channel.findById(iChannelId));
        }
        if (oMetaView != null) {
            MetaDBTables oMetaDBTables = oMetaView.getOtherTables(loginUser, null);
            oMetaDBTables.addElement(oMetaView.getMainTable());
            return oMetaDBTables;
        }
        WCMFilter filter = _oMethodContext.getExtraWCMFilter();
        return MetaDBTables.openWCMObjs(loginUser, filter);
    }

    public MetaDBFields queryDBFieldInfos(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        MetaDBTable oDBTableInfo = this.findDBTableInfo(_methodContext.getValue("TableInfoId", 0));
        return this.m_oMetaDataDefMgr.getDFieldInfos(loginUser, oDBTableInfo, _methodContext.getExtraWCMFilter());
    }

    public MetaViewFields queryViewFieldInfos(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nViewId = _methodContext.getValue("ViewId", 0);
        int nChannelId = _methodContext.getValue("ChannelId", 0);
        MetaView view = null;
        if (nViewId > 0) {
            view = this.findViewById(nViewId);
        } else if (nChannelId > 0 && (view = this.m_oMetaViewEmployerMgr.getViewOfEmployer(this.findChannelById(nChannelId))) == null) {
            return null;
        }
        _methodContext.setValue("View", view);
        return this.m_oMetaDataDefMgr.getViewFields(loginUser, view, _methodContext.getExtraWCMFilter());
    }

    public MetaView getViewFromChannel(MethodContext _methodContext) throws Throwable {
        int nChannelId = _methodContext.getValue("channelId", 0);
        MetaView view = this.m_oMetaViewEmployerMgr.getViewOfEmployer(this.findChannelById(nChannelId));
        return view;
    }

    public MetaViews queryViews(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        return MetaViews.openWCMObjs(loginUser, _methodContext.getExtraWCMFilter());
    }

    public MetaViews queryViewsUsingClassInfo(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        ClassInfo oClassInfo = null;
        int nClassInfoId = _methodContext.getValue("ClassInfoId", 0);
        if (nClassInfoId != 0) {
            oClassInfo = ClassInfo.findById(nClassInfoId);
        }
        return this.m_oMetaDataDefMgr.getMetaViewsUsingClassInfo(loginUser, oClassInfo);
    }

    public ClassInfos queryClassInfosUsingMetaView(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        MetaView oMetaView = null;
        int nViewId = _methodContext.getValue("ViewId", 0);
        if (nViewId != 0) {
            oMetaView = MetaView.findById(nViewId);
        }
        return this.m_oMetaDataDefMgr.getClassInfosUsingMetaView(loginUser, oMetaView);
    }

    public MetaViews queryViewsUsintTable(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        if (!loginUser.isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label2", "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u65b0\u5efa\u5143\u6570\u636e\u7ed3\u6784\uff01"));
        }
        MetaDBTable oDBTableInfo = this.findDBTableInfo(_methodContext.getValue("TableInfoId", 0));
        return this.m_oMetaDataDefMgr.getViewsUsingTable(oDBTableInfo);
    }

    public boolean testCanDeleteDBTable(MetaDBTable dbTable) throws WCMException {
        String sTableName = MetaDataConstants.makeTrueTableName(dbTable.getName());
        String sTestSQL = "select count(MetaDataId) from " + sTableName;
        int nCount = DBManager.getDBManager().sqlExecuteIntQuery(sTestSQL);
        return nCount <= 0;
    }

    public Reports deleteDBTableInfo(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sDeletedIds = _methodContext.getObjectIds();
        MetaDBTables oDBTableInfos = MetaDBTables.findByIds(loginUser, sDeletedIds);
        Reports reports = new Reports(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label3", "\u5220\u9664\u5143\u6570\u636e\u7ed3\u6784"));
        int nSize = oDBTableInfos.size();
        for (int i = 0; i < nSize; ++i) {
            MetaDBTable oDBTableInfo = (MetaDBTable)oDBTableInfos.getAt(i);
            if (oDBTableInfo == null) continue;
            this.validateRight(loginUser, oDBTableInfo);
            try {
                if (!this.testCanDeleteDBTable(oDBTableInfo)) {
                    String sTip = CMyString.format(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label4", "\u4e0d\u80fd\u5220\u9664\u5143\u6570\u636e[{0}],\u56e0\u4e3a\u8be5\u7ed3\u6784\u4e0b\u6570\u636e\u4e0d\u4e3a\u7a7a"), new String[]{oDBTableInfo.getAnotherName()});
                    reports.addFailedReport(sTip, new WCMException(sTip));
                    continue;
                }
                this.m_oMetaDataDefMgr.delete(loginUser, oDBTableInfo);
                reports.addSucessedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label4", "\u5220\u9664\u5143\u6570\u636e\u7ed3\u6784[") + oDBTableInfo.getName() + "][" + oDBTableInfo.getAnotherName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label5", "]\u6210\u529f\uff01"));
                continue;
            }
            catch (Exception e) {
                reports.addFailedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label4", "\u5220\u9664\u5143\u6570\u636e\u7ed3\u6784[") + oDBTableInfo.getName() + "][" + oDBTableInfo.getAnotherName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label6", "]\u5931\u8d25\uff01"), e);
            }
        }
        return reports;
    }

    public Reports deleteDBFieldInfo(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        if (!loginUser.isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label7", "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u5220\u9664\u5143\u6570\u636e\u5b57\u6bb5\uff01"));
        }
        String sDeletedIds = _methodContext.getObjectIds();
        MetaDBFields oDBFieldInfos = MetaDBFields.findByIds(loginUser, sDeletedIds);
        Reports reports = new Reports(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label8", "\u5220\u9664\u5143\u6570\u636e\u5b57\u6bb5"));
        int nSize = oDBFieldInfos.size();
        for (int i = 0; i < nSize; ++i) {
            MetaDBField oDBFieldInfo = (MetaDBField)oDBFieldInfos.getAt(i);
            if (oDBFieldInfo == null) continue;
            MetaDBTable oDBTable = this.findDBTableInfo(oDBFieldInfo.getTableId());
            this.validateRight(loginUser, oDBTable);
            try {
                this.m_oMetaDataDefMgr.delete(loginUser, oDBFieldInfo);
                reports.addSucessedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label9", "\u5220\u9664\u5143\u6570\u636e\u5b57\u6bb5[") + oDBFieldInfo.getName() + "][" + oDBFieldInfo.getAnotherName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label5", "]\u6210\u529f\uff01"));
                continue;
            }
            catch (Exception e) {
                reports.addFailedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label9", "\u5220\u9664\u5143\u6570\u636e\u5b57\u6bb5[") + oDBFieldInfo.getName() + "][" + oDBFieldInfo.getAnotherName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label6", "]\u5931\u8d25\uff01"), e);
            }
        }
        return reports;
    }

    public MetaDBField findDBFieldInfoById(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nObjectId = _methodContext.getObjectId();
        MetaDBField dbFieldInfo = null;
        if (nObjectId == 0) {
            dbFieldInfo = MetaDBField.createNewInstance();
        } else {
            dbFieldInfo = MetaDBField.findById(nObjectId);
            if (dbFieldInfo == null) {
                throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label10", "\u6307\u5b9a\u7684\u5143\u6570\u636e\u5bf9\u8c61\u6ca1\u6709\u627e\u5230\uff01[ID=") + nObjectId + "]");
            }
        }
        return dbFieldInfo;
    }

    public MetaDBTable findDBTableInfoById(MethodContext _methodContext) throws Throwable {
        int nObjectId = _methodContext.getObjectId();
        MetaDBTable oDBTableInfo = null;
        if (nObjectId == 0) {
            oDBTableInfo = MetaDBTable.createNewInstance();
        } else {
            oDBTableInfo = MetaDBTable.findById(nObjectId);
            if (oDBTableInfo == null) {
                throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label11", "\u6307\u5b9a\u7684\u5143\u6570\u636e\u7ed3\u6784\u5bf9\u8c61\u6ca1\u6709\u627e\u5230\uff01[ID=") + nObjectId + "]");
            }
        }
        return oDBTableInfo;
    }

    public MetaDBTables findDBTableInfosByIds(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        if (!loginUser.isAdministrator()) {
            throw new WCMException(1002, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label12", "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u65b0\u5efa\u5143\u6570\u636e\u7ed3\u6784\u7ed3\u6784\uff01"));
        }
        return MetaDBTables.findByIds(loginUser, _methodContext.getObjectIds());
    }

    public MetaView saveView(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        MetaView view = null;
        int nViewId = _methodContext.getObjectId();
        int nChannelId = _methodContext.getValue("ChannelId", 0);
        if (nViewId == 0) {
            int nOwnerType = _methodContext.getValue("OwnerType", 1);
            int nOwnerId = _methodContext.getValue("OwnerId", 1);
            if (nChannelId > 0) {
                nOwnerType = 101;
                nOwnerId = nChannelId;
            }
            CMSObj owner = this.findOwner(nOwnerType, nOwnerId);
            this.validateRight(loginUser, owner);
            int nMainTableId = _methodContext.getValue("MainTableId", 0);
            String sViewName = _methodContext.getValue("ViewDesc");
            MetaDBTable dbMainTable = null;
            if (nMainTableId == 0) {
                String sTableName = _methodContext.getValue("TableName");
                dbMainTable = MetaDBTable.createNewInstance();
                dbMainTable.setAnotherName(sViewName);
                dbMainTable.setName(sTableName);
                dbMainTable.setOwner(nOwnerType, nOwnerId);
                dbMainTable = this.m_oMetaDataDefMgr.save(loginUser, dbMainTable);
                nMainTableId = dbMainTable.getId();
            } else {
                dbMainTable = this.findDBTableInfo(nMainTableId);
            }
            view = MetaView.createNewInstance();
            view.setMainTable(dbMainTable);
            view.setOtherTableIds(_methodContext.getValue("OtherTableIds"));
            view.setDesc(sViewName);
            view.setOwner(nOwnerType, nOwnerId);
            view.setTemplatePath(_methodContext.getValue("TemplatePath"));
        } else {
            view = this.findViewById(nViewId);
            if (_methodContext.containsParameter("MainTableId")) {
                MetaDBTable dbMainTable = this.findDBTableInfo(_methodContext.getValue("MainTableId", 0));
                view.setMainTable(dbMainTable);
            }
            if (_methodContext.containsParameter("OtherTableIds")) {
                view.setOtherTableIds(_methodContext.getValue("OtherTableIds"));
            }
            if (_methodContext.containsParameter("ViewDesc")) {
                view.setDesc(_methodContext.getValue("ViewDesc"));
            }
            if (_methodContext.containsParameter("TemplatePath")) {
                view.setTemplatePath(_methodContext.getValue("TemplatePath"));
            }
        }
        view = this.m_oMetaDataDefMgr.save(loginUser, view);
        if (nChannelId > 0) {
            Channel channel = this.findChannelById(nChannelId);
            this.m_oMetaViewEmployerMgr.setEmployer(loginUser, channel, view);
            this.m_oMetaDataDefMgr.createViewRelations(loginUser, view, true);
        }
        return view;
    }

    public MetaViewField saveViewField(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        MetaViewField oMetaViewField = null;
        int nObjectId = _methodContext.getObjectId();
        int nViewId = 0;
        if (nObjectId == 0) {
            oMetaViewField = MetaViewField.createNewInstance();
            nViewId = _methodContext.getValue("ViewId", 0);
        } else {
            oMetaViewField = this.findViewFieldById(nObjectId);
            oMetaViewField.validCanEditAndLock(loginUser);
            nViewId = oMetaViewField.getViewId();
        }
        MetaView view = this.findViewById(nViewId);
        this.validateRight(loginUser, view);
        String[] pLogicFields = new String[]{"ObjectId"};
        oMetaViewField = (MetaViewField)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, oMetaViewField, pLogicFields);
        MetaViewField viewField = this.m_oMetaDataDefMgr.save(loginUser, view, oMetaViewField);
        this.m_oMetaDataDefMgr.createViewRelations(loginUser, view, false);
        return viewField;
    }

    private MetaViewField findViewFieldById(int _nObjectId) throws WCMException {
        MetaViewField oMetaViewField = MetaViewField.findById(_nObjectId);
        if (oMetaViewField == null) {
            throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label13", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u89c6\u56fe\u5b57\u6bb5\uff01[Id=") + _nObjectId + "]");
        }
        return oMetaViewField;
    }

    private MetaViewFieldGroup findViewFieldGroupById(int _nObjectId) throws WCMException {
        MetaViewFieldGroup oMetaViewFieldGroup = MetaViewFieldGroup.findById(_nObjectId);
        if (oMetaViewFieldGroup == null) {
            throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label100", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u89c6\u56fe\u5b57\u6bb5\u5206\u7ec4\uff01[Id=") + _nObjectId + "]");
        }
        return oMetaViewFieldGroup;
    }

    public boolean testCanDeleteView(MetaView oView) throws WCMException {
        ArrayList<Integer> parameters = new ArrayList<Integer>();
        parameters.add(oView.getKey());
        String sTestSQL = "select count(DocId) from WCMDocument where Dockind=?";
        int nCount = DBManager.getDBManager().sqlExecuteIntQuery(sTestSQL, parameters);
        return nCount <= 0;
    }

    public Reports deleteView(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sDeletedIds = _methodContext.getObjectIds();
        MetaViews oMetaViews = MetaViews.findByIds(loginUser, sDeletedIds);
        Reports reports = new Reports(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label14", "\u5220\u9664\u591a\u4e2a\u89c6\u56fe"));
        int nSize = oMetaViews.size();
        for (int i = 0; i < nSize; ++i) {
            MetaView oMetaView = (MetaView)oMetaViews.getAt(i);
            if (oMetaView == null) continue;
            this.validateRight(loginUser, oMetaView);
            try {
                if (!this.testCanDeleteView(oMetaView)) {
                    String sTip = CMyString.format(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label4", "\u4e0d\u80fd\u5220\u9664\u89c6\u56fe[{0}],\u56e0\u4e3a\u8be5\u89c6\u56fe\u4e0b\u6570\u636e\u4e0d\u4e3a\u7a7a"), new String[]{oMetaView.getDesc()});
                    reports.addFailedReport(sTip, new WCMException(sTip));
                    continue;
                }
                this.m_oMetaDataDefMgr.delete(loginUser, oMetaView);
                reports.addSucessedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label15", "\u5220\u9664\u591a\u4e2a\u89c6\u56fe[") + oMetaView.getName() + "][" + oMetaView.getName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label5", "]\u6210\u529f\uff01"));
                continue;
            }
            catch (Exception e) {
                reports.addFailedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label15", "\u5220\u9664\u591a\u4e2a\u89c6\u56fe[") + oMetaView.getName() + "][" + oMetaView.getName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label6", "]\u5931\u8d25\uff01"), e);
            }
        }
        return reports;
    }

    public Reports deleteViewField(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sDeletedIds = _methodContext.getObjectIds();
        MetaViewFields oMetaViewFields = MetaViewFields.findByIds(loginUser, sDeletedIds);
        Reports reports = new Reports(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label16", "\u5220\u9664\u89c6\u56fe\u5b57\u6bb5\u4fe1\u606f"));
        int nSize = oMetaViewFields.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewField oMetaViewField = (MetaViewField)oMetaViewFields.getAt(i);
            if (oMetaViewField == null) continue;
            this.validateRight(loginUser, this.findViewById(oMetaViewField.getViewId()));
            try {
                this.m_oMetaDataDefMgr.delete(loginUser, oMetaViewField);
                reports.addSucessedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label17", "\u5220\u9664\u89c6\u56fe\u5b57\u6bb5\u4fe1\u606f[") + oMetaViewField.getName() + "][" + oMetaViewField.getAnotherName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label5", "]\u6210\u529f\uff01"));
                continue;
            }
            catch (Exception e) {
                reports.addFailedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label17", "\u5220\u9664\u89c6\u56fe\u5b57\u6bb5\u4fe1\u606f[") + oMetaViewField.getName() + "][" + oMetaViewField.getAnotherName() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label6", "]\u5931\u8d25\uff01"), e);
            }
        }
        return reports;
    }

    private MetaView findViewById(int _nViewId) throws WCMException {
        MetaView view = MetaView.findById(_nViewId);
        if (view == null) {
            throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label18", "\u6307\u5b9a\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[Id=") + _nViewId + "]");
        }
        return view;
    }

    public MetaView importViewFromXML(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nViewId = _methodContext.getValue("ViewId", 0);
        MetaView view = null;
        if (nViewId > 0) {
            view = this.findViewById(nViewId);
        }
        int nChannelId = _methodContext.getValue("ChannelId", 0);
        Channel channel = null;
        if (nChannelId > 0) {
            channel = this.findChannelById(nChannelId);
            this.validateRight(loginUser, channel);
        } else if (nViewId > 0) {
            this.validateRight(loginUser, view);
        } else if (!loginUser.isAdministrator()) {
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label19", "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u4e0d\u80fd\u8fdb\u884c\u64cd\u4f5c\uff01"));
        }
        String sDataXML = _methodContext.getValue("DataXML");
        MetaViewImporter importer = new MetaViewImporter(loginUser, view);
        view = importer.importFromXML(sDataXML);
        if (channel != null) {
            if (nViewId == 0) {
                view.validCanDeleteAndLock(loginUser);
                view.setOwner(channel.getWCMType(), channel.getId());
                view.save(loginUser);
            }
            this.m_oMetaViewEmployerMgr.setEmployer(loginUser, channel, view);
        }
        return view;
    }

    private Channel findChannelById(int _nChannelId) throws WCMException {
        Channel channel = Channel.findById(_nChannelId);
        if (channel == null) {
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label20", "\u6307\u5b9a\u7684\u680f\u76ee\u6ca1\u6709\u627e\u5230\uff01[Id=") + _nChannelId + "]");
        }
        return channel;
    }

    public MetaView findViewById(MethodContext _methodContext) throws Throwable {
        int nObjectId = _methodContext.getObjectId();
        MetaView oView = null;
        if (nObjectId == 0) {
            oView = MetaView.createNewInstance();
        } else {
            oView = MetaView.findById(nObjectId);
            if (oView == null) {
                throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label21", "\u6307\u5b9a\u7684\u89c6\u56fe\u5bf9\u8c61\u6ca1\u6709\u627e\u5230\uff01[ID=") + nObjectId + "]");
            }
        }
        return oView;
    }

    public MetaViewField findViewFieldById(MethodContext _methodContext) throws Throwable {
        MetaViewField oMetaViewField;
        int nObjectId = _methodContext.getObjectId();
        if (nObjectId == 0) {
            oMetaViewField = MetaViewField.createNewInstance();
        } else {
            oMetaViewField = MetaViewField.findById(nObjectId);
            if (oMetaViewField == null) {
                throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label13", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u89c6\u56fe\u5b57\u6bb5\uff01[Id=") + nObjectId + "]");
            }
        }
        return oMetaViewField;
    }

    public void setViewFields(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        MetaView view = this.findViewById(_methodContext.getValue("ViewId", 0));
        MetaDBFields dbFields = MetaDBFields.findByIds(loginUser, _methodContext.getValue("DBFieldIds"));
        this.validateRight(loginUser, view);
        this.m_oMetaDataDefMgr.setViewFields(loginUser, view, dbFields);
        this.m_oMetaDataDefMgr.createViewRelations(loginUser, view);
        this.precompileViewApplication(_methodContext, view);
    }

    public void setViewFieldsInfo(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sPropertyName = _methodContext.getValue("propertyName");
        String sPropertyValue = _methodContext.getValue("propertyValue");
        String objectIds = _methodContext.getValue("objectIds");
        MetaView view = null;
        MetaViewFields viewFields = MetaViewFields.findByIds(loginUser, objectIds);
        int nSize = viewFields.size();
        for (int i = 0; i < nSize; ++i) {
            MetaViewField viewField = (MetaViewField)viewFields.getAt(i);
            if (viewField == null) continue;
            viewField.validCanEditAndLock(loginUser);
            if (view == null) {
                int nViewId = viewField.getViewId();
                view = this.findViewById(nViewId);
                this.validateRight(loginUser, view);
            }
            viewField.setPropertyWithString(sPropertyName, sPropertyValue);
            viewField.save();
        }
        this.m_oMetaDataDefMgr.createViewRelations(loginUser, view);
    }

    public void changeViewFieldOrder(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        MetaViewField fromViewField = this.findViewFieldById(_methodContext.getValue("FromId", 0));
        MetaViewField toViewField = this.findViewFieldById(_methodContext.getValue("ToId", 0));
        int nPosition = _methodContext.getValue("Position", 1);
        MetaView view = this.findViewById(fromViewField.getViewId());
        this.validateRight(loginUser, view);
        if (fromViewField.getOrder() == toViewField.getOrder() + nPosition) {
            return;
        }
        fromViewField.validCanDeleteAndLock(loginUser);
        fromViewField.setOrder(toViewField.getOrder() + nPosition);
        fromViewField.save(loginUser);
    }

    public void changeViewFieldGroupOrder(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        MetaViewFieldGroup currViewFieldGroup = this.findViewFieldGroupById(_methodContext.getValue("MetaViewFieldGroupId", 0));
        int nNewOrder = _methodContext.getValue("GroupOrder", 0);
        currViewFieldGroup.setOrder(nNewOrder);
        MetaView view = this.findViewById(currViewFieldGroup.getMetaViewId());
        this.validateRight(loginUser, view);
        currViewFieldGroup.validCanEditAndLock(loginUser);
        currViewFieldGroup.save(loginUser);
    }

    private void validateRight(User _loginUser, MetaView _view) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return;
        }
        CMSObj owner = this.findOwner(_view.getOwnerType(), _view.getOwnerId());
        this.validateRight(_loginUser, owner);
    }

    private void validateRight(User _loginUser, CMSObj _owner) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return;
        }
        int nRightIndex = -1;
        switch (_owner.getWCMType()) {
            case 101: {
                nRightIndex = 13;
                break;
            }
            case 1: {
                nRightIndex = -1;
                break;
            }
            default: {
                throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label22", "\u672a\u77e5\u7684Owner Type\uff01[Type=") + _owner.getWCMType() + "]");
            }
        }
        if (nRightIndex >= 0) {
            if (!AuthServer.hasRight(_loginUser, _owner, nRightIndex)) {
                throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label23", "\u60a8\u65e0\u6743\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\uff01"));
            }
        } else if (!_loginUser.isAdministrator()) {
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label24", "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u65e0\u6743\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\uff01"));
        }
    }

    private boolean hasRight(User _loginUser, CMSObj _owner) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return true;
        }
        int nRightIndex = -1;
        switch (_owner.getWCMType()) {
            case 101: {
                nRightIndex = 13;
                break;
            }
            case 1: {
                nRightIndex = -1;
                break;
            }
            default: {
                throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label22", "\u672a\u77e5\u7684Owner Type\uff01[Type=") + _owner.getWCMType() + "]");
            }
        }
        return !(nRightIndex >= 0 ? !AuthServer.hasRight(_loginUser, _owner, nRightIndex) : !_loginUser.isAdministrator());
    }

    public void setViewEmployerByChannel(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Channel channel = this.findChannelById(_methodContext.getValue("ChannelId", 0));
        int nViewId = _methodContext.getValue("ViewId", 0);
        MetaView view = null;
        if (nViewId > 0) {
            view = this.findViewById(nViewId);
        }
        if (_methodContext.getValue("ContainsChildren", false)) {
            SynChildrenExecutorForViewEmploy childrenExecutorForViewEmploy = new SynChildrenExecutorForViewEmploy(channel, view, nViewId <= 0);
            childrenExecutorForViewEmploy.execute(loginUser);
        } else {
            if (!AuthServer.hasRight(loginUser, (CMSObj)channel, 13)) {
                throw new WCMException(1002, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label25", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u7ef4\u62a4\u5f53\u524d\u680f\u76ee\u4f7f\u7528\u7684\u89c6\u56fe\uff01"));
            }
            if (nViewId > 0) {
                this.m_oMetaViewEmployerMgr.setEmployer(loginUser, channel, view);
            } else {
                this.m_oMetaViewEmployerMgr.clearEmployer(loginUser, channel);
            }
        }
    }

    public MetaView findViewByChannel(MethodContext _methodContext) throws WCMException {
        int nChannelId = _methodContext.getValue("channelId", 0);
        Channel channel = Channel.findById(nChannelId);
        if (channel == null) {
            return null;
        }
        MetaView view = this.m_oMetaViewEmployerMgr.getViewOfEmployer(channel);
        return view;
    }

    public Reports createViewRelation(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sViewIds = _methodContext.getValue("ViewIds");
        WCMFilter filter = null;
        if (!CMyString.isEmpty(sViewIds)) {
            filter = new WCMFilter("", "ViewInfoId in(" + sViewIds + ")", "");
        }
        MetaViews views = MetaViews.openWCMObjs(loginUser, filter);
        Reports reports = new Reports(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label26", "\u7ed9\u6307\u5b9a\u89c6\u56fe\u4ea7\u751f\u5e94\u7528\uff01"));
        int nSize = views.size();
        for (int i = 0; i < nSize; ++i) {
            MetaView view = (MetaView)views.getAt(i);
            if (view == null) continue;
            try {
                this.validateRight(loginUser, view);
                this.m_oMetaDataDefMgr.createViewRelations(loginUser, view);
                reports.addSucessedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label27", "\u7ed9\u89c6\u56fe[") + view.getDesc() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label28", "]\u751f\u6210\u5e94\u7528\u6210\u529f\uff01"));
            }
            catch (Exception e) {
                reports.addFailedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label27", "\u7ed9\u89c6\u56fe[") + view.getDesc() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label29", "]\u751f\u6210\u5e94\u7528\u5931\u8d25\uff01"), e);
                continue;
            }
            try {
                this.precompileViewApplication(_methodContext, view);
                continue;
            }
            catch (Exception e) {
                m_oLogger.error((Object)(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label30", "\u7f16\u8bd1\u89c6\u56fe[") + view.getDesc() + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label101", "]\u4ea7\u751f\u5e94\u7528\u5931\u8d25\uff01")), (Throwable)e);
            }
        }
        return reports;
    }

    private void precompileViewApplication(MethodContext _methodContext, MetaView _view) throws Exception {
        if (_methodContext.getServiceContext().getRequest() == null) {
            return;
        }
        String sApplicationPath = CMyString.setStrEndWith(ConfigServer.getServer().getInitProperty("WCM_PATH"), File.separatorChar);
        String sDefaultHost = _methodContext.getServiceContext().getRequest().getServerName();
        int nDefaultPort = _methodContext.getServiceContext().getRequest().getServerPort();
        String sHost = ConfigServer.getServer().getSysConfigValue("METADATA_PRECOMPILE_HOST", sDefaultHost);
        String sPort = ConfigServer.getServer().getSysConfigValue("METADATA_PRECOMPILE_PORT", String.valueOf(nDefaultPort));
        String sApplicationName = _methodContext.getServiceContext().getRequest().getContextPath();
        if (!CMyString.isEmpty(sApplicationName) && sApplicationName.charAt(0) == '/') {
            sApplicationName = sApplicationName.substring(1);
        }
        String sSubDir = ConfigServer.getServer().getSysConfigValue("APP_PATH_NAME", "WCMV6") + "\\metadata\\application\\";
        sSubDir = sSubDir.replace('\\', File.separatorChar);
        WCMJSPChecker checker = new WCMJSPChecker(sApplicationPath, sSubDir + _view.getId(), sHost, Integer.parseInt(sPort), sApplicationName);
        checker.run();
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }

    private MetaDBTable findDBTableInfo(int _nObjectId) throws WCMException {
        MetaDBTable oDBTableInfo = MetaDBTable.findById(_nObjectId);
        if (oDBTableInfo == null) {
            throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label31", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u8868\uff01[Id=") + _nObjectId + "]");
        }
        return oDBTableInfo;
    }

    public void saveSynRule(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sMetaSynField = _methodContext.getValue("metaSynField");
        String[] item = CMyString.split(sMetaSynField, "&");
        DBManager dbManager = DBManager.getDBManager();
        for (int i = 0; i < item.length; ++i) {
            String fieldName;
            FieldInfo fieldInfo;
            if (CMyString.isEmpty(item[i]) || (fieldInfo = dbManager.getFieldInfo("WCMDOCUMENT", fieldName = item[i].split("=")[0])) != null) continue;
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label51", "\u5b57\u6bb5\u540d ") + fieldName + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label52", "\u5728WCMDOCUMENT\u8868\u4e2d\u4e0d\u5b58\u5728"));
        }
        int iSynType = _methodContext.getValue("synType", 0);
        if (iSynType == 3) {
            MetaView oView = this.findViewById(_methodContext.getValue("viewId", 0));
            this.validateRight(loginUser, oView);
            if (sMetaSynField != null) {
                oView.setPropertyWithString("MetaSynFields", sMetaSynField);
                oView.save();
            }
        } else {
            int nChannelId = _methodContext.getValue("channelId", 0);
            Channel oChannel = Channel.findById(nChannelId);
            if (oChannel == null) {
                throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label32", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[id\uff1a") + nChannelId + "]");
            }
            if (this.hasRight(loginUser, oChannel)) {
                this.saveSynRule(oChannel, sMetaSynField);
            }
            if (iSynType == ViewRangeConstants.ONLY_SELF) {
                return;
            }
            MetaView oView = this.m_oMetaViewEmployerMgr.getViewOfEmployer(oChannel);
            Channels channels = this.m_oMetaViewEmployerMgr.getEmployers(oView, null);
            Channels children = null;
            if (iSynType == ViewRangeConstants.SAME_VIEW_CONTAIN_CHILDREN) {
                WCMFilterMakerForContainsChildren maker = new WCMFilterMakerForContainsChildren(oChannel);
                maker.execute(loginUser);
                children = maker.getCurrChannels();
            }
            for (int i = channels.size() - 1; i >= 0; --i) {
                Channel channel = (Channel)channels.getAt(i);
                if (channel == null || children != null && children.getById(channel.getId()) == null || !this.hasRight(loginUser, channel)) continue;
                this.saveSynRule(channel, sMetaSynField);
            }
        }
    }

    private void saveSynRule(Channel _channel, String _metaSynField) throws WCMException {
        if (_channel == null) {
            return;
        }
        if (_metaSynField != null) {
            _channel.setMetaSynFields(_metaSynField);
        }
        _channel.save();
    }

    public String findSynRule(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sMetaSynFields = "";
        String synRuleSetFrom = _methodContext.getValue("synRuleSetFrom");
        if (synRuleSetFrom.equalsIgnoreCase("channel")) {
            int nChannelId = _methodContext.getValue("channelId", 0);
            Channel oChannel = Channel.findById(nChannelId);
            if (oChannel == null) {
                throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label32", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[id\uff1a") + nChannelId + "]");
            }
            this.validateRight(loginUser, oChannel);
            sMetaSynFields = oChannel.getMetaSynFields();
        } else if (synRuleSetFrom.equalsIgnoreCase("metaView")) {
            MetaView oView = this.findViewById(_methodContext.getValue("viewId", 0));
            this.validateRight(loginUser, oView);
            sMetaSynFields = oView.getPropertyAsString("MetaSynFields", "docTitle=&docContent=");
        }
        HashMap synRuleMap = new HashMap();
        synRuleMap = new AttributesString(sMetaSynFields).getAttributesMap();
        _methodContext.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(synRuleMap, 0);
    }

    private CMSObj findOwner(int _nOwnerType, int _nOwnerId) throws WCMException {
        switch (_nOwnerType) {
            case 1: {
                return new WCMSystemObject(_nOwnerId);
            }
        }
        CMSObj result = (CMSObj)BaseObj.findById(_nOwnerType, _nOwnerId);
        if (result == null) {
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label33", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u5bf9\u8c61\uff01[Type=") + _nOwnerType + ", Id=" + _nOwnerId + "]");
        }
        return result;
    }

    private void validateRight(User _loginUser, MetaDBTable _oDBTable) throws WCMException {
        if (_loginUser.isAdministrator()) {
            return;
        }
        CMSObj owner = this.findOwner(_oDBTable.getOwnerType(), _oDBTable.getOwnerId());
        this.validateRight(_loginUser, owner);
    }

    public void recreateAllOfDBTableInfo(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        String sIds = _methodContext.getObjectIds();
        MetaDBTables oDBTableInfos = MetaDBTables.findByIds(loginUser, sIds);
        this.m_oMetaDataDefMgr.recreateAll(loginUser, oDBTableInfos);
    }

    public String buildAllFromTextFile(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        if (!loginUser.isAdministrator()) {
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label34", "\u60a8\u6ca1\u6709\u6743\u9650\u6267\u884c\u653f\u5e9c\u4fe1\u606f\u516c\u5f00\u670d\u52a1\u7cfb\u7edf\u7684\u521b\u5efa\uff01"));
        }
        SystemBuilder sb = new SystemBuilder(loginUser, _methodContext);
        sb.m_bCreateMainSite = _methodContext.getValue("CreateMainSite", true);
        sb.start();
        return null;
    }

    private ClassInfo findRootClassInfoByName(String _sRootClassName) throws WCMException {
        WCMFilter filterForQueryDeptClass = new WCMFilter("", "ParentId=0 and CName=?", "");
        filterForQueryDeptClass.addSearchValues(_sRootClassName);
        ClassInfos classInfos = ClassInfos.openWCMObjs(null, filterForQueryDeptClass);
        if (classInfos.isEmpty()) {
            return null;
        }
        ClassInfo deptClassInfo = (ClassInfo)classInfos.getAt(0);
        return deptClassInfo;
    }

    public String exportViews(MethodContext _oMethodContext) throws WCMException {
        User loginUser = this.getLoginUser();
        if (!loginUser.isAdministrator()) {
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label53", "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u5bfc\u51fa\u7cfb\u7edf\u7684\u7ed3\u6784\uff01"));
        }
        String sViewIds = _oMethodContext.getValue("ViewIds");
        MetaViews views = null;
        views = CMyString.isEmpty(sViewIds) ? MetaViews.openWCMObjs(loginUser, null) : MetaViews.findByIds(loginUser, sViewIds);
        MetaViewExporter exporter = new MetaViewExporter();
        return exporter.export(views);
    }

    public Reports importViewsFromXML(MethodContext _oMethodContext) throws WCMException {
        String sImportFile = _oMethodContext.getValue("importFile");
        Reports oReports = new Reports(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label44", "\u4ece\u6587\u4ef6[") + sImportFile + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label45", "]\u5bfc\u5165\u89c6\u56fe!"));
        String sFileExt = CMyFile.extractFileExt(sImportFile);
        if (sFileExt == null || (sFileExt = sFileExt.trim()).length() == 0) {
            oReports.addFailedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label46", "\u53c2\u6570[ImportFile=") + sImportFile + I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label47", "]\u4e0d\u6b63\u786e\uff01\u6ca1\u6709\u540e\u7f00\u540d"), null);
            return oReports;
        }
        User loginUser = this.getLoginUser();
        if (!loginUser.isAdministrator()) {
            oReports.addFailedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label48", "\u60a8\u4e0d\u662f\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u6743\u9650\u5bfc\u5165\u89c6\u56fe\uff01"), null);
            return oReports;
        }
        int importType = _oMethodContext.getValue("importType", 0);
        try {
            MetaDataDDLImporter importer = new MetaDataDDLImporter(loginUser);
            importer.importFromXML(sImportFile, importType, oReports);
        }
        catch (Exception ex) {
            oReports.addFailedReport(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label49", "\u5bfc\u5165\u89c6\u56fe\u5931\u8d25!"), ex);
        }
        return oReports;
    }

    public MetaViews queryViewsRelatingToCurrView(MethodContext _oMethodContext) throws WCMException {
        int nCurrViewId = _oMethodContext.getValue("MetaViewId", 0);
        if (nCurrViewId == 0) {
            throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label60", "\u5fc5\u987b\u7684\u53c2\u6570MetaViewId\u672a\u4f20\u5165\uff01"));
        }
        WCMFilter filter = new WCMFilter("", "", "");
        String sWhere = "VIEWINFOID in (select distinct VIEWID from XWCMVIEWFIELDINFO where FIELDTYPE=? AND RELATIONVIEWID=?)";
        filter.setWhere(sWhere);
        filter.addSearchValues(14);
        filter.addSearchValues(nCurrViewId);
        filter = filter.mergeWith(_oMethodContext.getExtraWCMFilter());
        MetaViews views = MetaViews.openWCMObjs(null, filter);
        return views;
    }

    public Channels getChannelsUseingMetaView(MethodContext _methodContext) throws WCMException {
        int nObjectId = _methodContext.getObjectId();
        MetaView oMetaView = this.findViewById(nObjectId);
        if (oMetaView == null) {
            throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label18", "\u6307\u5b9a\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[Id=") + nObjectId + "]");
        }
        return this.m_oMetaViewEmployerMgr.getEmployers(oMetaView, null);
    }

    public void setChannelEmployersOfMetaView(MethodContext _methodContext) throws Throwable {
        Channel channel;
        int i;
        User loginUser = this.getLoginUser();
        int nViewId = _methodContext.getValue("ViewId", 0);
        MetaView view = null;
        if (nViewId <= 0) {
            throw new WCMException(200006, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label18", "\u6307\u5b9a\u7684\u89c6\u56fe\u4e0d\u5b58\u5728\uff01[Id=") + nViewId + "]");
        }
        view = this.findViewById(nViewId);
        Channels oChannels = this.m_oMetaViewEmployerMgr.getEmployers(view, null);
        int[] sChnlIds = CMyString.splitToInt(_methodContext.getObjectIds(), ",");
        for (i = oChannels.size() - 1; i >= 0; --i) {
            channel = (Channel)oChannels.getAt(i);
            if (channel == null) continue;
            boolean bFound = false;
            for (int j = 0; j < sChnlIds.length; ++j) {
                if (channel.getId() != sChnlIds[j]) continue;
                sChnlIds[j] = 0;
                bFound = true;
                break;
            }
            if (bFound) continue;
            if (!AuthServer.hasRight(loginUser, (CMSObj)channel, 13)) {
                throw new WCMException(1002, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label25", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u7ef4\u62a4\u5f53\u524d\u680f\u76ee\u4f7f\u7528\u7684\u89c6\u56fe\uff01"));
            }
            this.m_oMetaViewEmployerMgr.clearEmployer(loginUser, channel);
        }
        for (i = 0; i < sChnlIds.length; ++i) {
            if (sChnlIds[i] == 0 || Channel.findById(sChnlIds[i]) == null) continue;
            channel = Channel.findById(sChnlIds[i]);
            if (!AuthServer.hasRight(loginUser, (CMSObj)channel, 13)) {
                throw new WCMException(1002, I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label25", "\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u6743\u9650\u7ef4\u62a4\u5f53\u524d\u680f\u76ee\u4f7f\u7528\u7684\u89c6\u56fe\uff01"));
            }
            this.m_oMetaViewEmployerMgr.setEmployer(loginUser, channel, view);
        }
    }

    private class SystemBuilder
    extends Thread {
        private MethodContext methodContext = null;
        private User loginUser = null;
        private HttpSession m_oSession = null;
        private String m_sRootDomain = null;
        private boolean m_bCreateMainSite = true;

        public SystemBuilder(User _currUser, MethodContext _methodContext) {
            this.methodContext = _methodContext;
            this.loginUser = _currUser;
            HttpServletRequest oRequest = _methodContext.getServiceContext().getRequest();
            this.m_oSession = oRequest.getSession();
            this.m_sRootDomain = this.makeRootDomain(oRequest);
        }

        private String makeRootDomain(HttpServletRequest _oRequest) {
            if (_oRequest == null) {
                return "http://not.set/";
            }
            String sRootDomain = _oRequest.getScheme() + "://" + _oRequest.getServerName();
            int nPort = _oRequest.getServerPort();
            if (nPort != -1) {
                sRootDomain = sRootDomain + ":" + nPort;
            }
            sRootDomain = sRootDomain + "/pub/";
            return sRootDomain;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                ClassInfo themecatClassInfo;
                String sThemecatRootName;
                ContextHelper.initContext(this.loginUser);
                String sOrgancatRootName = this.m_bCreateMainSite ? I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label35", "\u673a\u6784\u5206\u7c7b") : I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label36", "\u4e0b\u7ea7\u5355\u4f4d\u673a\u6784\u5206\u7c7b");
                String sSubcatRootName = this.m_bCreateMainSite ? I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label37", "\u4e3b\u9898\u5206\u7c7b") : I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label38", "\u4e0b\u7ea7\u5355\u4f4d\u4e3b\u9898\u5206\u7c7b");
                String string = sThemecatRootName = this.m_bCreateMainSite ? I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label39", "\u4f53\u88c1\u5206\u7c7b") : I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label40", "\u4e0b\u7ea7\u5355\u4f4d\u4f53\u88c1\u5206\u7c7b");
                if (this.m_bCreateMainSite) {
                    this.createFlows("workflow.xml");
                    this.createFlows("workflow2.xml");
                }
                MetaView oView = MetaDataDefServiceProvider.this.findViewById(this.methodContext.getValue("viewId", 0));
                boolean bContainCode = this.methodContext.getValue("ContainCode", false);
                String sFileName = this.methodContext.getValue("FileName");
                ClassInfo deptClassInfo = this.importClassInfo(sFileName, sOrgancatRootName, bContainCode);
                if (deptClassInfo == null) {
                    return;
                }
                this.setClassInfoOfViewField(oView, "organcat", deptClassInfo);
                ClassInfo subcatClassInfo = this.importClassInfo(this.methodContext.getValue("SubCatFileName"), sSubcatRootName, this.methodContext.getValue("SubCatContainCode", false));
                if (subcatClassInfo != null) {
                    this.setClassInfoOfViewField(oView, "subcat", subcatClassInfo);
                }
                if ((themecatClassInfo = this.importClassInfo(this.methodContext.getValue("ThemeCatFileName"), sThemecatRootName, this.methodContext.getValue("ThemeCatContainCode", false))) != null) {
                    this.setClassInfoOfViewField(oView, "themecat", themecatClassInfo);
                }
                int nLevel = this.methodContext.getValue("level", 1);
                StringBuffer sbResult = new StringBuffer();
                if (this.methodContext.getValue("AutoCreateGroup", false)) {
                    IDepartmentMgr departmentMgr = (IDepartmentMgr)DreamFactory.createObjectById("IDepartmentMgr");
                    ClassInfoToGroupCreator classInfoToGroupCreator = new ClassInfoToGroupCreator();
                    classInfoToGroupCreator.createGroups(deptClassInfo, departmentMgr.getRootDepartmentGroup(), 0);
                    sbResult.append(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label41", "\u65b0\u4ea7\u751f\u7684\u7528\u6237\u4fe1\u606f:<BR><BR>"));
                    sbResult.append(CMyString.transDisplay(classInfoToGroupCreator.getNewUserInfos()));
                }
                if (this.methodContext.getValue("AutoCreateChannel", false)) {
                    ClassInfoToChannelHelper.createSites(deptClassInfo, oView, nLevel, this.m_sRootDomain);
                }
                this.m_oSession.setAttribute("UserInfo", (Object)sbResult.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.m_oSession.setAttribute("ErrorInfo", (Object)e.getMessage());
            }
            finally {
                ContextHelper.clear();
            }
        }

        private void setClassInfoOfViewField(MetaView _oView, String _sFieldName, ClassInfo _oRootClassInfo) throws WCMException {
            IMetaDataDefCacheMgr defCacheMgr = (IMetaDataDefCacheMgr)DreamFactory.createObjectById("IMetaDataDefCacheMgr");
            MetaViewField viewField = defCacheMgr.getMetaViewField(_oView.getId(), _sFieldName);
            viewField.setClassId(_oRootClassInfo.getId());
            viewField.setType(10);
            IMetaDataDefMgr metaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
            metaDataDefMgr.save(this.loginUser, _oView, viewField);
        }

        private ClassInfo importClassInfo(String _sFileName, String _sClassInfoName, boolean _bContainCode) throws Exception {
            if (CMyString.isEmpty(_sFileName)) {
                return null;
            }
            ClassInfoUtil util = new ClassInfoUtil();
            boolean bResult = util.importClassInfos(_sClassInfoName, _sFileName, _bContainCode, 1, 0);
            if (!bResult) {
                throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label42", "\u521b\u5efa\u5206\u7c7b\u6cd5\u5931\u8d25\uff01"));
            }
            ClassInfo deptClassInfo = MetaDataDefServiceProvider.this.findRootClassInfoByName(_sClassInfoName);
            return deptClassInfo;
        }

        private void createFlows(String _sWorkFlowFileName) throws WCMException {
            String sWCMPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
            sWCMPath = CMyString.setStrEndWith(sWCMPath, File.separatorChar);
            String sGovDataPath = sWCMPath + ConfigServer.getServer().getSysConfigValue("APP_PATH_NAME_4GOVINFO", "WCMV6") + File.separatorChar + "gkml" + File.separatorChar + "data" + File.separator;
            String sImportFile = sGovDataPath + _sWorkFlowFileName;
            try {
                String sSrcFile = sImportFile;
                sImportFile = sGovDataPath + "workflow_temp.xml";
                if (!CMyFile.fileExists(sSrcFile)) {
                    return;
                }
                CMyFile.copyFile(sSrcFile, sImportFile);
            }
            catch (Exception e) {
                throw new WCMException(I18NMessage.get(MetaDataDefServiceProvider.class, "MetaDataDefServiceProvider.label43", "\u62f7\u8d1d\u6587\u4ef6\u5931\u8d25"), e);
            }
            CMSObj owner = MetaDataDefServiceProvider.this.findOwner(1, 4);
            FlowImporter importer = new FlowImporter(this.loginUser, 1);
            importer.setImportWithInfoviewId(false);
            importer.setOwner(owner);
            importer.importFromFile(sImportFile, null);
        }
    }
}

