/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.definition.excel;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.User;
import com.trs.components.metadata.definition.IMetaDataDefMgr;
import com.trs.components.metadata.definition.MetaDBTable;
import com.trs.components.metadata.definition.MetaView;
import com.trs.components.metadata.definition.MetaViewField;
import com.trs.components.metadata.definition.excel.ExcelForStructImporter;
import com.trs.components.metadata.definition.excel.FieldInfo;
import com.trs.components.metadata.definition.excel.FieldInfos;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import org.apache.log4j.Logger;

public class DefaultTabelsForHaierEN {
    private static Logger logger = Logger.getLogger(ExcelForStructImporter.class);
    private static StringBuffer sbDropSQL = new StringBuffer();
    public static FieldInfos DEFAULT_FIELDS_GS = new FieldInfos();
    public static FieldInfos DEFAULT_FIELDS_SM;
    public static FieldInfos DEFAULT_FIELDS_FAQ;
    public static FieldInfos DEFAULT_FIELDS_DRIVE;
    public static String PRE_TABLE_NAME;
    public static FieldInfos[] pDefaultFields;
    public static String[] pTableAnotherNames;
    public static String[] pTableNames;

    private static MetaViewField createDBFieldFromDataType(FieldInfo dataType) throws WCMException {
        MetaViewField dbField = MetaViewField.createNewInstance();
        if (dataType.getEnumValues() != null) {
            dbField.setEnmValue(dataType.getEnumValues());
        }
        dbField.setNotNull(dataType.isNotNull());
        dbField.setHidden(dataType.isHidden());
        dbField.setInOutline(dataType.isInOutline());
        dbField.setTitleField(dataType.isTitle());
        dbField.setSearchField(dataType.isSearchField());
        dbField.setAnotherName(dataType.getDataTypeDesc());
        dbField.setName(dataType.getKey());
        dbField.setType(dataType.getDataType());
        dbField.setDBType(dataType.getSqlDataType());
        return dbField;
    }

    private static MetaDBTable createTable(String _sTableAnotherName, String _sTableName, FieldInfos _fields) throws WCMException {
        sbDropSQL.append("drop table WCMMetaTable" + _sTableName + ";");
        sbDropSQL.append("\n");
        IMetaDataDefMgr oMetaDataDefMgr = (IMetaDataDefMgr)DreamFactory.createObjectById("IMetaDataDefMgr");
        User currUser = User.findByName("admin");
        MetaDBTable currTable = MetaDBTable.createNewInstance();
        currTable.setAnotherName(_sTableAnotherName);
        currTable.setName(_sTableName);
        oMetaDataDefMgr.save(currUser, currTable);
        MetaView view = DefaultTabelsForHaierEN.createViewFrom(currTable);
        oMetaDataDefMgr.save(currUser, view);
        int nSize = _fields.getDataTypesCount();
        for (int i = 0; i < nSize; ++i) {
            MetaViewField dbField = DefaultTabelsForHaierEN.createDBFieldFromDataType(_fields.getDataTypeAt(i));
            try {
                oMetaDataDefMgr.save(currUser, view, dbField);
                continue;
            }
            catch (Exception e) {
                oMetaDataDefMgr.delete(currUser, currTable);
                logger.error((Object)(I18NMessage.get(DefaultTabelsForHaierEN.class, "DefaultTabelsForHaierEN.label1", "\u5904\u7406\u5b57\u6bb5\u51fa\u73b0\u5f02\u5e38\uff01[") + _sTableAnotherName + "." + _sTableName + "." + dbField.getAnotherName() + "." + dbField.getName() + "]"), (Throwable)e);
                break;
            }
        }
        return currTable;
    }

    public static void createDefaultTables() throws Exception {
        for (int i = 0; i < pTableAnotherNames.length; ++i) {
            if (!PRE_TABLE_NAME.equalsIgnoreCase("HUK") && pTableAnotherNames[i].equalsIgnoreCase("Manual")) continue;
            DefaultTabelsForHaierEN.createTable(PRE_TABLE_NAME + "_" + pTableAnotherNames[i], PRE_TABLE_NAME + "_" + pTableNames[i], pDefaultFields[i]);
        }
        CMyFile.writeFile("c:\\drop_default_tables_" + PRE_TABLE_NAME + ".sql", sbDropSQL.toString());
    }

    private static MetaView createViewFrom(MetaDBTable currTable) throws WCMException {
        MetaView view = MetaView.createNewInstance();
        view.setMainTable(currTable);
        view.setDesc(currTable.getAnotherName());
        view.setName(currTable.getName());
        return view;
    }

    static {
        FieldInfo fieldInfo = DEFAULT_FIELDS_GS.register(3, "Title", "GName", 12, 60);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setTitle(true);
        fieldInfo.setSearchField(true);
        fieldInfo = DEFAULT_FIELDS_GS.register(4, "Description", "GDesc", 12, 140);
        fieldInfo.setSearchField(true);
        DEFAULT_FIELDS_GS.register(8, "Icon", "Icon", 12, 20);
        DEFAULT_FIELDS_SM = new FieldInfos();
        fieldInfo = DEFAULT_FIELDS_SM.register(3, "Name", "GName", 12, 80);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setTitle(true);
        fieldInfo.setSearchField(true);
        fieldInfo = DEFAULT_FIELDS_SM.register(3, "File Name", "GFileName", 12, 40);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setSearchField(true);
        fieldInfo = DEFAULT_FIELDS_SM.register(11, "Publishing Date", "GPubDate", 93, 40);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo = DEFAULT_FIELDS_SM.register(8, "File", "GFile", 12, 20);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        DEFAULT_FIELDS_FAQ = new FieldInfos();
        fieldInfo = DEFAULT_FIELDS_FAQ.register(3, "Question", "FName", 12, 80);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setTitle(true);
        fieldInfo.setSearchField(true);
        fieldInfo = DEFAULT_FIELDS_FAQ.register(4, "Answer", "FFileName", 12, 2000);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setSearchField(true);
        DEFAULT_FIELDS_DRIVE = new FieldInfos();
        fieldInfo = DEFAULT_FIELDS_DRIVE.register(3, "Name", "DName", 12, 80);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo.setTitle(true);
        fieldInfo.setSearchField(true);
        fieldInfo = DEFAULT_FIELDS_DRIVE.register(6, "Operating System", "DOS", 4, 0);
        fieldInfo.setEnumValues("Windows XP`1~Windows Visto`2~Windows 7`3~Other`4");
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        fieldInfo = DEFAULT_FIELDS_DRIVE.register(3, "File Path", "DFilePath", 12, 300);
        fieldInfo.setNotNull(true);
        fieldInfo.setInOutline(true);
        PRE_TABLE_NAME = "HUK";
        pDefaultFields = new FieldInfos[]{DEFAULT_FIELDS_GS, DEFAULT_FIELDS_SM, DEFAULT_FIELDS_FAQ, DEFAULT_FIELDS_DRIVE};
        pTableAnotherNames = new String[]{"Product Overview", "Manual", "FAQ", "Driver"};
        pTableNames = new String[]{"Overview", "Manual", "FAQ", "DRIVER"};
    }
}

