/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.metadata.center.xml;

import com.trs.components.metadata.center.MetaViewDatas;
import com.trs.components.metadata.center.xml.MetaViewDataToExcel;
import com.trs.components.metadata.center.xml.MetaViewDataToXML;
import com.trs.components.metadata.definition.MetaView;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyZip;
import com.trs.infra.util.store.FileService;
import java.util.ArrayList;

public class MetaViewDataExporter {
    private MetaView m_oMetaView = null;

    public MetaViewDataExporter(MetaView _view) {
        this.m_oMetaView = _view;
    }

    public String exportToZip(MetaViewDatas _viewDatas, String _sSelectFields, boolean _bExportAppendix) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        String sXMLFile = filesMan.getNextFileName("ST", "xml");
        String sXMLFilePath = filesMan.mapFilePath(sXMLFile, 0);
        MetaViewDataToXML metaViewDataToXML = new MetaViewDataToXML(this.m_oMetaView);
        metaViewDataToXML.toXMLFile(_viewDatas, sXMLFilePath + sXMLFile, null, _sSelectFields);
        int nLastPos = sXMLFile.lastIndexOf(46);
        String sZipFile = sXMLFile.substring(0, nLastPos) + ".zip";
        CMyZip oMyZip = new CMyZip();
        try {
            oMyZip.setZipFileName(sXMLFilePath + sZipFile);
            oMyZip.addToZip(sXMLFilePath + sXMLFile, false);
            if (_bExportAppendix) {
                this.mergeAppFiles(oMyZip, metaViewDataToXML.getAppFiles());
            }
            oMyZip.done();
        }
        catch (CMyException e) {
            throw new WCMException(54, I18NMessage.get(MetaViewDataExporter.class, "MetaViewDataExporter.label1", "\u521b\u5efaZip\u6587\u4ef6\u5931\u8d25!"), e);
        }
        finally {
            CMyFile.deleteFile(sXMLFilePath + sXMLFile);
        }
        return sZipFile;
    }

    public String exportToZip(MetaViewDatas _viewDatas) throws WCMException {
        return this.exportToZip(_viewDatas, null, true);
    }

    private void mergeAppFiles(CMyZip _oMyZip, ArrayList _arAppFiles) throws WCMException, CMyException {
        FilesMan filesMan = FilesMan.getFilesMan();
        int nSize = _arAppFiles.size();
        for (int i = 0; i < nSize; ++i) {
            String sAppFileName = (String)_arAppFiles.get(i);
            if (CMyString.isEmpty(sAppFileName) || !CMyFile.fileExists(sAppFileName = filesMan.mapFilePath(sAppFileName, 0) + sAppFileName)) continue;
            _oMyZip.addToZip(sAppFileName, false);
        }
    }

    public String exportToExcelZip(MetaViewDatas _viewDatas, String _sSelectFields, boolean _bExportAppendix) throws WCMException {
        FilesMan filesMan = FilesMan.getFilesMan();
        String sXMLFile = filesMan.getNextFileName("ST", "xml");
        String sExcelFile = CMyFile.extractMainFileName(sXMLFile) + ".xls";
        String sXMLFilePath = filesMan.mapFilePath(sXMLFile, 0);
        MetaViewDataToExcel metaViewDataToExcel = new MetaViewDataToExcel(this.m_oMetaView);
        metaViewDataToExcel.toXMLFile(_viewDatas, sXMLFilePath + sXMLFile, null, _sSelectFields);
        new FileService(sXMLFilePath + sXMLFile).renameTo(new FileService(sXMLFilePath + sExcelFile));
        int nLastPos = sXMLFile.lastIndexOf(46);
        String sZipFile = sXMLFile.substring(0, nLastPos) + ".zip";
        CMyZip oMyZip = new CMyZip();
        try {
            oMyZip.setZipFileName(sXMLFilePath + sZipFile);
            oMyZip.addToZip(sXMLFilePath + sExcelFile, false);
            if (_bExportAppendix) {
                this.mergeAppFiles(oMyZip, metaViewDataToExcel.getAppFiles());
            }
            oMyZip.done();
        }
        catch (CMyException e) {
            throw new WCMException(54, I18NMessage.get(MetaViewDataExporter.class, "MetaViewDataExporter.label1", "\u521b\u5efaZip\u6587\u4ef6\u5931\u8d25!"), e);
        }
        finally {
            CMyFile.deleteFile(sXMLFilePath + sXMLFile);
        }
        return sZipFile;
    }

    public String exportToExcelZip(MetaViewDatas _viewDatas) throws WCMException {
        return this.exportToExcelZip(_viewDatas, null, true);
    }
}

