/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.db;

import com.trs.components.infoview.InfoViewHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.CDATA;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;

public class InfoviewXMLDataUpdator {
    protected static Logger logger = Logger.getLogger(InfoviewXMLDataUpdator.class);
    private List m_oComplexFieldDatas;
    private String m_sXMLContent = null;
    private Document m_oXMLDoc = null;
    private Hashtable m_hProperties = new Hashtable();
    private Hashtable m_hBakProperties = new Hashtable();
    private Hashtable m_hRepeatFieldProperties = new Hashtable();
    private HashMap m_hRepeatFieldOrder = new HashMap();
    private HashMap m_hRepeatGroupDataSize = new HashMap();
    private HashMap m_hAddRepeatGroupDataSize = new HashMap();
    private HashMap m_hRepeatFieldSize = new HashMap();
    private Hashtable m_hAddRepeatGroupData = new Hashtable();
    private Hashtable m_hAddRepeatGroup = new Hashtable();
    private List m_lDeleteFields = new ArrayList();

    public InfoviewXMLDataUpdator(String _sXMLContent) throws WCMException {
        this.m_sXMLContent = _sXMLContent;
        this.m_oXMLDoc = InfoViewHelper.parseToDocument(_sXMLContent);
    }

    public void setProperty(String _sName, String _sValue) {
        this.m_hProperties.put(_sName.trim().toUpperCase(), _sValue);
        this.m_hBakProperties.put(_sName.trim().toUpperCase(), _sValue);
    }

    private boolean containsProperty(String _sName) {
        return this.m_hProperties.containsKey(_sName.trim().toUpperCase());
    }

    private String getProperty(String _sName) {
        return (String)this.m_hProperties.get(_sName.trim().toUpperCase());
    }

    public void setRepeatField(String _sName, String _sValue, int _nOrder) throws WCMException {
        int nCurrFieldSize = this.getFieldInRepeatSize(_sName);
        if (nCurrFieldSize >= _nOrder) {
            this.m_hProperties.put(_sName.trim().toUpperCase(), _sValue);
            this.m_hRepeatFieldProperties.put(_sName.trim().toUpperCase() + ";" + _nOrder, _sValue);
            this.m_hRepeatFieldOrder.put(_sName.trim().toUpperCase(), String.valueOf(0));
        } else {
            this.setAddRepeatFieldValue(_sName, _sValue, _nOrder - nCurrFieldSize);
        }
    }

    private void setAddRepeatFieldValue(String _sName, String _sValue, int _nOrder) {
        Enumeration enumKey = this.m_hAddRepeatGroupData.keys();
        while (enumKey.hasMoreElements()) {
            String sKeyName = (String)enumKey.nextElement();
            HashMap sValueMap = (HashMap)this.m_hAddRepeatGroupData.get(sKeyName);
            if (sValueMap == null) {
                return;
            }
            for (Map.Entry o : sValueMap.entrySet()) {
                String[] sContent = o.toString().split("=");
                if (!sContent[0].equals(_sName) || Integer.parseInt(sKeyName.split(";")[1]) != _nOrder) continue;
                sValueMap.put(_sName, _sValue);
            }
        }
    }

    private void addFieldOrder(String _sTagName) {
        int nOrderValue = Integer.parseInt((String)this.m_hRepeatFieldOrder.get(_sTagName.trim().toUpperCase()));
        this.m_hRepeatFieldOrder.put(_sTagName.trim().toUpperCase(), String.valueOf(++nOrderValue));
    }

    public List getFieldValue(String _sNodeName) throws WCMException {
        ArrayList sValueList = new ArrayList();
        this.getElementFieldValue(_sNodeName, sValueList);
        return sValueList;
    }

    public void addInfoViewField(String _sFieldName, String _sValue) {
        this.m_hBakProperties.put(_sFieldName.trim().toUpperCase(), _sValue);
    }

    public void addRepeatFieldLine(String _sFieldName, HashMap _hRepeatData) {
        String sMapFieldName = _sFieldName.trim().toUpperCase();
        if (this.m_hAddRepeatGroupDataSize.containsKey(sMapFieldName)) {
            int currSize = Integer.parseInt((String)this.m_hAddRepeatGroupDataSize.get(sMapFieldName)) + 1;
            this.m_hAddRepeatGroupDataSize.put(sMapFieldName, String.valueOf(currSize));
        } else {
            this.m_hAddRepeatGroupDataSize.put(sMapFieldName, String.valueOf(1));
        }
        this.m_hAddRepeatGroupData.put(sMapFieldName + ";" + this.m_hAddRepeatGroupDataSize.get(sMapFieldName), _hRepeatData);
    }

    public void addRepeatFieldGroup(String _sFieldName, HashMap hValue) {
        this.m_hAddRepeatGroup.put(_sFieldName, hValue);
    }

    public void setRemoveField(String sFieldName, int nOrder) {
        this.m_lDeleteFields.add(sFieldName + ";" + nOrder);
    }

    public int getRepeatFieldSize(String _sFieldName) {
        if (this.m_hRepeatGroupDataSize.containsKey(_sFieldName.trim().toUpperCase())) {
            return Integer.parseInt((String)this.m_hRepeatGroupDataSize.get(_sFieldName.trim().toUpperCase()));
        }
        int nRepeatSize = 0;
        Element rootEl = this.m_oXMLDoc.getRootElement();
        if (rootEl == null) {
            return 0;
        }
        nRepeatSize = this.getRepeatFieldElementSize(rootEl, _sFieldName);
        this.m_hRepeatGroupDataSize.put(_sFieldName.trim().toUpperCase(), String.valueOf(nRepeatSize));
        return nRepeatSize;
    }

    public int getAppenDixFieldSize(String _sFieldName) {
        Element rootEl = this.m_oXMLDoc.getRootElement();
        if (rootEl == null) {
            return 0;
        }
        if (rootEl != null && rootEl.elements(_sFieldName) != null) {
            return rootEl.elements(_sFieldName).size();
        }
        return 0;
    }

    public void setAppendixField(String _sFieldName, String _sValue, int _index) {
        Element rootEl = this.m_oXMLDoc.getRootElement();
        if (rootEl == null) {
            return;
        }
        if (rootEl != null && rootEl.elements(_sFieldName) != null) {
            List els = rootEl.elements(_sFieldName);
            if (_index > els.size() - 1) {
                return;
            }
            ((Element)els.get(_index)).setText(_sValue);
        }
    }

    public int getNomalFieldSize(String _sFieldName) {
        if (this.m_hRepeatFieldSize.containsKey(_sFieldName)) {
            return Integer.parseInt((String)this.m_hRepeatFieldSize.get(_sFieldName));
        }
        Element rootEl = this.m_oXMLDoc.getRootElement();
        if (rootEl == null) {
            return 0;
        }
        int nSize = 0;
        Iterator itrRoot = rootEl.elementIterator();
        while (itrRoot.hasNext()) {
            String currName;
            Element childEl = (Element)itrRoot.next();
            if (childEl == null || !_sFieldName.equals(currName = childEl.getName())) continue;
            ++nSize;
        }
        this.m_hRepeatFieldSize.put(_sFieldName, String.valueOf(nSize));
        return nSize;
    }

    public int getFieldInRepeatSize(String _sFieldName) {
        if (this.m_hRepeatFieldSize.containsKey(_sFieldName)) {
            return Integer.parseInt((String)this.m_hRepeatFieldSize.get(_sFieldName));
        }
        Element rootEl = this.m_oXMLDoc.getRootElement();
        if (rootEl == null) {
            return 0;
        }
        Iterator itrRoot = rootEl.elementIterator();
        while (itrRoot.hasNext()) {
            Element childEl = this.getFieldNode((Element)itrRoot.next(), _sFieldName);
            if (childEl == null) continue;
            String sParentNodeName = childEl.getParent().getName();
            int nFieldSize = this.getRepeatFieldSize(sParentNodeName);
            this.m_hRepeatFieldSize.put(_sFieldName, String.valueOf(nFieldSize));
            return nFieldSize;
        }
        return 0;
    }

    private Element getFieldNode(Element _el, String _sFieldName) {
        if (_el.getName().equals(_sFieldName)) {
            return _el;
        }
        Iterator itrRoot = _el.elementIterator();
        while (itrRoot.hasNext()) {
            Element targetEl = this.getFieldNode((Element)itrRoot.next(), _sFieldName);
            if (targetEl == null) continue;
            return targetEl;
        }
        return null;
    }

    public int getRepeatFieldElementSize(Element _Xmlelement, String _sFieldName) {
        int nSize = 0;
        if (_Xmlelement != null) {
            List childEls = _Xmlelement.elements();
            for (int k = 0; k < childEls.size(); ++k) {
                Element childEl = (Element)childEls.get(k);
                List els = childEl.elements(_sFieldName);
                if (els.size() == 0) continue;
                nSize = els.size();
            }
        }
        return nSize;
    }

    public String update(String[] saNameSpaceURI) throws WCMException {
        Element elRoot = this.m_oXMLDoc.getRootElement();
        if (elRoot == null) {
            return this.m_sXMLContent;
        }
        String[] saNSPrefix = this.getNSPrefix(elRoot, saNameSpaceURI);
        if (saNSPrefix == null) {
            saNSPrefix = new String[]{elRoot.getNamespacePrefix()};
        }
        Iterator itrRoot = elRoot.elementIterator();
        while (itrRoot.hasNext()) {
            this.addElementField((Element)itrRoot.next(), saNSPrefix);
        }
        this.insertOtherElementField(elRoot);
        this.insertRepeatFieldGroup(elRoot);
        this.removeField(elRoot);
        return this.m_oXMLDoc.asXML();
    }

    private String[] getNSPrefix(Element elRoot, String[] saNSURI) {
        if (saNSURI == null) {
            return null;
        }
        List list = elRoot.declaredNamespaces();
        if (list == null) {
            return null;
        }
        ArrayList<String> alPrefix = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            Namespace namespace = (Namespace)list.get(i);
            for (int j = 0; j < saNSURI.length; ++j) {
                if (!namespace.getURI().equals(saNSURI[j])) continue;
                alPrefix.add(namespace.getPrefix());
            }
        }
        if (alPrefix.size() <= 0) {
            return null;
        }
        String[] saPrefix = new String[alPrefix.size()];
        alPrefix.toArray(saPrefix);
        return saPrefix;
    }

    private void addElementField(Element xmlElement, String[] saNSPrefix) throws WCMException {
        if (!this.acceptNamespace(xmlElement, saNSPrefix)) {
            return;
        }
        String sTagName = xmlElement.getName();
        if (this.acceptElement(xmlElement, saNSPrefix) && this.containsProperty(sTagName)) {
            Node node = xmlElement.node(0);
            if (this.m_hRepeatFieldOrder.containsKey(sTagName.trim().toUpperCase())) {
                this.addFieldOrder(sTagName);
                this.setRepeatFieldNodeValue(xmlElement, node);
            } else {
                this.setGeneralFieldValue(xmlElement, node);
            }
            this.m_hBakProperties.remove(sTagName.trim().toUpperCase());
        }
        if (this.m_hAddRepeatGroupDataSize.containsKey(sTagName.trim().toUpperCase())) {
            this.InsertRepeatFieldData(xmlElement);
        }
        Iterator itr = xmlElement.elementIterator();
        while (itr.hasNext()) {
            this.addElementField((Element)itr.next(), saNSPrefix);
        }
    }

    private void setRepeatFieldNodeValue(Element xmlElement, Node node) {
        String sTagName = xmlElement.getName();
        int nFieldOrder = Integer.parseInt((String)this.m_hRepeatFieldOrder.get(sTagName.trim().toUpperCase()));
        String sKey = sTagName.trim().toUpperCase() + ";" + nFieldOrder;
        if (!this.m_hRepeatFieldProperties.containsKey(sKey)) {
            return;
        }
        String sValue = (String)this.m_hRepeatFieldProperties.get(sKey);
        this.setFieldValue(xmlElement, node, sValue);
    }

    private void InsertRepeatFieldData(Element _repeatFieldElement) {
        Element oRepeatparentEl = _repeatFieldElement.getParent();
        String currRepeatFieldName = _repeatFieldElement.getName();
        String sMapFieldName = currRepeatFieldName.trim().toUpperCase();
        int nAddRepeatFieldDataSize = Integer.parseInt((String)this.m_hAddRepeatGroupDataSize.get(sMapFieldName));
        List currEls = oRepeatparentEl.elements(currRepeatFieldName);
        Element elTemplate = null;
        Element elTemplateOrg = null;
        int currSize = currEls.size();
        if (currSize > 0) {
            elTemplateOrg = (Element)currEls.get(currSize - 1);
            boolean bCanRemove = true;
            for (int k = 0; k < nAddRepeatFieldDataSize; ++k) {
                elTemplate = (Element)elTemplateOrg.clone();
                Iterator childIter = elTemplate.elementIterator();
                while (childIter.hasNext()) {
                    Element el = (Element)childIter.next();
                    String sDataFieldName = sMapFieldName + ";" + (k + 1);
                    String sValue = this.m_hAddRepeatGroupData.get(sDataFieldName) != null ? (((HashMap)this.m_hAddRepeatGroupData.get(sDataFieldName)).containsKey(el.getName()) ? (String)((HashMap)this.m_hAddRepeatGroupData.get(sDataFieldName)).get(el.getName()) : "") : "";
                    Node node = el.node(0);
                    if (node.getText() != null && !node.getText().equals("")) {
                        bCanRemove = false;
                    }
                    this.setFieldValue(el, node, sValue);
                }
                oRepeatparentEl.add(elTemplate);
            }
            if (bCanRemove) {
                oRepeatparentEl.remove(elTemplateOrg);
            }
        }
        this.m_hAddRepeatGroupDataSize.clear();
    }

    private void insertOtherElementField(Element _rootEl) {
        Enumeration enumKey = this.m_hBakProperties.keys();
        while (enumKey.hasMoreElements()) {
            String sKeyName = (String)enumKey.nextElement();
            String sValue = (String)this.m_hBakProperties.get(sKeyName);
            Element el = DocumentHelper.createElement((String)("my:" + sKeyName));
            CDATA cdata = DocumentHelper.createCDATA((String)sValue);
            el.add(cdata);
            _rootEl.add(el);
        }
    }

    private void insertRepeatFieldGroup(Element _rootEl) {
        Enumeration enumKey = this.m_hAddRepeatGroup.keys();
        while (enumKey.hasMoreElements()) {
            String sKeyName = (String)enumKey.nextElement();
            String[] sFieldName = sKeyName.split("_");
            if (sFieldName.length != 2) continue;
            Element parentEl = DocumentHelper.createElement((String)("my:" + sFieldName[0]));
            Element groupEl = DocumentHelper.createElement((String)("my:" + sFieldName[1]));
            groupEl.addAttribute("complex_field", "1");
            HashMap hValueMap = (HashMap)this.m_hAddRepeatGroup.get(sKeyName);
            for (Map.Entry o : hValueMap.entrySet()) {
                String[] keyAndValue = o.toString().split("=");
                String sValue = keyAndValue.length == 2 ? keyAndValue[1] : "";
                Element el = DocumentHelper.createElement((String)("my:" + keyAndValue[0]));
                CDATA cdata = DocumentHelper.createCDATA((String)sValue);
                el.add(cdata);
                groupEl.add(el);
            }
            parentEl.add(groupEl);
            _rootEl.add(parentEl);
        }
    }

    private void removeField(Element _rootEl) {
        if (this.m_lDeleteFields.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_lDeleteFields.size(); ++i) {
            String sFieldNameInfo = (String)this.m_lDeleteFields.get(i);
            String[] aDeleteFieldInfo = sFieldNameInfo.split(";");
            int nFieldOrder = Integer.parseInt(aDeleteFieldInfo[1]);
            String sFieldName = aDeleteFieldInfo[0];
            boolean bRemoveSucessed = false;
            if (sFieldName.indexOf("_") < 0) {
                bRemoveSucessed = this.removeChildElement(_rootEl, sFieldName, nFieldOrder);
            } else {
                String[] repeatFieldInfo = sFieldName.split("_");
                Element parentElement = _rootEl.element(repeatFieldInfo[0]);
                if (parentElement == null) continue;
                bRemoveSucessed = this.removeChildElement(parentElement, repeatFieldInfo[1], nFieldOrder);
            }
            if (!bRemoveSucessed) continue;
            this.reduceSameRemoveFieldIndex(sFieldName, nFieldOrder);
        }
    }

    private void reduceSameRemoveFieldIndex(String sFieldName, int nFieldOrder) {
        if (CMyString.isEmpty(sFieldName)) {
            return;
        }
        for (int i = 0; i < this.m_lDeleteFields.size(); ++i) {
            int nCurrIndex;
            String[] sDeleteFieldInfo = ((String)this.m_lDeleteFields.get(i)).split(";");
            String sCurrFieldName = sDeleteFieldInfo[0];
            if (!sFieldName.equals(sCurrFieldName) || nFieldOrder >= (nCurrIndex = Integer.parseInt(sDeleteFieldInfo[1]))) continue;
            String sNewFieldInfo = sCurrFieldName + ";" + --nCurrIndex;
            this.m_lDeleteFields.set(i, sNewFieldInfo);
        }
    }

    private boolean removeChildElement(Element _parentEl, String _sChildElName, int _nChildIndex) {
        if (_parentEl == null || CMyString.isEmpty(_sChildElName)) {
            return false;
        }
        List els = _parentEl.elements(_sChildElName);
        if (els == null || _nChildIndex > els.size() || _nChildIndex < 1) {
            return false;
        }
        Element el = (Element)els.get(_nChildIndex - 1);
        if (el == null) {
            return false;
        }
        el.detach();
        return true;
    }

    private void setGeneralFieldValue(Element xmlElement, Node node) {
        String sTagName = xmlElement.getName();
        String sValue = this.getProperty(sTagName);
        this.setFieldValue(xmlElement, node, sValue);
    }

    private void setFieldValue(Element xmlElement, Node node, String _sValue) {
        if (node != null && node.getNodeType() == 4) {
            node.setText(_sValue);
        } else {
            xmlElement.setText(_sValue);
        }
    }

    private void getElementFieldValue(String _sNodeName, List _aValueList) throws WCMException {
        Element elRoot = this.m_oXMLDoc.getRootElement();
        if (elRoot == null) {
            return;
        }
        String[] saNSPrefix = this.getNSPrefix(elRoot, null);
        if (saNSPrefix == null) {
            saNSPrefix = new String[]{elRoot.getNamespacePrefix()};
        }
        Iterator itRoot = elRoot.elementIterator();
        while (itRoot.hasNext()) {
            this.getElementField((Element)itRoot.next(), saNSPrefix, _sNodeName, _aValueList);
        }
    }

    private void getElementField(Element xmlElement, String[] saNSPrefix, String _sNodeName, List _aValueList) throws WCMException {
        if (!this.acceptNamespace(xmlElement, saNSPrefix)) {
            return;
        }
        if (xmlElement != null) {
            if (this.acceptElement(xmlElement, saNSPrefix, _sNodeName)) {
                if (xmlElement.getText() != null) {
                    _aValueList.add(xmlElement.getTextTrim());
                } else {
                    _aValueList.add("");
                }
            }
            Iterator itr = xmlElement.elementIterator();
            while (itr.hasNext()) {
                this.getElementField((Element)itr.next(), saNSPrefix, _sNodeName, _aValueList);
            }
        }
    }

    private boolean acceptElement(Element node, String[] saNSPrefix, String _sNodeName) {
        if (node.hasMixedContent()) {
            Iterator itr = node.elementIterator();
            while (itr.hasNext()) {
                if (!this.acceptNamespace((Element)itr.next(), saNSPrefix)) continue;
                return false;
            }
        }
        return node.getName().equalsIgnoreCase(_sNodeName);
    }

    private boolean acceptElement(Element node, String[] saNSPrefix) {
        if (node.hasMixedContent()) {
            Iterator itr = node.elementIterator();
            while (itr.hasNext()) {
                if (!this.acceptNamespace((Element)itr.next(), saNSPrefix)) continue;
                return false;
            }
        }
        return this.m_hProperties.containsKey(node.getName().toUpperCase());
    }

    private boolean acceptNamespace(Element node, String[] saNSPrefix) {
        if (saNSPrefix == null) {
            return true;
        }
        String sPrefix = node.getNamespacePrefix();
        if (sPrefix == null || sPrefix.length() <= 0) {
            return false;
        }
        for (int i = saNSPrefix.length - 1; i >= 0; --i) {
            if (!sPrefix.equals(saNSPrefix[i])) continue;
            return true;
        }
        return false;
    }

    public List getComplexFieldDatas() {
        if (this.m_oComplexFieldDatas == null) {
            this.m_oComplexFieldDatas = new ArrayList(5);
        }
        return this.m_oComplexFieldDatas;
    }

    public static void main(String[] args) {
        try {
            String sXMLContent = CMyFile.readFile("c:\\infoview_data.txt");
            System.out.println(I18NMessage.get(InfoviewXMLDataUpdator.class, "InfoviewXMLDataUpdator.label1", "==============\u5904\u7406\u4e4b\u524d\u7684\u6570\u636e=================="));
            System.out.println(sXMLContent);
            InfoviewXMLDataUpdator updator = new InfoviewXMLDataUpdator(sXMLContent);
            int n = updator.getAppenDixFieldSize("\u9644\u4ef6_01");
            updator.setAppendixField("\u9644\u4ef6_01", "lalal", 1);
            System.out.println("\u6700\u540e\u662f\u4ec0\u4e48\u5462------------" + updator.update(null));
            System.out.println("==========================\u83b7\u53d6\u5230\u7684\u503c\u4e3a===============");
            List arrayList = updator.getFieldValue("\u5ba2\u6237\u7ecf\u7406");
            for (int i = 0; i < arrayList.size(); ++i) {
                System.out.println(arrayList.get(i));
            }
            updator.setProperty(I18NMessage.get(InfoviewXMLDataUpdator.class, "InfoviewXMLDataUpdator.label2", "\u5ba2\u6237\u7ecf\u7406"), I18NMessage.get(InfoviewXMLDataUpdator.class, "InfoviewXMLDataUpdator.label3", "test"));
            System.out.println(I18NMessage.get(InfoviewXMLDataUpdator.class, "InfoviewXMLDataUpdator.label4", "==============\u5904\u7406\u540e\u7684\u6570\u636e=================="));
            updator.setRepeatField("\u5e8f\u53f7", "200", 2);
            updator.setRepeatField("\u5e8f\u53f7", "100", 1);
            updator.setProperty("\u59d3\u540d", "\u5218\u7ea2\u6885");
            updator.addInfoViewField("\u5355\u4f4d", "TRS");
            HashMap<String, String> oValueHap = new HashMap<String, String>();
            oValueHap.put("\u5e8f\u53f7", "new1");
            oValueHap.put("\u4ea7\u54c1\u540d\u79f0", "new2");
            updator.addRepeatFieldLine("group10", oValueHap);
            updator.addRepeatFieldGroup("group11_group12", oValueHap);
            updator.setRepeatField("\u5e8f\u53f7", "300", 3);
            System.out.println(updator.update(null));
            System.out.println("==========================\u83b7\u53d6\u5230\u7684\u503c\u4e3a===============");
            List arrayListla = updator.getFieldValue("\u5e8f\u53f7");
            for (int i = 0; i < arrayListla.size(); ++i) {
                System.out.println("\u7b2c\u51e0\u4e2a\u5462=====" + arrayListla.get(i));
            }
            List arrayListnew = updator.getFieldValue("\u5ba2\u6237\u7ecf\u7406");
            if (arrayListnew.get(0).equals("admin")) {
                updator.setProperty("\u5ba2\u6237\u7ecf\u7406", "newadmin");
            }
            updator.setRepeatField("\u4ea7\u54c1\u540d\u79f0", "portal", 1);
            updator.addInfoViewField("\u65b0\u589e\u7684\u5b57\u6bb5", "new");
            HashMap<String, String> hValue = new HashMap<String, String>();
            hValue.put("\u5e8f\u53f7", "3");
            hValue.put("\u7248\u672cBuild", "\u8868\u5355");
            updator.addRepeatFieldLine("group10", hValue);
            HashMap<String, String> hValueSecond = new HashMap<String, String>();
            hValueSecond.put("\u5e8f\u53f7", "4");
            hValueSecond.put("\u7248\u672cBuild", "\u8868\u5355");
            updator.addRepeatFieldLine("group10", hValueSecond);
            updator.setRepeatField("\u7248\u672cBuild", "61\u7684\u8868\u5355", 4);
            HashMap<String, String> hValueNew = new HashMap<String, String>();
            hValueNew.put("\u59d3\u540d", "\u5218\u7ea2\u6885");
            hValueNew.put("\u6027\u522b", "\u4e0d\u7537\u4e0d\u5973");
            updator.addRepeatFieldGroup("group11_group12", hValueNew);
            System.out.println("\u6700\u540e\u7684\u6570\u636e\u4e3a=========================================");
            System.out.println(updator.update(null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

