/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.infoview.config;

import com.trs.components.infoview.InfoViewHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class InfoViewEnumHelper {
    public static String split2Options(String sKey, String saValues, String sSplitBy, String sValueSplitBy) {
        StringBuffer sbTmp = new StringBuffer();
        sbTmp.append("<script>\n");
        sbTmp.append("\tif(!window.DymEnum){\n");
        sbTmp.append("\t\twindow.DymEnum = {};\n");
        sbTmp.append("\t}\n");
        sbTmp.append("\twindow.DymEnum[\"");
        sbTmp.append(CMyString.filterForJs(sKey));
        sbTmp.append("\"] = [\n");
        String[] enumOptions = saValues.split(sSplitBy);
        for (int i = 0; i < enumOptions.length; ++i) {
            String sValue;
            if (enumOptions[i].trim().length() == 0) continue;
            String[] enumOption = enumOptions[i].trim().split(sValueSplitBy);
            String sDisplay = sValue = enumOption[0];
            if (enumOption.length >= 2) {
                sDisplay = enumOption[1];
            }
            if (i != 0) {
                sbTmp.append(",\n");
            }
            sbTmp.append("\t\t{value:\"");
            sbTmp.append(CMyString.filterForJs(sValue));
            sbTmp.append("\",display:\"");
            sbTmp.append(CMyString.filterForJs(sDisplay));
            sbTmp.append("\"}");
        }
        sbTmp.append("\n\t];\n");
        sbTmp.append("</script>\n");
        return sbTmp.toString();
    }

    public static String split2Options(String sKey, String saValues) {
        return InfoViewEnumHelper.split2Options(sKey, saValues, ",", "~");
    }

    private InfoViewEnumHelper() {
    }

    private static HashMap parseChains2Map(String sXmlContent) throws WCMException {
        Document oXmlDocument = InfoViewHelper.parseToDocument(sXmlContent);
        List lstNodes = oXmlDocument.selectNodes("//chains/chain");
        if (lstNodes == null || lstNodes.size() == 0) {
            return null;
        }
        HashMap<String, Cloneable> hmResult = new HashMap<String, Cloneable>();
        ArrayList<String> alChainItems = new ArrayList<String>();
        hmResult.put("ChainItems", alChainItems);
        HashMap hmData = new HashMap();
        hmResult.put("Data", hmData);
        for (Element eleChain : lstNodes) {
            String sChainKeys = eleChain.attributeValue("keys");
            alChainItems.add(sChainKeys);
            Element eleChainItems = eleChain.element("items");
            if (eleChainItems == null) continue;
            InfoViewEnumHelper.renderItemsData(eleChainItems, hmData);
        }
        return hmResult;
    }

    private static void renderItemsData(Element eleChainItems, HashMap _hmData) {
        String sKey = null;
        sKey = eleChainItems.attributeValue("key");
        ArrayList alDataItems = new ArrayList();
        _hmData.put(sKey, alDataItems);
        List lstNodes = eleChainItems.elements("item");
        for (Element elDataItem : lstNodes) {
            HashMap<String, String> aDataItem = new HashMap<String, String>();
            alDataItems.add(aDataItem);
            String sItemValue = CMyString.showNull(elDataItem.attributeValue("value"));
            aDataItem.put("value", sItemValue);
            aDataItem.put("display", CMyString.showNull(elDataItem.attributeValue("display"), sItemValue));
            Element elItemChilds = elDataItem.element("items");
            if (elItemChilds == null) continue;
            InfoViewEnumHelper.renderItemsData(elItemChilds, aDataItem);
        }
    }

    public static String parseChains2Script(String sContent) throws WCMException {
        HashMap hmSources = InfoViewEnumHelper.parseChains2Map(sContent);
        String sResult = InfoViewEnumHelper.parseChainsMap2Script(hmSources);
        return sResult;
    }

    private static String parseChainsMap2Script(HashMap hmSources) {
        if (hmSources == null) {
            return "";
        }
        StringBuffer sbTmp = new StringBuffer();
        sbTmp.append("<script>\n");
        sbTmp.append("\tif(!window.m_oLinkedEnums){\n");
        sbTmp.append("\t\twindow.m_oLinkedEnums = ");
        sbTmp.append(InfoViewHelper.parse2Json(hmSources));
        sbTmp.append(";\n");
        sbTmp.append("\t}\n");
        sbTmp.append("</script>\n");
        return sbTmp.toString();
    }

    public static void main(String[] args) {
        String sContent = "<chains><chain keys=\"" + I18NMessage.get(InfoViewEnumHelper.class, "InfoViewEnumHelper.label2", "\u5730\u533a,\u56fd\u5bb6,\u57ce\u5e02") + "\">\n<items key=\"" + I18NMessage.get(InfoViewEnumHelper.class, "InfoViewEnumHelper.label3", "\u5730\u533a") + "\">\n<item value=\"" + I18NMessage.get(InfoViewEnumHelper.class, "InfoViewEnumHelper.label4", "\u4e9a\u6d32") + "\">\n<items key=\"" + I18NMessage.get(InfoViewEnumHelper.class, "InfoViewEnumHelper.label5", "\u56fd\u5bb6") + "\">\n<item value=\"" + I18NMessage.get(InfoViewEnumHelper.class, "InfoViewEnumHelper.label6", "\u4e2d\u56fd") + "\">\n<items key=\"" + I18NMessage.get(InfoViewEnumHelper.class, "InfoViewEnumHelper.label7", "\u57ce\u5e02") + "\">\n<item value=\"" + I18NMessage.get(InfoViewEnumHelper.class, "InfoViewEnumHelper.label8", "\u5317\u4eac") + "\"/><item value=\"" + I18NMessage.get(InfoViewEnumHelper.class, "InfoViewEnumHelper.label9", "\u4e0a\u6d77") + "\"/><item value=\"" + I18NMessage.get(InfoViewEnumHelper.class, "InfoViewEnumHelper.label10", "\u5929\u6d25") + "\"/></items></item><item value=\"" + I18NMessage.get(InfoViewEnumHelper.class, "InfoViewEnumHelper.label11", "\u5370\u5ea6") + "\">\n<items key=\"" + I18NMessage.get(InfoViewEnumHelper.class, "InfoViewEnumHelper.label7", "\u57ce\u5e02") + "\">\n<item value=\"AA\"/><item value=\"BB\"/></items></item></items></item><item value=\"" + I18NMessage.get(InfoViewEnumHelper.class, "InfoViewEnumHelper.label12", "\u975e\u6d32") + "\"></item></items></chain></chains>";
        try {
            System.out.println(sContent);
            String sResult = InfoViewEnumHelper.parseChains2Script(sContent);
            System.out.println(sResult);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

