/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.govinfo;

import com.trs.components.govinfo.GovInfoViewFinder;
import com.trs.components.metadata.definition.MetaDataDefHelper;
import com.trs.components.metadata.definition.MetaView;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.listener.IObjectLCListenerOnAdd;
import com.trs.infra.persistent.listener.IObjectLCListenerOnDel;
import com.trs.infra.persistent.listener.IObjectLCListenerOnModify;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import java.io.File;

public class GovInfoLCListenerMetaView
implements IObjectLCListenerOnAdd,
IObjectLCListenerOnDel,
IObjectLCListenerOnModify {
    @Override
    public void notifyOnAddObj(BaseObj objAdded) throws WCMException {
        MetaView currMetaView = (MetaView)objAdded;
        boolean bIsGovInfoView = GovInfoViewFinder.isGovInfoView(currMetaView);
        String sApplicationPath = MetaDataDefHelper.getViewApplicationRootPath();
        int nViewId = currMetaView.getId();
        String sTempApplicationPath = sApplicationPath + File.separatorChar + nViewId + File.separatorChar + "template" + File.separatorChar;
        if (bIsGovInfoView) {
            if (!CMyFile.pathExists(sTempApplicationPath)) {
                CMyFile.makeDir(sTempApplicationPath, true);
            }
            String sGovInfoViewTemplatePath = sApplicationPath + File.separatorChar + "govinfo" + File.separatorChar + "template" + File.separatorChar;
            try {
                CMyFile.copyFileDir(sGovInfoViewTemplatePath, sTempApplicationPath, false);
            }
            catch (CMyException e) {
                throw new WCMException("\u62f7\u8d1d\u653f\u5e9c\u4fe1\u606f\u516c\u5f00\u7684\u6a21\u677f\u6587\u4ef6\u5931\u8d25\u3002", e);
            }
        }
        if (currMetaView.isSpecialView()) {
            if (!CMyFile.pathExists(sTempApplicationPath)) {
                CMyFile.makeDir(sTempApplicationPath, true);
            }
            String sSpecialViewTemplatePath = sApplicationPath + File.separatorChar + "metaresource" + File.separatorChar;
            try {
                CMyFile.copyFileDir(sSpecialViewTemplatePath, sTempApplicationPath, false);
            }
            catch (CMyException e) {
                throw new WCMException("\u62f7\u8d1d\u8d44\u6e90\u7ed3\u6784\u7684\u6a21\u677f\u6587\u4ef6\u5931\u8d25\u3002", e);
            }
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj objDeleted, int eventType) throws WCMException {
    }

    @Override
    public void notifyOnModifyObj(BaseObj objModified, int eventType) throws WCMException {
    }
}

