/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.trsad;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.trsad.ADFiles;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyDateTime;

public class ADCom
extends CMSObj {
    public static final int OBJ_TYPE = 2024;
    public static final String DB_TABLE_NAME = "XWCMADCOM";
    public static final String DB_ID_NAME = "ADCOMID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 2024;
    }

    public String getComName() {
        return this.getPropertyAsString("COMNAME");
    }

    public boolean setComName(String _sComName) throws WCMException {
        return this.setProperty("COMNAME", _sComName);
    }

    public String getComUrl() {
        return this.getPropertyAsString("COMSITE");
    }

    public boolean setComUrl(String _sComUrl) throws WCMException {
        return this.setProperty("COMSITE", _sComUrl);
    }

    public String getComContact() {
        return this.getPropertyAsString("COMCONTACT");
    }

    public boolean setComContact(String _sComContact) throws WCMException {
        return this.setProperty("COMCONTACT", _sComContact);
    }

    public String getComTel() {
        return this.getPropertyAsString("COMTEL");
    }

    public boolean setComTel(String _sComTel) throws WCMException {
        return this.setProperty("COMTEL", _sComTel);
    }

    public String getComAddress() {
        return this.getPropertyAsString("COMADDRESS");
    }

    public boolean setComAddress(String _sComAddress) throws WCMException {
        return this.setProperty("COMADDRESS", _sComAddress);
    }

    public String getComDesc() {
        return this.getPropertyAsString("COMDESC");
    }

    public boolean setComDesc(String _sComDesc) throws WCMException {
        return this.setProperty("COMDESC", _sComDesc);
    }

    public String getComCruser() {
        return this.getPropertyAsString("COMCRUSER");
    }

    public boolean setComCruser(String _sComCruser) throws WCMException {
        return this.setProperty("COMCRUSER", _sComCruser);
    }

    public CMyDateTime getComCrtime() {
        return (CMyDateTime)this.getProperty("COMCRTIME");
    }

    public boolean setComCrtime(CMyDateTime _dtComCrtime) throws WCMException {
        return this.setProperty("COMCRTIME", _dtComCrtime);
    }

    public String getComEmail() {
        return this.getPropertyAsString("COMEMAIL");
    }

    public boolean setComEmail(String _sComEmail) throws WCMException {
        return this.setProperty("COMEMAIL", _sComEmail);
    }

    public int getComPeople() {
        return this.getPropertyAsInt("COMPEOPLE", 0);
    }

    public boolean setComPeople(int _nComPeople) throws WCMException {
        return this.setProperty("COMPEOPLE", _nComPeople);
    }

    public String getComZipcode() {
        return this.getPropertyAsString("COMZIPCODE");
    }

    public boolean setComZipcode(String _sComZipcode) throws WCMException {
        return this.setProperty("COMZIPCODE", _sComZipcode);
    }

    public String getComZone() {
        return this.getPropertyAsString("COMZONE");
    }

    public boolean setComZone(String _sComZone) throws WCMException {
        return this.setProperty("COMZONE", _sComZone);
    }

    public String getComZo() {
        return this.getPropertyAsString("COMZO");
    }

    public boolean setComZo(String _sComZo) throws WCMException {
        return this.setProperty("COMZO", _sComZo);
    }

    public String getComMobile() {
        return this.getPropertyAsString("COMMOBILE");
    }

    public boolean setComMobile(String _sComMobile) throws WCMException {
        return this.setProperty("COMMOBILE", _sComMobile);
    }

    public int getComPubN() {
        return this.getPropertyAsInt("COMPUBN", 0);
    }

    public boolean setComPubN(int _sComPubN) throws WCMException {
        return this.setProperty("COMPUBN", _sComPubN);
    }

    public String getComConTit() {
        return this.getPropertyAsString("COMCONTIT");
    }

    public boolean setComConTit(String _sComConTit) throws WCMException {
        return this.setProperty("COMCONTIT", _sComConTit);
    }

    public ADFiles getADFiles() throws WCMException {
        ADFiles adfiles = new ADFiles(User.getSystem());
        adfiles.open(new WCMFilter("", "ADFILEID=" + this.getId(), ""));
        return adfiles;
    }

    @Override
    public int delete(User _currUser) throws WCMException {
        String sSql = "";
        try {
            sSql = "delete XWCMADFile where  ADCOMPANY=" + this.getId();
            super.getDBManager().sqlExecuteUpdate(sSql);
        }
        catch (Exception ex) {
            throw new WCMException(1000, "\u5220\u9664\u7528\u6237\u4e2a\u6027\u5316\u5b9a\u5236\u7684\u9891\u9053\u5931\u8d25\uff08Channel.delete\uff09", ex);
        }
        return super.delete(_currUser);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getAllProperty().get("COMSITE") == null) {
                throw new WCMException(1106, I18NMessage.get(ADCom.class, "ADCom.label1", "\u5c5e\u6027ComUrl\u6ca1\u6709\u8bbe\u7f6e(ADCOM.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(ADCom.class, "ADCom.label2", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(ADCOM.isValid)"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            if (this.getAllProperty().get("COMNAME") == null) {
                this.setComName("");
            }
            if (this.getAllProperty().get("COMZO") == null) {
                this.setComZo("");
            }
            if (this.getAllProperty().get("COMZONE") == null) {
                this.setComZone("");
            }
            super.insert(_currUser);
        }
    }
}

