/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget.acceptor;

import com.trs.DreamFactory;
import com.trs.components.common.publish.widget.IWidgetMgr;
import com.trs.components.common.publish.widget.Widget;
import com.trs.components.common.publish.widget.acceptor.IWidgetAcceptor;
import com.trs.components.common.publish.widget.acceptor.IWidgetAcceptorContext;
import com.trs.components.common.publish.widget.acceptor.IWidgetAcceptorSelector;
import com.trs.infra.common.WCMException;
import com.trs.infra.util.CMyString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class WidgetAcceptSelector
implements IWidgetAcceptorSelector {
    private static Logger logger = Logger.getLogger(WidgetAcceptSelector.class);
    protected IWidgetMgr widgetMgr = (IWidgetMgr)DreamFactory.createObjectById("IWidgetMgr");
    private String mWidgetAcceptorFileName = "/WigetAcceptors.xml";
    private List widgetAcceptorNames;
    private Map widgetAcceptors;

    private void init() {
        if (logger.isDebugEnabled()) {
            this.widgetAcceptors = null;
        }
        if (this.widgetAcceptors != null) {
            return;
        }
        this.widgetAcceptors = new HashMap();
        this.widgetAcceptorNames = new ArrayList();
        String sWidgetAcceptorFilePath = this.getClass().getResource(this.mWidgetAcceptorFileName).getFile();
        if (CMyString.isEmpty(sWidgetAcceptorFilePath)) {
            logger.error((Object)("\u8d44\u6e90\u5757\u9009\u62e9\u914d\u7f6e\u6587\u4ef6[" + this.mWidgetAcceptorFileName + "]\u4e0d\u5b58\u5728"));
            return;
        }
        SAXReader reader = new SAXReader();
        Document document = null;
        try {
            document = reader.read(sWidgetAcceptorFilePath);
        }
        catch (DocumentException e) {
            logger.error((Object)"\u8bfb\u53d6\u8d44\u6e90\u5757\u9009\u62e9\u5668\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            return;
        }
        Element root = document.getRootElement();
        boolean isFirst = true;
        Iterator i = root.elementIterator("WigetAcceptor");
        while (i.hasNext()) {
            Element elAcceptor = (Element)i.next();
            String sName = elAcceptor.attributeValue("name");
            if (CMyString.isEmpty(sName)) {
                logger.error((Object)"\u8d44\u6e90\u5757\u9009\u62e9\u5668\u6ca1\u6709\u914d\u7f6e\u540d\u79f0[name]");
                continue;
            }
            try {
                Widget oWidget = this.widgetMgr.findWidgetByName(null, sName);
                if (oWidget == null) {
                    logger.error((Object)("\u7cfb\u7edf\u4e2d\u6ca1\u6709\u627e\u5230\u540d\u79f0\u4e3a[" + sName + "]\u7684\u8d44\u6e90\u5757"));
                    continue;
                }
            }
            catch (Exception e) {
                logger.error((Object)("\u68c0\u67e5\u540d\u79f0\u4e3a[" + sName + "]\u7684\u8d44\u6e90\u51fa\u73b0\u5f02\u5e38"), (Throwable)e);
            }
            String sClass = elAcceptor.attributeValue("class");
            if (CMyString.isEmpty(sClass)) {
                logger.error((Object)"\u8d44\u6e90\u5757\u9009\u62e9\u5668\u6ca1\u6709\u914d\u7f6e\u7c7b\u540d[class]");
                continue;
            }
            try {
                IWidgetAcceptor acceptor = (IWidgetAcceptor)Class.forName(sClass).newInstance();
                this.widgetAcceptorNames.add(sName);
                acceptor.setWidgetName(sName);
                this.widgetAcceptors.put(sName, acceptor);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("\u6210\u529f\u52a0\u8f7d\u8d44\u6e90\u5757[" + sName + "]\u667a\u80fd\u9009\u62e9\u5668[" + sClass + "]"));
                }
                Iterator attributes = elAcceptor.attributeIterator();
                while (attributes.hasNext()) {
                    Attribute attribute = (Attribute)attributes.next();
                    acceptor.setExtraParam(attribute.getName(), attribute.getValue());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("\u8bbe\u7f6e\u9009\u62e9\u5668\u914d\u7f6e\u53c2\u6570[" + attribute.getName() + "]\u667a\u80fd\u9009\u62e9\u5668[" + attribute.getValue() + "]"));
                }
                if (!isFirst) continue;
                isFirst = false;
                Iterator rootAttributes = root.attributeIterator();
                while (rootAttributes.hasNext()) {
                    Attribute attribute = (Attribute)rootAttributes.next();
                    acceptor.setGlobalParam(attribute.getName(), attribute.getValue());
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug((Object)("\u8bbe\u7f6e\u5168\u5c40\u9009\u62e9\u5668\u914d\u7f6e\u53c2\u6570[" + attribute.getName() + "]\u667a\u80fd\u9009\u62e9\u5668[" + attribute.getValue() + "]"));
                }
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)("\u627e\u4e0d\u5230\u667a\u80fd\u8d44\u6e90\u9009\u62e9\u6240\u9700\u8981\u7684\u9009\u62e9\u5668[" + sClass + "]"), (Throwable)e);
            }
            catch (Exception e) {
                logger.error((Object)"\u521d\u59cb\u5316\u8d44\u6e90\u5757\u9009\u62e9\u5668\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    @Override
    public Widget getWidget(IWidgetAcceptorContext context) throws WCMException {
        this.init();
        int length = this.widgetAcceptorNames.size();
        for (int index = 0; index < length; ++index) {
            String sWidgetName = (String)this.widgetAcceptorNames.get(index);
            IWidgetAcceptor acceptor = (IWidgetAcceptor)this.widgetAcceptors.get(sWidgetName);
            if (acceptor == null) {
                return null;
            }
            context.resetWidgetParameter();
            if (!acceptor.accept(context)) continue;
            return acceptor.getWidget();
        }
        return null;
    }
}

