/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.publish.widget.ILayoutGenerator;
import com.trs.components.common.publish.widget.ILayoutMgr;
import com.trs.components.common.publish.widget.ILayoutServiceProvider;
import com.trs.components.common.publish.widget.Layout;
import com.trs.components.common.publish.widget.Layouts;
import com.trs.components.common.publish.widget.MasterMgr;
import com.trs.components.common.publish.widget.SpecialAuthServer;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;

public class LayoutServiceProvider
implements ILayoutServiceProvider {
    private ILayoutMgr m_oLayoutMgr = (ILayoutMgr)DreamFactory.createObjectById("ILayoutMgr");
    private ILayoutGenerator m_oLayoutGenerator = (ILayoutGenerator)DreamFactory.createObjectById("ILayoutGenerator");

    @Override
    public void delete(MethodContext context) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        String sLayoutIds = context.getObjectIds();
        Layouts oLayouts = Layouts.findByIds(loginUser, sLayoutIds);
        Layouts oNoRightLayouts = Layouts.createNewInstance(loginUser);
        for (int i = oLayouts.size() - 1; i >= 0; --i) {
            Layout currLayout = (Layout)oLayouts.getAt(i);
            if (currLayout == null || SpecialAuthServer.hasRight(loginUser, currLayout, 23)) continue;
            oNoRightLayouts.addElement(currLayout);
            oLayouts.remove(currLayout, false);
        }
        this.m_oLayoutMgr.delete(loginUser, oLayouts);
        if (oNoRightLayouts.size() > 0) {
            throw new WCMException("\u4f60\u6ca1\u6709\u6743\u9650\u5220\u9664ID\u4e3a[" + oNoRightLayouts.getIdListAsString() + "]\u7684 \u5e03\u5c40\uff01");
        }
    }

    @Override
    public Object query(MethodContext context) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        WCMFilter extraFilter = context.getExtraWCMFilter();
        Layouts oLayouts = this.m_oLayoutMgr.query(loginUser, extraFilter);
        for (int i = oLayouts.size() - 1; i >= 0; --i) {
            Layout currLayout = (Layout)oLayouts.getAt(i);
            if (currLayout == null || SpecialAuthServer.hasRight(loginUser, currLayout, 24)) continue;
            oLayouts.remove(currLayout, false);
        }
        return oLayouts;
    }

    @Override
    public int save(MethodContext context) throws WCMException {
        User loginUser = ContextHelper.getLoginUser();
        int nLayoutId = context.getObjectId();
        Layout currLayout = null;
        if (nLayoutId > 0) {
            currLayout = Layout.findById(nLayoutId);
            if (currLayout == null) {
                throw new WCMException(CMyString.format(I18NMessage.get(MasterMgr.class, "LayoutMgr.label9", "\u6ca1\u6709\u627e\u5230ID\u4e3a[{0}]\u7684\u5e03\u5c40\uff01"), new String[]{String.valueOf(nLayoutId)}));
            }
        } else {
            currLayout = Layout.createNewInstance();
        }
        if (!SpecialAuthServer.hasRight(loginUser, currLayout, 21)) {
            throw new WCMException("\u5bf9\u4e0d\u8d77\uff0c\u60a8\u6ca1\u6709\u4fee\u6539\u548c\u4fdd\u5b58\u5e03\u5c40\u7684\u6743\u9650\uff01");
        }
        String[] pLogicFields = new String[]{"ObjectId"};
        currLayout = (Layout)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, context, currLayout, pLogicFields);
        this.m_oLayoutMgr.save(loginUser, currLayout);
        return currLayout.getId();
    }

    @Override
    public String getLayoutHtml(MethodContext context) throws WCMException {
        int nRatioType = context.getValue("RatioType", Layout.RATIO_TYPE_FIXED);
        String sRatio = context.getValue("Ratio");
        int nColumns = sRatio.split(Layout.RATIO_SEPERATE).length;
        Layout tempLayout = Layout.createNewInstance();
        tempLayout.setColumns(nColumns);
        tempLayout.setRatio(sRatio);
        tempLayout.setRatioType(nRatioType);
        this.m_oLayoutMgr.validate(tempLayout);
        return this.m_oLayoutGenerator.generateHtml(tempLayout, true);
    }

    @Override
    public Object findById(MethodContext context) throws WCMException {
        return null;
    }

    @Override
    public Object findByIds(MethodContext context) throws WCMException {
        return null;
    }
}

