/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.widget;

import com.trs.cluster.FileMsgProcessor;
import com.trs.components.common.publish.widget.ILayoutGenerator;
import com.trs.components.common.publish.widget.Layout;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LayoutGenerator
implements ILayoutGenerator {
    private String sCssFileName = "app/special/layout/default.css";
    private String m_sFloatLeft = "float:left;";
    private String m_sFloatRight = "float:right;";
    private String m_sWidth = "width:";
    private int adaptiveColumn = 0;
    private int colNums = 0;
    private boolean formIe6Bug = false;

    @Override
    public String generateHtml(Layout _currLayout, boolean _bCssInHtml, boolean _bColIndexAsText) throws WCMException {
        if (_currLayout.getId() <= 0) {
            if (!_bCssInHtml) {
                _currLayout.setNextId();
            }
        } else {
            _currLayout.refreshProperty(_currLayout);
        }
        this.colNums = _currLayout.getColumns();
        this.adaptiveColumn = this.getAdaptiveColumn(_currLayout);
        String className = "r_c" + _currLayout.getColumns() + "_" + _currLayout.getId();
        String sRatio = _currLayout.getRatio();
        StringBuffer sHtml = new StringBuffer(500);
        StringBuffer sCss = new StringBuffer(256);
        sHtml.append("\n<!--layout ").append(className).append(" start-->\n");
        sHtml.append("<div class='").append("trs_layout").append(" ").append(className).append("' _ratio='").append(sRatio).append("' _ratiotype='").append(_currLayout.getRatioType()).append("'>\n");
        if (!_bCssInHtml) {
            sCss.append("\n/* ").append(className).append(" _ratio='").append(sRatio).append("' _ratiotype='").append(_currLayout.getRatioType()).append("'*/\n");
        }
        this.isFormIe6Bug(sRatio, _currLayout.getRatioType());
        for (int i = 1; i <= this.colNums; ++i) {
            int nCurrPageColNum = this.getPageColumnOfLayout(i, this.colNums);
            String cssOfCurrColumn = this.getCssOfColumn(i, _currLayout);
            sHtml.append(this.getHtmlOfColumn(i, _bCssInHtml, cssOfCurrColumn, _bColIndexAsText ? "{" + String.valueOf(nCurrPageColNum - 1) + "}" : "<div class='c-empty-column'>\u70b9\u51fb\u6dfb\u52a0\u8d44\u6e90</div>"));
            if (!_bCssInHtml) {
                sCss.append(".").append(className).append(" .c_" + i).append("{").append(cssOfCurrColumn).append("}\n");
            }
            if (i == this.colNums) continue;
            if (this.adaptiveColumn != 0 && i >= this.adaptiveColumn) {
                sHtml.append("<div class='c_sep c_right'></div>\n");
                continue;
            }
            sHtml.append("<div class='c_sep c_left'></div>\n");
        }
        sHtml.append("</div>\n");
        sHtml.append("<!--layout ").append(className).append(" end -->\n");
        _currLayout.setHtmlContent(sHtml.toString());
        if (!_bCssInHtml) {
            sCss.append("/* ").append(className).append(" end */");
            this.saveCss(_currLayout.getId(), sCss.toString());
        }
        return sHtml.toString();
    }

    @Override
    public String generateHtml(Layout _currLayout, boolean _bCssInHtml) throws WCMException {
        return this.generateHtml(_currLayout, _bCssInHtml, false);
    }

    private void isFormIe6Bug(String _sRatio, int _nRatioType) {
        if (_nRatioType != Layout.RATIO_TYPE_PERCENTAGE || this.adaptiveColumn != 0) {
            this.formIe6Bug = false;
            return;
        }
        String[] nRatios = _sRatio.split(Layout.RATIO_SEPERATE);
        for (int i = 0; i < nRatios.length; ++i) {
            int temp = Integer.parseInt(nRatios[i]);
            if (temp % 2 == 0) continue;
            this.formIe6Bug = true;
            return;
        }
        this.formIe6Bug = false;
    }

    private int getPageColumnOfLayout(int _nHtmlCol, int _nColNums) {
        if (this.adaptiveColumn == 0) {
            return _nHtmlCol;
        }
        if (_nHtmlCol < this.adaptiveColumn) {
            return _nHtmlCol;
        }
        return _nColNums - _nHtmlCol + this.adaptiveColumn;
    }

    private void saveCss(int _nLayoutId, String _sCss) throws WCMException {
        String sFilePath = this.getCssFilePath();
        String sFileContent = this.getFileContent(sFilePath);
        Pattern pattern = Pattern.compile("r_c\\d+_" + _nLayoutId);
        Matcher matcher = pattern.matcher(sFileContent);
        if (!matcher.find()) {
            sFileContent = sFileContent + _sCss;
        } else if (sFileContent.indexOf(_sCss.trim()) < 0) {
            sFileContent = this.replaceLayoutCssWith(_nLayoutId, sFileContent, _sCss);
        }
        this.writeCssFile(sFilePath, sFileContent, "utf-8");
    }

    @Override
    public void deleteCss(Layout _currLayout) throws WCMException {
        if (_currLayout.getId() <= 0) {
            return;
        }
        int nId = _currLayout.getId();
        String sFilePath = this.getCssFilePath();
        String sFileContent = this.getFileContent(sFilePath);
        Pattern pattern = Pattern.compile("r_c\\d+_" + nId);
        Matcher matcher = pattern.matcher(sFileContent);
        if (matcher.find()) {
            sFileContent = this.replaceLayoutCssWith(nId, sFileContent, "");
        }
        this.writeCssFile(sFilePath, sFileContent, "utf-8");
    }

    private String getCssOfColumn(int _nColumn, Layout _currLayout) {
        StringBuffer sCss = new StringBuffer();
        String[] sRatios = _currLayout.getRatio().split(Layout.RATIO_SEPERATE);
        if (_nColumn <= 0 || _nColumn > sRatios.length) {
            return null;
        }
        if (this.adaptiveColumn == 0 || _nColumn < this.adaptiveColumn) {
            sCss.append(this.m_sFloatLeft).append(this.m_sWidth).append(sRatios[_nColumn - 1]);
        } else if (_nColumn >= this.adaptiveColumn && _nColumn != sRatios.length) {
            sCss.append(this.m_sFloatRight).append(this.m_sWidth).append(sRatios[sRatios.length - _nColumn + this.adaptiveColumn - 1]);
        } else {
            return sCss.toString();
        }
        if (_currLayout.getRatioType() == Layout.RATIO_TYPE_FIXED) {
            sCss.append(Layout.RATIO_FIXED_WIDTH).append(";");
        } else {
            sCss.append(Layout.RATIO_PERCENTAGE_WIDTH).append(";");
        }
        return sCss.toString();
    }

    private int getAdaptiveColumn(Layout _currLayout) {
        String[] sRatios = _currLayout.getRatio().split(Layout.RATIO_SEPERATE);
        for (int i = 1; i <= sRatios.length; ++i) {
            if (!sRatios[i - 1].equals(Layout.ADAPTIVE_CHAR)) continue;
            return i;
        }
        return 0;
    }

    private String getHtmlOfColumn(int _nColumn, boolean _bCssInHtml, String _sStyle, String _sText) {
        StringBuffer sHtml = new StringBuffer(128);
        String marginClass = "";
        if (_nColumn + 1 == this.adaptiveColumn) {
            marginClass = "margin_right";
        }
        if (this.adaptiveColumn > 0 && _nColumn + 1 == this.colNums && this.adaptiveColumn != this.colNums) {
            marginClass = "margin_left";
        }
        if (this.formIe6Bug && _nColumn == 1) {
            marginClass = marginClass + " margin_left_IE6BUG_DIVFLOAT100";
        }
        if (this.formIe6Bug && _nColumn == this.colNums) {
            marginClass = marginClass + " margin_right_IE6BUG_DIVFLOAT100";
        }
        String style = "";
        if (_bCssInHtml) {
            style = style + "style='" + _sStyle + "'";
        }
        sHtml.append("<div class='").append("trs_column").append(" c_").append(_nColumn).append(" ").append(marginClass).append("' ");
        sHtml.append(style).append(">\n");
        sHtml.append("<div class='c-box'>");
        sHtml.append(_sText);
        sHtml.append("</div>\n");
        sHtml.append("</div>\n");
        return sHtml.toString();
    }

    private String getCssFilePath() throws WCMException {
        String sWCMPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        sWCMPath = CMyString.setStrEndWith(sWCMPath, File.separatorChar);
        return sWCMPath + this.sCssFileName;
    }

    private String getFileContent(String _sFilePath) throws WCMException {
        String sFileContent = "";
        try {
            sFileContent = CMyFile.readFile(_sFilePath, "utf-8");
            return sFileContent;
        }
        catch (Exception ex) {
            throw new WCMException(CMyString.format(I18NMessage.get(LayoutGenerator.class, "LayoutGenerator.label1", "\u6ca1\u6709\u627e\u5230\u5e03\u5c40\u7684\u603b\u6837\u5f0f\u6587\u4ef6\uff01[filepath={0}]"), new String[]{_sFilePath}));
        }
    }

    private void writeCssFile(String _sFilePath, String _sContent, String _EnCode) throws WCMException {
        try {
            CMyFile.writeFile(_sFilePath, _sContent, _EnCode);
            FileMsgProcessor.send(new FileService(_sFilePath).getAbsolutePath());
        }
        catch (Exception ex) {
            throw new WCMException(CMyString.format(I18NMessage.get(LayoutGenerator.class, "LayoutGenerator.label2", "\u5199\u6587\u4ef6\u5931\u8d25\uff01[filepath={0}]"), new String[]{_sFilePath}));
        }
    }

    private String replaceLayoutCssWith(int _layoutId, String _fileContent, String _replaceString) {
        Pattern pattern = Pattern.compile("(?s)(\\n|\\r|\\r\\n)/\\* r_c\\d+_" + _layoutId + " .*?r_c\\d+_" + _layoutId + " end \\*/");
        String sResult = null;
        Matcher matcher = pattern.matcher(_fileContent);
        if (matcher.find()) {
            sResult = matcher.group(0);
            return CMyString.replaceStr(_fileContent, sResult, _replaceString);
        }
        return _fileContent;
    }

    @Override
    public boolean validateHtml(Layout layout) throws WCMException {
        return true;
    }
}

