/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.publish.domain.template;

import com.trs.DreamFactory;
import com.trs.cms.ContextHelper;
import com.trs.components.common.publish.domain.template.TemplateCacheMgr;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.TemplateNest;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class TemplateNestMgr {
    private static final Logger logger = Logger.getLogger((String)TemplateNestMgr.class.getName());

    public boolean addNestRecord(int _nTemplateId, IPublishFolder _root, String _sNestedTemplateName) throws WCMException {
        TemplateCacheMgr cacheMgr = (TemplateCacheMgr)DreamFactory.createObjectById("TemplateCacheMgr");
        Template nestedTemplate = cacheMgr.lookupByName(_root, _sNestedTemplateName);
        if (nestedTemplate == null) {
            throw new WCMException(10, "Template [" + _sNestedTemplateName + "] is not found!");
        }
        return this.addNestRecord(_nTemplateId, nestedTemplate.getId());
    }

    public boolean addNestRecord(int _nTemplateId, int _nNestedTemplateId) throws WCMException {
        if (this.isExistsNestRecord(_nTemplateId, _nNestedTemplateId)) {
            return true;
        }
        try {
            TemplateNest tempNest = TemplateNest.createNewInstance();
            tempNest.setNestedTemplateId(_nNestedTemplateId);
            tempNest.setTemplateId(_nTemplateId);
            tempNest.save();
            return true;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to add template nest record!", ex);
        }
    }

    private boolean isExistsNestRecord(int _nTemplateId, int _nNestedTemplateId) throws WCMException {
        String SQL = "select NESTEDTEMPLATEID from WCMTEMPLATENEST where TEMPLATEID=? and NESTEDTEMPLATEID=?";
        Connection oConn = null;
        PreparedStatement oPreStmt = null;
        ResultSet resultSet = null;
        DBManager dbManager = DBManager.getDBManager();
        try {
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement("select NESTEDTEMPLATEID from WCMTEMPLATENEST where TEMPLATEID=? and NESTEDTEMPLATEID=?");
            oPreStmt.setInt(1, _nTemplateId);
            oPreStmt.setInt(2, _nNestedTemplateId);
            resultSet = oPreStmt.executeQuery();
            boolean bl = resultSet.next();
            return bl;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to add template nest record!", ex);
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to close resultSet", (Throwable)e);
                }
            }
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    public int clearNestRecordsOf(Template _template) throws WCMException {
        if (_template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        Connection oConn = null;
        Statement oPreStmt = null;
        DBManager dbManager = DBManager.getDBManager();
        try {
            String strSQL = "DELETE FROM WCMTEMPLATENEST WHERE TEMPLATEID=?";
            oConn = dbManager.getConnection();
            oPreStmt = oConn.prepareStatement(strSQL);
            oPreStmt.setInt(1, _template.getId());
            int n = oPreStmt.executeUpdate();
            return n;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to clear template nest record!", ex);
        }
        finally {
            if (oPreStmt != null) {
                try {
                    oPreStmt.close();
                }
                catch (Exception ex) {
                    logger.error((Object)"Failed to close prepared statement", (Throwable)ex);
                }
            }
            if (oConn != null) {
                dbManager.freeConnection(oConn);
            }
        }
    }

    public Templates getNestedTemplates(Template _template) throws WCMException {
        if (_template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        Templates templates = null;
        try {
            String sWhere = "TEMPLATEID=?";
            WCMFilter filter = new WCMFilter("WCMTEMPLATENEST", sWhere, "", "NESTEDTEMPLATEID AS TEMPID");
            filter.addSearchValues(0, _template.getId());
            templates = new Templates(ContextHelper.getLoginUser());
            templates.open(filter);
            return templates;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to lookup the nested template!", ex);
        }
    }

    public Templates getTemplatesNested(Template _template) throws WCMException {
        if (_template == null) {
            throw new WCMException(10, "Valid template required!");
        }
        Templates templates = null;
        try {
            String sWhere = "NESTEDTEMPLATEID=?";
            WCMFilter filter = new WCMFilter("WCMTEMPLATENEST", sWhere, "", "TEMPLATEID AS TEMPID");
            filter.addSearchValues(0, _template.getId());
            templates = new Templates(ContextHelper.getLoginUser());
            templates.open(filter);
            return templates;
        }
        catch (Exception ex) {
            throw new WCMException(1100, "Failed to lookup the template nested!", ex);
        }
    }
}

