/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.message;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.MailContentHelper;
import com.trs.components.common.message.ISendWorker;
import com.trs.components.common.message.Message;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.email.CMyEmail;
import com.trs.infra.util.email.CMySMTPServer;
import com.trs.infra.util.email.TRSMailer;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class EmailSendWorker
implements ISendWorker {
    private static Logger logger = Logger.getLogger(EmailSendWorker.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(Message _currMessage, User _currReceiver) {
        HashMap<String, String> hParamValues = new HashMap<String, String>(3);
        hParamValues.put("TO_USER", _currReceiver.getName());
        hParamValues.put("CONTENT", _currMessage.getBody());
        hParamValues.put("FROM_USER", _currMessage.getCrUserName());
        CMySMTPServer cMySMTPServer = CMySMTPServer.getDefaultSMTPServer();
        String sUseSMTPServerUsername = "";
        try {
            sUseSMTPServerUsername = ConfigServer.getServer().getSysConfigValue("USE_WCM_SMTPSERVER_USERNAME", "false");
        }
        catch (WCMException e) {
            logger.error((Object)I18NMessage.get(EmailSendWorker.class, "EmailSendWorker.label4", "\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u9879\u53d1\u751f\u5f02\u5e38!"), (Throwable)e);
        }
        CMyEmail myEmail = new CMyEmail();
        myEmail.setTo(_currReceiver.getEmail());
        myEmail.setSubject(_currMessage.getTitle());
        try {
            myEmail.setBody(MailContentHelper.makeEmailContent(hParamValues));
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(EmailSendWorker.class, "EmailSendWorker.label1", "\u6784\u9020\u90ae\u4ef6\u5185\u5bb9\u5931\u8d25!"), (Throwable)e);
        }
        myEmail.setMailFormat(1);
        String sFromEmail = _currMessage.getCrUser().getEmail();
        logger.debug((Object)("FromEmail:" + sFromEmail));
        if (sUseSMTPServerUsername.equalsIgnoreCase("true")) {
            String sSMTPUserName = cMySMTPServer.getUserName();
            String checkMail = "^([a-zA-Z0-9\\.\\_])+\\@(([a-zA-Z0-9\\_])+\\.)+([a-zA-Z0-9]{2,4})+$";
            Pattern regex = Pattern.compile(checkMail);
            Matcher matcher = regex.matcher(sSMTPUserName);
            if (matcher.matches()) {
                myEmail.setFrom(sSMTPUserName);
            } else {
                String sSMTPServerName = cMySMTPServer.getServerName();
                myEmail.setFrom(sSMTPUserName + "@" + sSMTPServerName.substring(sSMTPServerName.indexOf(".") + 1));
            }
            myEmail.setFromUser(sSMTPUserName);
        } else {
            myEmail.setFrom(sFromEmail);
            myEmail.setFromUser(_currMessage.getCrUserName());
        }
        TRSMailer currMailer = new TRSMailer();
        try {
            if (!currMailer.send(myEmail, cMySMTPServer)) {
                throw new WCMException(I18NMessage.get(EmailSendWorker.class, "EmailSendWorker.label2", "\u90ae\u4ef6\u53d1\u9001\u5931\u8d25!") + currMailer.getMailLogString());
            }
        }
        catch (CMyException e) {
            logger.error((Object)I18NMessage.get(EmailSendWorker.class, "EmailSendWorker.label3", "\u90ae\u4ef6\u53d1\u9001\u53d1\u751f\u5f02\u5e38!"), (Throwable)e);
        }
        finally {
            if (myEmail != null) {
                myEmail = null;
            }
        }
    }
}

