/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.conjection.service;

import com.trs.DreamFactory;
import com.trs.components.common.conjection.persistent.EntryConfig;
import com.trs.components.common.conjection.service.IAdmanageConfigService;
import com.trs.components.common.conjection.service.IComponentEntryConfigService;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import java.io.File;
import org.apache.log4j.Logger;

public class AdmanageConfigServiceImpl
implements IAdmanageConfigService {
    private static Logger logger = Logger.getLogger(AdmanageConfigServiceImpl.class);

    private EntryConfig getConfig() throws WCMException {
        IComponentEntryConfigService configSrv = (IComponentEntryConfigService)DreamFactory.createObjectById("IComponentEntryConfigService");
        return configSrv.getTypedEntryConfig(5);
    }

    @Override
    public boolean isAdManagerEnable() throws WCMException {
        EntryConfig m_config = this.getConfig();
        if (m_config == null) {
            return false;
        }
        return m_config.isEnable();
    }

    @Override
    public void updateAdManageService() throws WCMException {
        try {
            String sRootPath = CMyString.setStrEndWith(this.getAdManagerLinkPath(), '/');
            ConfigServer m_oConfigServer = ConfigServer.createInstance();
            String sWCMPath = m_oConfigServer.getInitProperty("WCM_PATH");
            if (sWCMPath == null) {
                logger.error((Object)I18NMessage.get(AdmanageConfigServiceImpl.class, "AdmanageConfigServiceImpl.label1", "WCM_PATH\u8bbe\u7f6e\u9519\u8bef\uff01"));
                return;
            }
            sWCMPath = CMyString.setStrEndWith(sWCMPath, File.separatorChar);
            String sConfigFile = sWCMPath + "html_edit/js/trsad_config.js";
            String sFileContent = "config.adRootPath \t= \"" + sRootPath + "\";\n";
            sFileContent = sFileContent + "config.InsertTRSAd \t= " + (this.isAdManagerEnable() ? "true" : "false") + ";\n";
            CMyFile.writeFile(sConfigFile, sFileContent);
            sFileContent = "var config=new Object(); \n" + sFileContent;
            sConfigFile = sWCMPath + "js/trsad_config.js";
            CMyFile.writeFile(sConfigFile, sFileContent);
        }
        catch (Exception e) {
            logger.error((Object)I18NMessage.get(AdmanageConfigServiceImpl.class, "AdmanageConfigServiceImpl.label2", "\u540c\u6b65\u66f4\u65b0\u76f8\u5173\u914d\u7f6e\u6587\u4ef6\u5931\u8d25\uff01"), (Throwable)e);
        }
    }

    @Override
    public String getAdManagerLinkPath() throws WCMException {
        EntryConfig m_config = this.getConfig();
        if (m_config == null) {
            throw new WCMException(200006, I18NMessage.get(AdmanageConfigServiceImpl.class, "AdmanageConfigServiceImpl.label3", "\u6ca1\u6709\u627e\u5230\u5e7f\u544a\u7ba1\u7406\u7684\u7684\u9875\u9762\u94fe\u63a5\u914d\u7f6e\uff01"));
        }
        String result = m_config.getLinkPath();
        if (result == null) {
            throw new WCMException(200006, I18NMessage.get(AdmanageConfigServiceImpl.class, "AdmanageConfigServiceImpl.label3", "\u6ca1\u6709\u627e\u5230\u5e7f\u544a\u7ba1\u7406\u7684\u7684\u9875\u9762\u94fe\u63a5\u914d\u7f6e\uff01"));
        }
        return result;
    }
}

