/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.bookmark;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.bookmark.BookMarks;
import com.trs.components.common.bookmark.MarkKinds;
import com.trs.components.common.bookmark.MarkShares;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;

public class MarkKind
extends CMSObj {
    public static final int OBJ_TYPE = 307;
    public static final String DB_TABLE_NAME = "WCMMARKKIND";
    public static final String DB_ID_NAME = "KINDID";

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 307;
    }

    public String getName() {
        return (String)this.getProperty("KNAME");
    }

    public boolean setName(String _name) throws WCMException {
        return this.setProperty("KNAME", _name);
    }

    public String getDesc() {
        return (String)this.getProperty("KDESC");
    }

    public boolean setDesc(String _desc) throws WCMException {
        return this.setProperty("KDESC", _desc);
    }

    public int getParentId() {
        return this.getPropertyAsInt("PARENTID", 0);
    }

    public MarkKind getParent() throws WCMException {
        WCMFilter filter = new WCMFilter("", "KindId=" + this.getParentId(), "");
        MarkKinds MarkKinds2 = new MarkKinds(User.getSystem(), 1, 1);
        MarkKind MarkKindParent = null;
        try {
            MarkKinds2.open(filter);
            MarkKindParent = MarkKinds2.isEmpty() ? null : (MarkKind)MarkKinds2.getAt(0);
            MarkKinds2.clear();
            return MarkKindParent;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(MarkKind.class, "MarkKind.label1", "\u83b7\u53d6\u7236\u5bf9\u8c61\u65f6\u5931\u8d25\uff08MarkKind.getParent\uff09"), ex);
        }
    }

    public boolean setParentId(int _parentId) throws WCMException {
        return this.setParent(_parentId);
    }

    public boolean setParent(int _parentId) throws WCMException {
        if (_parentId < 0) {
            throw new WCMException(1104, I18NMessage.get(MarkKind.class, "MarkKind.label2", "ParentId\u503c\u65e0\u6548(MarkKind.setParentId)"));
        }
        return this.setProperty("PARENTID", _parentId);
    }

    public boolean setParent(MarkKind _parent) throws WCMException {
        if (_parent == null) {
            return this.setParent(0);
        }
        if (!_parent.isValidInstance()) {
            throw new WCMException(10, I18NMessage.get(MarkKind.class, "MarkKind.label3", "\u65e0\u6548\u7684\u7236\u5bf9\u8c61"));
        }
        return this.setParent(_parent.getId());
    }

    @Override
    public String getAttribute() {
        return (String)this.getProperty("ATTRIBUTE");
    }

    @Override
    public boolean setAttribute(String _attribute) throws WCMException {
        return this.setProperty("ATTRIBUTE", _attribute);
    }

    @Override
    public boolean isValid() throws WCMException {
        String sName = null;
        Number iParentId = null;
        if (this.isAddMode()) {
            sName = (String)this.getAllProperty().get("KNAME");
            iParentId = (Number)this.getAllProperty().get("PARENTID");
            if (sName == null) {
                throw new WCMException(1106, I18NMessage.get(MarkKind.class, "MarkKind.label4", "\u5c5e\u6027Name\u6ca1\u6709\u8bbe\u7f6e(MarkKind.isValid)"));
            }
            if (iParentId == null) {
                throw new WCMException(1106, I18NMessage.get(MarkKind.class, "MarkKind.label5", "\u5c5e\u6027ParentId\u6ca1\u6709\u8bbe\u7f6e(MarkKind.isValid)"));
            }
        } else {
            if (!this.isModified()) {
                throw new WCMException(1107, I18NMessage.get(MarkKind.class, "MarkKind.label6", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(MarkKind.isValid)"));
            }
            sName = (String)this.getNewProperty("KNAME");
            iParentId = (Number)this.getNewProperty("PARENTID");
            if (sName != null && iParentId == null) {
                iParentId = (Number)this.getNewProperty("PARENTID");
            }
            if (iParentId != null && sName == null) {
                sName = (String)this.getAllProperty().get("KNAME");
            }
        }
        if (sName != null || iParentId != null) {
            String strCondition = " (CrUser='" + this.getCrUserName() + "') and  (ParentId=" + iParentId + " ) and  (KName='" + CMyString.filterForSQL(sName) + "') ";
            if (!this.isAddMode()) {
                strCondition = strCondition + " and " + this.getIdFieldName() + "<>" + this.getId();
            }
            if (this.checkExists(strCondition)) {
                throw new WCMException(1108, I18NMessage.get(MarkKind.class, "MarkKind.label7", "\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff08MarkKind.isValid\uff09"));
            }
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.getAllProperty() != null) {
            this.setCrTime();
            super.insert(_currUser);
        }
    }

    public BookMarks getBookMarks(User _currUser) throws WCMException {
        WCMFilter filter = new WCMFilter("", "MKind=" + this.getId(), "");
        BookMarks aBookMarks = new BookMarks(_currUser);
        try {
            aBookMarks.open(filter);
            return aBookMarks;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(MarkKind.class, "MarkKind.label8", "\u53d6\u8be5\u7c7b\u522b\u4e2d\u4e66\u7b7e\u96c6\u5408\u65f6\u51fa\u9519(MarkKind.getBookMarks)"), ex);
        }
    }

    public MarkShares getMarkShares(User _currUser) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ObjType=307 and ObjId=" + this.getId(), "");
        MarkShares aMarkShares = new MarkShares(_currUser);
        try {
            aMarkShares.open(filter);
            return aMarkShares;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(MarkKind.class, "MarkKind.label9", "\u53d6\u4e66\u7b7e\u5206\u7c7b\u4e2d\u7684\u4e66\u7b7e\u5171\u4eab\u4fe1\u606f\u65f6\u51fa\u9519(MarkKind.getMarkShares)"), ex);
        }
    }

    public boolean isShared(User _currUser) throws WCMException {
        WCMFilter filter = new WCMFilter("", "ObjType=307 and ObjId=" + this.getId(), "", "ShareId");
        MarkShares aMarkShares = new MarkShares(_currUser);
        try {
            aMarkShares.open(filter);
            boolean bIsShared = !aMarkShares.isEmpty();
            aMarkShares.clear();
            return bIsShared;
        }
        catch (WCMException ex) {
            throw new WCMException(1100, I18NMessage.get(MarkKind.class, "MarkKind.label10", "\u5224\u65ad\u4e66\u7b7e\u5206\u7c7b\u662f\u5426\u5171\u4eab\u65f6\u51fa\u9519(MarkKind.isShared)"), ex);
        }
    }

    public static final MarkKind findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (MarkKind)BaseObj.findById(MarkKind.class, _nId);
    }

    public static final MarkKind createNewInstance() throws WCMException {
        return (MarkKind)BaseObj.createNewInstance(MarkKind.class);
    }

    public static final MarkKind findByKey(Object _oKey) throws WCMException {
        return (MarkKind)BaseObj.findByKey(MarkKind.class, _oKey);
    }

    @Override
    public String toString() {
        if (this.IS_ENGVERSION) {
            return this.getName();
        }
        return this.getName() + I18NMessage.get(MarkKind.class, "MarkKind.label11", "[\u4e66\u7b7e\u6587\u4ef6\u5939-") + this.getId() + "]";
    }
}

