/*
 * Decompiled with CFR 0.152.
 */
package com.trs.components.common.address;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.common.address.Contact;
import com.trs.components.common.address.ContactGrp;
import com.trs.components.common.address.ContactGrps;
import com.trs.components.common.address.Contacts;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.util.CMyString;

public class ContactMgr {
    private static final String OBJ_CONTACT = I18NMessage.get(ContactMgr.class, "ContactMgr.label1", "\u8054\u7cfb\u4eba");
    private static final String OBJ_CONTACTGROUP = I18NMessage.get(ContactMgr.class, "ContactMgr.label2", "\u8054\u7cfb\u4eba\u5206\u7ec4");

    public Contact addContactFromSystemUser(User _user) throws WCMException {
        this.assertNotNull(_user, I18NMessage.get(ContactMgr.class, "ContactMgr.label3", "\u7528\u6237"));
        Contact contact = Contact.createNewInstance();
        contact.setUserName(_user.getName());
        contact.setAddress(_user.getAddress());
        contact.setCrUser(this.getLoginUser());
        contact.setMobile(_user.getMobile());
        contact.setEmail(_user.getEmail());
        contact.setTel(_user.getTel());
        contact.setNickName(_user.getNickName());
        contact.setDesc(I18NMessage.get(ContactMgr.class, "ContactMgr.label4", "\u7cfb\u7edf\u7528\u6237:") + _user.getName());
        contact.setAttribute(_user.getAttribute());
        contact.save(this.getLoginUser());
        return contact;
    }

    public Contact addContact(Contact _contact, ContactGrp _contactGroup) throws WCMException {
        this.assertNotNull(_contact, OBJ_CONTACT);
        _contact.save(this.getLoginUser());
        if (_contactGroup != null) {
            _contactGroup.addContact(_contact, this.getLoginUser());
        }
        return _contact;
    }

    public Contact saveContact(Contact _contact) throws WCMException {
        return this.addContact(_contact, null);
    }

    public void deleteContact(Contact _contact) throws WCMException {
        this.assertNotNull(_contact, OBJ_CONTACT);
        _contact.delete(this.getLoginUser());
        this.syncContactGroupMap(_contact);
    }

    public ContactGrp saveContactGroup(ContactGrp _contactGrp) throws WCMException {
        this.assertNotNull(_contactGrp, OBJ_CONTACTGROUP);
        _contactGrp.save(this.getLoginUser());
        return _contactGrp;
    }

    public void deleteContactGroup(ContactGrp _contactGrp) throws WCMException {
        this.assertNotNull(_contactGrp, OBJ_CONTACTGROUP);
        this.deleteChildren(_contactGrp);
        this.syncContactGroupMap(_contactGrp);
        _contactGrp.delete();
    }

    private void deleteChildren(ContactGrp _contactGroup) throws WCMException {
        ContactGrps groups = _contactGroup.getChildren();
        ContactGrp group = null;
        for (int i = 0; i < groups.size(); ++i) {
            group = (ContactGrp)groups.getAt(i);
            if (group == null) continue;
            this.deleteContactGroup(group);
        }
    }

    public ContactGrps getGroups(Contact _contact) throws WCMException {
        this.assertNotNull(_contact, OBJ_CONTACT);
        String sWhere = "EXISTS (SELECT * FROM WCMContGrpMap WHERE WCMContGrpMap.ContactId=" + _contact.getId() + " AND WCMContGrpMap.ContGrpId=WCMContGroup.GroupId)";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        return this.getContactGroups(aFilter);
    }

    public ContactGrps getContactGroups(WCMFilter _filter) throws WCMException {
        User currUser = this.getLoginUser();
        WCMFilter aFilter = new WCMFilter("", "CrUser='" + CMyString.filterForSQL(currUser.getName()) + "'", "");
        aFilter.mergeWith(_filter);
        return ContactGrps.openWCMObjs(currUser, aFilter);
    }

    public Contacts getContacts(WCMFilter _filter, ContactGrp _contactGroup) throws WCMException {
        this.assertNotNull(_contactGroup, OBJ_CONTACTGROUP);
        String sWhere = "EXISTS (SELECT * FROM WCMContGrpMap WHERE wcmContGrpMap.ContGrpId=" + _contactGroup.getId() + " and wcmContact.ContactId=wcmContGrpMap.ContactId)";
        WCMFilter aFilter = new WCMFilter("", sWhere, "");
        aFilter.mergeWith(_filter);
        return this.getContacts(aFilter);
    }

    public Contacts getContacts(WCMFilter _filter) throws WCMException {
        User user = this.getLoginUser();
        WCMFilter aFilter = new WCMFilter("WCMCONTACT", "CrUser='" + CMyString.filterForSQL(user.getName()) + "'", "CrTime desc");
        aFilter.mergeWith(_filter);
        return Contacts.openWCMObjs(user, aFilter);
    }

    public void removeContact(Contact _contact, ContactGrp _contactGroup) throws WCMException {
        this.assertNotNull(_contact, OBJ_CONTACT);
        this.assertNotNull(_contactGroup, OBJ_CONTACTGROUP);
        _contactGroup.removeContact(_contact, this.getLoginUser());
    }

    public void changeGroup(Contact _contact, ContactGrp _srcGroup, ContactGrp _destGroup) throws WCMException {
        this.removeContact(_contact, _srcGroup);
        this.addContact(_contact, _destGroup);
    }

    private void assertNotNull(Object _object, String _objdesc) throws WCMException {
        if (_object == null) {
            throw new WCMException(10, I18NMessage.get(ContactMgr.class, "ContactMgr.label5", "\u65e0\u6548\u7684") + _objdesc + I18NMessage.get(ContactMgr.class, "ContactMgr.label6", "\u5bf9\u8c61[null]"));
        }
    }

    private void syncContactGroupMap(Contact _contact) throws WCMException {
        String sSQL = "DELETE FROM WCMCONTGRPMAP WHERE ContactId=" + _contact.getId();
        DBManager.getDBManager().sqlExecuteUpdate(sSQL);
    }

    private void syncContactGroupMap(ContactGrp _contactGroup) throws WCMException {
        this.deleteContactIfNecessary(_contactGroup);
        String sSQL = "DELETE FROM WCMCONTGRPMAP WHERE ContGrpId=" + _contactGroup.getId();
        DBManager.getDBManager().sqlExecuteUpdate(sSQL);
    }

    private void deleteContactIfNecessary(ContactGrp _contactGroup) throws WCMException {
        Contacts contacts = this.getContacts(null, _contactGroup);
        Contact contact = null;
        for (int i = 0; i < contacts.size(); ++i) {
            contact = (Contact)contacts.getAt(i);
            if (contact == null || this.getGroups(contact).size() != 1) continue;
            contact.delete();
        }
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }
}

