/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.process.engine;

import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.cms.process.IFlowContent;
import com.trs.cms.process.engine.FlowContentHelper;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;

public class FlowContentConfig
extends CMSObj {
    public static final int OBJ_TYPE = 2069049653;
    public static final String DB_TABLE_NAME = "WCMFLOWCONTENTCONFIG";
    public static final String DB_ID_NAME = "FLOWCONTENTCONFIGID";

    public FlowContentConfig() {
    }

    public FlowContentConfig(int _nObjType, String _sClassName, String _sDesc) throws WCMException {
        this.setObjType(_nObjType);
        this.setObjClass(_sClassName);
        this.setObjDesc(_sDesc);
    }

    @Override
    public String getDbTableName() {
        return DB_TABLE_NAME;
    }

    @Override
    public String getIdFieldName() {
        return DB_ID_NAME;
    }

    @Override
    public int getWCMType() {
        return 2069049653;
    }

    public int getObjType() {
        return this.getPropertyAsInt("OBJTYPE", 0);
    }

    public boolean setObjType(int _nObjType) throws WCMException {
        return this.setProperty("OBJTYPE", _nObjType);
    }

    public String getObjClassName() {
        return this.getPropertyAsString("OBJCLASS");
    }

    public Class getObjClass() throws WCMException {
        try {
            return Class.forName(this.getObjClassName());
        }
        catch (ClassNotFoundException ex) {
            throw new WCMException(I18NMessage.get(FlowContentConfig.class, "FlowContentConfig.label1", "\u6307\u5b9a\u7684Class[") + this.getObjClassName() + I18NMessage.get(FlowContentConfig.class, "FlowContentConfig.label2", "]\u65e0\u6548\uff01"), ex);
        }
    }

    public IFlowContent getFlowContent() throws WCMException {
        Object currObj = null;
        try {
            currObj = this.getObjClass().newInstance();
        }
        catch (InstantiationException ex) {
            throw new WCMException(I18NMessage.get(FlowContentConfig.class, "FlowContentConfig.label1", "\u6307\u5b9a\u7684Class[") + this.getObjClassName() + I18NMessage.get(FlowContentConfig.class, "FlowContentConfig.label3", "]\u65e0\u6cd5\u5b9e\u4f8b\u5316\uff01"), ex);
        }
        catch (IllegalAccessException ex) {
            throw new WCMException(I18NMessage.get(FlowContentConfig.class, "FlowContentConfig.label1", "\u6307\u5b9a\u7684Class[") + this.getObjClassName() + I18NMessage.get(FlowContentConfig.class, "FlowContentConfig.label4", "]\u5b9e\u4f8b\u5316\u4e3a\u975e\u6cd5\uff01"), ex);
        }
        if (currObj instanceof IFlowContent) {
            return currObj;
        }
        throw new WCMException(I18NMessage.get(FlowContentConfig.class, "FlowContentConfig.label1", "\u6307\u5b9a\u7684Class[") + this.getObjClassName() + I18NMessage.get(FlowContentConfig.class, "FlowContentConfig.label5", "]\u4e0d\u662fIFlowContent\u7684\u5b9e\u73b0\uff01"));
    }

    public boolean setObjClass(String _sObjClass) throws WCMException {
        return this.setProperty("OBJCLASS", _sObjClass);
    }

    public String getObjDesc() {
        return this.getPropertyAsString("OBJDESC");
    }

    public boolean setObjDesc(String _sObjDesc) throws WCMException {
        return this.setProperty("OBJDESC", _sObjDesc);
    }

    @Override
    public boolean isValid() throws WCMException {
        if (this.isAddMode()) {
            if (this.getProperty("OBJTYPE") == null) {
                throw new WCMException(1106, I18NMessage.get(FlowContentConfig.class, "FlowContentConfig.label6", "\u5c5e\u6027ObjType\u6ca1\u6709\u8bbe\u7f6e(FlowContentConfig.isValid)"));
            }
            if (this.getProperty("OBJCLASS") == null) {
                throw new WCMException(1106, I18NMessage.get(FlowContentConfig.class, "FlowContentConfig.label7", "\u5c5e\u6027ObjClass\u6ca1\u6709\u8bbe\u7f6e(FlowContentConfig.isValid)"));
            }
            this.getObjClass();
            if (this.getProperty("OBJDESC") == null) {
                throw new WCMException(1106, I18NMessage.get(FlowContentConfig.class, "FlowContentConfig.label8", "\u5c5e\u6027ObjDesc\u6ca1\u6709\u8bbe\u7f6e(FlowContentConfig.isValid)"));
            }
        } else if (!this.isModified()) {
            throw new WCMException(1107, I18NMessage.get(FlowContentConfig.class, "FlowContentConfig.label9", "\u5bf9\u8c61\u5c5e\u6027\u6ca1\u6709\u66f4\u6539(FlowContentConfig.isValid)"));
        }
        return true;
    }

    @Override
    public void insert(User _currUser) throws WCMException {
        if (this.isAddMode() && this.isModified()) {
            super.insert(_currUser);
            FlowContentHelper.registerContent(this.getObjType(), this.getObjClass());
        }
    }

    public static final FlowContentConfig findById(int _nId) throws WCMException {
        if (_nId <= 0) {
            return null;
        }
        return (FlowContentConfig)BaseObj.findById(FlowContentConfig.class, _nId);
    }

    public static final FlowContentConfig createNewInstance() throws WCMException {
        return (FlowContentConfig)BaseObj.createNewInstance(FlowContentConfig.class);
    }

    public static final FlowContentConfig findByKey(Object _oKey) throws WCMException {
        return (FlowContentConfig)BaseObj.findByKey(FlowContentConfig.class, _oKey);
    }

    @Override
    public synchronized void update(User _user) throws WCMException {
        boolean bChangeType = this.isChangeProperty("OBJTYPE");
        int nOldType = this.getObjType();
        boolean bChangeClass = this.isChangeProperty("OBJCLASS");
        super.update(_user);
        if (bChangeType) {
            FlowContentHelper.removeContent(nOldType);
        }
        if (bChangeType || bChangeClass) {
            FlowContentHelper.registerContent(this.getObjType(), this.getObjClass());
        }
    }
}

