/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.IUserCacheMgr;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.I18NMessage;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;

public class UserCacheMgr
implements IUserCacheMgr {
    private static Logger s_logger = Logger.getLogger(UserCacheMgr.class);
    public static int MAX_USERNAME_CACHE_SIZE = 52000;
    public static long LRU_CACHE_EXPIRES = 3600000L;
    private static Cache cache = (Cache)DreamFactory.createObjectById("lruCache");

    public UserCacheMgr() {
        cache.setMaxSize(MAX_USERNAME_CACHE_SIZE);
    }

    @Override
    public User _getUserByName(String _sUserName) {
        if (_sUserName == null || _sUserName.length() == 0) {
            return null;
        }
        User aUser = null;
        String sUserName = _sUserName.toLowerCase();
        String sKey = this.getKey(sUserName);
        Integer oUserId = (Integer)cache.get(sKey);
        try {
            if (oUserId != null) {
                return User.findByKey(oUserId);
            }
            aUser = this.loadByName(sUserName);
        }
        catch (Exception ex) {
            s_logger.error((Object)("get user[" + sUserName + "] from db error!"), (Throwable)ex);
            return null;
        }
        return aUser;
    }

    private void addUserToNameCache(User _currUser) {
        if (_currUser == null) {
            return;
        }
        String sKey = this.getKey(_currUser.getName().toLowerCase());
        cache.set(sKey, _currUser.getKey());
        cache.pexpire(sKey, LRU_CACHE_EXPIRES);
    }

    private void removeUserFromNameCache(User _currUser) throws WCMException {
        if (_currUser == null) {
            throw new WCMException(10, I18NMessage.get(UserCacheMgr.class, "UserCacheMgr.label3", "\u6307\u5b9a\u7684\u7528\u6237\u65e0\u6548!"));
        }
        String sKey = this.getKey(_currUser.getName().toLowerCase());
        cache.clear(sKey);
    }

    private void initUserNameCache() throws WCMException {
        if (cache.exists(this.getKey()).booleanValue()) {
            return;
        }
        cache.set(this.getKey(), "true");
        s_logger.info((Object)I18NMessage.get(UserCacheMgr.class, "UserCacheMgr.label4", "\u6b63\u5728\u521d\u59cb\u5316\u7528\u6237\u540d\u7f13\u51b2..."));
        int nCacheMaxSize = MAX_USERNAME_CACHE_SIZE;
        if (nCacheMaxSize < MAX_USERNAME_CACHE_SIZE && (nCacheMaxSize = (int)((double)nCacheMaxSize * 1.5)) > MAX_USERNAME_CACHE_SIZE) {
            nCacheMaxSize = MAX_USERNAME_CACHE_SIZE;
        }
        cache.set(this.getKey("system"), User.getSystem().getKey());
        s_logger.info((Object)I18NMessage.get(UserCacheMgr.class, "UserCacheMgr.label5", "\u521d\u59cb\u5316\u7528\u6237\u540d\u7f13\u51b2\u5b8c\u6210"));
    }

    private void clearUserNameCache() {
    }

    private User loadByName(String _sUserName) throws WCMException {
        Users aUsers;
        WCMFilter aFilter = new WCMFilter("", "UserName=?", "", "", 1);
        aFilter.addSearchValues(_sUserName);
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Cache\u4e0d\u591f\uff0c\u9700\u8981\u91cd\u65b0\u8bfb\u53d6\u7528\u6237[" + _sUserName + "]\u4fe1\u606f\uff01"));
            s_logger.debug((Object)aFilter.toSQL());
        }
        if ((aUsers = Users.openWCMObjs(null, aFilter)).isEmpty()) {
            return null;
        }
        User aUser = (User)aUsers.getAt(0);
        String sKey = this.getKey(aUser.getName().toLowerCase());
        cache.set(sKey, aUser.getKey());
        cache.pexpire(sKey, LRU_CACHE_EXPIRES);
        return aUser;
    }

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) {
        this.addUserToNameCache((User)_oObjAdded);
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        this.removeUserFromNameCache((User)_oObjDeleted);
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) throws WCMException {
        _oObjModified.isChangeProperty("USERNAME");
        if (_oObjModified.isChangeProperty("USERNAME")) {
            this.removeUserFromNameCache((User)_oObjModified);
            return;
        }
    }

    @Override
    public boolean init() throws WCMException {
        this.initUserNameCache();
        return true;
    }

    @Override
    public void clear() {
        this.clearUserNameCache();
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    private String getKey() {
        return this.getClass().getName();
    }

    private String getKey(String sUserName) {
        return this.getKey() + "." + sUserName;
    }
}

