/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cms.auth.persistent;

import com.trs.DreamFactory;
import com.trs.cms.auth.persistent.IAdministratorCacheMgr;
import com.trs.cms.auth.persistent.RoleUser;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.I18NMessage;
import com.trs.infra.cache.Cache;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import org.apache.log4j.Logger;

public class AdministratorCacheMgr
implements IAdministratorCacheMgr {
    private static Logger s_logger = Logger.getLogger(AdministratorCacheMgr.class);
    private Users m_oAdminUsers;
    private static Cache cache = (Cache)DreamFactory.createObjectById("cache");

    @Override
    public void notifyOnAddObj(BaseObj _oObjAdded) throws WCMException {
        RoleUser aRoleUser = (RoleUser)_oObjAdded;
        if (aRoleUser.getRoleId() == 1) {
            this.addAdminToAdminUsers(User.findById(aRoleUser.getUserId()));
        }
    }

    @Override
    public void notifyOnDelObj(BaseObj _oObjDeleted, int _nEventType) throws WCMException {
        RoleUser aRoleUser = (RoleUser)_oObjDeleted;
        if (aRoleUser.getRoleId() == 1) {
            this.removeAdminFromAdminUsers(User.findById(aRoleUser.getUserId()));
        }
    }

    @Override
    public void notifyOnModifyObj(BaseObj _oObjModified, int _nEventType) {
    }

    @Override
    public Users getAdminUsers() throws WCMException {
        if (!cache.exists(this.getKey()).booleanValue()) {
            this.initAdminUsers();
        }
        String _sIds = (String)cache.get(this.getKey());
        Users users = Users.findByIds(User.getSystem(), _sIds);
        return users;
    }

    @Override
    public boolean init() throws WCMException {
        this.initAdminUsers();
        return true;
    }

    @Override
    public boolean reinit() throws WCMException {
        this.clear();
        return this.init();
    }

    @Override
    public void clear() {
        this.clearAdminUsers();
    }

    protected void initAdminUsers() throws WCMException {
        if (cache.exists(this.getKey()).booleanValue()) {
            return;
        }
        s_logger.info((Object)I18NMessage.get(AdministratorCacheMgr.class, "AdministratorCacheMgr.label1", "\u6b63\u5728\u521d\u59cb\u5316\u7ba1\u7406\u5458\u7f13\u51b2..."));
        WCMFilter aFilter = new WCMFilter("WCMRoleUser", "RoleId=1", "", "UserId");
        this.m_oAdminUsers = Users.openWCMObjs(User.getSystem(), aFilter);
        String _sIds = this.m_oAdminUsers.getIdListAsString();
        cache.set(this.getKey(), _sIds);
        s_logger.info((Object)I18NMessage.get(AdministratorCacheMgr.class, "AdministratorCacheMgr.label2", "\u521d\u59cb\u5316\u7ba1\u7406\u5458\u7f13\u51b2\u5b8c\u6210\uff01"));
    }

    private String getKey() {
        return AdministratorCacheMgr.class.getName();
    }

    protected void clearAdminUsers() {
        if (!cache.exists(this.getKey()).booleanValue()) {
            return;
        }
        s_logger.info((Object)I18NMessage.get(AdministratorCacheMgr.class, "AdministratorCacheMgr.label3", "\u6b63\u5728\u6e05\u7a7a\u7ba1\u7406\u5458\u7f13\u51b2..."));
        cache.clear(this.getKey());
        s_logger.info((Object)I18NMessage.get(AdministratorCacheMgr.class, "AdministratorCacheMgr.label4", "\u6e05\u7a7a\u7ba1\u7406\u5458\u7f13\u51b2\u5b8c\u6210!"));
    }

    protected void removeAdminFromAdminUsers(User _admin) throws WCMException {
        if (_admin == null) {
            return;
        }
        Users users = this.getAdminUsers();
        users.remove(_admin, false);
        String _sIds = users.getIdListAsString();
        cache.set(this.getKey(), _sIds);
    }

    protected void addAdminToAdminUsers(User _admin) throws WCMException {
        if (_admin == null) {
            return;
        }
        Users users = this.getAdminUsers();
        if (users.indexOf(_admin) != -1) {
            return;
        }
        users.addElement(_admin);
        String _sIds = users.getIdListAsString();
        cache.set(this.getKey(), _sIds);
    }
}

