/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster.ext.wcm;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class HttpProxy {
    private static final String HEAD_XFORWARDED = "X-Forwarded-For";
    private static final int BUFF_SIZE = 20480;
    private int m_nBuffSize = 20480;
    private String m_sProxyHost;
    private int m_nProxyPort;
    private Set m_oIgnoreHeaders = new HashSet();

    public HttpProxy() {
        this.initIgnoreHeaders();
    }

    private void initIgnoreHeaders() {
        this.m_oIgnoreHeaders.add("proxy-connection");
        this.m_oIgnoreHeaders.add("connection");
        this.m_oIgnoreHeaders.add("keep-alive");
        this.m_oIgnoreHeaders.add("transfer-encoding");
        this.m_oIgnoreHeaders.add("te");
        this.m_oIgnoreHeaders.add("trailer");
        this.m_oIgnoreHeaders.add("proxy-authorization");
        this.m_oIgnoreHeaders.add("proxy-authenticate");
        this.m_oIgnoreHeaders.add("upgrade");
    }

    public void proxy(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String cacheCtl;
        String uri = req.getRequestURI();
        if (req.getQueryString() != null) {
            uri = uri + "?" + req.getQueryString();
        }
        URL url = new URL(req.getScheme(), this.m_sProxyHost, this.m_nProxyPort, uri);
        HttpURLConnection http = (HttpURLConnection)url.openConnection();
        http.setAllowUserInteraction(false);
        http.setRequestMethod(req.getMethod());
        http.setInstanceFollowRedirects(false);
        String connectionHdr = req.getHeader("Connection");
        if (connectionHdr != null && ((connectionHdr = connectionHdr.toLowerCase()).equals("keep-alive") || connectionHdr.equals("close"))) {
            connectionHdr = null;
        }
        boolean zForwardedFor = false;
        boolean hasContent = false;
        Enumeration enm = req.getHeaderNames();
        while (enm.hasMoreElements()) {
            String hdr = (String)enm.nextElement();
            String lhdr = hdr.toLowerCase();
            if (this.m_oIgnoreHeaders.contains(lhdr) || connectionHdr != null && connectionHdr.indexOf(lhdr) >= 0) continue;
            if ("content-type".equals(lhdr)) {
                hasContent = true;
            }
            Enumeration vals = req.getHeaders(hdr);
            while (vals.hasMoreElements()) {
                String val = (String)vals.nextElement();
                if (val == null) continue;
                http.addRequestProperty(hdr, val);
                zForwardedFor |= HEAD_XFORWARDED.equalsIgnoreCase(hdr);
            }
        }
        if (!zForwardedFor) {
            http.addRequestProperty(HEAD_XFORWARDED, req.getRemoteAddr());
        }
        if ((cacheCtl = req.getHeader("Cache-Control")) != null && ((cacheCtl = cacheCtl.toLowerCase()).indexOf("no-cache") >= 0 || cacheCtl.indexOf("no-store") >= 0)) {
            http.setUseCaches(false);
        }
        http.setDoInput(true);
        if (hasContent) {
            ServletInputStream reqIns = req.getInputStream();
            http.setDoOutput(true);
            this.copyStream((InputStream)reqIns, http.getOutputStream());
        }
        http.connect();
        InputStream proxyIns = null;
        proxyIns = http.getErrorStream();
        resp.setStatus(http.getResponseCode());
        if (proxyIns == null) {
            try {
                proxyIns = http.getInputStream();
            }
            catch (Exception e) {
                proxyIns = http.getErrorStream();
            }
        }
        int index = 0;
        String hdr = http.getHeaderFieldKey(index);
        String val = http.getHeaderField(index);
        while (hdr != null || val != null) {
            if (hdr != null && val != null && !this.m_oIgnoreHeaders.contains(hdr.toLowerCase()) && !resp.containsHeader(hdr)) {
                resp.setHeader(hdr, val);
            }
            hdr = http.getHeaderFieldKey(++index);
            val = http.getHeaderField(index);
        }
        resp.addHeader("WcmClusterRespProxy", this.m_sProxyHost + ":" + this.m_nProxyPort);
        if (proxyIns != null) {
            this.copyStream(proxyIns, (OutputStream)resp.getOutputStream());
            proxyIns.close();
        }
        http.disconnect();
    }

    private void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] buff = new byte[this.m_nBuffSize];
        int len = -1;
        while ((len = inputStream.read(buff, 0, this.m_nBuffSize)) != -1) {
            outputStream.write(buff, 0, len);
        }
    }

    public String getHost() {
        return this.m_sProxyHost;
    }

    public void setHost(String sProxyHost) {
        this.m_sProxyHost = sProxyHost;
    }

    public int getPort() {
        return this.m_nProxyPort;
    }

    public void setPort(int nProxyPort) {
        this.m_nProxyPort = nProxyPort;
    }

    public void setBuffSize(int size) {
        if (size > 0) {
            this.m_nBuffSize = size;
        }
    }

    public void addIgnoreHeader(String hdr) {
        if (hdr == null) {
            return;
        }
        this.m_oIgnoreHeaders.add(hdr.toLowerCase().intern());
    }

    public void clear() {
        this.m_oIgnoreHeaders.clear();
    }
}

