/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster.ext.wcm;

import com.trs.DreamFactory;
import com.trs.cluster.TRSWCMClusterServer;
import com.trs.cluster.ext.wcm.EventLocker;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.store.FileService;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class ClusterWatchDog {
    private static final Logger LOG = Logger.getLogger(ClusterWatchDog.class);
    private static final int HTTP_STATUS_OK = 200;
    private static final String NOTIFY_URI = "/wcm/clusterservice";
    private String nodeWatched = null;

    public ClusterWatchDog() {
        this("");
    }

    public ClusterWatchDog(String nodeWatched) {
        this.nodeWatched = nodeWatched;
    }

    public boolean barkOnTokenDuplicated() {
        if (!this.isWatching() || !this.isSupportedOs()) {
            return false;
        }
        boolean result = this.recordEvent();
        if (result) {
            result = this.restart();
        }
        return result;
    }

    private boolean isWatching() {
        ConfigServer server = ConfigServer.getServer();
        try {
            return "true".equals(server.getSysConfigValue("cluster.watchdog.enable", "false"));
        }
        catch (WCMException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean recordEvent() {
        if (!EventLocker.globalLock()) {
            return false;
        }
        LOG.info((Object)"Record cluster event begin.");
        ConfigServer confServer = ConfigServer.getServer();
        String nodeips = null;
        try {
            nodeips = confServer.getSysConfigValue("cluster.nodeips", "");
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to get conf: nodeips", (Throwable)ex);
        }
        if (nodeips == null || nodeips.trim().length() == 0) {
            LOG.fatal((Object)"nodeips conf is invalid.");
            return false;
        }
        String[] pNodeIps = nodeips.split(",");
        DBManager dbman = DBManager.getDBManager();
        Connection conn = null;
        Statement pstmt = null;
        String sql = "insert into XWCMCLUSTEREVENT(NODEIP,PREVNODEIP,NODESTATUS,EVENTTIME,RECORDNODEIP) values(?,?,?,?,?)";
        boolean autoCommit = false;
        boolean rollback = false;
        try {
            int i;
            conn = dbman.getConnection();
            autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            pstmt = conn.prepareStatement(sql);
            int len = pNodeIps.length;
            for (i = 0; i < len; ++i) {
                int index = 1;
                pstmt.setString(index++, pNodeIps[i]);
                int prev = i == 0 ? len - 1 : i - 1;
                pstmt.setString(index++, pNodeIps[prev]);
                pstmt.setInt(index++, 0);
                pstmt.setTimestamp(index++, CMyDateTime.now().toTimestamp());
                pstmt.setString(index++, this.nodeWatched);
                pstmt.executeUpdate();
            }
            conn.commit();
            LOG.info((Object)"Record cluster event end.");
            i = 1;
            return i != 0;
        }
        catch (Exception e) {
            rollback = true;
            LOG.error((Object)"record cluster event failed.", (Throwable)e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {}
            }
            if (conn != null) {
                if (rollback) {
                    try {
                        conn.rollback();
                    }
                    catch (Exception e) {}
                }
                try {
                    conn.setAutoCommit(autoCommit);
                    dbman.freeConnection(conn);
                }
                catch (Exception e) {
                    LOG.error((Object)"free connection error: ", (Throwable)e);
                }
            }
        }
        return false;
    }

    public boolean barkOnStarted(int servicePort) {
        boolean result = this.markRestarted();
        if (!result) {
            return false;
        }
        String nextNode2Notify = this.getNextNode2Notify();
        if (nextNode2Notify != null) {
            this.notifyNextNode(nextNode2Notify, servicePort);
        } else {
            result = EventLocker.globalUnlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyNextNode(String nextNode2Notify, int servicePort) {
        HttpURLConnection http = null;
        int respCode = 0;
        Exception error = null;
        LOG.info((Object)("Notify the next node: " + nextNode2Notify));
        try {
            URL url = new URL("http", nextNode2Notify, servicePort, NOTIFY_URI);
            http = (HttpURLConnection)url.openConnection();
            http.setAllowUserInteraction(false);
            http.setInstanceFollowRedirects(false);
            http.setDoInput(true);
            http.setDoOutput(true);
            OutputStream outx = http.getOutputStream();
            String msg = "trswcm-" + this.nodeWatched + "-cluster";
            outx.write(msg.getBytes());
            http.connect();
            respCode = http.getResponseCode();
        }
        catch (Exception e) {
            error = e;
        }
        finally {
            if (http != null) {
                http.disconnect();
            }
            if (respCode != 200) {
                String msg = "Failed to notify the nextnode: ";
                msg = msg + nextNode2Notify;
                msg = msg + ", code=" + respCode;
                LOG.fatal((Object)msg, (Throwable)error);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getNextNode2Notify() {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        DBManager dbman = DBManager.getDBManager();
        String sql = "select NODEIP from XWCMCLUSTEREVENT where PREVNODEIP=? and NODESTATUS=0";
        String next = null;
        try {
            conn = dbman.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, this.nodeWatched);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                next = rs.getString(1);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to get next node", (Throwable)e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                dbman.freeConnection(conn);
            }
        }
        return next;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean markRestarted() {
        DBManager dbman = DBManager.getDBManager();
        Connection conn = null;
        PreparedStatement pstmt = null;
        String sql = "update XWCMCLUSTEREVENT set NODESTATUS=1,UPTIME=? where NODEIP=? and NODESTATUS=0";
        try {
            conn = dbman.getConnection();
            pstmt = conn.prepareStatement(sql);
            pstmt.setTimestamp(1, CMyDateTime.now().toTimestamp());
            pstmt.setString(2, this.nodeWatched);
            boolean bl = pstmt.executeUpdate() == 1;
            return bl;
        }
        catch (Exception e) {
            LOG.error((Object)"update event status error: ", (Throwable)e);
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                dbman.freeConnection(conn);
            }
        }
        return false;
    }

    public boolean barkOnRestart() {
        boolean result = false;
        if (this.isWatching() && this.isSupportedOs()) {
            result = this.restart();
        }
        return result;
    }

    private boolean restart() {
        boolean ok = false;
        ConfigServer confServer = ConfigServer.getServer();
        String wcmpath = confServer.getInitProperty("WCM_PATH");
        FileService shellScript = new FileService(wcmpath, "WEB-INF/restart_wcm.sh");
        try {
            LOG.info((Object)"Execute the cluster auto restart.");
            TRSWCMClusterServer server = (TRSWCMClusterServer)DreamFactory.createObjectById("TRSWCMClusterServer");
            server.shutdown();
            String[] cmd = new String[]{"nohup", shellScript.getAbsolutePath(), "&"};
            LOG.info((Object)(cmd[0] + " " + cmd[1] + " " + cmd[2]));
            Runtime.getRuntime().exec(cmd);
            ok = true;
        }
        catch (Exception ex) {
            LOG.fatal((Object)"Failed to restart.", (Throwable)ex);
        }
        return ok;
    }

    private boolean isSupportedOs() {
        boolean supported;
        String osname = System.getProperty("os.name", "").toLowerCase();
        boolean bl = supported = osname.indexOf("windows") == -1;
        if (!supported) {
            LOG.fatal((Object)"Only unix family os support the cluster auto restart.");
        }
        return supported;
    }
}

