/*
 * Decompiled with CFR 0.152.
 */
package com.trs.cluster;

import com.trs.DreamFactory;
import com.trs.cluster.TRSWCMClusterServer;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyDateTime;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.store.FileService;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.apache.log4j.Logger;

public class FileMsgProcessor {
    private static Logger logger = Logger.getLogger(FileMsgProcessor.class);
    private static TRSWCMClusterServer m_oClusterServer = null;
    private static boolean m_bClsutered = false;
    private static boolean m_bInited = false;
    private static String m_sLocalWcmPath = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void send(String filename) {
        Object buff;
        FileMsgProcessor.initIfNeed();
        if (!m_bClsutered) {
            return;
        }
        Object[] params = new Object[3];
        params[0] = "FILE.UPD";
        params[1] = FileMsgProcessor.resolveFileName(filename, true);
        InputStream fis = null;
        ByteArrayOutputStream bos = null;
        try {
            fis = new FileService(filename).getInputStream();
            buff = new byte[1024];
            bos = new ByteArrayOutputStream(2048);
            int nLen = 0;
            while ((nLen = fis.read((byte[])buff)) > 0) {
                bos.write((byte[])buff, 0, nLen);
            }
            bos.flush();
            params[2] = bos.toByteArray();
        }
        catch (Exception e) {
            logger.error((Object)"Failed to read file. No message sended.", (Throwable)e);
            return;
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
        if (logger.isDebugEnabled()) {
            buff = new StringBuffer(128);
            ((StringBuffer)buff).append("Cluster Msg Send: MsgType=");
            ((StringBuffer)buff).append(params[0]);
            ((StringBuffer)buff).append(", FileName=");
            ((StringBuffer)buff).append(params[1]);
            logger.debug((Object)((StringBuffer)buff).toString(), (Throwable)new Exception("For call stack inspect."));
        }
        m_oClusterServer.sendMsg((Serializable)params, true);
    }

    private static String resolveFileName(String filename, boolean truncate) {
        String resolvedFileName = null;
        resolvedFileName = truncate ? filename.substring(m_sLocalWcmPath.length()) : m_sLocalWcmPath + filename;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Message about file: " + resolvedFileName));
        }
        logger.fatal((Object)("Message about file: " + resolvedFileName));
        return resolvedFileName;
    }

    private static boolean initIfNeed() {
        if (m_bInited) {
            return m_bClsutered;
        }
        m_oClusterServer = (TRSWCMClusterServer)DreamFactory.createObjectById("TRSWCMClusterServer");
        m_bInited = true;
        if (m_oClusterServer == null || m_oClusterServer.getContext() == null) {
            m_bClsutered = false;
            return false;
        }
        m_bClsutered = m_oClusterServer.getContext().getConfig().isEnabled();
        m_sLocalWcmPath = ConfigServer.getServer().getInitProperty("WCM_PATH");
        logger.fatal((Object)m_sLocalWcmPath);
        m_sLocalWcmPath = CMyString.setStrEndWith(m_sLocalWcmPath, File.separatorChar);
        logger.fatal((Object)m_sLocalWcmPath);
        return m_bClsutered;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void receive(Object[] params) {
        FileService file;
        FileMsgProcessor.initIfNeed();
        String filename = FileMsgProcessor.resolveFileName((String)params[1], false);
        byte[] content = (byte[])params[2];
        if (logger.isDebugEnabled()) {
            StringBuffer buff = new StringBuffer(128);
            buff.append("Cluster Msg Received: MsgType=");
            buff.append(params[0]);
            buff.append(", FileName=");
            buff.append(filename);
            if (content.length > 0) {
                buff.append(", Content(ISO8859)=");
                try {
                    buff.append(new String(content, "ISO-8859-1"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else {
                buff.append("Content=Empty");
            }
            logger.debug((Object)buff.toString());
        }
        if ((file = new FileService(filename)).isDirectory()) {
            logger.error((Object)(filename + " is a directory."));
        } else {
            String fn = filename + "." + CMyDateTime.now().toString("yyyyMMddHHmmss");
            OutputStream fos = null;
            FileService newFile = new FileService(fn);
            boolean ok = false;
            Exception error = null;
            try {
                if (!newFile.getParentFileStore().exists()) {
                    newFile.getParentFileStore().mkdirs();
                }
                fos = newFile.getOutputStream();
                fos.write(content);
                fos.flush();
                fos.close();
                if (file.exists()) {
                    file.delete();
                } else if (logger.isDebugEnabled()) {
                    logger.debug((Object)("cluster add new file: " + filename));
                }
                ok = newFile.renameTo(file);
            }
            catch (Exception ex) {
                error = ex;
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (Exception exception) {}
                }
            }
            if (!ok) {
                logger.error((Object)("Failed to process file: " + filename), (Throwable)error);
            }
        }
    }
}

