/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.xmlconvertors;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.process.engine.ContentProcessInfo;
import com.trs.infra.I18NMessage;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.xmlserver.ConvertException;
import com.trs.webframework.xmlserver.IXMLConvertor;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class ContentProcessInfoToXML
implements IXMLConvertor {
    @Override
    public String[] registerTargetClassName() {
        return new String[]{ContentProcessInfo.class.getName()};
    }

    @Override
    public String toXmlString(MethodContext _methodContext, Object _result) throws ConvertException {
        User loginUser = ContextHelper.getLoginUser();
        ContentProcessInfo contentProcessInfo = (ContentProcessInfo)_result;
        Element elResult = DocumentHelper.createElement((String)"ProcessInfo");
        elResult.addAttribute("IsEnd", contentProcessInfo.isEnd() ? "true" : "false");
        elResult.addAttribute("StartUser", CMyString.showNull(contentProcessInfo.getStartUserName()));
        boolean bIsStarter = loginUser.getName().equals(contentProcessInfo.getStartUserName());
        elResult.addAttribute("LoginUserIsStarter", bIsStarter ? "true" : "false");
        elResult.addAttribute("FlowId", String.valueOf(contentProcessInfo.getContentFlowId()));
        try {
            boolean bIsAdministrator = loginUser.isAdministrator();
            boolean bOnlyAdmin = "true".equalsIgnoreCase(ConfigServer.getServer().getSysConfigValue("ONLY_ADMIN_CTR_FLOW", "false"));
            elResult.addAttribute("ReInFlow", String.valueOf(contentProcessInfo.canReInFlow() && (bIsAdministrator || loginUser.equals(contentProcessInfo.getContent().getCrUser()))));
            elResult.addAttribute("InFlow", String.valueOf(contentProcessInfo.canInFlow() && (bIsAdministrator || loginUser.equals(contentProcessInfo.getContent().getCrUser()))));
            elResult.addAttribute("StopFlow", String.valueOf(contentProcessInfo.canStopFlow() && (!bOnlyAdmin && bIsStarter || bIsAdministrator)));
        }
        catch (Exception e) {
            throw new ConvertException(I18NMessage.get(ContentProcessInfoToXML.class, "ContentProcessInfoToXML.label1", "\u6784\u9020\u6d41\u7a0b\u64cd\u4f5c\u65f6\u5019\u53d1\u751f\u5f02\u5e38\uff01"), e);
        }
        return elResult.asXML();
    }
}

