/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.jsonconvertors;

import com.alibaba.fastjson.JSON;
import com.trs.ajaxservice.jsonconvertors.ApiResult;
import com.trs.ajaxservice.jsonconvertors.SpecialPropertyOfBaseObjForJSON;
import com.trs.ajaxservice.jsonconvertors.WCMJSONHelper;
import com.trs.ajaxservice.jsonconvertors.WCMJsonTemp;
import com.trs.cms.ContextHelper;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Report;
import com.trs.infra.util.Reports;
import com.trs.mlf.simplelog.LogBodys;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class WCMJsonUtil {
    private static Logger logger = Logger.getLogger(WCMJsonUtil.class);
    public static final int CONTEXT_INDEX_IDS = WCMJSONHelper.CONTEXT_INDEX_IDS;
    public static final int CONTAINS_PAGE_INFO = WCMJSONHelper.CONTAINS_PAGE_INFO;
    public static final int INDEX_SELECT_FIELDS = WCMJSONHelper.INDEX_SELECT_FIELDS;
    public static final int CONTAINS_JSON_SPECIAL = WCMJSONHelper.CONTAINS_JSON_SPECIAL;

    private WCMJsonUtil() {
    }

    public static String toJSON(Object value) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("object to json ::::::::::: value=" + value));
        }
        ApiResult apiResult = value == null ? new ApiResult().data(null) : (!(value instanceof ApiResult) ? new ApiResult().data(value) : (ApiResult)value);
        Map<String, Object> mapOrMaps = WCMJsonUtil.apiResultToMap(apiResult);
        return JSON.toJSONString(mapOrMaps);
    }

    private static Map<String, Object> baseObjToMap(BaseObj baseObj) {
        return WCMJsonUtil.baseObjToMap(baseObj, null);
    }

    private static Map<String, Object> baseObjToMap(BaseObj baseObj, String selectFields) {
        if (baseObj == null) {
            return new HashMap<String, Object>();
        }
        if (selectFields == null) {
            selectFields = WCMJsonUtil.getSelectFields();
        }
        Map<String, Object> baseObjAllProperties = WCMJsonUtil.baseObjPropertiesToMap(baseObj, selectFields);
        return WCMJsonUtil.resolveMap(baseObjAllProperties);
    }

    private static Map<String, Object> baseObjsToMapWithPager(BaseObjs baseObjs, int currentPageIndex, int pageSize, int itemCount) {
        HashMap<String, Integer> pagerMap = new HashMap<String, Integer>();
        pagerMap.put("CURRPAGE", currentPageIndex);
        pagerMap.put("PAGESIZE", pageSize);
        pagerMap.put("PAGECOUNT", itemCount % pageSize > 0 ? itemCount / pageSize + 1 : itemCount / pageSize);
        pagerMap.put("ITEMCOUNT", itemCount);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("PAGER", pagerMap);
        resultMap.put("DATA", WCMJsonUtil.baseObjsToMapsWithoutPager(baseObjs, (currentPageIndex - 1) * pageSize, currentPageIndex * pageSize - 1));
        return resultMap;
    }

    private static Object[] baseObjsToMapsWithoutPager(BaseObjs baseObjs) {
        return WCMJsonUtil.baseObjsToMapsWithoutPager(baseObjs, 0, baseObjs.size() - 1);
    }

    private static Object[] baseObjsToMapsWithoutPager(BaseObjs baseObjs, int firstIndex, int lastIndex) {
        if (baseObjs == null || baseObjs.size() == 0) {
            return new Object[0];
        }
        ArrayList<Map<String, Object>> maps = new ArrayList<Map<String, Object>>(baseObjs.size());
        WCMFilter filter = baseObjs.getFilter();
        String selectFields = filter.getSelect();
        StringBuilder sbIds = new StringBuilder("");
        for (int i = firstIndex; i <= lastIndex && i < baseObjs.size(); ++i) {
            BaseObj baseObj = baseObjs.getAt(i);
            if (baseObj == null) continue;
            sbIds.append(baseObj.getId() + ",");
            maps.add(WCMJsonUtil.baseObjToMap(baseObj, selectFields));
        }
        if (sbIds.length() > 0) {
            sbIds.setLength(sbIds.length() - 1);
        }
        WCMJsonTemp oWCMJsonTemp = new WCMJsonTemp();
        oWCMJsonTemp.setObjectIdsOfCurrPage(sbIds.toString());
        ContextHelper.setArg(CONTEXT_INDEX_IDS, oWCMJsonTemp);
        return maps.toArray();
    }

    public static void setSelectFields(String selectFields) {
        ContextHelper.setArg(INDEX_SELECT_FIELDS, selectFields);
    }

    public static String getSelectFields() {
        return (String)ContextHelper.getArg(INDEX_SELECT_FIELDS);
    }

    public static boolean isStartContainsPageInfo() {
        return ContextHelper.getArg(CONTAINS_PAGE_INFO) != null;
    }

    public static boolean isJSONResultContainsPageInfo() {
        Object containsPageInfo = ContextHelper.getArg(CONTAINS_PAGE_INFO);
        return containsPageInfo != null && (Boolean)containsPageInfo != false;
    }

    public static void setJSONSpecial(String key, Object value) {
        HashMap<String, Object> hJSONSpecial = (HashMap<String, Object>)ContextHelper.getArg(CONTAINS_JSON_SPECIAL);
        if (hJSONSpecial == null) {
            hJSONSpecial = new HashMap<String, Object>();
            ContextHelper.setArg(CONTAINS_JSON_SPECIAL, hJSONSpecial);
        }
        hJSONSpecial.put(key.toUpperCase(), value);
    }

    public static Object getJSONSpecial(String key) {
        Map hJSONSpecial = (Map)ContextHelper.getArg(CONTAINS_JSON_SPECIAL);
        if (hJSONSpecial == null) {
            return null;
        }
        return hJSONSpecial.get(key.toUpperCase());
    }

    public static Map<String, Object> apiResultToMap(ApiResult apiResult) {
        Object data = apiResult.getData();
        if (data instanceof Reports) {
            List reports = ((Reports)data).getFailedReporter();
            apiResult.setIsSuccess(reports == null || reports.isEmpty());
            if (!apiResult.getIsSuccess()) {
                apiResult.setMsg("\u64cd\u4f5c\u5931\u8d25");
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ISSUCCESS", apiResult.getIsSuccess() ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        map.put("MSG", apiResult.getMsg());
        map.put("DATA", WCMJsonUtil.toMapOrMaps(data));
        return map;
    }

    private static Object toMapOrMaps(Object value) {
        if (value instanceof BaseObj) {
            return WCMJsonUtil.baseObjToMap((BaseObj)value);
        }
        if (value instanceof BaseObjs) {
            if (WCMJsonUtil.isStartContainsPageInfo() && !WCMJsonUtil.isJSONResultContainsPageInfo()) {
                return WCMJsonUtil.baseObjsToMapsWithoutPager((BaseObjs)value);
            }
            BaseObjs baseObjs = (BaseObjs)value;
            WCMFilter oFilter = baseObjs.getFilter();
            int currentPageIndex = 0;
            int pageSize = 0;
            int itemCount = baseObjs.size();
            if (oFilter != null && oFilter.getCurrPage() > 0) {
                currentPageIndex = oFilter.getCurrPage();
                pageSize = oFilter.getPageSize();
            }
            if (baseObjs.getCurrPage() > 0) {
                currentPageIndex = baseObjs.getCurrPage();
                pageSize = baseObjs.getPageSize();
            }
            if (currentPageIndex > 0 && pageSize > 0) {
                return WCMJsonUtil.baseObjsToMapWithPager(baseObjs, currentPageIndex, pageSize, itemCount);
            }
            return WCMJsonUtil.baseObjsToMapsWithoutPager((BaseObjs)value);
        }
        if (value instanceof Reports) {
            return WCMJsonUtil.reportsToMaps((Reports)value);
        }
        if (value instanceof Report) {
            return WCMJsonUtil.reportToMap((Report)value);
        }
        if (value instanceof Object[]) {
            return WCMJsonUtil.objectsToMaps((Object[])value);
        }
        if (value instanceof Collection) {
            return WCMJsonUtil.collectionToMaps((Collection)value);
        }
        if (value instanceof Map) {
            return WCMJsonUtil.resolveMap((Map)value);
        }
        if (value instanceof LogBodys) {
            return WCMJsonUtil.logBodysToMap((LogBodys)value);
        }
        if (value == null) {
            return "";
        }
        if ("null".equalsIgnoreCase(String.valueOf(String.valueOf(value)))) {
            return "";
        }
        return String.valueOf(value);
    }

    private static Object logBodysToMap(LogBodys logBodys) {
        String json = JSON.toJSONString((Object)logBodys);
        Map jsonMap = (Map)JSON.parseObject((String)json, HashMap.class);
        return WCMJsonUtil.resolveMap(jsonMap);
    }

    private static Object[] objectsToMaps(Object[] objects) {
        if (objects == null || objects.length == 0) {
            return new Object[0];
        }
        ArrayList<Object> resultList = new ArrayList<Object>(objects.length);
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (object == null) continue;
            resultList.add(WCMJsonUtil.toMapOrMaps(object));
        }
        return resultList.toArray();
    }

    private static Object[] collectionToMaps(Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return new Object[0];
        }
        ArrayList<Object> resultList = new ArrayList<Object>(collection.size());
        for (Object object : collection) {
            if (object == null) continue;
            resultList.add(WCMJsonUtil.toMapOrMaps(object));
        }
        return resultList.toArray();
    }

    private static Object[] reportsToMaps(Reports reports) {
        if (reports == null) {
            return new Object[0];
        }
        ArrayList allReport = new ArrayList();
        allReport.addAll(reports.getSucessedReporter());
        allReport.addAll(reports.getWarnedReporter());
        allReport.addAll(reports.getFailedReporter());
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(allReport.size());
        for (int i = 0; i < allReport.size() && !allReport.isEmpty(); ++i) {
            Report report = (Report)allReport.get(i);
            if (report == null) continue;
            list.add(WCMJsonUtil.reportToMap(report));
        }
        return list.toArray();
    }

    private static Map<String, Object> reportToMap(Report report) {
        if (report == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TITLE", report.getRportTitle());
        map.put("ISSUCCESS", report.getType() != 5 ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
        map.put("TYPE", report.getType());
        map.put("DETAIL", report.getRportDetail());
        map.put("DESC", CMyString.showEmpty(report.getRportTitle()) + (CMyString.isEmpty(report.getRportDetail()) ? "" : "(" + report.getRportDetail() + ")"));
        return map;
    }

    private static Map<String, Object> baseObjPropertiesToMap(BaseObj baseObj, String selectFields) {
        HashMap<String, Object> allProperties = new HashMap<String, Object>();
        if (CMyString.isEmpty(selectFields)) {
            if (baseObj.getAllProperty() == null) {
                logger.warn((Object)("dirty data?" + baseObj.getId()));
            } else {
                allProperties.putAll(baseObj.getAllProperty());
            }
        } else {
            String[] pFieldNames;
            selectFields = selectFields.toUpperCase();
            for (String sFieldName : pFieldNames = selectFields.split(",")) {
                sFieldName = sFieldName.trim();
                allProperties.put(sFieldName, baseObj.getProperty(sFieldName));
            }
        }
        Map<String, Object> hExtProperties = baseObj.getExtProperties();
        allProperties.putAll(hExtProperties);
        SpecialPropertyOfBaseObjForJSON.transformSpecialPropertyMap(baseObj, allProperties);
        return allProperties;
    }

    private static Map<String, Object> resolveMap(Map<String, Object> map) {
        Iterator<String> iterator = map.keySet().iterator();
        HashMap<String, Object> mapWithKeyUpperCase = new HashMap<String, Object>();
        while (iterator.hasNext()) {
            String key = iterator.next();
            Object object = map.get(key);
            mapWithKeyUpperCase.put(key.toUpperCase(), WCMJsonUtil.toMapOrMaps(object));
        }
        return mapWithKeyUpperCase;
    }
}

