/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice.jsonconvertors;

import com.trs.ajaxservice.jsonconvertors.ApiResult;
import com.trs.ajaxservice.jsonconvertors.SpecialPropertyOfBaseObjForJSON;
import com.trs.ajaxservice.jsonconvertors.WCMJsonTemp;
import com.trs.cms.ContextHelper;
import com.trs.infra.common.BaseContextHelper;
import com.trs.infra.config.persistent.IConfigElement;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.BaseObjs;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CPager;
import com.trs.infra.util.Report;
import com.trs.infra.util.Reports;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class WCMJSONHelper {
    private static Logger logger = Logger.getLogger(WCMJSONHelper.class);
    public static final int CONTEXT_INDEX_IDS = BaseContextHelper.getNextIndex();
    public static final int CONTAINS_PAGE_INFO = BaseContextHelper.getNextIndex();
    public static final int INDEX_SELECT_FIELDS = BaseContextHelper.getNextIndex();
    public static final int CONTAINS_JSON_SPECIAL = BaseContextHelper.getNextIndex();

    public static void setSelectFields(String _sSelectFields) {
        ContextHelper.setArg(INDEX_SELECT_FIELDS, _sSelectFields);
    }

    public static String getSelectFields() {
        return (String)ContextHelper.getArg(INDEX_SELECT_FIELDS);
    }

    public static void setJSONResultContainsPageInfo(boolean _bContains) {
        ContextHelper.setArg(CONTAINS_PAGE_INFO, _bContains);
    }

    public static boolean isStartContainsPageInfo() {
        return ContextHelper.getArg(CONTAINS_PAGE_INFO) != null;
    }

    public static boolean isJSONResultContainsPageInfo() {
        return (Boolean)ContextHelper.getArg(CONTAINS_PAGE_INFO);
    }

    public static void setJSONSpecial(String _sKey, Object _oValue) {
        HashMap<String, Object> hJSONSpecial = (HashMap<String, Object>)ContextHelper.getArg(CONTAINS_JSON_SPECIAL);
        if (hJSONSpecial == null) {
            hJSONSpecial = new HashMap<String, Object>();
            ContextHelper.setArg(CONTAINS_JSON_SPECIAL, hJSONSpecial);
        }
        hJSONSpecial.put(_sKey.toUpperCase(), _oValue);
    }

    public static Object getJSONSpecial(String _sKey) {
        Map hJSONSpecial = (Map)ContextHelper.getArg(CONTAINS_JSON_SPECIAL);
        if (hJSONSpecial == null) {
            return null;
        }
        return hJSONSpecial.get(_sKey.toUpperCase());
    }

    public static String toJSON(ApiResult _oApiResult) {
        String dataStr;
        StringBuffer sbResult = new StringBuffer();
        Object data = _oApiResult.getData();
        if (data instanceof Reports) {
            List reports = ((Reports)data).getFailedReporter();
            _oApiResult.setIsSuccess(reports == null || reports.isEmpty());
            if (!_oApiResult.getIsSuccess()) {
                _oApiResult.setMsg("\u64cd\u4f5c\u5931\u8d25");
            }
        }
        if ((dataStr = WCMJSONHelper.toJSON(data)) == null || dataStr.trim().length() == 0) {
            dataStr = null;
        }
        sbResult.append("{\n").append("\"ISSUCCESS\":\"").append(_oApiResult.getIsSuccess()).append("\",\n").append("\"MSG\":\"").append(_oApiResult.getMsg()).append("\",\n").append("\"DATA\":").append(dataStr).append("\n").append("}");
        return sbResult.toString();
    }

    public static String toJSON(Object _oValue) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("1._oValue:::::::::::" + _oValue));
        }
        if (_oValue == null) {
            return "";
        }
        if (_oValue instanceof Map) {
            return WCMJSONHelper.toJSON((Map)_oValue, 0);
        }
        if (_oValue instanceof String) {
            return WCMJSONHelper.toJSON((String)_oValue);
        }
        if (_oValue instanceof BaseObj) {
            BaseObj oCurrBaseObj = (BaseObj)_oValue;
            return WCMJSONHelper.toJSON(oCurrBaseObj);
        }
        if (_oValue instanceof BaseObjs) {
            return WCMJSONHelper.toJSON((BaseObjs)_oValue);
        }
        if (_oValue instanceof Reports) {
            return WCMJSONHelper.toJSON((Reports)_oValue);
        }
        if (_oValue instanceof Report) {
            return WCMJSONHelper.toJSON((Report)_oValue);
        }
        if (_oValue instanceof List) {
            return WCMJSONHelper.toJSON((List)_oValue);
        }
        if (_oValue instanceof JSONObject) {
            return WCMJSONHelper.toJSON((Map)_oValue);
        }
        if (_oValue instanceof JSONArray) {
            return WCMJSONHelper.toJSON((List)_oValue);
        }
        if (_oValue instanceof Object[]) {
            return WCMJSONHelper.toJSON((Object[])_oValue);
        }
        if (_oValue instanceof ApiResult) {
            return WCMJSONHelper.toJSON((ApiResult)_oValue);
        }
        if (_oValue instanceof IConfigElement) {
            return WCMJSONHelper.toJSON((IConfigElement)_oValue);
        }
        return WCMJSONHelper.toJSON(_oValue != null ? _oValue.toString() : null);
    }

    private static String toJSON(Reports _reports) {
        return WCMJSONHelper.toJSON(_reports, 0);
    }

    private static String toJSON(Reports _reports, int _nTabLevel) {
        if (_reports == null) {
            return "";
        }
        StringBuffer sbResult = new StringBuffer();
        int nTabIndex = _nTabLevel;
        String sElementTabContent = WCMJSONHelper.makeTabStr(nTabIndex++);
        sbResult.append("[\n");
        boolean bFirst = true;
        ArrayList allReport = new ArrayList();
        allReport.addAll(_reports.getSucessedReporter());
        allReport.addAll(_reports.getWarnedReporter());
        allReport.addAll(_reports.getFailedReporter());
        for (int i = 0; i < allReport.size() && allReport.size() > 0; ++i) {
            Report report = (Report)allReport.get(i);
            if (report == null) continue;
            if (bFirst) {
                bFirst = false;
            } else {
                sbResult.append(",");
                sbResult.append("\n");
            }
            sbResult.append(WCMJSONHelper.toJSON(report));
        }
        sbResult.append("\n");
        sbResult.append(sElementTabContent);
        sbResult.append("]\n");
        return sbResult.toString();
    }

    private static String toJSON(Report _report) {
        if (_report == null) {
            return "";
        }
        StringBuffer sbResult = new StringBuffer();
        sbResult.append("{").append("\"TITLE\":\"").append(_report.getRportTitle()).append("\",").append("\"ISSUCCESS\":\"").append(_report.getType() != 5 ? "true" : "false").append("\",").append("\"TYPE\":\"").append(_report.getType()).append("\",").append("\"DETAIL\":\"").append(_report.getRportDetail());
        sbResult.append("\"}");
        return sbResult.toString();
    }

    public static String toJsonForReportXml(String xml) {
        JSONObject obj = new JSONObject();
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes("utf-8"));
            SAXBuilder sb = new SAXBuilder();
            Document doc = sb.build((InputStream)is);
            Element root = doc.getRootElement();
            obj.put((Object)root.getName(), WCMJSONHelper.iterateElement(root));
            return obj.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String toJSON(Map<String, Object> _oValue) {
        return WCMJSONHelper.toJSON(_oValue, 0);
    }

    private static String toJSON(BaseObj _oValue) {
        if (_oValue == null) {
            return "";
        }
        return WCMJSONHelper.toJSON(_oValue, 0);
    }

    private static String toJSON(BaseObj _oValue, int _nTabLevel) {
        return WCMJSONHelper.toJSON(_oValue, _nTabLevel, null);
    }

    private static String toJSON(BaseObj _oValue, int _nTabLevel, String _sSelectFields) {
        if (_oValue == null) {
            return "";
        }
        if (_sSelectFields == null) {
            _sSelectFields = WCMJSONHelper.getSelectFields();
        }
        Map<String, Object> allProperties = WCMJSONHelper.makeAllProperties(_oValue, _sSelectFields);
        return WCMJSONHelper.toJSON(allProperties, _nTabLevel);
    }

    private static String toJSON(Object[] _pObject) {
        return WCMJSONHelper.toJSON(_pObject, 0);
    }

    private static String toJSON(Object[] _pObject, int _nTabLevel) {
        if (_pObject == null) {
            return "[]";
        }
        StringBuffer sbResult = new StringBuffer();
        int nTabIndex = _nTabLevel;
        String sElementTabContent = WCMJSONHelper.makeTabStr(nTabIndex++);
        sbResult.append("[\n");
        boolean bFirst = true;
        int nCount = _pObject == null ? 0 : _pObject.length;
        for (int i = 0; i < nCount; ++i) {
            if (_pObject[i] == null) continue;
            if (bFirst) {
                bFirst = false;
            } else {
                sbResult.append(",");
                sbResult.append("\n");
            }
            sbResult.append(WCMJSONHelper.toJSON(_pObject[i]));
        }
        sbResult.append("\n");
        sbResult.append(sElementTabContent);
        sbResult.append("]");
        return sbResult.toString();
    }

    private static String toJSON(BaseObjs _oCurrObjs) {
        return WCMJSONHelper.toJSON(_oCurrObjs, 0);
    }

    private static String toJSON(BaseObjs _oCurrObjs, int _nTabLevel) {
        BaseObj oCurrObj;
        int i;
        int nSize;
        if (_oCurrObjs == null) {
            return WCMJSONHelper.getNullArray(0, 0);
        }
        if (_oCurrObjs.size() == 0) {
            int nCurrPage = _oCurrObjs.getCurrPage();
            int nPageSize = _oCurrObjs.getPageSize();
            return WCMJSONHelper.getNullArray(nCurrPage, nPageSize);
        }
        StringBuffer sbResult = new StringBuffer();
        int nTabIndex = _nTabLevel;
        String sElementTabContent = WCMJSONHelper.makeTabStr(nTabIndex++);
        sbResult.append("[\n");
        boolean bFirst = true;
        int nPageSize = nSize = _oCurrObjs.size();
        int nCurrPage = 1;
        String sSelectFields = null;
        WCMFilter oFilter = _oCurrObjs.getFilter();
        if (oFilter != null) {
            if (oFilter.getCurrPage() > 0) {
                nPageSize = oFilter.getPageSize();
                nCurrPage = oFilter.getCurrPage();
            }
            sSelectFields = oFilter.getSelect();
        }
        if (_oCurrObjs.getCurrPage() > 0) {
            nPageSize = _oCurrObjs.getPageSize();
            nCurrPage = _oCurrObjs.getCurrPage();
        }
        CPager pager = new CPager(nPageSize);
        pager.setItemCount(nSize);
        pager.setCurrentPageIndex(nCurrPage);
        int nPageCount = pager.getPageCount();
        StringBuffer sbIds = new StringBuffer("");
        WCMJsonTemp oWCMJsonTemp = new WCMJsonTemp();
        for (i = pager.getFirstItemIndex() - 1; i < pager.getLastItemIndex(); ++i) {
            oCurrObj = _oCurrObjs.getAt(i);
            if (null == oCurrObj) continue;
            sbIds.append(oCurrObj.getId() + ",");
        }
        if (sbIds.length() > 0) {
            sbIds.setLength(sbIds.length() - 1);
        }
        oWCMJsonTemp.setObjectIdsOfCurrPage(sbIds.toString());
        ContextHelper.setArg(CONTEXT_INDEX_IDS, oWCMJsonTemp);
        for (i = pager.getFirstItemIndex() - 1; i < pager.getLastItemIndex(); ++i) {
            oCurrObj = _oCurrObjs.getAt(i);
            if (oCurrObj == null) continue;
            if (bFirst) {
                bFirst = false;
            } else {
                sbResult.append(",");
                sbResult.append("\n");
            }
            sbResult.append(WCMJSONHelper.toJSON(oCurrObj, _nTabLevel, sSelectFields));
        }
        sbResult.append("\n");
        sbResult.append(sElementTabContent);
        sbResult.append("]");
        if (WCMJSONHelper.isStartContainsPageInfo() && !WCMJSONHelper.isJSONResultContainsPageInfo()) {
            return sbResult.toString();
        }
        boolean bIsHasPager = false;
        if (oFilter != null && oFilter.getCurrPage() > 0) {
            bIsHasPager = true;
        }
        if (_oCurrObjs.getCurrPage() > 0) {
            bIsHasPager = true;
        }
        if (!bIsHasPager) {
            return sbResult.toString();
        }
        StringBuffer sbPagerData = new StringBuffer();
        sbPagerData.append("{\"PAGER\":").append("{\"CURRPAGE\":").append(nCurrPage).append(",\"PAGESIZE\":").append(nPageSize).append(",\"PAGECOUNT\":").append(nPageCount).append(",\"ITEMCOUNT\":").append(nSize).append("}").append(",\"DATA\":").append(sbResult).append("}");
        return sbPagerData.toString();
    }

    private static Map<String, Object> makeAllProperties(BaseObj _oCurrObj, String _sSelectFields) {
        HashMap<String, Object> allProperties = new HashMap<String, Object>();
        if (CMyString.isEmpty(_sSelectFields)) {
            if (_oCurrObj.getAllProperty() == null) {
                System.err.println("dirty data?" + _oCurrObj.getId());
            } else {
                allProperties.putAll(_oCurrObj.getAllProperty());
            }
        } else {
            String[] pFieldNames;
            _sSelectFields = _sSelectFields.toUpperCase();
            for (String sFieldName : pFieldNames = _sSelectFields.split(",")) {
                sFieldName = sFieldName.trim();
                allProperties.put(sFieldName, _oCurrObj.getProperty(sFieldName));
            }
        }
        Map<String, Object> hExtProperties = _oCurrObj.getExtProperties();
        allProperties.putAll(hExtProperties);
        SpecialPropertyOfBaseObjForJSON.transformSpecialPropertyMap(_oCurrObj, allProperties);
        return allProperties;
    }

    private static String makeTabStr(int _nTabCount) {
        StringBuffer sbResult = new StringBuffer(4 * _nTabCount);
        for (int i = 0; i < _nTabCount; ++i) {
            sbResult.append("   ");
        }
        return sbResult.toString();
    }

    public static String toJSON(String _sValue) {
        if (_sValue == null) {
            return "\"\"";
        }
        if (_sValue.contains("<REPORT>")) {
            return WCMJSONHelper.toJsonForReportXml(_sValue);
        }
        if (_sValue.startsWith("{") && _sValue.endsWith("}") || _sValue.startsWith("[") && _sValue.endsWith("]")) {
            return _sValue;
        }
        StringBuffer sbResult = new StringBuffer(_sValue.length() + 2);
        sbResult.append('\"');
        _sValue = _sValue.replaceAll("\\\\", "\\\\\\\\");
        _sValue = _sValue.replaceAll("\n", "\\\\n");
        _sValue = _sValue.replaceAll("\r", "\\\\r");
        _sValue = _sValue.replaceAll("\t", "\\\\t");
        _sValue = _sValue.replaceAll("\"", "\\\\\"");
        sbResult.append(_sValue);
        sbResult.append('\"');
        return sbResult.toString();
    }

    private static String toJSON(Map<String, Object> _map, int _nTabLevel) {
        if (_map == null || _map.isEmpty()) {
            return "";
        }
        String sTabContent = WCMJSONHelper.makeTabStr(_nTabLevel++);
        int nElementTabCount = _nTabLevel++;
        int nCount = _map.size() * 52 + 6;
        StringBuffer sbResult = new StringBuffer(nCount);
        Iterator<String> itKeys = _map.keySet().iterator();
        sbResult.append(sTabContent);
        sbResult.append("{\n");
        boolean bFirst = true;
        while (itKeys.hasNext()) {
            String sKey = itKeys.next();
            Object value = _map.get(sKey);
            if (bFirst) {
                bFirst = false;
            } else {
                sbResult.append(",\n");
            }
            sKey = sKey.toUpperCase();
            sbResult.append(sTabContent);
            sbResult.append('\"');
            sbResult.append(sKey);
            sbResult.append('\"');
            sbResult.append(" : ");
            if (value instanceof String[]) {
                sbResult.append(WCMJSONHelper.toJSON((String[])value, nElementTabCount));
                continue;
            }
            if (value instanceof HashMap) {
                sbResult.append(WCMJSONHelper.toJSON((Map)value, nElementTabCount));
                continue;
            }
            if (value instanceof List) {
                sbResult.append(WCMJSONHelper.toJSON((List)value, nElementTabCount));
                continue;
            }
            if (value instanceof String[][]) {
                sbResult.append(WCMJSONHelper.toJSON((String[][])value, nElementTabCount));
                continue;
            }
            if (value instanceof Object[]) {
                sbResult.append(WCMJSONHelper.toJSON((Object[])value, nElementTabCount));
                continue;
            }
            if (value instanceof BaseObjs) {
                sbResult.append(WCMJSONHelper.toJSON((BaseObjs)value, nElementTabCount));
                continue;
            }
            if (value instanceof BaseObj) {
                sbResult.append(WCMJSONHelper.toJSON((BaseObj)value, nElementTabCount));
                continue;
            }
            sbResult.append(WCMJSONHelper.toJSON(value != null ? value.toString() : null));
        }
        sbResult.append('\n');
        sbResult.append(sTabContent);
        sbResult.append("}");
        return sbResult.toString();
    }

    public static String toJSON(String[] _pValues) {
        if (_pValues == null) {
            return "";
        }
        int nCount = _pValues.length * 50 + 6;
        StringBuffer sbResult = new StringBuffer(nCount);
        sbResult.append("[");
        boolean bFirst = true;
        for (int i = 0; i < _pValues.length; ++i) {
            if (_pValues[i] == null) continue;
            if (bFirst) {
                bFirst = false;
            } else {
                sbResult.append(",");
            }
            sbResult.append(WCMJSONHelper.toJSON(_pValues[i]));
        }
        sbResult.append("]");
        return sbResult.toString();
    }

    public static String toJSON(String[][] _pValues) {
        return WCMJSONHelper.toJSON(_pValues, 0);
    }

    private static String toJSON(String[][] _pValues, int _nLevel) {
        if (_pValues == null) {
            return "";
        }
        String sRootTabCount = WCMJSONHelper.makeTabStr(_nLevel++);
        String sElementTabCount = WCMJSONHelper.makeTabStr(_nLevel++);
        int nCount = _pValues.length * 50 + 6;
        StringBuffer sbResult = new StringBuffer(nCount);
        sbResult.append(sRootTabCount);
        sbResult.append("{\n");
        boolean bFirst = true;
        for (int i = 0; i < _pValues.length; ++i) {
            if (_pValues[i] == null || _pValues[i].length < 2) continue;
            if (bFirst) {
                bFirst = false;
            } else {
                sbResult.append(",\n");
            }
            sbResult.append(sElementTabCount);
            sbResult.append('\"');
            sbResult.append(_pValues[i][0]);
            sbResult.append('\"');
            sbResult.append(" : ");
            sbResult.append(WCMJSONHelper.toJSON(_pValues[i][1]));
        }
        sbResult.append('\n');
        sbResult.append(sRootTabCount);
        sbResult.append("}");
        sbResult.append('\n');
        return sbResult.toString();
    }

    private static Map<String, List> iterateElement(Element element) {
        List jiedian = element.getChildren();
        Element et = null;
        HashMap<String, List> obj = new HashMap<String, List>();
        List<Object> list = null;
        for (int i = 0; i < jiedian.size(); ++i) {
            list = new LinkedList<Object>();
            et = (Element)jiedian.get(i);
            if (et.getTextTrim().equals("")) {
                if (et.getChildren().size() == 0) continue;
                if (obj.containsKey(et.getName())) {
                    list = (List)obj.get(et.getName());
                }
                list.add(WCMJSONHelper.iterateElement(et));
                obj.put(et.getName(), list);
                continue;
            }
            if (obj.containsKey(et.getName())) {
                list = (List)obj.get(et.getName());
            }
            list.add(et.getTextTrim());
            obj.put(et.getName(), list);
        }
        return obj;
    }

    private static String toJSON(List _oValue) {
        return WCMJSONHelper.toJSON(_oValue, 0);
    }

    private static String toJSON(List _oValue, int _nTabLevel) {
        if (_oValue == null) {
            return "[]";
        }
        StringBuffer sbResult = new StringBuffer();
        int nTabIndex = _nTabLevel;
        String sElementTabContent = WCMJSONHelper.makeTabStr(nTabIndex++);
        int nElementTabCount = _nTabLevel++;
        sbResult.append("[\n");
        boolean bFirst = true;
        for (int i = 0; i < _oValue.size() && _oValue.size() > 0; ++i) {
            Object value = _oValue.get(i);
            if (value == null) continue;
            if (bFirst) {
                bFirst = false;
            } else {
                sbResult.append(",");
                sbResult.append("\n");
            }
            sbResult.append(WCMJSONHelper.toJSON(value));
        }
        sbResult.append("\n");
        sbResult.append(sElementTabContent);
        sbResult.append("]");
        return sbResult.toString();
    }

    private static String toJSON(IConfigElement _config) {
        return JSONObject.fromObject((Object)_config).toString();
    }

    private static String getNullArray(int _currPage, int _pageSize) {
        if (WCMJSONHelper.isStartContainsPageInfo() && !WCMJSONHelper.isJSONResultContainsPageInfo()) {
            return "[]";
        }
        StringBuilder sbPagerData = new StringBuilder();
        if (_currPage <= 0) {
            _currPage = 1;
        }
        sbPagerData.append("{\"PAGER\":").append("{\"CURRPAGE\":").append(_currPage).append(",\"PAGESIZE\":").append(_pageSize).append(",\"PAGECOUNT\":").append(0).append(",\"ITEMCOUNT\":").append(0).append("}").append(",\"DATA\":[]").append("}");
        return sbPagerData.toString();
    }

    public static void main(String[] args) {
        System.out.println(Thread.currentThread());
        HashMap<String, Object> hTest = new HashMap<String, Object>();
        hTest.put("test", "123\"dsaf\\dfasdsfa\u56de\u8f66\ndafdsd\u56de\u8f66\ntest");
        hTest.put("test2", "1\u5929\u53f0\uff1a\u201c\u91d1\u878d\u7535\u5546\u8d85\u5e02\u201d\u5f00\u5230\u519c\u6c11\u5bb6\u95e8\u53e3\t(QQ\u56fe\u724720150429203135.jpg)");
        System.out.println(WCMJSONHelper.toJSON(hTest));
        hTest.put("test2", "2\u5929\u53f0\uff1a\u201c\u91d1\u878d\u7535\u5546\u8d85\u5e02\u201d\u5f00\u5230\u519c\u6c11\u5bb6\u95e8\u53e3\t(QQ\u56fe\u724720150429203135.jpg)");
        System.out.println(JSONObject.fromObject(hTest));
        hTest.put("test3", "<p>\u676d\u5dde</p>");
        System.out.println(JSONObject.fromObject(hTest));
    }
}

