/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.wcm.photo.Watermark;
import com.trs.wcm.photo.Watermarks;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;

public class WatermarkServiceProvider
implements IGlueServiceProvider {
    @Override
    public void delete(MethodContext _context) throws Throwable {
        String sIds = _context.getObjectIds();
        if (CMyString.isEmpty(sIds)) {
            return;
        }
        User loginUser = ContextHelper.getLoginUser();
        int nLibId = _context.getValue("LibId", 0);
        WebSite lib = WebSite.findById(nLibId);
        if (lib == null) {
            throw new WCMException(200006, I18NMessage.get(WatermarkServiceProvider.class, "WatermarkServiceProvider.label1", "\u6ca1\u6709\u627e\u5230[Id=") + nLibId + I18NMessage.get(WatermarkServiceProvider.class, "WatermarkServiceProvider.label2", "]\u7684\u56fe\u5e93!"));
        }
        if (lib.isDeleted()) {
            throw new WCMException(200006, "[Id=" + nLibId + I18NMessage.get(WatermarkServiceProvider.class, "WatermarkServiceProvider.label3", "]\u7684\u56fe\u5e93\u5df2\u88ab\u5220\u9664!"));
        }
        if (!AuthServer.hasRight(loginUser, (CMSObj)lib, 32)) {
            throw new WCMException(1002, I18NMessage.get(WatermarkServiceProvider.class, "WatermarkServiceProvider.label4", "\u5bf9\u4e0d\u8d77,\u60a8\u65e0\u6743\u5220\u9664\u56fe\u5e93\u7684\u6c34\u5370!"));
        }
        WCMFilter filter = new WCMFilter("", "LibId=? AND WaterMarkId IN(" + sIds + ")", "");
        filter.addSearchValues(0, nLibId);
        Watermarks wms = new Watermarks(loginUser);
        wms.open(filter);
        wms.deleteAll(true);
    }

    @Override
    public Object query(MethodContext _context) throws Throwable {
        int nChnlId;
        Channel chnl;
        int nLibId = _context.getValue("LibId", 0);
        if (nLibId == 0 && (chnl = Channel.findById(nChnlId = _context.getValue("ChannelId", 0))) != null) {
            nLibId = chnl.getSiteId();
        }
        WCMFilter filter = new WCMFilter("", "LibId=?", "");
        filter.addSearchValues(0, nLibId);
        String orderBy = _context.getValue("OrderBy");
        orderBy = CMyString.isEmpty(orderBy) ? "CrTime desc" : orderBy + ",WatermarkId desc";
        filter.setOrder(orderBy);
        filter.mergeWith(_context.getExtraWCMFilter());
        Watermarks marks = new Watermarks(null);
        marks.open(filter);
        return marks;
    }

    @Override
    public int save(MethodContext _context) throws Throwable {
        int nId = _context.getObjectId();
        User loginUser = ContextHelper.getLoginUser();
        Watermark wm = null;
        if (nId > 0) {
            wm = Watermark.findById(nId);
            if (!wm.canEdit(loginUser)) {
                throw new WCMException(1012, wm + I18NMessage.get(WatermarkServiceProvider.class, "WatermarkServiceProvider.label5", "\u88ab[") + wm.getLockerUserName() + I18NMessage.get(WatermarkServiceProvider.class, "WatermarkServiceProvider.label6", "]\u9501\u5b9a,\u60a8\u6682\u65f6\u65e0\u6cd5\u9501\u5b9a\u5bf9\u8c61\u8fdb\u884c\u7f16\u8f91!"));
            }
        } else {
            wm = new Watermark();
        }
        wm.setWMName(_context.getValue("WMName"));
        if (_context.getValue("NOTQUICKEDIT", false)) {
            wm.setLibId(_context.getValue("LibId", 0));
            wm.setWMPicture(_context.getValue("WMPicture"));
        }
        wm.save(loginUser);
        return wm.getId();
    }

    @Override
    public Object findById(MethodContext _context) throws Throwable {
        String id = _context.getValue("ObjectId");
        int objId = 0;
        try {
            objId = Integer.parseInt(id);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Watermark mark = Watermark.findById(objId);
        if (mark == null) {
            throw new WCMException(200006, I18NMessage.get(WatermarkServiceProvider.class, "WatermarkServiceProvider.label1", "\u6ca1\u6709\u627e\u5230[Id=") + objId + I18NMessage.get(WatermarkServiceProvider.class, "WatermarkServiceProvider.label7", "]\u7684\u6c34\u5370\uff01"));
        }
        return mark;
    }

    @Override
    public Object findByIds(MethodContext _context) throws Throwable {
        String sIds = _context.getValue("ObjectIds");
        User loginUser = ContextHelper.getLoginUser();
        return Watermarks.findByIds(loginUser, sIds);
    }
}

