/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.GroupServiceProvider;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.GroupMgr;
import com.trs.cms.auth.domain.GroupRoleMgr;
import com.trs.cms.auth.domain.RoleMgr;
import com.trs.cms.auth.domain.UserMgr;
import com.trs.cms.auth.persistent.Group;
import com.trs.cms.auth.persistent.Groups;
import com.trs.cms.auth.persistent.Role;
import com.trs.cms.auth.persistent.RoleUser;
import com.trs.cms.auth.persistent.RoleUsers;
import com.trs.cms.auth.persistent.Roles;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.auth.persistent.Users;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.util.CMyString;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class RoleServiceProvider
implements IGlueServiceProvider {
    @Override
    public void delete(MethodContext context) throws Throwable {
    }

    @Override
    public Object query(MethodContext context) throws Throwable {
        return null;
    }

    public void saveRoles(MethodContext _methodContext) throws Throwable {
        int i;
        User loginUser = ContextHelper.getLoginUser();
        int nUserId = _methodContext.getValue("UserId", 0);
        Roles currRoles = Roles.findByIds(loginUser, _methodContext.getValue("CurrRoleIds"));
        User currUser = null;
        if (nUserId > 0) {
            currUser = User.findById(nUserId);
            if (currUser == null) {
                throw new WCMException(I18NMessage.get(GroupServiceProvider.class, "UserServiceProvider.label4", "\u6ca1\u6709\u627e\u5230ID\u4e3a[") + nUserId + "]" + I18NMessage.get(GroupServiceProvider.class, "UserServiceProvider.label3", "\u7684\u7528\u6237\uff01"));
            }
        } else {
            throw new WCMException(I18NMessage.get(GroupServiceProvider.class, "UserServiceProvider.label8", "\u83b7\u53d6\u7684\u7528\u6237ID\u4e0d\u6b63\u786e\uff01"));
        }
        Roles origRoles = currUser.getRoles();
        RoleMgr roleMgr = new RoleMgr();
        for (i = 0; i < currRoles.size(); ++i) {
            if (origRoles.indexOf(currRoles.getAt(i)) >= 0) continue;
            roleMgr.addUser(currUser, (Role)currRoles.getAt(i));
        }
        for (i = 0; i < origRoles.size(); ++i) {
            if (currRoles.indexOf(origRoles.getAt(i)) >= 0) continue;
            roleMgr.removeUser(currUser, (Role)origRoles.getAt(i));
        }
    }

    @Override
    public int save(MethodContext context) throws Throwable {
        Role role;
        int nObjectId = context.getObjectId();
        int nRoleType = context.getValue("RoleType", 0);
        int nRoleRange = context.getValue("Range", 0);
        String sGroupIds = context.getValue("GroupIds");
        User loginUser = ContextHelper.getLoginUser();
        if (nObjectId <= 0) {
            role = Role.createNewInstance();
        } else {
            role = Role.findById(nObjectId);
            nRoleType = role.getRoleType();
            nRoleRange = role.getRoleRange();
        }
        this.validateRight(loginUser, nRoleType, nRoleRange);
        this.validateRight(loginUser, sGroupIds);
        String[] _pLogicFields = new String[]{"ObjectId"};
        role = (Role)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, context, role, _pLogicFields);
        if (role.isChangeProperty("RoleType")) {
            throw new WCMException("\u4e0d\u80fd\u4fee\u6539\u89d2\u8272\u7684\u7c7b\u578b");
        }
        role.save(loginUser);
        if (nRoleType == 0 && nRoleRange == 0) {
            this.getGroupRoleMgr().setGroups(role, Groups.findByIds(loginUser, sGroupIds));
        }
        return role.getId();
    }

    private void validateRight(User loginUser, int nRoleType, int nRoleRange) throws WCMException {
        if (loginUser.isSecurityAdmin()) {
            return;
        }
        if (nRoleType == -1 || nRoleRange == -1 || nRoleRange == 1) {
            throw new WCMException("\u4ec5\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u53ef\u4ee5\u521b\u5efa\u7cfb\u7edf\u7ea7\u89d2\u8272\u6216\u5bf9\u6240\u6709\u7ec4\u7ec7\u53ef\u80fd\u7684\u89d2\u8272");
        }
        RoleMgr roleMgr = this.getRoleMgr();
        if (!roleMgr.isRoleManagers(loginUser)) {
            throw new WCMException("\u4ec5\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u89d2\u8272\u7ba1\u7406\u5458\u53ef\u4ee5\u521b\u5efa\u7279\u5b9a\u89d2\u8272");
        }
    }

    private void validateRight(User loginUser, String sGroupdIds) throws WCMException {
        if (CMyString.isEmpty(sGroupdIds)) {
            return;
        }
        if (loginUser.isSecurityAdmin()) {
            return;
        }
        GroupMgr groupMgr = this.getGroupMgr();
        Groups groups = Groups.findByIds(ContextHelper.getLoginUser(), sGroupdIds);
        int length = groups.size();
        for (int i = 0; i < length; ++i) {
            Group group = (Group)groups.getAt(i);
            if (group == null || groupMgr.isAdministrator(group, loginUser, true)) continue;
            throw new WCMException("\u4e0d\u80fd\u5728\u975e\u7ec4\u7ba1\u7406\u5458\u7684\u7ec4\u7ec7\u4e0a\u521b\u5efa\u89d2\u8272");
        }
    }

    public Roles getRolesForCurrUser(MethodContext context) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        String sRoleType = context.getValue("RoleType");
        String sViewable = context.getValue("Viewable");
        boolean bIncludeEveryone = context.getValue("IncludeEveryone", false);
        String sWhere = "";
        if (!CMyString.isEmpty(sRoleType)) {
            sWhere = sWhere + "RoleType=?";
        }
        if (!CMyString.isEmpty(sViewable)) {
            if (sWhere != "") {
                sWhere = sWhere + " and ";
            }
            sWhere = sWhere + "Viewable=?";
        }
        WCMFilter filter = new WCMFilter("", sWhere, "");
        if (!CMyString.isEmpty(sRoleType)) {
            filter.addSearchValues(Integer.parseInt(sRoleType));
        }
        if (!CMyString.isEmpty(sViewable)) {
            filter.addSearchValues(Integer.parseInt(sViewable));
        }
        WCMFilter extraFilter = context.getExtraWCMFilter();
        extraFilter.mergeWith(filter);
        return this.getRoleMgr().getRolesForUser(loginUser, extraFilter, bIncludeEveryone);
    }

    public Map getSiteRoleUsersInfo(MethodContext _context) throws WCMException {
        int nUserId = _context.getValue("UserId", 0);
        User currUser = User.findById(nUserId);
        if (currUser == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7528\u6237[UserId" + nUserId + "]\u4e0d\u5b58\u5728");
        }
        RoleUsers roleUsers = this.getRoleMgr().getRoleUsers(currUser, null);
        HashMap<Integer, ArrayList<RoleUser>> sitesMap = new HashMap<Integer, ArrayList<RoleUser>>();
        int length = roleUsers.size();
        for (int i = 0; i < length; ++i) {
            RoleUser roleUser = (RoleUser)roleUsers.getAt(i);
            if (roleUser == null) continue;
            Integer oSiteId = new Integer(roleUser.getSiteId());
            if (this.isDirtyData(roleUser)) continue;
            ArrayList<RoleUser> roleUserList = (ArrayList<RoleUser>)sitesMap.get(oSiteId);
            if (roleUserList == null) {
                roleUserList = new ArrayList<RoleUser>();
                sitesMap.put(oSiteId, roleUserList);
            }
            roleUserList.add(roleUser);
        }
        return sitesMap;
    }

    private boolean isDirtyData(RoleUser _roleUser) throws WCMException {
        if (_roleUser == null) {
            return true;
        }
        Role role = Role.findById(_roleUser.getRoleId());
        if (role == null) {
            return true;
        }
        int nSiteId = _roleUser.getSiteId();
        return role.isSystemRole() && nSiteId == -1 || !role.isSystemRole() && nSiteId == 0;
    }

    public void saveRoleUsers(MethodContext context) throws Throwable {
        int nRoleId = context.getValue("RoleId", 0);
        Role role = Role.findById(nRoleId);
        if (role == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89d2\u8272[RoleId" + nRoleId + "]\u6ca1\u6709\u627e\u5230");
        }
        if (role.getRoleType() == -1) {
            this.saveUsersOfSystemRoleOnSite(context);
        } else {
            this.saveUsersOfSpecialRole(context);
        }
    }

    public void saveUsersOfSystemRoleOnSite(MethodContext context) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        int nSiteId = context.getValue("SiteId", 0);
        int nRoleId = context.getValue("RoleId", 0);
        Role role = Role.findById(nRoleId);
        if (role == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89d2\u8272[RoleId" + nRoleId + "]\u6ca1\u6709\u627e\u5230");
        }
        if (role.getRoleType() != -1) {
            throw new WCMException("\u975e\u7cfb\u7edf\u7ea7\u89d2\u8272[RoleId" + nRoleId + "]\u4e0d\u80fd\u4f7f\u7528\u8be5\u63a5\u53e3");
        }
        RoleMgr roleMgr = this.getRoleMgr();
        if (!loginUser.isSecurityAdmin() && !roleMgr.isRoleManagers(loginUser)) {
            throw new WCMException("\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u89d2\u8272\u7ba1\u7406\u5458\u80fd\u7ed9\u7cfb\u7edf\u7ea7\u89d2\u8272\u6dfb\u52a0\u7528\u6237");
        }
        String sUserIds = context.getValue("UserIds");
        Users users = Users.findByIds(ContextHelper.getLoginUser(), sUserIds);
        roleMgr.setRoleUsers(role, nSiteId, users);
    }

    public void saveUsersOfSpecialRole(MethodContext context) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        int nRoleId = context.getValue("RoleId", 0);
        Role role = Role.findById(nRoleId);
        if (role == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89d2\u8272[RoleId" + nRoleId + "]\u6ca1\u6709\u627e\u5230");
        }
        if (role.getRoleType() != 0) {
            throw new WCMException("\u975e\u7279\u5b9a\u89d2\u8272[RoleId" + nRoleId + "]\u4e0d\u80fd\u4f7f\u7528\u8be5\u63a5\u53e3");
        }
        String sUserIds = context.getValue("UserIds");
        Users users = Users.findByIds(ContextHelper.getLoginUser(), sUserIds);
        RoleMgr roleMgr = this.getRoleMgr();
        if (!loginUser.isSecurityAdmin() && !roleMgr.isRoleManagers(loginUser)) {
            throw new WCMException("\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u89d2\u8272\u7ba1\u7406\u5458\u80fd\u7ed9\u7279\u5b9a\u89d2\u8272\u6dfb\u52a0\u7528\u6237");
        }
        roleMgr.setRoleUsers(role, -1, users);
    }

    public void removeUsersFromCurrRole(MethodContext context) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        int nRoleId = context.getValue("RoleId", 0);
        Role role = Role.findById(nRoleId);
        int nSiteId = context.getValue("SiteId", 0);
        if (role == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u89d2\u8272[RoleId" + nRoleId + "]\u6ca1\u6709\u627e\u5230");
        }
        String sUserIds = context.getValue("UserIds");
        Users users = Users.findByIds(ContextHelper.getLoginUser(), sUserIds);
        if (users == null) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230\u8981\u5220\u9664\u7684\u7528\u6237");
        }
        RoleMgr roleMgr = this.getRoleMgr();
        if (!loginUser.isSecurityAdmin() && !roleMgr.isRoleManagers(loginUser)) {
            throw new WCMException("\u53ea\u6709\u7cfb\u7edf\u7ba1\u7406\u5458\u6216\u89d2\u8272\u7ba1\u7406\u5458\u80fd\u5220\u9664\u7528\u6237");
        }
        for (int i = 0; i < users.size(); ++i) {
            roleMgr.removeUser(role, nSiteId, (User)users.getAt(i));
        }
    }

    public Roles getSystemRolesOfUser(MethodContext context) throws Throwable {
        int nSiteId = context.getValue("SiteId", 0);
        int nUserId = context.getValue("UserId", 0);
        User currUser = User.findById(nUserId);
        if (currUser == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7528\u6237[UserId=" + nUserId + "]\u6ca1\u6709\u627e\u5230");
        }
        WCMFilter extraFilter = context.getExtraWCMFilter();
        RoleMgr roleMgr = this.getRoleMgr();
        return roleMgr.getSystemRolesOfUser(currUser, nSiteId, extraFilter);
    }

    public void saveSystemRolesOfUser(MethodContext context) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        int nSiteId = context.getValue("SiteId", 0);
        int nUserId = context.getValue("UserId", 0);
        String sRoleIds = context.getValue("RoleIds");
        User currUser = User.findById(nUserId);
        if (currUser == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7528\u6237[UserId=" + nUserId + "]\u6ca1\u6709\u627e\u5230\uff01");
        }
        RoleMgr roleMgr = this.getRoleMgr();
        if (!loginUser.isSecurityAdmin()) {
            if (!this.getUserMgr().isManagerOfUser(currUser)) {
                throw new WCMException("\u60a8\u4e0d\u662f\u5f53\u524d\u7528\u6237\u7684\u7ec4\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u4fee\u6539\u8be5\u7528\u6237\u89d2\u8272\u4fe1\u606f\u7684\u6743\u9650\uff01");
            }
            Roles roles = roleMgr.getRolesForUser(loginUser, null);
            int[] aRoleIds = CMyString.splitToInt(sRoleIds, ",");
            for (int i = 0; i < aRoleIds.length; ++i) {
                String sWhere = "userid=" + currUser.getId() + " and roleid=" + aRoleIds[i] + " and siteid=" + nSiteId;
                WCMFilter filter = new WCMFilter("", sWhere, "");
                RoleUsers roleUsers = RoleUsers.openWCMObjs(null, filter);
                if (roles.indexOf(aRoleIds[i]) >= 0 || roleUsers == null || roleUsers.size() != 0) continue;
                throw new WCMException("\u60a8\u6ca1\u6709\u5411\u89d2\u8272[RoleId=" + aRoleIds[i] + "]\u4e2d\u6dfb\u52a0\u7528\u6237\u7684\u6743\u9650\uff01");
            }
        }
        Roles currRoles = Roles.findByIds(null, sRoleIds);
        roleMgr.setSystemRolesOfUser(currUser, nSiteId, currRoles);
    }

    public Roles getSpecialRolesOfUser(MethodContext context) throws Throwable {
        int nUserId = context.getValue("UserId", 0);
        User currUser = User.findById(nUserId);
        if (currUser == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7528\u6237[UserId=" + nUserId + "]\u6ca1\u6709\u627e\u5230");
        }
        WCMFilter extraFilter = context.getExtraWCMFilter();
        RoleMgr roleMgr = this.getRoleMgr();
        return roleMgr.getSpecialRolesOfUser(currUser, extraFilter);
    }

    public void saveSpecialRolesOfUser(MethodContext context) throws Throwable {
        User loginUser = ContextHelper.getLoginUser();
        int nUserId = context.getValue("UserId", 0);
        User currUser = User.findById(nUserId);
        if (currUser == null) {
            throw new WCMException("\u6307\u5b9a\u7684\u7528\u6237[UserId=" + nUserId + "]\u6ca1\u6709\u627e\u5230");
        }
        String specialRoleIds = context.getValue("SpecialRoleIds");
        RoleMgr roleMgr = this.getRoleMgr();
        if (!loginUser.isSecurityAdmin()) {
            if (!this.getUserMgr().isManagerOfUser(currUser)) {
                throw new WCMException("\u60a8\u4e0d\u662f\u5f53\u524d\u7528\u6237\u7684\u7ec4\u7ba1\u7406\u5458\uff0c\u6ca1\u6709\u4fee\u6539\u8be5\u7528\u6237\u89d2\u8272\u4fe1\u606f\u7684\u6743\u9650\uff01");
            }
            Roles roles = roleMgr.getRolesForUser(loginUser, null);
            int[] aRoleIds = CMyString.splitToInt(specialRoleIds, ",");
            for (int i = 0; i < aRoleIds.length; ++i) {
                String sWhere = "userid=" + currUser.getId() + " and roleid=" + aRoleIds[i] + " and siteid=-1";
                WCMFilter filter = new WCMFilter("", sWhere, "");
                RoleUsers roleUsers = RoleUsers.openWCMObjs(null, filter);
                if (roles.indexOf(aRoleIds[i]) >= 0 || roleUsers == null || roleUsers.size() != 0) continue;
                throw new WCMException("\u60a8\u6ca1\u6709\u5411\u89d2\u8272[RoleId=" + aRoleIds[i] + "]\u4e2d\u6dfb\u52a0\u7528\u6237\u7684\u6743\u9650\uff01");
            }
        }
        Roles currRoles = Roles.findByIds(null, specialRoleIds);
        roleMgr.setSpecailRolesOfUser(currUser, currRoles);
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return null;
    }

    private RoleMgr getRoleMgr() {
        return (RoleMgr)DreamFactory.createObjectById("RoleMgr");
    }

    private GroupMgr getGroupMgr() {
        return (GroupMgr)DreamFactory.createObjectById("GroupMgr");
    }

    private GroupRoleMgr getGroupRoleMgr() {
        return (GroupRoleMgr)DreamFactory.createObjectById("GroupRoleMgr");
    }

    private UserMgr getUserMgr() {
        return (UserMgr)DreamFactory.createObjectById("UserMgr");
    }
}

