/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.WCMProcessServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.persistent.User;
import com.trs.components.infoview.helper.InfoViewNewQueryHelper;
import com.trs.components.infoview.helper.InfoViewTemplateHelper;
import com.trs.components.infoview.persistent.InfoView;
import com.trs.components.infoview.persistent.InfoViews;
import com.trs.components.infoview.persistent.InfoviewXmlConverter;
import com.trs.components.wcm.content.domain.DocumentMgr;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Documents;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.WCMException;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.support.config.ConfigServer;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.BASE64DecoderStream;
import com.trs.infra.util.CMyException;
import com.trs.infra.util.CMyFile;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.CMyZip;
import com.trs.infra.util.store.FileService;
import com.trs.infra.util.store.FileStore;
import com.trs.service.IInfoViewService;
import com.trs.service.ISecurityService;
import com.trs.service.ServiceHelper;
import com.trs.service.impl.InfoViewDocImportService;
import com.trs.service.impl.InfoViewService;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import com.trs.webframework.xmlserver.parser.StreamBuddy;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;

public class InfoviewService
implements IGlueServiceProvider {
    InfoViewDocImportService m_oService = new InfoViewDocImportService();
    IInfoViewService m_oInfoviewService = new InfoViewService();
    private FilesMan m_oFilesManMgr = FilesMan.getFilesMan();
    private String m_sWCMPath = null;
    private String m_sWCMTempaltesPath = null;
    private static String m_sDefaultSearchFields = "_DOCSTATUS,DOCTITLE,CRTIME,CRUSER,DOCNO,RANDOMSERIAL";

    public void checkSysInfos(MethodContext _context) throws Exception {
        this.m_oService.checkSysInfos(_context.getValue("channelid"), _context.getValue("infoviewid"));
    }

    public String retriveChannelInfo(MethodContext _context) throws Exception {
        return this.m_oService.retriveChannelInfo(_context.getValue("SiteId"), _context.getValue("ChannelName"), _context.getValue("InfoViewId"));
    }

    public String importInfoViewData(MethodContext _context) throws Exception {
        InputStream ins = _context.getServiceContext().getInputStream();
        if (ins == null) {
            ins = _context.getServiceContext().getRequest().getInputStream();
        }
        byte[] content = StreamBuddy.readFromInputStream(ins);
        String sSign = _context.getValue("SignData");
        if (CMyString.isEmpty(sSign)) {
            throw new WCMException(I18NMessage.get(InfoviewService.class, "InfoviewService.label1", "\u5bc6\u94a5\u4e0d\u5339\u914d\uff0c\u4e0d\u5141\u8bb8\u6ca1\u6709\u7b7e\u540d\u7684\u6570\u636e\u63d0\u4ea4\u81f3WCM\u7cfb\u7edf\uff01"));
        }
        byte[] btSignData = BASE64DecoderStream.decode(sSign);
        String sPostUser = _context.getValue("PostUser");
        String sSelect = _context.getValue("SelectFields");
        this.m_oService.setSelectFields(CMyString.showNull(sSelect, ""));
        String result = this.m_oService.importInfoViewData(content, btSignData, _context.getValue("channelid"), _context.getValue("infoviewid"), _context.getValue("documentid"), sPostUser, _context.getValue("Attribute"));
        return result;
    }

    public String importInfoViewDataForCustom(MethodContext _context) throws Exception {
        String sDocXml = CMyString.decodeForCDATA(_context.getValue("ObjectXml"));
        if (sDocXml.isEmpty() && !CMyString.isEmpty(_context.getValue("ZipData"))) {
            String fileName = _context.getValue("ZipData");
            FilesMan filesMan = FilesMan.getFilesMan();
            String _sZipFile = filesMan.mapFilePath(fileName, 0) + fileName;
            return this.m_oService.importDataForCustomZip(_sZipFile, _context.getValue("channelid"), _context.getValue("infoviewid"), _context.getValue("DOCUMENTID"), _context.getValue("PostUser"), _context.getValue("Attribute"));
        }
        Document xmlDoc = ServiceHelper.createInfoViewService().getDOM4JDocument(sDocXml);
        Map propertyMap = _context.getValues();
        return this.m_oService.importInfoViewDataForCustom(xmlDoc, _context.getValue("channelid"), _context.getValue("infoviewid"), _context.getValue("PostUser"), propertyMap);
    }

    public InfoViews queryFlowInfoviews(MethodContext _context) throws WCMException {
        int nInfoviewId = _context.getValue("InfoviewId", 0);
        WCMFilter filter = _context.getExtraWCMFilter();
        if (filter == null) {
            filter = new WCMFilter();
        }
        filter.setPageSize(-1);
        if (nInfoviewId > 0) {
            filter.setWhere("INFOVIEWID=" + nInfoviewId);
        }
        InfoViews result = new InfoViews(ContextHelper.getLoginUser());
        result.open(filter);
        return result;
    }

    public String queryChannelUsableInfoviews(MethodContext _context) throws WCMException {
        WCMFilter filter;
        int nChannelId = _context.getValue("ChannelId", 0);
        int nInfoViewId = 0;
        if (nChannelId > 0) {
            Channel chnl = Channel.findById(nChannelId);
            if (chnl == null) {
                throw new WCMException("[ID=" + nChannelId + I18NMessage.get(InfoviewService.class, "InfoviewService.label2", "]\u7684\u680f\u76ee\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01"));
            }
            List oList = this.m_oInfoviewService.getEmployedInfoViews(chnl);
            BaseObj infoview = null;
            if (oList != null && oList.size() > 0) {
                infoview = (InfoView)oList.get(0);
            }
            int n = nInfoViewId = infoview == null ? 0 : infoview.getId();
        }
        if ((filter = _context.getExtraWCMFilter()) == null) {
            filter = new WCMFilter();
        }
        filter.setPageSize(-1);
        InfoViews infoviews = this.m_oInfoviewService.getInfoViews(filter);
        if (infoviews == null || infoviews.size() <= 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        String sNode = null;
        boolean bUsedInfoview = nInfoViewId > 0;
        for (int i = 0; i < infoviews.size(); ++i) {
            InfoView infoview = (InfoView)infoviews.getAt(i);
            if (infoview == null) continue;
            sNode = WCMProcessServiceHelper.makeXMLNode("Id", String.valueOf(infoview.getId()));
            sNode = sNode + WCMProcessServiceHelper.makeXMLNode("Name", infoview.getName());
            if (bUsedInfoview && nInfoViewId == infoview.getId()) {
                sNode = sNode + WCMProcessServiceHelper.makeXMLNode("Used", "true");
            }
            sb.append(WCMProcessServiceHelper.makeXMLNode("Infoview", sNode, false));
        }
        String result = WCMProcessServiceHelper.makeXMLNode("Infoviews", sb.toString(), false);
        sb.setLength(0);
        return result;
    }

    public void setEmployedInfoView(MethodContext _context) throws WCMException {
        int nChannelId = _context.getValue("ChannelId", 0);
        int nInfoviewId = _context.getValue("InfoviewId", 0);
        Channel chnl = (Channel)_context.getCurrHost();
        if (chnl == null && (chnl = Channel.findById(nChannelId)) == null) {
            throw new WCMException("[ID=" + nChannelId + I18NMessage.get(InfoviewService.class, "InfoviewService.label2", "]\u7684\u680f\u76ee\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01"));
        }
        InfoView infoview = InfoView.findById(nInfoviewId);
        if (infoview == null) {
            throw new WCMException("[ID=" + nInfoviewId + I18NMessage.get(InfoviewService.class, "InfoviewService.label3", "]\u7684\u8868\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664\uff01"));
        }
        this.m_oInfoviewService.setEmployedInfoView(chnl, infoview);
    }

    public void setVerifyParamValue(MethodContext _context) throws WCMException {
        int infoviewId = _context.getValue("infoviewId", 0);
        int verifyParamValue = _context.getValue("verifyParamValue", 1);
        if (verifyParamValue != 1 && verifyParamValue != 0 || infoviewId <= 0) {
            throw new WCMException(200006, "\u60a8\u8f93\u5165\u7684\u53c2\u6570\u4e0d\u5408\u6cd5!\u8bf7\u91cd\u65b0\u8f93\u5165");
        }
        InfoView oInfoview = InfoView.findById(infoviewId);
        if (oInfoview == null) {
            throw new WCMException(200006, "\u627e\u4e0d\u5230id\u4e3a[" + infoviewId + "]\u7684\u8868\u5355\u5bf9\u8c61!");
        }
        boolean isNeedVerifycode = verifyParamValue == 1;
        oInfoview.setNeedVerifycode(isNeedVerifycode);
        oInfoview.save();
    }

    private User getLoginUser() {
        return ContextHelper.getLoginUser();
    }

    public String querySearchFields(MethodContext _context) throws WCMException {
        int nInfoviewId = _context.getValue("InfoviewId", 0);
        InfoView infoview = InfoView.findById(nInfoviewId);
        if (infoview == null) {
            throw new WCMException(200006, I18NMessage.get(InfoviewService.class, "InfoviewService.label4", "\u83b7\u53d6ID\u4e3a[") + nInfoviewId + I18NMessage.get(InfoviewService.class, "InfoviewService.label5", "]\u7684\u81ea\u5b9a\u4e49\u8868\u5355\u5931\u8d25\uff01"));
        }
        String sSearchFields = infoview.getSearchFields();
        if (sSearchFields == null || sSearchFields.length() <= 0) {
            sSearchFields = m_sDefaultSearchFields;
        }
        StringBuffer sbResult = new StringBuffer();
        sbResult.append("<result><![CDATA[").append(sSearchFields).append("]]></result>");
        return sbResult.toString();
    }

    public String queryData(MethodContext _context) throws Throwable {
        this.assertSignData(_context);
        this.prepareDocStatusMode(_context);
        return InfoViewNewQueryHelper.queryDataXML(_context);
    }

    public String queryData2(MethodContext _context) throws Throwable {
        this.assertSignData(_context);
        this.prepareDocStatusMode(_context);
        if (_context.getValue("Combin", false)) {
            return InfoViewNewQueryHelper.queryDataXML(_context);
        }
        return InfoViewNewQueryHelper.queryDataXML2(_context);
    }

    public String queryData3(MethodContext _context) throws Throwable {
        this.assertSignData(_context);
        this.prepareDocStatusMode(_context);
        return InfoViewNewQueryHelper.queryDataXML3(_context);
    }

    public String getDocContent(MethodContext _context) throws Throwable {
        this.assertSignData(_context);
        String sDocumentId = _context.getValue("DocumentId");
        int nDocId = 0;
        if (!CMyString.isEmpty(sDocumentId)) {
            nDocId = Integer.parseInt(sDocumentId);
        }
        if (nDocId == 0) {
            throw new WCMException("\u4f20\u5165\u7684\u6587\u6863ID\u5fc5\u987b\u5927\u4e8e0\uff01");
        }
        com.trs.components.wcm.content.persistent.Document doc = com.trs.components.wcm.content.persistent.Document.findById(nDocId);
        if (doc == null) {
            throw new WCMException("\u6ca1\u6709\u627e\u5230ID\u4e3a\u3010" + nDocId + "\u3011\u7684\u6587\u6863\uff01");
        }
        int nDocFlag = doc.getFlag();
        if (nDocFlag == 0) {
            throw new WCMException("ID\u4e3a\u3010" + nDocId + "\u3011\u7684\u6587\u6863\u4e0d\u662f\u8868\u5355\u6587\u6863\uff01");
        }
        String sContent = doc.getContent();
        return sContent;
    }

    public FileStore getDocFile(MethodContext _context) throws WCMException {
        String sFileName = _context.getValue("FileName");
        FilesMan currFilesMan = FilesMan.getFilesMan();
        String sFilePath = "";
        try {
            sFilePath = currFilesMan.mapFilePath(sFileName, 0);
        }
        catch (WCMException e) {
            throw new WCMException("\u83b7\u53d6\u6587\u4ef6" + sFileName + "\u5931\u8d25\uff01");
        }
        FileService oFile = new FileService(sFilePath + sFileName);
        if (oFile.exists()) {
            return oFile;
        }
        return null;
    }

    private void prepareDocStatusMode(MethodContext _context) {
        if (_context.getValue("DocStatusMode") != null) {
            int nDocStatusMode = _context.getValue("DocStatusMode", 0);
            int statusType = _context.getValue("statusType", -1);
            int tempStatus = 10;
            tempStatus = statusType == -1 ? 10 : statusType;
            switch (nDocStatusMode) {
                case 0: {
                    _context.setValue("DocStatusMode", "");
                    _context.setValue("DocStatus2", "");
                    break;
                }
                case 1: {
                    _context.setValue("DocStatusMode", tempStatus);
                    _context.setValue("DocStatus2", "");
                    break;
                }
                case 2: {
                    _context.setValue("DocStatus2", tempStatus);
                    _context.setValue("DocStatusMode", "");
                }
            }
        }
    }

    public String generaterContent(MethodContext _context) throws WCMException {
        User loginUser = this.getLoginUser();
        String sContent = InfoViewTemplateHelper.generateContent(_context, loginUser);
        StringBuffer sbResult = new StringBuffer();
        sbResult.append("<result><![CDATA[").append(sContent).append("]]></result>");
        return sbResult.toString();
    }

    public void deleteData(MethodContext _context) throws Throwable {
        this.assertSignData(_context);
        String sDocumentIds = _context.getValue("DocumentIds");
        boolean bDrop = _context.getValue("Drop", true);
        ContextHelper.initContext(User.getSystem());
        User loginUser = this.getLoginUser();
        Documents documents = Documents.findByIds(loginUser, sDocumentIds);
        DocumentMgr oDocumentMgr = (DocumentMgr)DreamFactory.createObjectById("DocumentMgr");
        int nSize = documents.size();
        for (int i = 0; i < nSize; ++i) {
            com.trs.components.wcm.content.persistent.Document document = (com.trs.components.wcm.content.persistent.Document)documents.getAt(i);
            if (document == null) continue;
            Channel channel = document.getChannel();
            oDocumentMgr.delete(document, channel, bDrop);
        }
    }

    @Override
    public void delete(MethodContext context) throws Throwable {
    }

    @Override
    public Object query(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public int save(MethodContext context) throws Throwable {
        return 0;
    }

    @Override
    public Object findById(MethodContext context) throws Throwable {
        return null;
    }

    @Override
    public Object findByIds(MethodContext context) throws Throwable {
        return null;
    }

    public void assertSignData(MethodContext _context) throws Throwable {
        String sRawData = _context.getValue("RawData");
        String sSignData = _context.getValue("SignData");
        if (CMyString.isEmpty(sRawData) || CMyString.isEmpty(sSignData)) {
            throw new WCMException(I18NMessage.get(InfoviewService.class, "InfoviewService.label1", "\u4e0d\u5141\u8bb8\u6ca1\u6709\u7b7e\u540d\u7684\u6570\u636e\u63d0\u4ea4\u81f3WCM\u7cfb\u7edf\uff01"));
        }
        boolean zVerify = false;
        try {
            ISecurityService service = (ISecurityService)DreamFactory.createObjectById("ISecurityService");
            byte[] btSignData = BASE64DecoderStream.decode(sSignData);
            zVerify = service.verify("InfogateKey", sRawData.getBytes("utf-8"), btSignData);
        }
        catch (Exception e) {
            throw new WCMException(1100, I18NMessage.get(InfoviewService.class, "InfoviewService.label6", "\u9a8c\u8bc1\u6570\u636e\u6709\u6548\u6027\u5931\u8d25!"), e);
        }
        if (!zVerify) {
            throw new WCMException(1100, I18NMessage.get(InfoviewService.class, "InfoviewService.label7", "\u65e0\u6548\u6570\u636e,\u7b7e\u540d\u6709\u8bef!"));
        }
    }

    public FileStore makeTemplatesToZip(MethodContext _context) throws IOException, CMyException {
        this.initInfoViewTemFileUrls();
        String sInfoviewIds = "";
        sInfoviewIds = _context.getValue("InfoViewIds");
        this.putInfoViewTemplateInfoOnePath(sInfoviewIds);
        CMyZip oMyZip = new CMyZip();
        oMyZip.setEncoding("utf-8");
        oMyZip.setZipFileName(this.m_sWCMTempaltesPath + "templates.zip");
        oMyZip.addToZip(this.m_sWCMPath, false);
        oMyZip.done();
        FileService file = new FileService(this.m_sWCMTempaltesPath + "templates.zip");
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public void putInfoViewTemplateInfoOnePath(String _infoviewids) throws IOException, CMyException {
        if (CMyString.isEmpty(_infoviewids)) {
            return;
        }
        ArrayList<String> aIdList = new ArrayList<String>();
        String[] ids = null;
        ids = _infoviewids.split(",");
        for (int k = 0; k < ids.length; ++k) {
            aIdList.add(ids[k]);
        }
        InfoViews oInfoViews = this.getInfoViews();
        for (int i = 0; i < oInfoViews.size(); ++i) {
            String infoTemPath;
            InfoView oInfoView = (InfoView)oInfoViews.getAt(i);
            if (_infoviewids != null && !_infoviewids.equals("") && !aIdList.contains(String.valueOf(oInfoView.getId())) || !CMyFile.fileExists(infoTemPath = this.getInfoViewTemPath(oInfoView))) continue;
            CMyFile.copyFile(infoTemPath, this.m_sWCMPath + "template" + oInfoView.getId() + ".xml");
            this.makeInfogateConfig2XML(oInfoView);
        }
    }

    private void makeInfogateConfig2XML(InfoView oInfoView) throws WCMException {
        InfoviewXmlConverter infoviewConveter = new InfoviewXmlConverter();
        String srcXMLFile = this.m_sWCMPath + "infoviewconf_" + oInfoView.getId() + ".xml";
        infoviewConveter.toXMLFile(oInfoView, srcXMLFile);
    }

    public InfoViews getInfoViews() throws WCMException {
        WCMFilter filter = new WCMFilter();
        filter.setPageSize(-1);
        InfoViews result = new InfoViews(this.getLoginUser());
        result.open(filter);
        return result;
    }

    public void initInfoViewTemFileUrls() throws WCMException {
        FileService oFile;
        String sWcmUrl = ConfigServer.getServer().getInitProperty("WCM_PATH");
        this.m_sWCMPath = sWcmUrl + File.separator + "infoviewtemplates" + File.separator + "infoviewtemps" + File.separator;
        this.m_sWCMTempaltesPath = sWcmUrl + File.separator + "infoviewtemplates" + File.separator + "infoviewtempszip" + File.separator;
        boolean bIsExists = CMyFile.fileExists(this.m_sWCMPath);
        if (!bIsExists) {
            oFile = new FileService(this.m_sWCMPath);
            oFile.mkdirs();
        }
        if (!(bIsExists = CMyFile.fileExists(this.m_sWCMTempaltesPath))) {
            oFile = new FileService(this.m_sWCMTempaltesPath);
            oFile.mkdirs();
        }
    }

    public String getInfoViewTemPath(InfoView _oInfoView) {
        String filePath = "";
        try {
            filePath = this.getAbsolutePath(_oInfoView, _oInfoView.getTemplateFile());
        }
        catch (WCMException ex) {
            ex.printStackTrace();
        }
        return filePath;
    }

    public String getAbsolutePath(InfoView _oInfoView, String sFileName) throws WCMException {
        String sInfoViewPath = _oInfoView.getInfoViewPath();
        String sBasePath = this.m_oFilesManMgr.mapFilePath(sInfoViewPath, 0);
        return sBasePath + File.separatorChar + sInfoViewPath + File.separatorChar + sFileName;
    }
}

