/*
 * Decompiled with CFR 0.152.
 */
package com.trs.ajaxservice;

import com.trs.DreamFactory;
import com.trs.ajaxservice.ChannelHelper;
import com.trs.ajaxservice.JSONHelper;
import com.trs.ajaxservice.PageOperatorsForServiceHelper;
import com.trs.ajaxservice.WCMAJAXServiceHelper;
import com.trs.cms.ContextHelper;
import com.trs.cms.auth.domain.AuthServer;
import com.trs.cms.auth.persistent.User;
import com.trs.cms.content.CMSObj;
import com.trs.components.common.publish.domain.template.TemplateEmployMgr;
import com.trs.components.common.publish.domain.template.TemplateMgr;
import com.trs.components.common.publish.persistent.element.IPublishElement;
import com.trs.components.common.publish.persistent.element.IPublishFolder;
import com.trs.components.common.publish.persistent.element.PublishElementFactory;
import com.trs.components.common.publish.persistent.template.Template;
import com.trs.components.common.publish.persistent.template.Templates;
import com.trs.components.special.ISpecialMgr;
import com.trs.components.special.Special;
import com.trs.components.wcm.channel.IVChannelParser;
import com.trs.components.wcm.channel.VChannel;
import com.trs.components.wcm.channel.VChannelManager;
import com.trs.components.wcm.content.domain.ChannelExporter;
import com.trs.components.wcm.content.domain.ChannelImporter;
import com.trs.components.wcm.content.domain.ChannelMgr;
import com.trs.components.wcm.content.persistent.BaseChannel;
import com.trs.components.wcm.content.persistent.Channel;
import com.trs.components.wcm.content.persistent.Channels;
import com.trs.components.wcm.content.persistent.WebSite;
import com.trs.components.wcm.content.persistent.WebSites;
import com.trs.components.wcm.publish.WCMFolderPublishConfig;
import com.trs.infra.I18NMessage;
import com.trs.infra.common.ContextParameters;
import com.trs.infra.common.WCMException;
import com.trs.infra.common.WCMTypes;
import com.trs.infra.persistent.BaseObj;
import com.trs.infra.persistent.WCMFilter;
import com.trs.infra.persistent.db.DBManager;
import com.trs.infra.support.file.FilesMan;
import com.trs.infra.util.CMyString;
import com.trs.infra.util.Report;
import com.trs.infra.util.Reports;
import com.trs.wcm.config.PageOperators;
import com.trs.webframework.context.MethodContext;
import com.trs.webframework.provider.IGlueServiceProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ChannelServiceProvider
implements IGlueServiceProvider {
    private ChannelMgr m_oChannelMgr = (ChannelMgr)DreamFactory.createObjectById("ChannelMgr");

    @Override
    public void delete(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        Channels channels = Channels.findByIds(loginUser, _methContext.getObjectIds());
        boolean bDrop = _methContext.getValue("Drop", false);
        int nRightIndex = 12;
        if (!AuthServer.hasRightInObjects(loginUser, channels, nRightIndex)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label1", "\u60a8\u6ca1\u6709\u6743\u9650\u5220\u9664\u8fd9\u4e9b\u680f\u76ee[ID=") + channels.getIdListAsString() + "].");
        }
        int nSize = channels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null) continue;
            this.m_oChannelMgr.delete(channel, bDrop);
        }
    }

    @Override
    public Object query(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nSiblingChannelId = _methContext.getValue("SiblingChannelId", 0);
        BaseChannel parent = null;
        if (nSiblingChannelId > 0) {
            Channel channel = this.findChannelById(nSiblingChannelId);
            parent = channel.getHost();
            if (parent == null) {
                throw new WCMException(101100, I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label2", "\u6307\u5b9a\u680f\u76ee[Id=") + nSiblingChannelId + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label3", "]\u7684\u7236\u680f\u76ee\u6216\u8005\u7ad9\u70b9\u4e0d\u5b58\u5728\uff01"));
            }
        } else {
            if (_methContext.getValue("ChannelId", 0) == 0 && _methContext.getValue("SiteId", 0) == 0) {
                return this.filterChannels(_methContext);
            }
            parent = this.findBaseChannel(_methContext, "");
        }
        return this.getChildren(_methContext, loginUser, parent);
    }

    private Channels getChildren(MethodContext _methContext, User _loginUser, BaseChannel _parent) throws WCMException {
        WCMFilter extraFilter = _methContext.getExtraWCMFilter();
        Channels channels = ChannelHelper.getChildren(_loginUser, _parent, extraFilter);
        Channel[] pTopOrPicChannel = new Channel[2];
        for (int i = channels.size() - 1; i >= 0; --i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null || channel.getType() != 2 && channel.getType() != 1) continue;
            channels.removeAt(i, false);
            pTopOrPicChannel[channel.getType() == 2 ? 0 : 1] = channel;
        }
        if (!_methContext.getValue("ExcludeTopOrPic", false)) {
            int nIndex = 0;
            for (int i = 0; i < pTopOrPicChannel.length; ++i) {
                if (pTopOrPicChannel[i] == null) continue;
                channels.addElement(pTopOrPicChannel[i], nIndex++);
            }
        }
        return channels;
    }

    @Override
    public int save(MethodContext _methodContext) throws Throwable {
        BaseChannel rightHost;
        User loginUser = this.getLoginUser();
        Channel channel = null;
        BaseChannel parent = null;
        int nObjectId = _methodContext.getObjectId();
        if (nObjectId == 0) {
            channel = new Channel();
            parent = this.getParentChannelOrSite(_methodContext);
        } else {
            channel = Channel.findById(nObjectId);
            if (channel == null) {
                throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label4", "\u6307\u5b9a\u7684\u680f\u76ee\u4e0d\u5b58\u5728![ObjectId=") + _methodContext.getObjectId() + "]");
            }
        }
        int nRightIndex = nObjectId == 0 ? 11 : 13;
        BaseChannel baseChannel = rightHost = nObjectId == 0 ? parent : channel;
        if (!AuthServer.hasRight(loginUser, (CMSObj)rightHost, nRightIndex)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label5", "\u60a8\u6ca1\u6709\u6743\u9650\u65b0\u5efa\u6216\u8005\u4fee\u6539\u680f\u76ee![ObjectId=") + _methodContext.getObjectId() + "][Host=" + rightHost + "]");
        }
        String[] pLogicFields = new String[]{"ObjectId"};
        if ((channel = (Channel)WCMAJAXServiceHelper.setWCMObjectProperties(loginUser, _methodContext, channel, pLogicFields)).isAddMode()) {
            channel.setSite(parent.getSiteId());
        }
        if (_methodContext.containsParameter("OnlySearch")) {
            channel.setOnlySearch(_methodContext.getValue("OnlySearch", false));
        }
        if (_methodContext.containsParameter("OnlyManager")) {
            channel.setOnlyManager(_methodContext.getValue("OnlyManager", false));
        }
        if (_methodContext.containsParameter("CanPub")) {
            channel.setCanPub(_methodContext.getValue("CanPub", true));
        }
        if (_methodContext.containsParameter("DoDeptFilter")) {
            channel.setDoDeptFilter(_methodContext.getValue("DoDeptFilter", true));
        }
        this.m_oChannelMgr.save(channel);
        return channel.getId();
    }

    private BaseChannel getParentChannelOrSite(MethodContext _methodContext) throws WCMException {
        BaseChannel parent;
        int nParentId = _methodContext.getValue("ParentId", 0);
        if (nParentId == 0) {
            int nSiteId = _methodContext.getValue("SiteId", 0);
            if (nSiteId <= 0) {
                throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label6", "\u6ca1\u6709\u6307\u5b9aParentId\u6216\u8005SiteId    "));
            }
            parent = WebSite.findById(nSiteId);
            if (parent == null) {
                throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nSiteId), WCMTypes.getLowerObjName(103)}));
            }
        } else {
            parent = Channel.findById(nParentId);
            if (parent == null) {
                throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nParentId), WCMTypes.getLowerObjName(101)}));
            }
        }
        return parent;
    }

    @Override
    public Object findById(MethodContext _context) throws Throwable {
        int nRightIndex;
        User loginUser = this.getLoginUser();
        if (_context.getObjectId() == 0) {
            Channel newChannel = new Channel();
            int nParentId = _context.getValue("ParentId", 0);
            int nSiteId = _context.getValue("SiteId", 0);
            if (nParentId > 0) {
                newChannel.setParent(nParentId);
                Channel parent = this.findChannelById(nParentId);
                newChannel.setSite(parent.getSiteId());
            } else if (nSiteId > 0) {
                newChannel.setSite(_context.getValue("SiteId", 0));
            }
            newChannel.setType(_context.getValue("ChnlType", 0));
            newChannel.setCrUser(loginUser);
            return newChannel;
        }
        Channel channel = this.findChannelById(_context.getObjectId());
        if (!AuthServer.hasRight(loginUser, (CMSObj)channel, nRightIndex = 64)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label9", "\u60a8[") + loginUser.getName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label10", "]\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u680f\u76ee[Id=") + channel.getId() + "]\uff01");
        }
        return channel;
    }

    public Object filterChannels(MethodContext _context) throws Throwable {
        User loginUser = this.getLoginUser();
        WCMFilter extraFilter = _context.getExtraWCMFilter();
        Channels oChannels = Channels.openWCMObjs(loginUser, extraFilter);
        return oChannels;
    }

    @Override
    public Object findByIds(MethodContext _context) throws Throwable {
        User loginUser = this.getLoginUser();
        Channels channels = Channels.findByIds(loginUser, _context.getObjectIds());
        ChannelHelper.removeNoRightChannel(loginUser, channels, 64);
        return channels;
    }

    public PageOperators getOperators(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nObjectId = _methContext.getObjectId();
        if (nObjectId > 0) {
            Channel channel = this.findChannelById(nObjectId);
            return PageOperatorsForServiceHelper.makeCMSObjOpertators(loginUser, "channel", channel);
        }
        String sObjectIds = _methContext.getObjectIds();
        if (sObjectIds != null && sObjectIds.length() > 0) {
            Channels channels = Channels.findByIds(loginUser, sObjectIds);
            if (channels.isEmpty()) {
                throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label11", "\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u680f\u76ee[ObjectIds=") + sObjectIds + "]\uff01");
            }
            if (channels.size() == 1) {
                return PageOperatorsForServiceHelper.makeCMSObjOpertators(loginUser, "channel", (CMSObj)channels.getAt(0));
            }
            return PageOperatorsForServiceHelper.makeCMSBaseObjsOpertators(loginUser, "channels", channels);
        }
        throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label12", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u83b7\u53d6\u65b9\u5f0f\uff01"));
    }

    public PageOperators getDocumentOperators(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nObjectId = _methContext.getObjectId();
        if (nObjectId > 0) {
            Channel channel = this.findChannelById(nObjectId);
            return PageOperatorsForServiceHelper.makeCMSObjOpertators(loginUser, "documentInChannel", channel);
        }
        throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label12", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u83b7\u53d6\u65b9\u5f0f\uff01"));
    }

    public PageOperators getOperatorsInChannel(MethodContext _methContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nObjectId = _methContext.getObjectId();
        if (nObjectId > 0) {
            Channel channel = this.findChannelById(nObjectId);
            return PageOperatorsForServiceHelper.makeCMSObjOpertators(loginUser, "ChannelHost", channel);
        }
        throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label12", "\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u83b7\u53d6\u65b9\u5f0f\uff01"));
    }

    public String export(MethodContext _MethodContext2) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseChannel parent = null;
        if (_MethodContext2.getValue("ParentChannelId", 0) > 0 || _MethodContext2.getValue("ParentSiteId", 0) > 0) {
            parent = this.findBaseChannel(_MethodContext2, "Parent");
        }
        boolean bContainsChildren = _MethodContext2.getValue("ContainsChildren", true);
        boolean bContainsRelated = _MethodContext2.getValue("ContainsRelated", false);
        Channels channels = null;
        if (parent != null) {
            channels = this.getChildren(_MethodContext2, loginUser, parent);
        } else {
            channels = Channels.findByIds(loginUser, _MethodContext2.getObjectIds());
            ChannelHelper.removeNoRightChannel(loginUser, channels, 13);
        }
        if (channels.isEmpty()) {
            return "no-available-channels";
        }
        ChannelExporter exporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
        _MethodContext2.setContentTypeIsHTML();
        return exporter.export(channels, bContainsChildren, bContainsRelated, false, true);
    }

    public String importChannels(MethodContext _MethodContext2) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseChannel dstSiteOrChannel = this.findDstBaseChannel(_MethodContext2);
        String sImportFile = _MethodContext2.getValue("ImportFile");
        WCMAJAXServiceHelper.validateFile(sImportFile);
        String sImportXSLFile = _MethodContext2.getValue("ImportXSLFile");
        WCMAJAXServiceHelper.validateFile(sImportXSLFile);
        if (!AuthServer.hasRight(loginUser, (CMSObj)dstSiteOrChannel, 11)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + loginUser.getName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label14", "]\u6ca1\u6709\u6743\u9650\u5728[") + dstSiteOrChannel + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label15", "]\u5bfc\u5165\u680f\u76ee\uff01"));
        }
        ChannelImporter importer = (ChannelImporter)DreamFactory.createObjectById("ChannelImporter");
        return importer.importFromFile(sImportFile, sImportXSLFile, dstSiteOrChannel).toJSONXML();
    }

    private BaseChannel findDstBaseChannel(MethodContext _MethodContext2) throws WCMException {
        return this.findBaseChannel(_MethodContext2, "Dst");
    }

    private BaseChannel findBaseChannel(MethodContext _MethodContext2, String _sParamPre) throws WCMException {
        int nChannelId = _MethodContext2.getValue(_sParamPre + "ChannelId", 0);
        int nSiteId = _MethodContext2.getValue(_sParamPre + "SiteId", 0);
        BaseChannel dstSiteOrChannel = null;
        if (nChannelId > 0) {
            dstSiteOrChannel = this.findChannelById(nChannelId);
        } else if (nSiteId > 0) {
            dstSiteOrChannel = this.findSiteById(nSiteId);
        } else {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label16", "\u6ca1\u6709\u6307\u5b9a") + _sParamPre + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label17", "ChannelId\u6216\u8005") + _sParamPre + "SiteId\uff01");
        }
        return dstSiteOrChannel;
    }

    private List findDstBaseChannels(MethodContext _MethodContext2) throws WCMException {
        String nChannelIds = _MethodContext2.getValue("DstChannelId");
        String nSiteIds = _MethodContext2.getValue("DstSiteId");
        ArrayList<BaseObj> dstSitesOrChannels = new ArrayList<BaseObj>();
        if (nChannelIds != null && nChannelIds.length() > 0) {
            Channels _chs = Channels.findByIds(ContextHelper.getLoginUser(), nChannelIds);
            for (int i = 0; i < _chs.size(); ++i) {
                if (_chs.getAt(i) == null) continue;
                dstSitesOrChannels.add(_chs.getAt(i));
            }
        } else if (nSiteIds != null && nSiteIds.length() > 0) {
            WebSites _sites = WebSites.findByIds(ContextHelper.getLoginUser(), nSiteIds);
            for (int i = 0; i < _sites.size(); ++i) {
                if (_sites.getAt(i) == null) continue;
                dstSitesOrChannels.add(_sites.getAt(i));
            }
        } else {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label16", "\u6ca1\u6709\u6307\u5b9a") + "Dst" + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label17", "ChannelId\u6216\u8005") + "DstSiteId\uff01");
        }
        return dstSitesOrChannels;
    }

    public String createFrom(MethodContext _MethodContext2) throws Throwable {
        User loginUser = this.getLoginUser();
        List dstSitesOrChannels = this.findDstBaseChannels(_MethodContext2);
        int nSrcChannelId = _MethodContext2.getValue("SrcChannelId", 0);
        Channel srcChannel = this.findChannelById(nSrcChannelId);
        if (srcChannel.getStatus() < 0) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(nSrcChannelId), WCMTypes.getLowerObjName(101)}));
        }
        ChannelExporter exporter = (ChannelExporter)DreamFactory.createObjectById("ChannelExporter");
        ChannelImporter importer = (ChannelImporter)DreamFactory.createObjectById("ChannelImporter");
        String sXmlFile = exporter.export(srcChannel, true, true);
        Reports resultReports = new Reports("\u7c7b\u4f3c\u521b\u5efa\u680f\u76ee");
        int[] ids = new int[dstSitesOrChannels.size()];
        for (int i = 0; i < dstSitesOrChannels.size(); ++i) {
            String sTitle;
            BaseChannel dstSiteOrChannel = (BaseChannel)dstSitesOrChannels.get(i);
            ids[i] = dstSiteOrChannel.getId();
            if (!AuthServer.hasRight(loginUser, (CMSObj)dstSiteOrChannel, 11)) {
                sTitle = I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + loginUser.getName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label45", "]\u6ca1\u6709\u6743\u9650") + CMyString.format(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label47", "\u5728[{1}]\u4e0a\u8fdb\u884c \u7c7b\u4f3c\u521b\u5efa."), new Object[]{dstSiteOrChannel});
                resultReports.getFailedReporter().add(new Report(sTitle));
                continue;
            }
            if (!AuthServer.hasRight(loginUser, (CMSObj)srcChannel, 13)) {
                sTitle = I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + loginUser.getName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label45", "]\u6ca1\u6709\u6743\u9650") + CMyString.format(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label46", "\u4ece\u680f\u76ee[{0}]\u7c7b\u4f3c\u521b\u5efa\u5230[{1}]."), new Object[]{srcChannel.getDispDesc(), dstSiteOrChannel});
                resultReports.getFailedReporter().add(new Report(sTitle));
                continue;
            }
            try {
                String sTitle2;
                Reports reports = importer.importFromFile(sXmlFile, null, dstSiteOrChannel);
                List fails = reports.getFailedReporter();
                List succs = reports.getSucessedReporter();
                if (fails != null && fails.size() > 0) {
                    sTitle2 = CMyString.format(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label44", "\u4ece\u680f\u76ee[{0}]\u7c7b\u4f3c\u521b\u5efa\u5230[{1}]\u5931\u8d25\uff01"), new Object[]{srcChannel.getDispDesc(), dstSiteOrChannel});
                    resultReports.getFailedReporter().add(new Report(sTitle2));
                    continue;
                }
                if (succs == null || succs.size() <= 0) continue;
                sTitle2 = CMyString.format(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label43", "\u4ece\u680f\u76ee[{0}]\u7c7b\u4f3c\u521b\u5efa\u5230[{1}]\u6210\u529f\uff01"), new Object[]{srcChannel.getDispDesc(), dstSiteOrChannel});
                resultReports.getSucessedReporter().add(new Report(sTitle2));
                continue;
            }
            catch (WCMException e) {
                throw new WCMException(1100, I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label25", "\u7c7b\u4f3c\u521b\u5efa\u680f\u76ee\u5931\u8d25!"), e);
            }
        }
        resultReports.setResultIds(ids);
        _MethodContext2.setValue("reports", resultReports.getResultIds());
        return resultReports.toJSONXML();
    }

    public void moveAsChild(MethodContext _methodContext) throws Throwable {
        BaseChannel dstSiteOrChannel;
        User loginUser = this.getLoginUser();
        if (!AuthServer.hasRight(loginUser, (CMSObj)(dstSiteOrChannel = this.findDstBaseChannel(_methodContext)), 11)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + loginUser.getName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label14", "]\u6ca1\u6709\u6743\u9650\u5728[") + dstSiteOrChannel + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label26", "]\u4e0b\u65b0\u589e\u680f\u76ee\uff01"));
        }
        int nSrcChannelId = _methodContext.getValue("SrcChannelId", 0);
        if (nSrcChannelId > 0) {
            Channel srcChannel = this.findChannelById(nSrcChannelId);
            this.moveAsChild(loginUser, srcChannel, dstSiteOrChannel);
            return;
        }
        String sSrcChannelIds = _methodContext.getValue("SrcChannelIds");
        Channels channels = Channels.findByIds(loginUser, sSrcChannelIds);
        int nSize = channels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel srcChannel = (Channel)channels.getAt(i);
            if (srcChannel == null) continue;
            this.moveAsChild(loginUser, srcChannel, dstSiteOrChannel);
        }
    }

    private void moveAsChild(User _loginUser, Channel _srcChannel, BaseChannel _dstSiteOrChannel) throws WCMException {
        if (!AuthServer.hasRight(_loginUser, (CMSObj)_srcChannel, 12)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + _loginUser.getName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label27", "]\u6ca1\u6709\u6743\u9650\u79fb\u52a8\u680f\u76ee[") + _srcChannel.getDispDesc() + "]\uff01");
        }
        this.m_oChannelMgr.moveTo(_srcChannel, _dstSiteOrChannel, 1);
    }

    public void changeOrder(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        int nSrcChannelId = _methodContext.getValue("SrcChannelId", 0);
        Channel srcChannel = this.findChannelById(nSrcChannelId);
        int nDstChannelId = _methodContext.getValue("DstChannelId", 0);
        Channel dstChannel = null;
        if (nDstChannelId > 0) {
            dstChannel = this.findChannelById(nDstChannelId);
        }
        if (!AuthServer.hasRight(loginUser, (CMSObj)srcChannel, 13)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label13", "\u5bf9\u4e0d\u8d77\uff0c\u60a8[") + loginUser.getName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label28", "]\u6ca1\u6709\u6743\u9650\u6539\u53d8\u680f\u76ee[") + srcChannel.getDispDesc() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label29", "]\u7684\u987a\u5e8f\uff01"));
        }
        if (!srcChannel.canEdit(loginUser)) {
            throw new WCMException(srcChannel + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label30", "\u5df2\u7ecf\u88ab[") + srcChannel.getLockerUserName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label31", "]\u9501\u5b9a\uff0c\u60a8\u4e0d\u80fd\u505a\u4efb\u4f55\u79fb\u52a8\u64cd\u4f5c\uff01"));
        }
        int nNewOrder = this.isToFirst(dstChannel) ? -1 : dstChannel.getOrder();
        srcChannel.setOrder(nNewOrder);
        this.m_oChannelMgr.save(srcChannel);
    }

    public Channels getRecycleChannels(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseChannel oSiteOrChannel = this.findBaseChannel(_methodContext, "");
        WCMFilter filter = new WCMFilter(_methodContext.getQueryFilter());
        Channels channels = this.m_oChannelMgr.getRecycleChannels(oSiteOrChannel, filter);
        if (loginUser.isAdministrator()) {
            return channels;
        }
        for (int i = channels.size() - 1; i >= 0; --i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel != null && AuthServer.hasRight(loginUser, (CMSObj)channel, 12)) continue;
            channels.removeAt(i, false);
        }
        return channels;
    }

    public void restoreChannels(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseChannel oSiteOrChannel = this.findBaseChannel(_methodContext, "");
        boolean bRestoreAll = _methodContext.getValue("RestoreAll", false);
        Channels channels = null;
        channels = bRestoreAll ? this.m_oChannelMgr.getRecycleChannels(oSiteOrChannel, null) : Channels.findByIds(loginUser, _methodContext.getObjectIds());
        if (channels.size() == 0) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label36", "\u680f\u76ee\u56de\u6536\u7ad9\u4e2d\u6ca1\u6709\u4efb\u4f55\u53ef\u4ee5\u8fd8\u539f\u7684\u680f\u76ee\uff01"));
        }
        int nSize = channels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null || !AuthServer.hasRight(loginUser, (CMSObj)channel, 12)) continue;
            this.m_oChannelMgr.restore(channel);
        }
    }

    public void clearRecycle(MethodContext _methodContext) throws Throwable {
        User loginUser = this.getLoginUser();
        BaseChannel oSiteOrChannel = this.findBaseChannel(_methodContext, "");
        Channels channels = this.m_oChannelMgr.getRecycleChannels(oSiteOrChannel, null);
        if (channels.size() == 0) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label38", "\u680f\u76ee\u56de\u6536\u7ad9\u4e2d\u6ca1\u6709\u4efb\u4f55\u53ef\u4ee5\u5220\u9664\u7684\u680f\u76ee\uff01"));
        }
        int nSize = channels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel channel = (Channel)channels.getAt(i);
            if (channel == null || !AuthServer.hasRight(loginUser, (CMSObj)channel, 12)) continue;
            this.m_oChannelMgr.delete(channel, true);
        }
    }

    public boolean existsSimilarName(MethodContext _methodContext) throws Throwable {
        Channel channel;
        int nSiteId = _methodContext.getValue("SiteId", 0);
        int nObjectid = _methodContext.getObjectId();
        if (nSiteId == 0 && (channel = Channel.findById(nObjectid)) != null) {
            nSiteId = channel.getSiteId();
        }
        WCMFilter existFilter = new WCMFilter("WCMCHANNEL", "SiteId=? and ChnlName=? and ChannelId<>?", "", "ChannelId");
        existFilter.addSearchValues(0, nSiteId);
        existFilter.addSearchValues(1, _methodContext.getValue("ChannelName"));
        existFilter.addSearchValues(2, nObjectid);
        return DBManager.getDBManager().sqlExecuteIntQuery(existFilter) > 0;
    }

    public Object existsSimilarDataPath(MethodContext _methodContext) throws Throwable {
        WCMFilter existFilter = new WCMFilter("WCMCHANNEL", "SiteId=? and ParentId=? and ChannelId<>? and exists(select FolderId from WCMFolderPublishConfig where FolderType=101 and FolderId=WCMChannel.ChannelId and DataPath=?)", "", "ChannelId");
        int nSiteId = _methodContext.getValue("SiteId", 0);
        int nParentId = _methodContext.getValue("ParentId", 0);
        int nChnlId = _methodContext.getObjectId();
        if (nSiteId == 0 && nChnlId != 0) {
            Channel chnl = Channel.findById(nChnlId);
            if (chnl == null) {
                throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label39", "\u65e0\u6cd5\u83b7\u53d6\u5230[ID=") + nChnlId + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label40", "]\u7684\u680f\u76ee!"));
            }
            nSiteId = chnl.getSiteId();
            nParentId = chnl.getParentId();
        }
        existFilter.addSearchValues(nSiteId);
        existFilter.addSearchValues(nParentId);
        existFilter.addSearchValues(nChnlId);
        existFilter.addSearchValues(_methodContext.getValue("DataPath"));
        int nTheChnlId = DBManager.getDBManager().sqlExecuteIntQuery(existFilter);
        if (nTheChnlId > 0) {
            Channel theChnl = Channel.findById(nTheChnlId);
            if (theChnl == null) {
                return "";
            }
            return theChnl.getDesc() + "-" + theChnl.getId();
        }
        return "";
    }

    @Deprecated
    public String checkSQLValid(MethodContext _context) throws WCMException {
        String sQuery = _context.getValue("queryby");
        String sOrder = _context.getValue("orderby");
        HashMap<String, String> result = new HashMap<String, String>(2);
        result.put("sql", "Deprecated");
        _context.setReturnJSON(true);
        return JSONHelper.toSimpleJSON(result, 0);
    }

    private Channel findChannelById(int _nObjectId) throws WCMException {
        if (_nObjectId <= 0) {
            return null;
        }
        Channel channel = Channel.findById(_nObjectId);
        if (channel == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(_nObjectId), WCMTypes.getLowerObjName(101)}));
        }
        return channel;
    }

    private WebSite findSiteById(int _nObjectId) throws WCMException {
        WebSite site = WebSite.findById(_nObjectId);
        if (site == null) {
            throw new WCMException(200006, I18NMessage.makeObjectNotFound(new String[]{String.valueOf(_nObjectId), WCMTypes.getLowerObjName(103)}));
        }
        return site;
    }

    private User getLoginUser() {
        User loginUser = ContextHelper.getLoginUser();
        return loginUser;
    }

    private boolean isToFirst(Channel _dstChannel) {
        if (_dstChannel == null) {
            return true;
        }
        switch (_dstChannel.getType()) {
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void createFromFile(MethodContext _methodContext) throws WCMException {
        User loginUser = this.getLoginUser();
        String sImportFile = _methodContext.getValue("ImportFile");
        sImportFile = FilesMan.getFilesMan().mapFilePath(sImportFile, 0) + sImportFile;
        BaseChannel parent = this.findDstBaseChannel(_methodContext);
        if (!AuthServer.hasRight(loginUser, (CMSObj)parent, 11)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label5", "\u60a8\u6ca1\u6709\u6743\u9650\u65b0\u5efa\u6216\u8005\u4fee\u6539\u680f\u76ee![ObjectId=") + _methodContext.getObjectId() + "][Host=" + parent + "]");
        }
        IVChannelParser parser = (IVChannelParser)DreamFactory.createObjectById("IVChannelParser");
        VChannel vchannel = parser.parse(sImportFile);
        VChannelManager manager = (VChannelManager)DreamFactory.createObjectById("VChannelManager");
        StringBuffer url = _methodContext.getServiceContext().getRequest().getRequestURL();
        String uri = _methodContext.getServiceContext().getRequest().getRequestURI();
        url.replace(url.indexOf(uri), url.length(), "");
        ContextParameters.set1(url.toString());
        if (parent.isSite()) {
            manager.save((WebSite)parent, vchannel);
        } else {
            manager.save((Channel)parent, vchannel);
        }
        ContextParameters.get1();
    }

    public String createChannelTreeHTMLOfIds(MethodContext _methodContext) throws WCMException {
        User loginUser = this.getLoginUser();
        int nChannelId = _methodContext.getValue("ChannelId", 0);
        Channel channel = Channel.findById(nChannelId);
        if (channel == null) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label39", "\u65e0\u6cd5\u83b7\u53d6\u5230[ID=") + nChannelId + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label40", "]\u7684\u680f\u76ee!"));
        }
        StringBuffer sbResult = new StringBuffer(4096);
        Channels childChannels = ChannelHelper.getChildren(loginUser, channel, new WCMFilter());
        if (childChannels.size() <= 0) {
            return "";
        }
        int nSize = childChannels.size();
        for (int i = 0; i < nSize; ++i) {
            Channel _oChannel = (Channel)childChannels.getAt(i);
            if (_oChannel == null) continue;
            this.makeChannelHTML(sbResult, _oChannel);
        }
        return sbResult.toString();
    }

    private void makeChannelHTML(StringBuffer _sbResult, Channel _channel) throws WCMException {
        if (_channel == null) {
            return;
        }
        this.appendOneChannelHTML(_sbResult, _channel);
        String SQL_QUERY_CHILD = "Select ChannelId from WCMChannel Where ParentId=?";
        int nId = DBManager.getDBManager().sqlExecuteIntQuery("Select ChannelId from WCMChannel Where ParentId=?", new int[]{_channel.getId()});
        if (nId > 0) {
            _sbResult.append("<ul></ul>\n");
        }
    }

    private void appendOneChannelHTML(StringBuffer _sbResult, Channel _channel) throws WCMException {
        String SQL_QUERY_CHILD = "Select ChannelId from WCMChannel Where ParentId=?";
        int nId = DBManager.getDBManager().sqlExecuteIntQuery("Select ChannelId from WCMChannel Where ParentId=?", new int[]{_channel.getId()});
        boolean bHasChild = false;
        if (nId > 0) {
            bHasChild = true;
        }
        _sbResult.append("<div objectId=");
        _sbResult.append("'");
        _sbResult.append(_channel.getId());
        _sbResult.append("'");
        _sbResult.append(" id=");
        _sbResult.append("'");
        _sbResult.append("node_");
        _sbResult.append(_channel.getId());
        _sbResult.append("'");
        if (bHasChild) {
            _sbResult.append(" onlyNode='true'");
        }
        _sbResult.append(" title=");
        _sbResult.append("'");
        _sbResult.append("ID:");
        _sbResult.append(_channel.getId());
        _sbResult.append("'");
        _sbResult.append(" chnlOrder=");
        _sbResult.append("'");
        _sbResult.append(_channel.getOrder());
        _sbResult.append("'");
        _sbResult.append(">");
        _sbResult.append("<a href=#>");
        _sbResult.append(CMyString.transDisplay(_channel.getDesc()));
        _sbResult.append("</a></div>");
    }

    public int saveForSpecial(MethodContext _methContext) throws Throwable {
        Special special;
        int nChannelId;
        Channel channel;
        int nParentId = Integer.valueOf(_methContext.getValue("PARENTID"));
        BaseChannel destHost = null;
        if (nParentId != 0) {
            destHost = (BaseChannel)BaseChannel.findById(101, nParentId);
            if (destHost == null) {
                throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label4", "\u6307\u5b9a\u7684\u680f\u76ee\u4e0d\u5b58\u5728![ObjectId=") + nParentId + "]");
            }
        } else {
            WCMFilter filter = new WCMFilter();
            filter.setWhere("SiteName = ?");
            filter.addSearchValues(0, "\u4e13\u9898\u5e93");
            WebSites websites = WebSites.openWCMObjs(ContextHelper.getLoginUser(), filter);
            if (websites.size() > 0) {
                destHost = (WebSite)websites.getAt(0);
            }
        }
        if (destHost != null) {
            String _ChnlName = _methContext.getValue("CHNLNAME");
            _methContext.setValue("CHNLNAME", this.getNewChnlName(_ChnlName, destHost));
        }
        if ((channel = Channel.findById(nChannelId = this.save(_methContext))) == null) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label4", "\u6307\u5b9a\u7684\u680f\u76ee\u4e0d\u5b58\u5728![ObjectId=") + nChannelId + "]");
        }
        int nSpeicalId = _methContext.getValue("SPECIALID", 0);
        boolean bDataOper4Chnl = _methContext.getValue("bDataOper4Chnl", false);
        if (bDataOper4Chnl) {
            ISpecialMgr specialMgr = (ISpecialMgr)DreamFactory.createObjectById("ISpecialMgr");
            Special currSpecial = specialMgr.findSpecialByChnlId(this.getLoginUser(), nParentId);
            if (currSpecial == null) {
                return nChannelId;
            }
            nSpeicalId = currSpecial.getId();
        }
        if ((special = Special.findById(nSpeicalId)) == null) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label4", "\u6307\u5b9a\u7684\u4e13\u9898\u4e0d\u5b58\u5728![ObjectId=") + nSpeicalId + "]");
        }
        IPublishElement publishElement = PublishElementFactory.lookupElement(101, nChannelId);
        WCMFolderPublishConfig currPublishConfig = new WCMFolderPublishConfig((IPublishFolder)publishElement);
        currPublishConfig.setFolderType(101, nChannelId);
        currPublishConfig.setDataPath(nChannelId + "");
        currPublishConfig.canEdit(this.getLoginUser());
        this.setTemplate(channel, currPublishConfig);
        currPublishConfig.save(this.getLoginUser());
        return nChannelId;
    }

    private void setTemplate(Channel _oChannel, WCMFolderPublishConfig _currPublishConfig) throws WCMException {
        Channel oParentChannel = _oChannel.getParent();
        if (oParentChannel == null) {
            return;
        }
        boolean isSpecialChannel = oParentChannel.getParentId() == 0;
        int nParentChannelId = oParentChannel.getId();
        IPublishElement oParentChnlElement = PublishElementFactory.lookupElement(101, nParentChannelId);
        WCMFolderPublishConfig oParentChnlPublishConfig = new WCMFolderPublishConfig((IPublishFolder)oParentChnlElement);
        int nOutlineTemplateId = 0;
        if (isSpecialChannel) {
            TemplateMgr m_oTemplateMgr = (TemplateMgr)DreamFactory.createObjectById("TemplateMgr");
            String sWhere = "VISUAL=1 and TEMPNAME like '\u5206\u7c7b\u9996\u9875\u6a21\u677f%'";
            WCMFilter aFilter = new WCMFilter("", sWhere, "CRTIME asc");
            Templates oOutlineTemplates = m_oTemplateMgr.getManagedTemplates((IPublishFolder)oParentChnlElement, 1, aFilter, false);
            int size = oOutlineTemplates.size();
            for (int i = 0; i < size; ++i) {
                Template currOutlineTemplate = (Template)oOutlineTemplates.getAt(i);
                if (currOutlineTemplate == null) continue;
                nOutlineTemplateId = currOutlineTemplate.getId();
                break;
            }
            if (nOutlineTemplateId == 0) {
                nOutlineTemplateId = this.findTemplateOfSite(_oChannel, 1);
            }
        } else {
            nOutlineTemplateId = oParentChnlPublishConfig.getDefaultOutlineTemplateId();
            if (nOutlineTemplateId == 0) {
                nOutlineTemplateId = this.findTemplateOfSite(_oChannel, 1);
            }
        }
        if (nOutlineTemplateId != 0) {
            _currPublishConfig.setOutlineTemplateId(nOutlineTemplateId + "");
        }
        int nDetailTemplateId = 0;
        nDetailTemplateId = oParentChnlPublishConfig.getDetailTemplateId();
        if (nDetailTemplateId == 0) {
            nDetailTemplateId = this.findTemplateOfSite(_oChannel, 2);
        }
        if (nDetailTemplateId != 0) {
            _currPublishConfig.setDetailTemplateId(nDetailTemplateId);
        }
    }

    private int findTemplateOfSite(Channel _oChannel, int _nTempalteType) throws WCMException {
        Template oDetailTemplate;
        if (_oChannel == null) {
            return 0;
        }
        IPublishElement publishElement = PublishElementFactory.lookupElement(103, _oChannel.getSiteId());
        TemplateEmployMgr templateEmployMgr = (TemplateEmployMgr)DreamFactory.createObjectById("TemplateEmployMgr");
        if (_nTempalteType == 1) {
            Templates templats = templateEmployMgr.getOtherOutlineTemplates((IPublishFolder)publishElement);
            if (templats.size() > 0) {
                Template oOutlineTemplate = (Template)templats.getAt(0);
                return oOutlineTemplate.getId();
            }
        } else if (_nTempalteType == 2 && (oDetailTemplate = templateEmployMgr.getDetailTemplate((IPublishFolder)publishElement)) != null) {
            return oDetailTemplate.getId();
        }
        return 0;
    }

    private String getNewChnlName(String _sChnlName, BaseChannel _destSiteOrChnl) throws Throwable {
        String sChnlName = _sChnlName;
        if (!this.existsChnlName(sChnlName, _destSiteOrChnl)) {
            return sChnlName;
        }
        String sNewChnlName = sChnlName = sChnlName.replaceAll("(_\\d+)+", "");
        int nPostNumber = DBManager.getDBManager().sqlExecuteIntQuery("select max(channelid) from wcmchannel", new int[0]);
        while (this.existsChnlName(sNewChnlName, _destSiteOrChnl)) {
            sNewChnlName = sChnlName + "_" + nPostNumber;
            ++nPostNumber;
        }
        return sNewChnlName;
    }

    private boolean existsChnlName(String _sChnlName, BaseChannel _destSiteOrChnl) {
        if (_destSiteOrChnl instanceof Channel) {
            return Channel.findByName(_destSiteOrChnl.getSiteId(), _sChnlName) != null;
        }
        if (_destSiteOrChnl instanceof WebSite) {
            return Channel.findByName(_destSiteOrChnl.getId(), _sChnlName) != null;
        }
        return false;
    }

    public Object findChannelByPath(MethodContext _context) throws Throwable {
        User loginUser = this.getLoginUser();
        String sChnlPath = _context.getValue("ChnlPath");
        Channel oChannel = this.m_oChannelMgr.getChannelByPath(sChnlPath);
        if (oChannel == null) {
            return oChannel;
        }
        int nRightIndex = 64;
        if (!AuthServer.hasRight(loginUser, (CMSObj)oChannel, nRightIndex)) {
            throw new WCMException(I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label9", "\u60a8[") + loginUser.getName() + I18NMessage.get(ChannelServiceProvider.class, "ChannelServiceProvider.label10", "]\u6ca1\u6709\u6743\u9650\u8bbf\u95ee\u680f\u76ee[Id=") + oChannel.getId() + "]\uff01");
        }
        return oChannel;
    }
}

