/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.log4j.Logger;

public class MacAddrUtil {
    private static String osName = System.getProperty("os.name");
    private static double osVersion;
    private static final double VISTA_INNER_VERSION = 6.0;
    private static final Logger logger;

    static {
        logger = Logger.getLogger(MacAddrUtil.class);
        String sOSVer = System.getProperty("os.version");
        try {
            osVersion = Double.parseDouble(sOSVer);
        }
        catch (Exception e) {
            osVersion = 1.0;
        }
    }

    public static String[] getMacAddrs() {
        String sOs = osName.toUpperCase();
        if (sOs.indexOf("WINDOWS") >= 0) {
            return MacAddrUtil.getMacOnWindows();
        }
        if (sOs.indexOf("LINUX") >= 0) {
            return MacAddrUtil.getMacOnLinux();
        }
        if (sOs.indexOf("SOLARIS") >= 0 || sOs.indexOf("SUNOS") >= 0) {
            return MacAddrUtil.getMacOnSolaris();
        }
        if (sOs.indexOf("AIX") >= 0) {
            return MacAddrUtil.getMacOnAIX();
        }
        if (sOs.indexOf("HP") >= 0) {
            return MacAddrUtil.getMacOnHP();
        }
        if (sOs.indexOf("MAC OS X") >= 0) {
            String[] tmp = new String[]{"ff"};
            return tmp;
        }
        return new String[0];
    }

    private static String[] getMacOnWindows() {
        if (osVersion >= 6.0) {
            return MacAddrUtil.parseGetMAC();
        }
        return MacAddrUtil.parseIPConfig();
    }

    private static String[] parseIPConfig() {
        ArrayList<String> macList = new ArrayList<String>();
        try {
            String cmd = "ipconfig /all";
            Process process = Runtime.getRuntime().exec(cmd);
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = bufferedreader.readLine();
            while (line != null) {
                if (line.indexOf("Physical Address") > 0) {
                    int i = line.indexOf("Physical Address") + 36;
                    macList.add(line.substring(i).trim());
                }
                line = bufferedreader.readLine();
            }
            bufferedreader.close();
            process.waitFor();
        }
        catch (Exception e) {
            System.err.println(e + " occured when getMacOnWindows()! os=" + osName);
            e.printStackTrace();
            logger.error((Object)(e + " occured when getMacOnWindows()! os=" + osName), (Throwable)e);
        }
        return macList.toArray(new String[0]);
    }

    private static String[] parseGetMAC() {
        ArrayList<String> macList = new ArrayList<String>();
        int exitValue = 0;
        try {
            String cmd = "getmac /nh";
            Process process = Runtime.getRuntime().exec(cmd);
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = bufferedreader.readLine();
            while (line != null) {
                StringTokenizer st;
                if ((line = line.trim()).length() != 0 && (st = new StringTokenizer(line)).hasMoreTokens()) {
                    macList.add(st.nextToken());
                }
                line = bufferedreader.readLine();
            }
            bufferedreader.close();
            exitValue = process.waitFor();
        }
        catch (Exception e) {
            System.err.println(e + " occured when exec getmac.exe /nh! os=" + osName);
            e.printStackTrace();
            logger.error((Object)(e + " occured when exec getmac.exe /nh! os=" + osName), (Throwable)e);
        }
        if (exitValue != 0) {
            throw new RuntimeException("exitValue:  of exec getmac.exe /nh!");
        }
        return macList.toArray(new String[0]);
    }

    private static String[] getMacOnLinux() {
        try {
            String cmd = "/sbin/ifconfig -a";
            Process process = Runtime.getRuntime().exec(cmd);
            InputStream is = process.getInputStream();
            List macList = MacAddrUtil.parseMacsFromLinuxIfconfigOutput(is);
            process.waitFor();
            return macList.toArray(new String[0]);
        }
        catch (Exception e) {
            System.err.println(e + " occured when getMacOnLinux()! os=" + osName);
            e.printStackTrace();
            logger.error((Object)(e + " occured when getMacOnLinux()! os=" + osName), (Throwable)e);
            return new String[0];
        }
    }

    static List parseMacsFromLinuxIfconfigOutput(InputStream is) throws IOException {
        ArrayList<String> macList = new ArrayList<String>();
        BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(is));
        String line = bufferedreader.readLine();
        while (line != null) {
            if ((line = line.toUpperCase()).indexOf("HWADDR") > 0) {
                int i = line.indexOf("HWADDR") + 7;
                macList.add(line.substring(i).trim().replace(':', '-'));
            }
            line = bufferedreader.readLine();
        }
        bufferedreader.close();
        return macList;
    }

    private static String[] getMacOnSolaris() {
        return MacAddrUtil.getMacByCmd("/usr/bin/hostid");
    }

    private static String[] getMacOnAIX() {
        return MacAddrUtil.getMacByCmd("/usr/bin/uname -m");
    }

    private static String[] getMacByCmd(String cmd) {
        ArrayList<String> macList = new ArrayList<String>();
        try {
            Process process = Runtime.getRuntime().exec(cmd);
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = bufferedreader.readLine();
            while (line != null) {
                macList.add(line.trim().toUpperCase());
                line = bufferedreader.readLine();
            }
            bufferedreader.close();
            process.waitFor();
        }
        catch (Exception e) {
            System.err.println(e + " occured when getMacByCmd()! cmd=" + cmd + ", os=" + osName);
            e.printStackTrace();
            logger.error((Object)(e + " occured when getMacByCmd()! cmd=" + cmd + ", os=" + osName), (Throwable)e);
        }
        return macList.toArray(new String[0]);
    }

    private static String[] getMacOnHP() {
        ArrayList<String> macList = new ArrayList<String>();
        try {
            String cmd = "/usr/sbin/lanscan";
            Process process = Runtime.getRuntime().exec(cmd);
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = bufferedreader.readLine();
            while (line != null) {
                int nPose = (line = line.toUpperCase()).indexOf("0X");
                if (nPose > 0) {
                    int nStart = nPose + 2;
                    int nEnd = line.indexOf(" ", nStart);
                    macList.add(line.substring(nStart, nEnd).trim());
                }
                line = bufferedreader.readLine();
            }
            bufferedreader.close();
            process.waitFor();
        }
        catch (Exception e) {
            System.err.println(e + " occured when getMacOnHP()! os=" + osName);
            e.printStackTrace();
            logger.error((Object)(e + " occured when getMacOnHP()! os=" + osName), (Throwable)e);
        }
        return macList.toArray(new String[0]);
    }

    static void printLocalMacAddrs() {
        System.out.println("----Begin getMacAddrs----");
        String[] macAddrs = MacAddrUtil.getMacAddrs();
        int i = 0;
        while (i < macAddrs.length) {
            System.out.println(String.valueOf(i) + ": " + macAddrs[i]);
            ++i;
        }
        System.out.println("----End getMacAddrs----");
    }

    public static boolean isValidMachineCode(String machineCode) {
        if (machineCode == null) {
            return false;
        }
        String[] macAddrs = MacAddrUtil.getMacAddrs();
        int i = 0;
        while (i < macAddrs.length) {
            if (machineCode.equals(DigestUtils.md5Hex((String)macAddrs[i]))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String getPrimaryMacInHex() {
        String myMac = null;
        String[] allMacs = MacAddrUtil.getMacAddrs();
        if (allMacs == null || allMacs.length == 0) {
            myMac = "";
        }
        return (myMac = allMacs[0]) == null ? "" : DigestUtils.md5Hex((String)myMac);
    }
}

