/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.exception.IdMException;
import com.trs.idm.model.sync.SynchronizerException;
import com.trs.idm.util.StringHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import org.apache.log4j.Logger;

public class EyouMailHelper {
    private static final String EYOUMAIL_MESSAGE_MOD = "mod{";
    private static final String EYOUMAIL_MESSAGE_DEL = "del{";
    private static final String EYOUMAIL_MESSAGE_SEARCH = "search{";
    private static final String EYOUMAIL_MESSAGE_ADD = "add{";
    private static final Logger LOG = Logger.getLogger(EyouMailHelper.class);
    private EyouMailConfig config;

    public EyouMailHelper(Map connections) {
        this.config = new EyouMailConfig(connections);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("EyouMailConfig(" + this.config + ") with connections(EYOU_IP,EYOU_PORT,EYOU_DOMAIN):" + connections.get("EYOU_IP") + "," + connections.get("EYOU_PORT") + "," + connections.get("EYOU_DOMAIN")));
        }
    }

    public boolean createUser(String userName, String trueName, String password, int state) throws Exception {
        String message = this.buildMessage(EYOUMAIL_MESSAGE_ADD, userName, trueName, password, state);
        return this.request(message);
    }

    String buildMessage(String header, String userName, String trueName, String password, int state) {
        if (header == null || userName == null) {
            LOG.error((Object)"header == null || userName == null");
            throw new IllegalArgumentException("header == null || userName == null");
        }
        StringBuffer message = new StringBuffer(512);
        message.append(header);
        message.append("\r\ndomain=").append(this.config.getEyouDomain());
        message.append("\r\nuid=").append(userName);
        if (trueName != null) {
            message.append("\r\nusername=").append(trueName);
        }
        if (password != null) {
            message.append("\r\nuserPassword=").append(password);
        }
        if (state != -1) {
            message.append("\r\nlockstatus=").append(String.valueOf(state));
        }
        message.append("\r\n}\r\n.\r\n");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("EYou Message:" + message.toString()));
        }
        return message.toString();
    }

    public boolean createUser(String username, String truename, String password) throws Exception {
        return this.createUser(username, truename, password, 0);
    }

    public boolean deleteUser(String userName) throws Exception {
        return this.request(this.buildMessage(EYOUMAIL_MESSAGE_DEL, userName, null, null, -1));
    }

    public boolean findUser(String userName) throws SynchronizerException {
        try {
            return this.request(this.buildMessage(EYOUMAIL_MESSAGE_SEARCH, userName, null, null, 0));
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new SynchronizerException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean updateUser(String userName, String trueName, String password) throws Exception {
        return this.request(this.buildMessage(EYOUMAIL_MESSAGE_MOD, userName, trueName, password, 0));
    }

    private boolean request(String message) throws Exception {
        String result;
        block3: {
            try {
                result = this.sendMessage(this.config.getEyouIP(), this.config.getEyouPort(), message);
                LOG.debug((Object)("Result(" + result + ") of Message(" + message + ") with (" + this.config.getEyouIP() + ":" + this.config.getEyouPort() + ")"));
                if (!result.substring(0, 1).equals("+")) break block3;
                return true;
            }
            catch (Exception ex) {
                LOG.error((Object)("Exception of Message(" + message + ") with (" + this.config.getEyouIP() + ":" + this.config.getEyouPort() + "):" + ex.getMessage()), (Throwable)ex);
                throw ex;
            }
        }
        throw new IdMException(result);
    }

    private String sendMessage(String serverIP, int serverPort, String message) throws Exception {
        Socket socket = null;
        try {
            socket = new Socket(serverIP, serverPort);
            InputStream in = socket.getInputStream();
            OutputStream out = socket.getOutputStream();
            byte[] inbytes = new byte[200];
            in.read(inbytes);
            byte[] outbytes = message.getBytes();
            out.write(outbytes);
            out.flush();
            in.read(inbytes);
            String string = new String(inbytes);
            return string;
        }
        catch (Exception ex) {
            LOG.error((Object)("Send message(" + message + ") to (" + serverIP + ":" + serverPort + ") error:" + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public class EyouMailConfig {
        private String eyouIP;
        private int eyouPort;
        private String eyouDomain;

        public EyouMailConfig(Map connections) {
            this.eyouIP = (String)connections.get("EYOU-IP");
            this.eyouPort = StringHelper.parseInt((String)connections.get("EYOU-PORT"));
            this.eyouDomain = (String)connections.get("EYOU-DOMAIN");
        }

        public String getEyouIP() {
            return this.eyouIP;
        }

        public int getEyouPort() {
            return this.eyouPort;
        }

        public String getEyouDomain() {
            return this.eyouDomain;
        }

        public String toString() {
            return "EyouMailConfig [eyouIP=" + this.eyouIP + ", eyouPort=" + this.eyouPort + ", eyouDomain=" + this.eyouDomain + "]";
        }
    }
}

