/*
 * Decompiled with CFR 0.152.
 */
package com.trs.idm.util;

import com.trs.idm.util.Base64Util;
import com.trs.idm.util.StringHelper;
import com.trs.idm.util.UrlUtil;
import org.apache.log4j.Logger;

public class LoginEncoder {
    private static Logger logger = Logger.getLogger(LoginEncoder.class);

    public static String getURLSafeUser(String alInfo) {
        return UrlUtil.encode(LoginEncoder.decodeUser(alInfo));
    }

    public static String decodePwd(String alInfo) {
        if (StringHelper.isEmpty(alInfo) || alInfo.indexOf(95) < 0) {
            return null;
        }
        String[] alInfoArray = StringHelper.split(alInfo, "_");
        if (alInfoArray == null || alInfoArray.length < 2) {
            return null;
        }
        String b64Pwd = alInfoArray[1];
        if (StringHelper.isEmpty(b64Pwd) || !Base64Util.isBase64Encoded(b64Pwd)) {
            return null;
        }
        return Base64Util.decode(b64Pwd);
    }

    public static String decodeUser(String alInfo) {
        if (StringHelper.isEmpty(alInfo) || alInfo.indexOf(95) < 0) {
            return null;
        }
        String b64User = alInfo.substring(0, alInfo.indexOf(95));
        return Base64Util.decode(b64User);
    }

    public static String decodeLoginType(String alInfo) {
        if (StringHelper.isEmpty(alInfo) || alInfo.indexOf(95) < 0) {
            return null;
        }
        String[] alInfoArray = StringHelper.split(alInfo, "_");
        if (alInfoArray == null || alInfoArray.length < 4) {
            return null;
        }
        String b64LoginType = alInfoArray[2];
        if (StringHelper.isEmpty(b64LoginType) || !Base64Util.isBase64Encoded(b64LoginType)) {
            return null;
        }
        return Base64Util.decode(b64LoginType);
    }

    public static String decodeLoginKey(String alInfo) {
        if (StringHelper.isEmpty(alInfo) || alInfo.indexOf(95) < 0) {
            return null;
        }
        String[] alInfoArray = StringHelper.split(alInfo, "_");
        if (alInfoArray == null || alInfoArray.length < 4) {
            return null;
        }
        String b64LoginKey = alInfoArray[3];
        if (StringHelper.isEmpty(b64LoginKey) || !Base64Util.isBase64Encoded(b64LoginKey)) {
            return null;
        }
        return Base64Util.decode(b64LoginKey);
    }

    public static String encodeInfo(String user, String pwd) {
        if (user == null || user.trim().length() == 0) {
            return null;
        }
        return String.valueOf(Base64Util.encode(user)) + "_" + Base64Util.encode(pwd);
    }

    public static String encodeInfo(String user, String pwd, String loginType, String loginKey) {
        if (StringHelper.isEmpty(user)) {
            user = loginKey;
        }
        if (StringHelper.isEmpty(user)) {
            return null;
        }
        if (StringHelper.isEmpty(loginType)) {
            return String.valueOf(Base64Util.encode(user)) + "_" + Base64Util.encode(pwd);
        }
        return String.valueOf(Base64Util.encode(user)) + "_" + Base64Util.encode(pwd) + "_" + Base64Util.encode(loginType) + "_" + Base64Util.encode(loginKey);
    }

    public static String encode(String value) {
        if (value == null) {
            return null;
        }
        return Base64Util.encode(value);
    }

    public static String decode(String value) {
        if (value == null) {
            return null;
        }
        return Base64Util.decode(value);
    }
}

