/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.dao.hb3;

import com.trs.dev4.jdk16.dao.SearchFilter;
import org.apache.log4j.Logger;

public class QueryTimer {
    private static final Logger logger = Logger.getLogger(QueryTimer.class);
    private long beginTimeInMillis = System.currentTimeMillis();
    private Class<?> classType;

    public QueryTimer(Class<?> classType) {
        this.classType = classType;
    }

    public void startWatch() {
        this.beginTimeInMillis = System.currentTimeMillis();
    }

    public void stopWatch(SearchFilter searchFilter) {
        long duration = this.getDuration();
        if (this.isSlow(duration)) {
            logger.debug((Object)("(" + this.classType + ")'s SearchFilter(" + searchFilter.toString() + ") consumed (" + duration + ") ms"));
        }
    }

    public void stopWatch(int id) {
        long duration = this.getDuration();
        if (this.isSlow(duration)) {
            logger.debug((Object)("(" + this.classType + ")'s Get id=(" + id + ") consumed (" + duration + ") ms"));
        }
    }

    public void stopWatch() {
        long duration = this.getDuration();
        if (this.isSlow(duration)) {
            logger.debug((Object)("(" + this.classType + ")'s listObjects consumed (" + duration + ") ms"));
        }
    }

    public void stopWatch(Object entity, String action) {
        long duration = this.getDuration();
        if (this.isSlow(duration)) {
            logger.debug((Object)("(" + entity.toString() + ")'s (" + action + ") consumed (" + duration + ") ms"));
        }
    }

    public void stopWatch(String statement) {
        long duration = this.getDuration();
        if (this.isSlow(duration)) {
            logger.debug((Object)("(" + this.classType + ")'s execute command(" + statement + ") consumed (" + duration + ") ms"));
        }
    }

    private boolean isSlow(long duration) {
        return duration > 1000L;
    }

    private long getDuration() {
        return System.currentTimeMillis() - this.beginTimeInMillis;
    }
}

