/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.utils;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.springframework.util.FileCopyUtils;

@Deprecated
public class ZipUtil {
    private String inFilePath;
    private String releaseFilePath;
    private String[] FileNameArray;
    private ZipEntry entry;
    private FileInputStream fileDataIn;
    private FileOutputStream fileDataOut;
    private ZipInputStream zipInFile;
    private DataOutputStream writeData;
    private DataInputStream readData;
    private int zipFileCount = 0;
    private int zipPathCount = 0;

    public ZipUtil(String inpath, String releasepath) {
        this.inFilePath = inpath;
        this.releaseFilePath = releasepath;
    }

    protected long initInStream(ZipInputStream zipFileA) {
        try {
            this.readData = new DataInputStream(zipFileA);
            return 0L;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1L;
        }
    }

    protected long initOutStream(String outFileA) {
        try {
            this.fileDataOut = new FileOutputStream(outFileA);
            this.writeData = new DataOutputStream(this.fileDataOut);
            return 0L;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public long checkFile(File inFileA) {
        if (inFileA.exists()) {
            return 0L;
        }
        return -1L;
    }

    public long checkOpen(File inFileA) {
        if (inFileA.canRead()) {
            return inFileA.length();
        }
        return -1L;
    }

    public long getFileFolderCount(String infileA) {
        try {
            int fileCount = 0;
            this.zipInFile = new ZipInputStream(new FileInputStream(infileA));
            while ((this.entry = this.zipInFile.getNextEntry()) != null) {
                if (this.entry.isDirectory()) {
                    ++this.zipPathCount;
                } else {
                    ++this.zipFileCount;
                }
                ++fileCount;
            }
            return fileCount;
        }
        catch (IOException e) {
            e.printStackTrace();
            return -1L;
        }
    }

    public String[] getFileList(String infileA) {
        try {
            ZipInputStream AzipInFile = new ZipInputStream(new FileInputStream(infileA));
            this.FileNameArray = new String[(int)this.getFileFolderCount(infileA)];
            int i = 0;
            while ((this.entry = AzipInFile.getNextEntry()) != null) {
                this.FileNameArray[i++] = this.entry.getName();
            }
            return this.FileNameArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public long writeFile(String outFileA, byte[] dataByte) {
        block3: {
            try {
                if (this.initOutStream(outFileA) != 0L) break block3;
                this.writeData.write(dataByte);
                this.fileDataOut.close();
                return 0L;
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1L;
            }
        }
        this.fileDataOut.close();
        return -1L;
    }

    protected byte[] readFile(ZipEntry entryA, ZipInputStream zipFileA) {
        try {
            if (this.initInStream(zipFileA) == 0L) {
                long entryFilelen = entryA.getSize();
                if (entryFilelen >= 0L) {
                    byte[] entryFileData = new byte[(int)entryFilelen];
                    this.readData.readFully(entryFileData, 0, (int)entryFilelen);
                    return entryFileData;
                }
                return null;
            }
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public long createFolder(String dir) {
        File file = new File(dir);
        if (file.mkdirs()) {
            return 0L;
        }
        return -1L;
    }

    public long deleteFile(String Apath) throws SecurityException {
        File file = new File(Apath.trim());
        if (!file.exists()) {
            return -2L;
        }
        if (!file.isFile()) {
            return -3L;
        }
        if (file.delete()) {
            return 0L;
        }
        return -1L;
    }

    public long deleteFolder(String Apath) {
        File file = new File(Apath);
        if (file.delete()) {
            return 0L;
        }
        return -1L;
    }

    public long checkPathExists(String AreleasePath) {
        File file = new File(AreleasePath);
        if (!file.exists()) {
            return 0L;
        }
        return -1L;
    }

    protected long deleteReleaseZipFile(String[] listFilePath, String releasePath) {
        long flagReturn;
        int k = 0;
        String[] pathArray = new String[this.zipPathCount];
        long arrayLen = listFilePath.length;
        int i = 0;
        while (i < (int)arrayLen) {
            String tempPath = String.valueOf(releasePath.replace('\\', '/')) + listFilePath[i];
            flagReturn = this.deleteFile(tempPath);
            if (flagReturn != -2L) {
                if (flagReturn == -3L) {
                    pathArray[k++] = tempPath;
                } else if (flagReturn == -1L) {
                    return -1L;
                }
            }
            ++i;
        }
        --k;
        while (k >= 0) {
            flagReturn = this.deleteFolder(pathArray[k]);
            if (flagReturn == -1L) {
                return -1L;
            }
            --k;
        }
        return 0L;
    }

    public String getZipRoot(String infileA) {
        try {
            FileInputStream tempfile = new FileInputStream(infileA);
            ZipInputStream AzipInFile = new ZipInputStream(tempfile);
            ZipEntry Aentry = AzipInFile.getNextEntry();
            String rootName = Aentry.getName();
            tempfile.close();
            AzipInFile.close();
            return rootName;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void closeStream() throws Exception {
        this.fileDataIn.close();
        this.fileDataOut.close();
        this.zipInFile.close();
        this.writeData.flush();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long doRelease() throws Exception {
        File inFile = new File(this.inFilePath);
        File outFile = new File(this.releaseFilePath);
        if (this.checkFile(inFile) == -1L) {
            return -1L;
        }
        if (this.checkOpen(inFile) == -1L) {
            return -2L;
        }
        if (!this.releaseFilePath.equals("/") && this.checkFile(outFile) == -1L) {
            return -3L;
        }
        String tempPathParent = !this.releaseFilePath.equals("/") ? String.valueOf(this.releaseFilePath.replace('\\', '/')) + "/" : String.valueOf(inFile.getParent().replace('\\', '/')) + "/";
        this.FileNameArray = this.getFileList(this.inFilePath);
        this.fileDataIn = new FileInputStream(this.inFilePath);
        this.zipInFile = new ZipInputStream(this.fileDataIn);
        try {
            int i = 0;
            while (true) {
                if ((this.entry = this.zipInFile.getNextEntry()) == null) {
                    this.closeStream();
                    return 0L;
                }
                if (this.entry.isDirectory()) {
                    String zipPath = String.valueOf(tempPathParent) + this.FileNameArray[i];
                    if (this.createFolder(zipPath = zipPath.substring(0, zipPath.lastIndexOf("/"))) == -1L) {
                        this.closeStream();
                        this.deleteReleaseZipFile(this.FileNameArray, tempPathParent);
                        return -4L;
                    }
                } else {
                    byte[] zipEntryFileData = this.readFile(this.entry, this.zipInFile);
                    String tempFile = String.valueOf(tempPathParent) + this.FileNameArray[i];
                    if (this.writeFile(tempFile, zipEntryFileData) == -1L) {
                        this.closeStream();
                        this.deleteReleaseZipFile(this.FileNameArray, tempPathParent);
                        return -5L;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.closeStream();
            this.deleteReleaseZipFile(this.FileNameArray, tempPathParent);
            e.printStackTrace();
            return -50L;
        }
    }

    public static long extractZipFileToDirectory(InputStream in, File directory) throws Exception {
        if (!directory.exists()) {
            directory.mkdirs();
        } else if (directory.isFile()) {
            throw new IllegalArgumentException("cannot extract to a file[" + directory.getAbsolutePath() + "]. file folder is expected.");
        }
        File toFile = new File(System.getProperty("tmp"), String.valueOf(System.currentTimeMillis()) + ".zip");
        FileCopyUtils.copy((InputStream)in, (OutputStream)new FileOutputStream(toFile));
        ZipUtil zu = new ZipUtil(toFile.getAbsolutePath(), directory.getAbsolutePath());
        return zu.doRelease();
    }

    public static long extractZipFileToDirectory(File inFile, File directory) throws Exception {
        if (!directory.exists()) {
            directory.mkdirs();
        } else if (directory.isFile()) {
            throw new IllegalArgumentException("cannot extract to a file[" + directory.getAbsolutePath() + "]. file folder is expected.");
        }
        ZipUtil zu = new ZipUtil(inFile.getAbsolutePath(), directory.getAbsolutePath());
        return zu.doRelease();
    }

    public static void assertNoException(long flag) throws IOException {
        switch ((int)flag) {
            case -1: {
                throw new IOException("\u60a8\u6240\u8981\u89e3\u538b\u7684\u6587\u4ef6\u4e0d\u5b58\u5728\uff01");
            }
            case -2: {
                throw new IOException("\u60a8\u6240\u8981\u89e3\u538b\u7684\u6587\u4ef6\u4e0d\u80fd\u88ab\u6253\u5f00\uff01");
            }
            case -3: {
                throw new IOException("\u60a8\u6240\u8981\u91ca\u653e\u7684\u8def\u5f84\u4e0d\u5b58\u5728\uff01");
            }
            case -4: {
                throw new IOException("\u60a8\u6240\u521b\u5efa\u6587\u4ef6\u76ee\u5f55\u5931\u8d25\uff01");
            }
            case -5: {
                throw new IOException("\u5199\u5165\u6587\u4ef6\u5931\u8d25\uff01");
            }
            case -6: {
                throw new IOException("\u6587\u4ef6\u5df2\u7ecf\u5b58\u5728\uff01");
            }
            case -50: {
                throw new IOException("\u6587\u4ef6\u8bfb\u53d6\u5f02\u5e38\uff01");
            }
        }
    }

    public static void main(String[] args) throws Exception {
        BufferedReader userInput = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("\u8bf7\u8f93\u5165zip\u6587\u4ef6\u8def\u5f84\uff1a");
        String inPath = "d:/control.zip";
        System.out.println("\u8bf7\u8f93\u5165\u4fdd\u5b58\u8def\u5f84\uff1a");
        String releasePath = "d:/test/style2";
        userInput.close();
        long flag = ZipUtil.extractZipFileToDirectory(new File(inPath), new File(releasePath));
        ZipUtil.assertNoException(flag);
    }
}

