/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.job.impl;

import com.trs.dev4.jdk16.job.IJobExecutor;
import com.trs.dev4.jdk16.job.IJobListener;
import com.trs.dev4.jdk16.job.JobDetail;
import com.trs.dev4.jdk16.job.impl.BaseJobService;
import com.trs.dev4.jdk16.job.impl.QuartzJob;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzJobService
extends BaseJobService
implements IJobListener {
    private static final Logger logger = Logger.getLogger(QuartzJobService.class);
    private Scheduler quartzScheduler;
    private Map<String, JobDetail> jobMap = new HashMap<String, JobDetail>();
    public static String JOB_KEY = "quartzJobKey";
    public static String JOB_EXECUTOR = "quartzJobExecutor";

    @Override
    public int countJobs() {
        return this.jobMap.size();
    }

    @Override
    public void beforeExecute(IJobExecutor jobExecutor, JobDetail jobDetail) {
    }

    @Override
    public void afterExecuted(IJobExecutor jobExecutor, JobDetail jobDetail) {
    }

    @Override
    protected void cancelJob(JobDetail jobDetail) {
        try {
            this.quartzScheduler.deleteJob(jobDetail.getJobName(), jobDetail.getExecutorName());
        }
        catch (SchedulerException e) {
            logger.error((Object)("error while cancle job, job : " + jobDetail), (Throwable)e);
        }
    }

    @Override
    public void scheduleJob(JobDetail jobDetail) {
        IJobExecutor jobExecutor;
        if (jobDetail == null) {
            logger.debug((Object)"job is null, so return directly. ");
            return;
        }
        if (this.jobMap.containsKey(jobDetail.getJobName())) {
            this.cancelJob(jobDetail);
            logger.debug((Object)("job is exist, so cancle it first . job : " + jobDetail));
        }
        if ((jobExecutor = this.getExecutor(jobDetail)) == null) {
            logger.debug((Object)("Can't found jobExecutor with executorName(" + jobDetail.getExecutorName() + ")."));
            return;
        }
        Trigger trigger = this.makeTrigger(jobDetail);
        if (trigger == null) {
            logger.debug((Object)("trigger is null, so return. jobDetail is : " + jobDetail));
            return;
        }
        org.quartz.JobDetail job = null;
        try {
            job = new org.quartz.JobDetail(jobDetail.getJobName(), jobDetail.getExecutorName(), QuartzJob.class);
            JobDataMap dataMap = new JobDataMap();
            dataMap.put((Object)JOB_KEY, (Object)jobDetail);
            dataMap.put((Object)JOB_EXECUTOR, (Object)jobExecutor);
            job.setJobDataMap(dataMap);
            this.quartzScheduler.scheduleJob(job, trigger);
            this.jobMap.put(jobDetail.getJobName(), jobDetail);
        }
        catch (SchedulerException e) {
            logger.error((Object)("error while schedule job, quartz job : " + job + "; jobDetail : " + jobDetail), (Throwable)e);
            return;
        }
    }

    private Trigger makeTrigger(JobDetail job) {
        CronTrigger trigger = new CronTrigger();
        try {
            trigger.setName(String.valueOf(job.getExecutorName()) + "-" + job.getJobName() + "-trigger");
            trigger.setCronExpression(job.getCron());
        }
        catch (ParseException e) {
            logger.error((Object)("(triggerExpression)=" + job.getCron()), (Throwable)e);
            return null;
        }
        logger.debug((Object)("job trigger name: " + trigger.getName() + ", trigger cron expression: " + job.getCron()));
        return trigger;
    }

    @Override
    public void start() {
        this.quartzScheduler = this.startScheduler();
        logger.info((Object)"SingletonMonitorJob started.");
    }

    @Override
    public void stop() {
        try {
            this.quartzScheduler.shutdown();
        }
        catch (SchedulerException e) {
            logger.error((Object)"error while shutdown the quartzScheduler. ", (Throwable)e);
        }
    }

    private Scheduler startScheduler() {
        Scheduler quartzScheduler = this.getScheduler();
        if (quartzScheduler == null) {
            return null;
        }
        try {
            quartzScheduler.start();
        }
        catch (SchedulerException e) {
            logger.error((Object)("error while start quartzScheduler , quartzScheduler :" + quartzScheduler), (Throwable)e);
        }
        logger.debug((Object)"QuartzScheduler server started.");
        return quartzScheduler;
    }

    private Scheduler getScheduler() {
        try {
            return StdSchedulerFactory.getDefaultScheduler();
        }
        catch (SchedulerException e) {
            logger.error((Object)("error while getDefaultScheduler from StdSchedulerFactory , error : " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean existsJob(String jobName) {
        return this.jobMap.containsKey(jobName);
    }
}

