/*
 * Decompiled with CFR 0.152.
 */
package com.trs.dev4.jdk16.cms.impl;

import com.trs.dev4.jdk16.cms.ICMSPublisher;
import com.trs.dev4.jdk16.cms.IContentProvider;
import java.util.Map;
import org.apache.log4j.Logger;

class PublisherJob {
    private static final Logger logger = Logger.getLogger(PublisherJob.class);
    private String templateName;
    private int duration;
    private String outputDirectory;
    private IContentProvider contentProvider;
    private Map<String, Object> parameters;
    private ICMSPublisher publisher;

    PublisherJob() {
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public ICMSPublisher getPublisher() {
        return this.publisher;
    }

    public void setPublisher(ICMSPublisher publisher) {
        this.publisher = publisher;
    }

    public void publish() {
        if (this.contentProvider != null) {
            Map<String, Object> inputObjects = this.contentProvider.getContent(this.parameters);
            String outputFilePath = String.valueOf(this.outputDirectory) + this.contentProvider.getOutputFile(this.parameters);
            logger.debug((Object)("Publisher(" + this.publisher + ") executed with templateName(" + this.templateName + ") and contentProvider(" + this.contentProvider + "),parameters is (" + this.parameters + "),outputFile is (" + outputFilePath + ")."));
            this.publisher.publish(this.templateName, inputObjects, outputFilePath);
        }
    }

    public IContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public void setContentProvider(IContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }
}

