/*
 * Decompiled with CFR 0.152.
 */
package com.trs.net.http.rfc1867.impl;

import com.trs.net.http.rfc1867.FormPart;
import com.trs.net.http.rfc1867.impl.DelegateOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileFormPart
implements FormPart {
    protected int m_iBrotherCount = 1;
    protected FileFormPart m_rfNextBrother = null;
    protected DelegateOutputStream m_osOutputStream;
    protected String m_sName;
    protected String m_sValue;
    protected String m_sFileName;
    protected String m_sFilePath;
    protected String m_sFileType;
    protected String m_sMimeType;
    protected File m_oTempFile;

    public String getName() {
        return this.m_sName;
    }

    public String getFileName() {
        return this.m_sFileName;
    }

    public String getFilePath() {
        return this.m_sFilePath;
    }

    public void setFilePath(String sFileName) {
        if (sFileName != null) {
            if (sFileName.length() > 256) {
                sFileName = sFileName.substring(0, 255);
            }
            this.m_sFilePath = sFileName;
            int index = sFileName.lastIndexOf(92);
            if (index < 0) {
                index = sFileName.lastIndexOf(47);
            }
            this.m_sFileName = index >= 0 ? sFileName.substring(index + 1) : sFileName;
            index = sFileName.lastIndexOf(46);
            if (index > 0) {
                String sFileType = sFileName.substring(index + 1);
                if (sFileType.length() > 16) {
                    sFileType = sFileType.substring(0, 15);
                }
                this.m_sFileType = sFileType;
            }
        }
    }

    public String getFileType() {
        return this.m_sFileType;
    }

    public String getMimeType() {
        return this.m_sMimeType;
    }

    public void setMimeType(String sMimeType) {
        if (sMimeType != null) {
            if (sMimeType.length() > 64) {
                sMimeType = sMimeType.substring(0, 63);
            }
            this.m_sMimeType = sMimeType;
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.m_osOutputStream == null) {
            this.m_osOutputStream = new DelegateOutputStream();
            this.m_osOutputStream.setTempFile(this.m_oTempFile);
        }
        return this.m_osOutputStream;
    }

    public long getSize() {
        return this.m_osOutputStream.getSize();
    }

    public byte[] getBytes() {
        return this.m_osOutputStream.getData();
    }

    public String getString() {
        return this.m_sValue;
    }

    public void setString(String value) {
        this.m_sValue = value;
    }

    public InputStream getInputStream() throws IOException {
        if (this.inMemory()) {
            return new ByteArrayInputStream(this.getBytes());
        }
        return new FileInputStream(this.getTempFile());
    }

    public boolean inMemory() {
        return this.m_osOutputStream.isInMemory();
    }

    public void writeTo(File file) throws IOException {
        block14: {
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            if (this.inMemory() || !this.getTempFile().renameTo(file)) {
                FileOutputStream fos = null;
                try {
                    try {
                        fos = new FileOutputStream(file);
                        this.writeTo(fos);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        if (fos == null) break block14;
                        try {
                            fos.close();
                        }
                        catch (Exception exception) {}
                    }
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        block13: {
            int iLen = 0;
            byte[] buff = new byte[4096];
            InputStream is = this.getInputStream();
            try {
                try {
                    while ((iLen = is.read(buff)) != -1) {
                        os.write(buff, 0, iLen);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    if (is == null) break block13;
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public void destroy() {
        this.m_osOutputStream.delete();
    }

    public File getTempFile() {
        if (this.m_osOutputStream != null) {
            return this.m_osOutputStream.getFile();
        }
        return null;
    }

    public void setTempFile(File file) {
        this.m_oTempFile = file;
    }
}

