/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.shell;

import com.trs.infra.cluster.shell.ClusterConsole;

abstract class Command {
    protected String name;
    protected String desc;
    protected String[] argNames;
    protected String[] argValues;

    Command(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    void exec() {
        this.readArgs();
        this.execute();
    }

    private void readArgs() {
        if (this.argNames != null && this.argNames.length > 0) {
            int len = this.argNames.length;
            this.argValues = new String[len];
            String cmd = this.name.toUpperCase();
            int i = 0;
            while (i < len) {
                this.argValues[i] = ClusterConsole.readIn(String.valueOf(cmd) + " " + this.argNames[i] + "> ");
                ++i;
            }
        }
    }

    protected void sleepSomeMillis(int interval) {
        try {
            Thread.sleep(interval);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected int parseInt(String s, int def) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception e) {
            return def;
        }
    }

    protected String getDesc() {
        return this.desc;
    }

    abstract void execute();
}

