/*
 * Decompiled with CFR 0.152.
 */
package com.trs.infra.cluster.impl;

import com.trs.infra.cluster.ClusterMessage;
import com.trs.infra.cluster.ClusterReceiver;
import com.trs.infra.cluster.Member;
import com.trs.infra.cluster.StreamType;
import com.trs.infra.cluster.impl.ClusterReceiverDispatcher;
import com.trs.infra.cluster.impl.ClusterTransporterBase;
import com.trs.infra.cluster.io.StreamDataUtil;
import org.apache.log4j.Logger;

public abstract class ClusterReceiverBase
extends ClusterTransporterBase
implements ClusterReceiver {
    private static final Logger s_logger;
    private static int receiverNumber;
    private ClusterReceiverDispatcher dispatcher;
    private int magicNumber;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.trs.infra.cluster.impl.ClusterReceiverBase");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger((Class)clazz);
    }

    private static synchronized int nextReceiverNumber() {
        return receiverNumber++;
    }

    public ClusterReceiverBase(String name) {
        super(String.valueOf(name) + "_" + ClusterReceiverBase.nextReceiverNumber());
    }

    public void run() {
        this.getContext().addReceiver(this);
        while (this.isContinue()) {
            try {
                this.doReceive();
            }
            catch (Throwable e) {
                try {
                    s_logger.error((Object)"Unexpected receive exception", e);
                }
                catch (Exception ex) {
                    System.out.println("Unexpected receive exception.");
                    e.printStackTrace(System.out);
                }
            }
        }
        this.cleanup();
        this.getContext().removeReceiver(this);
    }

    protected final void dispatch(ClusterMessage msg, Member sender) {
        this.dispatcher.dispatch(msg, sender);
    }

    protected boolean checkMagicNumber(int magicNumber) {
        return this.magicNumber == magicNumber;
    }

    protected final ClusterMessage getMessageFromHeader(byte[] buffer) {
        int magicNumber = StreamDataUtil.read_short(buffer, 0) & 0xFFFF;
        if (!this.checkMagicNumber(magicNumber)) {
            s_logger.error((Object)("Bad magic mumber:" + magicNumber + ", from:" + this.getRemoteMember()));
            return null;
        }
        int majorVersion = buffer[2] & 0xFF;
        int minorVersion = buffer[3] & 0xFF;
        if (!ClusterMessage.checkVersion(majorVersion, minorVersion)) {
            s_logger.error((Object)("Bad message version:" + majorVersion + "," + minorVersion));
            return null;
        }
        int flag = StreamDataUtil.read_int(buffer, 4);
        int sequence = StreamDataUtil.read_int(buffer, 8);
        int majorId = buffer[12] & 0xFF;
        int minorId = buffer[13] & 0xFF;
        short streamType = StreamDataUtil.read_short(buffer, 14);
        int length = StreamDataUtil.read_int(buffer, 28);
        StreamType type = StreamType.valueOf(streamType);
        if (type == null) {
            s_logger.error((Object)("Bad message version:" + majorVersion + "," + minorVersion));
            return null;
        }
        ClusterMessage message = (ClusterMessage)type.newInstance();
        message.setMagicNumber(magicNumber);
        message.setFlag(flag);
        message.setSequence(sequence);
        message.setMajorId(majorId);
        message.setMinorId(minorId);
        message.setLength(length);
        return message;
    }

    protected abstract void doReceive();

    protected abstract long getReadBytes();

    public void start() {
        this.dispatcher = this.getContext().receiverDispatcher;
        this.magicNumber = this.getConfig().getMagicNumber();
        this.startup();
        this.startThread();
    }

    public void close() {
        this.stopThread();
    }
}

