/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.jta;

import java.io.IOException;
import java.io.ObjectInputStream;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.aopalliance.aop.AspectException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jndi.JndiTemplate;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.HeuristicCompletionException;
import org.springframework.transaction.IllegalTransactionStateException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSuspensionNotSupportedException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.UnexpectedRollbackException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class JtaTransactionManager
extends AbstractPlatformTransactionManager
implements InitializingBean {
    public static final String DEFAULT_USER_TRANSACTION_NAME = "java:comp/UserTransaction";
    private transient JndiTemplate jndiTemplate = new JndiTemplate();
    private transient UserTransaction userTransaction;
    private String userTransactionName = "java:comp/UserTransaction";
    private transient TransactionManager transactionManager;
    private String transactionManagerName;

    public JtaTransactionManager() {
        this.setNestedTransactionAllowed(true);
    }

    public JtaTransactionManager(UserTransaction userTransaction) {
        this();
        this.userTransaction = userTransaction;
        this.afterPropertiesSet();
    }

    public JtaTransactionManager(UserTransaction userTransaction, TransactionManager transactionManager) {
        this();
        this.userTransaction = userTransaction;
        this.transactionManager = transactionManager;
        this.afterPropertiesSet();
    }

    public void setJndiTemplate(JndiTemplate jndiTemplate) {
        if (jndiTemplate == null) {
            throw new IllegalArgumentException("jndiTemplate must not be null");
        }
        this.jndiTemplate = jndiTemplate;
    }

    public JndiTemplate getJndiTemplate() {
        return this.jndiTemplate;
    }

    public void setUserTransactionName(String userTransactionName) {
        this.userTransactionName = userTransactionName;
    }

    public void setUserTransaction(UserTransaction userTransaction) {
        this.userTransaction = userTransaction;
    }

    public UserTransaction getUserTransaction() {
        return this.userTransaction;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManagerName(String transactionManagerName) {
        this.transactionManagerName = transactionManagerName;
    }

    public void afterPropertiesSet() throws CannotCreateTransactionException {
        if (this.userTransaction == null) {
            if (this.userTransactionName != null) {
                this.userTransaction = this.lookupUserTransaction(this.userTransactionName);
            } else {
                throw new IllegalArgumentException("Either userTransaction or userTransactionName must be set");
            }
        }
        if (this.transactionManager == null) {
            if (this.transactionManagerName != null) {
                this.transactionManager = this.lookupTransactionManager(this.transactionManagerName);
            } else if (this.userTransaction instanceof TransactionManager) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info((Object)("JTA UserTransaction object [" + this.userTransaction + "] implements TransactionManager"));
                }
                this.transactionManager = (TransactionManager)this.userTransaction;
            } else {
                this.logger.info((Object)"No JTA TransactionManager specified - transaction suspension not available");
            }
        }
    }

    protected UserTransaction lookupUserTransaction(String userTransactionName) throws CannotCreateTransactionException {
        try {
            Object jndiObj = this.getJndiTemplate().lookup(userTransactionName);
            if (!(jndiObj instanceof UserTransaction)) {
                throw new CannotCreateTransactionException("Object [" + jndiObj + "] available at JNDI location [" + userTransactionName + "] does not implement " + "javax.transaction.UserTransaction");
            }
            UserTransaction ut = (UserTransaction)jndiObj;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using JTA UserTransaction [" + ut + "] from JNDI location [" + userTransactionName + "]"));
            }
            return ut;
        }
        catch (NamingException ex) {
            throw new CannotCreateTransactionException("JTA UserTransaction is not available at JNDI location [" + userTransactionName + "]", ex);
        }
    }

    protected TransactionManager lookupTransactionManager(String transactionManagerName) throws CannotCreateTransactionException {
        try {
            Object jndiObj = this.getJndiTemplate().lookup(transactionManagerName);
            if (!(jndiObj instanceof TransactionManager)) {
                throw new CannotCreateTransactionException("Object [" + jndiObj + "] available at JNDI location [" + transactionManagerName + "] does not implement " + "javax.transaction.TransactionManager");
            }
            TransactionManager tm = (TransactionManager)jndiObj;
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Using JTA TransactionManager [" + tm + "] from JNDI location [" + transactionManagerName + "]"));
            }
            return tm;
        }
        catch (NamingException ex) {
            throw new CannotCreateTransactionException("JTA TransactionManager is not available at JNDI location [" + transactionManagerName + "]", ex);
        }
    }

    protected Object doGetTransaction() {
        return this.getUserTransaction();
    }

    protected boolean isExistingTransaction(Object transaction) {
        try {
            return this.getUserTransaction().getStatus() != 6;
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on getStatus", ex);
        }
    }

    protected boolean useSavepointForNestedTransaction() {
        return false;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) {
        this.logger.debug((Object)"Beginning JTA transaction");
        try {
            this.applyIsolationLevel(definition.getIsolationLevel());
            if (definition.getTimeout() > -1) {
                this.getUserTransaction().setTransactionTimeout(definition.getTimeout());
            }
            this.getUserTransaction().begin();
        }
        catch (NotSupportedException ex) {
            throw new NestedTransactionNotSupportedException("JTA implementation does not support nested transactions", ex);
        }
        catch (UnsupportedOperationException ex) {
            throw new NestedTransactionNotSupportedException("JTA implementation does not support nested transactions", ex);
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on begin", ex);
        }
    }

    protected void applyIsolationLevel(int isolationLevel) throws InvalidIsolationLevelException, SystemException {
        if (isolationLevel != -1) {
            throw new InvalidIsolationLevelException("JtaTransactionManager does not support custom isolation levels");
        }
    }

    protected Object doSuspend(Object transaction) {
        if (this.getTransactionManager() == null) {
            throw new TransactionSuspensionNotSupportedException("JtaTransactionManager needs a JTA TransactionManager for suspending a transaction - specify the 'transactionManager' or 'transactionManagerName' property");
        }
        try {
            return this.doJtaSuspend();
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on suspend", ex);
        }
    }

    protected Transaction doJtaSuspend() throws SystemException {
        return this.getTransactionManager().suspend();
    }

    protected void doResume(Object transaction, Object suspendedResources) {
        if (this.getTransactionManager() == null) {
            throw new TransactionSuspensionNotSupportedException("JtaTransactionManager needs a JTA TransactionManager for suspending a transaction - specify the 'transactionManager' or 'transactionManagerName' property");
        }
        try {
            this.doJtaResume((Transaction)suspendedResources);
        }
        catch (InvalidTransactionException ex) {
            throw new IllegalTransactionStateException("Tried to resume invalid JTA transaction", ex);
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on resume", ex);
        }
    }

    protected void doJtaResume(Transaction suspendedTransaction) throws InvalidTransactionException, SystemException {
        this.getTransactionManager().resume(suspendedTransaction);
    }

    protected boolean isRollbackOnly(Object transaction) throws TransactionException {
        try {
            return this.getUserTransaction().getStatus() == 1;
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on getStatus", ex);
        }
    }

    protected void doCommit(DefaultTransactionStatus status) {
        this.logger.debug((Object)"Committing JTA transaction");
        try {
            this.getUserTransaction().commit();
        }
        catch (RollbackException ex) {
            throw new UnexpectedRollbackException("JTA transaction rolled back", ex);
        }
        catch (HeuristicMixedException ex) {
            throw new HeuristicCompletionException(3, (Throwable)ex);
        }
        catch (HeuristicRollbackException ex) {
            throw new HeuristicCompletionException(2, (Throwable)ex);
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on commit", ex);
        }
    }

    protected void doRollback(DefaultTransactionStatus status) {
        this.logger.debug((Object)"Rolling back JTA transaction");
        try {
            this.getUserTransaction().rollback();
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on rollback", ex);
        }
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) {
        if (status.isDebug()) {
            this.logger.debug((Object)"Setting JTA transaction rollback-only");
        }
        try {
            this.getUserTransaction().setRollbackOnly();
        }
        catch (IllegalStateException ex) {
            throw new NoTransactionException("No active JTA transaction");
        }
        catch (SystemException ex) {
            throw new TransactionSystemException("JTA failure on setRollbackOnly", ex);
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        try {
            ois.defaultReadObject();
        }
        catch (ClassNotFoundException ex) {
            throw new AspectException("Failed to deserialize JtaTransactionManager: Check that JTA and Spring transaction libraries are available on the client side", (Throwable)ex);
        }
        this.jndiTemplate = new JndiTemplate();
        this.userTransaction = this.lookupUserTransaction(this.userTransactionName);
    }
}

