/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap.util.xml;

import com.ibm.xmi.framework.WriterFactory;
import com.ibm.xmi.job.Job;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import org.apache.soap.rpc.SOAPContext;
import org.apache.soap.util.Bean;
import org.apache.soap.util.xml.DOMWriter;
import org.apache.soap.util.xml.Deserializer;
import org.apache.soap.util.xml.QName;
import org.apache.soap.util.xml.XMLJavaMappingRegistry;
import org.w3c.dom.Node;

public class XMIDeserializer
implements Deserializer {
    static String XMIheader = "<?xml version='1.0' encoding='UTF-8'?><XMI xmi.version='1.1' timestamp='timestamp temporarily ommitted'><XMI.header><XMI.documentation><XMI.exporter>Java Object Bridge (JOB)</XMI.exporter><XMI.exporterVersion>0.9</XMI.exporterVersion></XMI.documentation></XMI.header><XMI.content>";
    static String XMIend = "</XMI.content></XMI>";

    public Bean unmarshall(String inScopeEncStyle, QName elementType, Node src, XMLJavaMappingRegistry xjmr, SOAPContext ctx) throws IllegalArgumentException {
        String xmlString = DOMWriter.nodeToString(src);
        String document = XMIheader + xmlString + XMIend;
        byte[] bytes = document.getBytes();
        ByteArrayInputStream bs = new ByteArrayInputStream(bytes);
        WriterFactory.setInline((boolean)true);
        Collection objects = Job.readObjects((InputStream)bs);
        try {
            bs.close();
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
        }
        Iterator it = objects.iterator();
        if (it.hasNext()) {
            Object o = it.next();
            return new Bean(o.getClass(), o);
        }
        throw new IllegalArgumentException("Unable to unmarshall XMI-encoded object.");
    }
}

