/*
 * Decompiled with CFR 0.152.
 */
package org.apache.soap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Vector;
import org.apache.soap.Header;
import org.apache.soap.SOAPException;
import org.apache.soap.util.xml.DOM2Writer;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class Utils {
    public static String cleanString(String orig) {
        if (orig == null) {
            return "";
        }
        StringBuffer strBuf = new StringBuffer(orig.length() * 2);
        char[] chars = orig.toCharArray();
        block7: for (int i = 0; i < chars.length; ++i) {
            switch (chars[i]) {
                case '&': {
                    strBuf.append("&amp;");
                    continue block7;
                }
                case '\"': {
                    strBuf.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    strBuf.append("&apos;");
                    continue block7;
                }
                case '<': {
                    strBuf.append("&lt;");
                    continue block7;
                }
                case '>': {
                    strBuf.append("&gt;");
                    continue block7;
                }
                default: {
                    strBuf.append(chars[i]);
                }
            }
        }
        return strBuf.toString();
    }

    public static void marshallNode(Node node, Writer sink) {
        DOM2Writer.serializeAsXML(node, sink);
    }

    public static Vector buildFaultDetailsFromThrowable(Throwable t) {
        Vector<Element> details = new Vector<Element>();
        Document doc = XMLParserUtils.newDocument();
        Element elem = doc.createElement("stackTrace");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        Text tn = doc.createTextNode(Utils.cleanString(sw.toString()));
        elem.appendChild(tn);
        details.addElement(elem);
        return details;
    }

    public static void checkMustUnderstands(Header header) throws SOAPException {
        Vector entries = header.getHeaderEntries();
        for (int i = 0; i < entries.size(); ++i) {
            Element el = (Element)entries.elementAt(i);
            String val = el.getAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand");
            if (val == null || !val.equals("1")) continue;
            throw new SOAPException("mustUnderstand", "Didn't understand header '" + el.getLocalName() + "'");
        }
    }
}

