/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts.apps;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.util.CommandLineLogger;
import org.w3c.dom.Document;

public abstract class AbstractFontReader {
    protected static Log log;
    static /* synthetic */ Class class$org$apache$fop$fonts$apps$AbstractFontReader;

    protected AbstractFontReader() {
        if (log == null) {
            log = LogFactory.getLog(class$org$apache$fop$fonts$apps$AbstractFontReader == null ? (class$org$apache$fop$fonts$apps$AbstractFontReader = AbstractFontReader.class$("org.apache.fop.fonts.apps.AbstractFontReader")) : class$org$apache$fop$fonts$apps$AbstractFontReader);
        }
    }

    protected static String[] parseArguments(Map options, String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        int i = 0;
        while (i < args.length) {
            if (args[i].startsWith("-")) {
                if ("-d".equals(args[i]) || "-q".equals(args[i])) {
                    options.put(args[i], "");
                } else if (i + 1 < args.length && !args[i + 1].startsWith("-")) {
                    options.put(args[i], args[i + 1]);
                    ++i;
                } else {
                    options.put(args[i], "");
                }
            } else {
                arguments.add(args[i]);
            }
            ++i;
        }
        return arguments.toArray(new String[0]);
    }

    protected static void setLogLevel(String level) {
        LogFactory.getFactory().setAttribute("level", level);
        if (log instanceof CommandLineLogger) {
            ((CommandLineLogger)log).setLogLevel(level);
        }
    }

    protected static void determineLogLevel(Map options) {
        if (options.get("-d") != null) {
            AbstractFontReader.setLogLevel("debug");
        } else if (options.get("-q") != null) {
            AbstractFontReader.setLogLevel("error");
        } else {
            AbstractFontReader.setLogLevel("info");
        }
    }

    public void writeFontXML(Document doc, String target) throws TransformerException {
        this.writeFontXML(doc, new File(target));
    }

    public void writeFontXML(Document doc, File target) throws TransformerException {
        log.info("Writing xml font file " + target + "...");
        try {
            OutputStream out = new FileOutputStream(target);
            out = new BufferedOutputStream(out);
            try {
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer();
                transformer.transform(new DOMSource(doc), new StreamResult(out));
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                out.close();
                throw throwable;
            }
            out.close();
            {
            }
        }
        catch (IOException ioe) {
            throw new TransformerException("Error writing the output file", ioe);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

