/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLOutput;
import java.util.Map;
import java.util.Vector;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleType;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.OpaqueDescriptor;
import oracle.sql.OracleJdbc2SQLInput;
import oracle.sql.OracleSQLOutput;
import oracle.sql.SQLName;
import oracle.sql.STRUCT;
import oracle.sql.TypeDescriptor;

public class StructDescriptor
extends TypeDescriptor
implements Serializable {
    static final boolean DEBUG = false;
    static final long serialVersionUID = 1013921343538311063L;
    transient Boolean isInstanciable = null;
    transient String supertype = null;
    transient int numLocalAttrs = -1;
    transient String[] subtypes = null;
    transient String[] attrJavaNames = null;
    final int LOCAL_TYPE = 0;
    final int LOOK_FOR_USER_SYNONYM = 1;
    final int LOOK_FOR_PUBLIC_SYNONYM = 2;
    final String[] initMetaData1_9_0_SQL = new String[]{"SELECT INSTANTIABLE, supertype_owner, supertype_name, LOCAL_ATTRIBUTES FROM all_types WHERE type_name = :1 AND owner = :2 ", "DECLARE \n bind_synonym_name user_synonyms.synonym_name%type := :1; \n the_table_owner  user_synonyms.table_owner%type; \n the_table_name   user_synonyms.table_name%type; \n the_db_link      user_synonyms.db_link%type; \n sql_string       VARCHAR2(1000); \nBEGIN \n   SELECT /*+RULE*/ TABLE_NAME, TABLE_OWNER, DB_LINK INTO  \n         the_table_name, the_table_owner, the_db_link \n         FROM USER_SYNONYMS WHERE \n         SYNONYM_NAME = bind_synonym_name; \n \n   sql_string := 'SELECT /*+RULE*/ INSTANTIABLE, SUPERTYPE_OWNER,      SUPERTYPE_NAME, LOCAL_ATTRIBUTES FROM ALL_TYPES'; \n \n   IF the_db_link IS NOT NULL  \n   THEN \n     sql_string := sql_string || '@' || the_db_link; \n   END IF; \n   sql_string := sql_string       || ' WHERE TYPE_NAME = '''       || the_table_name   || ''' AND OWNER = '''       || the_table_owner  || ''''; \n   OPEN :2 FOR sql_string; \nEND;", "DECLARE \n bind_synonym_name user_synonyms.synonym_name%type := :1; \n the_table_owner  user_synonyms.table_owner%type; \n the_table_name   user_synonyms.table_name%type; \n the_db_link      user_synonyms.db_link%type; \n sql_string       VARCHAR2(1000); \nBEGIN \n   SELECT /*+RULE*/ TABLE_NAME, TABLE_OWNER, DB_LINK INTO  \n         the_table_name, the_table_owner, the_db_link \n         FROM ALL_SYNONYMS WHERE \n         OWNER = 'PUBLIC' AND \n         SYNONYM_NAME = bind_synonym_name; \n \n   sql_string := 'SELECT /*+RULE*/ INSTANTIABLE, SUPERTYPE_OWNER,      SUPERTYPE_NAME, LOCAL_ATTRIBUTES FROM ALL_TYPES'; \n \n   IF the_db_link IS NOT NULL  \n   THEN \n     sql_string := sql_string || '@' || the_db_link; \n   END IF; \n   sql_string := sql_string       || ' WHERE TYPE_NAME = '''       || the_table_name   || ''' AND OWNER = '''       || the_table_owner  || ''''; \n   OPEN :2 FOR sql_string; \nEND;"};
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:18:48_PDT_2005";

    public static StructDescriptor createDescriptor(String string, Connection connection) throws SQLException {
        return StructDescriptor.createDescriptor(string, connection, false, false);
    }

    public static StructDescriptor createDescriptor(String string, Connection connection, boolean bl, boolean bl2) throws SQLException {
        if (string == null || string.length() == 0 || connection == null) {
            DatabaseError.throwSqlException(60, "Invalid arguments");
        }
        SQLName sQLName = new SQLName(string, (oracle.jdbc.OracleConnection)connection);
        return StructDescriptor.createDescriptor(sQLName, connection, bl, bl2);
    }

    public static StructDescriptor createDescriptor(SQLName sQLName, Connection connection, boolean bl, boolean bl2) throws SQLException {
        String string = sQLName.getName();
        StructDescriptor structDescriptor = null;
        if (!bl2 && (structDescriptor = (StructDescriptor)((oracle.jdbc.OracleConnection)connection).getDescriptor(string)) == null) {
            structDescriptor = new StructDescriptor(sQLName, connection);
            if (bl) {
                structDescriptor.initNamesRecursively();
            }
            ((oracle.jdbc.OracleConnection)connection).putDescriptor(string, structDescriptor);
        }
        return structDescriptor;
    }

    public static StructDescriptor createDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        return StructDescriptor.createDescriptor(sQLName, connection, false, false);
    }

    public static StructDescriptor createDescriptor(OracleTypeADT oracleTypeADT) throws SQLException {
        String string = oracleTypeADT.getFullName();
        OracleConnection oracleConnection = oracleTypeADT.getConnection();
        StructDescriptor structDescriptor = (StructDescriptor)oracleConnection.getDescriptor(string);
        if (structDescriptor == null) {
            SQLName sQLName = new SQLName(oracleTypeADT.getSchemaName(), oracleTypeADT.getSimpleName(), oracleTypeADT.getConnection());
            structDescriptor = new StructDescriptor(sQLName, oracleTypeADT, oracleConnection);
            structDescriptor.initNamesRecursively();
            oracleConnection.putDescriptor(string, (Object)structDescriptor);
        }
        return structDescriptor;
    }

    public StructDescriptor(String string, Connection connection) throws SQLException {
        super(string, connection);
        this.initPickler();
    }

    public StructDescriptor(SQLName sQLName, Connection connection) throws SQLException {
        super(sQLName, connection);
        this.initPickler();
    }

    public StructDescriptor(SQLName sQLName, OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super(sQLName, oracleTypeADT, connection);
    }

    static StructDescriptor createDescriptor(SQLName sQLName, byte[] byArray, int n, byte[] byArray2, byte[] byArray3, OracleConnection oracleConnection, byte[] byArray4) throws SQLException {
        OracleTypeADT oracleTypeADT = new OracleTypeADT(sQLName, byArray, n, byArray2, byArray3, oracleConnection, byArray4);
        return new StructDescriptor(sQLName, oracleTypeADT, oracleConnection);
    }

    private void initPickler() throws SQLException {
        try {
            this.pickler = new OracleTypeADT(this.getName(), (Connection)this.connection);
            ((OracleTypeADT)this.pickler).init(this.connection);
            this.pickler.setDescriptor(this);
        }
        catch (Exception exception) {
            if (exception instanceof SQLException) {
                throw (SQLException)exception;
            }
            DatabaseError.throwSqlException(60, "Unable to resolve type \"" + this.getName() + "\"");
        }
    }

    public StructDescriptor(OracleTypeADT oracleTypeADT, Connection connection) throws SQLException {
        super(oracleTypeADT, connection);
    }

    public int getTypeCode() throws SQLException {
        int n = this.pickler.getTypeCode();
        return n;
    }

    public int getTypeVersion() throws SQLException {
        int n = this.pickler.getTypeVersion();
        return n;
    }

    byte[] toBytes(STRUCT sTRUCT, boolean bl) throws SQLException {
        byte[] byArray = sTRUCT.shareBytes();
        if (byArray == null) {
            if (sTRUCT.datumArray != null) {
                byArray = this.pickler.linearize(sTRUCT);
                if (!bl) {
                    sTRUCT.setShareBytes(null);
                }
            } else if (sTRUCT.objectArray != null) {
                sTRUCT.datumArray = this.toOracleArray(sTRUCT.objectArray);
                byArray = this.pickler.linearize(sTRUCT);
                if (!bl) {
                    sTRUCT.datumArray = null;
                    sTRUCT.setShareBytes(null);
                }
            } else {
                DatabaseError.throwSqlException(1);
            }
        } else if (sTRUCT.imageLength != 0L && (sTRUCT.imageOffset != 0L || sTRUCT.imageLength != (long)byArray.length)) {
            byte[] byArray2 = new byte[(int)sTRUCT.imageLength];
            System.arraycopy(byArray, (int)sTRUCT.imageOffset, byArray2, 0, (int)sTRUCT.imageLength);
            sTRUCT.setImage(byArray2, 0L, 0L);
            byArray = byArray2;
        }
        return byArray;
    }

    Datum[] toOracleArray(STRUCT sTRUCT, boolean bl) throws SQLException {
        Datum[] datumArray = sTRUCT.datumArray;
        Datum[] datumArray2 = null;
        if (datumArray == null) {
            if (sTRUCT.objectArray != null) {
                datumArray = this.toOracleArray(sTRUCT.objectArray);
            } else if (sTRUCT.shareBytes() != null) {
                if ((sTRUCT.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
                    this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
                }
                this.pickler.unlinearize(sTRUCT.shareBytes(), sTRUCT.imageOffset, sTRUCT, 1, null);
                datumArray = sTRUCT.datumArray;
                if (!bl) {
                    sTRUCT.datumArray = null;
                }
            } else {
                DatabaseError.throwSqlException(1);
            }
        }
        if (bl) {
            sTRUCT.datumArray = datumArray;
            datumArray2 = (Datum[])datumArray.clone();
        } else {
            datumArray2 = datumArray;
        }
        return datumArray2;
    }

    Object[] toArray(STRUCT sTRUCT, Map map, boolean bl) throws SQLException {
        Object[] objectArray = null;
        if (sTRUCT.objectArray == null) {
            if (sTRUCT.datumArray != null) {
                objectArray = new Object[sTRUCT.datumArray.length];
                for (int i = 0; i < sTRUCT.datumArray.length; ++i) {
                    if (sTRUCT.datumArray[i] == null) continue;
                    objectArray[i] = sTRUCT.datumArray[i] instanceof STRUCT ? ((STRUCT)sTRUCT.datumArray[i]).toJdbc(map) : sTRUCT.datumArray[i].toJdbc();
                }
            } else if (sTRUCT.shareBytes() != null) {
                if ((sTRUCT.shareBytes()[0] & 0x80) <= 0 && ((OracleTypeADT)this.pickler).isEmbeddedADT()) {
                    this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
                }
                this.pickler.unlinearize(sTRUCT.shareBytes(), sTRUCT.imageOffset, sTRUCT, 2, map);
                objectArray = sTRUCT.objectArray;
                sTRUCT.objectArray = null;
            } else {
                DatabaseError.throwSqlException(1);
            }
        } else {
            objectArray = (Object[])sTRUCT.objectArray.clone();
        }
        return objectArray;
    }

    public int getLength() throws SQLException {
        int n = this.getFieldTypes().length;
        return n;
    }

    public OracleTypeADT getOracleTypeADT() {
        OracleTypeADT oracleTypeADT = (OracleTypeADT)this.pickler;
        return oracleTypeADT;
    }

    private OracleType[] getFieldTypes() throws SQLException {
        OracleType[] oracleTypeArray = ((OracleTypeADT)this.pickler).getAttrTypes();
        return oracleTypeArray;
    }

    public SQLInput toJdbc2SQLInput(STRUCT sTRUCT, Map map) throws SQLException {
        OracleJdbc2SQLInput oracleJdbc2SQLInput = new OracleJdbc2SQLInput(this.toOracleArray(sTRUCT, false), map, this.connection);
        return oracleJdbc2SQLInput;
    }

    public SQLOutput toJdbc2SQLOutput() throws SQLException {
        OracleSQLOutput oracleSQLOutput = new OracleSQLOutput(this, this.connection);
        return oracleSQLOutput;
    }

    public Datum[] toOracleArray(Object[] objectArray) throws SQLException {
        Datum[] datumArray = null;
        if (objectArray != null) {
            OracleType[] oracleTypeArray = this.getFieldTypes();
            int n = oracleTypeArray.length;
            if (objectArray.length != n) {
                DatabaseError.throwSqlException(49, null);
            }
            datumArray = new Datum[n];
            OracleConnection oracleConnection = this.connection;
            for (int i = 0; i < n; ++i) {
                datumArray[i] = oracleTypeArray[i].toDatum(objectArray[i], oracleConnection);
            }
        }
        return datumArray;
    }

    public Datum[] toOracleArray(Map map) throws SQLException {
        Datum[] datumArray = null;
        int n = 0;
        if (map != null) {
            OracleType[] oracleTypeArray = this.getFieldTypes();
            int n2 = oracleTypeArray.length;
            int n3 = map.size();
            datumArray = new Datum[n2];
            OracleConnection oracleConnection = this.connection;
            for (int i = 0; i < n2; ++i) {
                Object v = map.get(((OracleTypeADT)this.pickler).getAttributeName(i + 1));
                datumArray[i] = oracleTypeArray[i].toDatum(v, oracleConnection);
                if (v == null && !map.containsKey(((OracleTypeADT)this.pickler).getAttributeName(i + 1))) continue;
                ++n;
            }
            if (n < n3) {
                DatabaseError.throwSqlException(68, null);
            }
        }
        return datumArray;
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        ResultSetMetaData resultSetMetaData = this.connection.newStructMetaData(this);
        return resultSetMetaData;
    }

    public boolean isFinalType() throws SQLException {
        boolean bl = this.getOracleTypeADT().isFinalType();
        return bl;
    }

    public boolean isSubtype() throws SQLException {
        boolean bl = this.getOracleTypeADT().isSubType();
        return bl;
    }

    public boolean isInHierarchyOf(String string) throws SQLException {
        StructDescriptor structDescriptor = this;
        String string2 = structDescriptor.getName();
        boolean bl = false;
        if (string.equals(string2)) {
            bl = true;
        } else {
            while (true) {
                if ((string2 = structDescriptor.getSupertypeName()) == null) {
                    bl = false;
                    break;
                }
                if (string.equals(string2)) {
                    bl = true;
                    break;
                }
                structDescriptor = StructDescriptor.createDescriptor(string2, (Connection)this.connection);
            }
        }
        return bl;
    }

    public boolean isInstantiable() throws SQLException {
        if (this.isInstanciable == null) {
            this.initMetaData1();
        }
        boolean bl = this.isInstanciable;
        return bl;
    }

    public boolean isJavaObject() throws SQLException {
        boolean bl = this.getOracleTypeADT().isJavaObject();
        return bl;
    }

    public String getSupertypeName() throws SQLException {
        String string = null;
        if (this.isSubtype()) {
            if (this.supertype == null) {
                this.initMetaData1();
            }
            string = this.supertype;
        }
        return string;
    }

    public int getLocalAttributeCount() throws SQLException {
        int n;
        if (!this.isSubtype()) {
            n = this.getOracleTypeADT().getAttrTypes().length;
        } else {
            if (this.numLocalAttrs == -1) {
                this.initMetaData1();
            }
            n = this.numLocalAttrs;
        }
        return n;
    }

    public String[] getSubtypeNames() throws SQLException {
        if (this.subtypes == null) {
            this.initMetaData2();
        }
        return this.subtypes;
    }

    public String getJavaClassName() throws SQLException {
        String string = null;
        if (this.isJavaObject()) {
            string = StructDescriptor.getJavaObjectClassName(this.connection, this);
        }
        return string;
    }

    public String getAttributeJavaName(int n) throws SQLException {
        String string = null;
        if (this.isJavaObject()) {
            if (this.attrJavaNames == null) {
                this.initMetaData3();
            }
            string = this.attrJavaNames[n];
        }
        return string;
    }

    public String[] getAttributeJavaNames() throws SQLException {
        String[] stringArray = null;
        if (this.isJavaObject()) {
            if (this.attrJavaNames == null) {
                this.initMetaData3();
            }
            stringArray = this.attrJavaNames;
        } else {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public String getLanguage() throws SQLException {
        String string = null;
        string = this.isJavaObject() ? "JAVA" : "SQL";
        return string;
    }

    public Class getClass(Map map) throws SQLException {
        String string = this.getName();
        Class clazz = (Class)map.get(string);
        String string2 = this.getSchemaName();
        String string3 = this.getTypeName();
        if (clazz == null && this.connection.getUserName().equals(string2)) {
            clazz = (Class)map.get(string3);
        }
        if (SQLName.s_parseAllFormat) {
            if (clazz == null && this.connection.getUserName().equals(string2)) {
                clazz = (Class)map.get("\"" + string3 + "\"");
            }
            if (clazz == null) {
                clazz = (Class)map.get("\"" + string2 + "\"" + "." + "\"" + string3 + "\"");
            }
            if (clazz == null) {
                clazz = (Class)map.get("\"" + string2 + "\"" + "." + string3);
            }
            if (clazz == null) {
                clazz = (Class)map.get(string2 + "." + "\"" + string3 + "\"");
            }
        }
        return clazz;
    }

    public static String getJavaObjectClassName(Connection connection, StructDescriptor structDescriptor) throws SQLException {
        String string = StructDescriptor.getJavaObjectClassName(connection, structDescriptor.getSchemaName(), structDescriptor.getTypeName());
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getJavaObjectClassName(Connection connection, String string, String string2) throws SQLException {
        String string3;
        PreparedStatement preparedStatement;
        block10: {
            preparedStatement = null;
            ResultSet resultSet = null;
            string3 = null;
            try {
                try {
                    preparedStatement = connection.prepareStatement("select external_name from all_sqlj_types where owner = :1 and type_name = :2");
                    preparedStatement.setString(1, string);
                    preparedStatement.setString(2, string2);
                    resultSet = preparedStatement.executeQuery();
                    if (resultSet.next()) {
                        string3 = resultSet.getString(1);
                    } else {
                        DatabaseError.throwSqlException(100);
                    }
                }
                catch (SQLException sQLException) {
                    Object var8_7 = null;
                    if (resultSet != null) {
                        resultSet.close();
                    }
                    if (preparedStatement == null) return string3;
                    preparedStatement.close();
                    return string3;
                }
                Object var8_6 = null;
                if (resultSet == null) break block10;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement == null) throw throwable;
                preparedStatement.close();
                throw throwable;
            }
            resultSet.close();
        }
        if (preparedStatement == null) return string3;
        preparedStatement.close();
        return string3;
    }

    public String descType() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        return this.descType(stringBuffer, 0);
    }

    String descType(StringBuffer stringBuffer, int n) throws SQLException {
        String string = "";
        for (int i = 0; i < n; ++i) {
            string = string + "  ";
        }
        String string2 = string + "  ";
        stringBuffer.append(string);
        stringBuffer.append(this.getTypeName());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("Subtype=" + this.getOracleTypeADT().isSubType());
        stringBuffer.append(" JavaObject=" + this.getOracleTypeADT().isJavaObject());
        stringBuffer.append(" FinalType=" + this.getOracleTypeADT().isFinalType());
        stringBuffer.append("\n");
        ResultSetMetaData resultSetMetaData = this.getMetaData();
        int n2 = resultSetMetaData.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            TypeDescriptor typeDescriptor;
            int n3 = resultSetMetaData.getColumnType(i + 1);
            if (n3 == 2002 || n3 == 2008) {
                typeDescriptor = StructDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(i + 1), (Connection)this.connection);
                ((StructDescriptor)typeDescriptor).descType(stringBuffer, n + 1);
                continue;
            }
            if (n3 == 2003) {
                typeDescriptor = ArrayDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(i + 1), (Connection)this.connection);
                ((ArrayDescriptor)typeDescriptor).descType(stringBuffer, n + 1);
                continue;
            }
            if (n3 == 2007) {
                typeDescriptor = OpaqueDescriptor.createDescriptor(resultSetMetaData.getColumnTypeName(i + 1), (Connection)this.connection);
                ((OpaqueDescriptor)typeDescriptor).descType(stringBuffer, n + 1);
                continue;
            }
            stringBuffer.append(string2);
            stringBuffer.append(resultSetMetaData.getColumnTypeName(i + 1));
            stringBuffer.append("\n");
        }
        String string3 = stringBuffer.substring(0, stringBuffer.length());
        return string3;
    }

    public byte[] toBytes(Object[] objectArray) throws SQLException {
        Datum[] datumArray = this.toOracleArray(objectArray);
        return this.toBytes(datumArray);
    }

    public byte[] toBytes(Datum[] datumArray) throws SQLException {
        STRUCT sTRUCT = new STRUCT(this, (byte[])null, this.connection);
        sTRUCT.setDatumArray(datumArray);
        return this.pickler.linearize(sTRUCT);
    }

    public Datum[] toArray(Object[] objectArray) throws SQLException {
        return this.toOracleArray(objectArray);
    }

    public Datum[] toArray(byte[] byArray) throws SQLException {
        STRUCT sTRUCT = new STRUCT(this, byArray, this.connection);
        return this.toOracleArray(sTRUCT, false);
    }

    private void initMetaData1() throws SQLException {
        short s = this.connection.getVersionNumber();
        if (s >= 9000) {
            this.initMetaData1_9_0();
        } else {
            this.initMetaData1_pre_9_0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData1_9_0() throws SQLException {
        block25: {
            int n = 0;
            OracleConnection oracleConnection = this.connection;
            synchronized (oracleConnection) {
                StructDescriptor structDescriptor = this;
                synchronized (structDescriptor) {
                    int n2;
                    OracleCallableStatement oracleCallableStatement;
                    PreparedStatement preparedStatement;
                    block24: {
                        if (this.numLocalAttrs != -1) break block25;
                        preparedStatement = null;
                        oracleCallableStatement = null;
                        ResultSet resultSet = null;
                        n2 = -1;
                        try {
                            block14: while (true) {
                                switch (n) {
                                    case 0: {
                                        preparedStatement = this.connection.prepareStatement(this.initMetaData1_9_0_SQL[n]);
                                        preparedStatement.setString(1, this.getTypeName());
                                        preparedStatement.setString(2, this.getSchemaName());
                                        preparedStatement.setFetchSize(1);
                                        resultSet = preparedStatement.executeQuery();
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        try {
                                            oracleCallableStatement = (OracleCallableStatement)this.connection.prepareCall(this.initMetaData1_9_0_SQL[n]);
                                            oracleCallableStatement.setString(1, this.getTypeName());
                                            oracleCallableStatement.registerOutParameter(2, -10);
                                            oracleCallableStatement.execute();
                                            resultSet = oracleCallableStatement.getCursor(2);
                                            resultSet.setFetchSize(1);
                                            break;
                                        }
                                        catch (SQLException sQLException) {
                                            if (sQLException.getErrorCode() == 1403) {
                                                if (n == 1) {
                                                    oracleCallableStatement.close();
                                                    ++n;
                                                    continue block14;
                                                }
                                                DatabaseError.throwSqlException(1, "Inconsistent catalog view");
                                                break;
                                            }
                                            throw sQLException;
                                        }
                                    }
                                }
                                if (resultSet.next()) break;
                                if (n == 2) {
                                    DatabaseError.throwSqlException(1, "Inconsistent catalog view");
                                    continue;
                                }
                                resultSet.close();
                                if (oracleCallableStatement != null) {
                                    oracleCallableStatement.close();
                                }
                                ++n;
                            }
                            this.isInstanciable = new Boolean(resultSet.getString(1).equals("YES"));
                            this.supertype = resultSet.getString(2) + "." + resultSet.getString(3);
                            n2 = resultSet.getInt(4);
                            Object var10_9 = null;
                            if (resultSet == null) break block24;
                        }
                        catch (Throwable throwable) {
                            Object var10_10 = null;
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                            if (oracleCallableStatement != null) {
                                oracleCallableStatement.close();
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    if (oracleCallableStatement != null) {
                        oracleCallableStatement.close();
                    }
                    this.numLocalAttrs = n2;
                }
            }
        }
    }

    private synchronized void initMetaData1_pre_9_0() throws SQLException {
        this.isInstanciable = new Boolean(true);
        this.supertype = "";
        this.numLocalAttrs = 0;
    }

    private void initMetaData2() throws SQLException {
        short s = this.connection.getVersionNumber();
        if (s >= 9000) {
            this.initMetaData2_9_0();
        } else {
            this.initMetaData2_pre_9_0();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData2_9_0() throws SQLException {
        block14: {
            OracleConnection oracleConnection = this.connection;
            synchronized (oracleConnection) {
                StructDescriptor structDescriptor = this;
                synchronized (structDescriptor) {
                    String[] stringArray;
                    PreparedStatement preparedStatement;
                    block13: {
                        if (this.subtypes != null) break block14;
                        preparedStatement = null;
                        ResultSet resultSet = null;
                        stringArray = null;
                        try {
                            preparedStatement = this.connection.prepareStatement("select owner, type_name from all_types where supertype_name = :1 and supertype_owner = :2");
                            preparedStatement.setString(1, this.getTypeName());
                            preparedStatement.setString(2, this.getSchemaName());
                            resultSet = preparedStatement.executeQuery();
                            Vector<String> vector = new Vector<String>();
                            while (resultSet.next()) {
                                vector.addElement(resultSet.getString(1) + "." + resultSet.getString(2));
                            }
                            stringArray = new String[vector.size()];
                            for (int i = 0; i < stringArray.length; ++i) {
                                stringArray[i] = (String)vector.elementAt(i);
                            }
                            vector.removeAllElements();
                            vector = null;
                            Object var9_8 = null;
                            if (resultSet == null) break block13;
                        }
                        catch (Throwable throwable) {
                            Object var9_9 = null;
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    this.subtypes = stringArray;
                }
            }
        }
    }

    private void initMetaData2_pre_9_0() throws SQLException {
        this.subtypes = new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMetaData3() throws SQLException {
        block13: {
            OracleConnection oracleConnection = this.connection;
            synchronized (oracleConnection) {
                StructDescriptor structDescriptor = this;
                synchronized (structDescriptor) {
                    PreparedStatement preparedStatement;
                    String[] stringArray;
                    block12: {
                        if (this.attrJavaNames != null) break block13;
                        stringArray = null;
                        preparedStatement = null;
                        ResultSet resultSet = null;
                        try {
                            preparedStatement = this.connection.prepareStatement("select EXTERNAL_ATTR_NAME from all_sqlj_type_attrs where owner = :1 and type_name = :2");
                            preparedStatement.setString(1, this.getSchemaName());
                            preparedStatement.setString(2, this.getTypeName());
                            resultSet = preparedStatement.executeQuery();
                            stringArray = new String[this.getOracleTypeADT().getAttrTypes().length];
                            int n = 0;
                            while (resultSet.next()) {
                                stringArray[n] = resultSet.getString(1);
                                ++n;
                            }
                            Object var8_7 = null;
                            if (resultSet == null) break block12;
                        }
                        catch (Throwable throwable) {
                            Object var8_8 = null;
                            if (resultSet != null) {
                                resultSet.close();
                            }
                            if (preparedStatement != null) {
                                preparedStatement.close();
                            }
                            throw throwable;
                        }
                        resultSet.close();
                    }
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                    this.attrJavaNames = stringArray;
                }
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
    }
}

