/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.oracore.PickleOutputStream;

public final class PickleContext {
    private PickleOutputStream outStream;
    byte[] image;
    int imageOffset;
    private byte[] lengthBuffer = new byte[5];
    static short KOPI20_LN_ELNL = (short)255;
    static short KOPI20_LN_5BLN = (short)254;
    static short KOPI20_LN_ATMN = (short)253;
    static short KOPI20_LN_IEMN = (short)252;
    static short KOPI20_LN_MAXV = (short)245;
    static short KOPI20_IF_IS81 = (short)128;
    static short KOPI20_IF_CMSB = (short)64;
    static short KOPI20_IF_CLSB = (short)32;
    static short KOPI20_IF_DEGN = (short)16;
    static short KOPI20_IF_COLL = (short)8;
    static short KOPI20_IF_NOPS = (short)4;
    static short KOPI20_IF_ANY = (short)2;
    static short KOPI20_IF_NONL = 1;
    static short KOPI20_CF_CMSB = (short)64;
    static short KOPI20_CF_CLSB = (short)32;
    static short KOPI20_CF_INDX = (short)16;
    static short KOPI20_CF_NOLN = (short)8;
    static short KOPI20_VERSION = 1;
    static final byte KOPUP_INLINE_COLL = 1;
    static final byte KOPUP_TYPEINFO_NONE = 0;
    static final byte KOPUP_TYPEINFO_TOID = 4;
    static final byte KOPUP_TYPEINFO_TOBJN = 8;
    static final byte KOPUP_TYPEINFO_TDS = 12;
    static final byte KOPUP_VSN_PRESENT = 16;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:18:49_PDT_2005";

    public PickleContext() {
    }

    public PickleContext(byte[] byArray) {
        this.image = byArray;
        this.imageOffset = 0;
    }

    public PickleContext(byte[] byArray, long l) {
        this.image = byArray;
        this.imageOffset = (int)l;
    }

    public void initStream(int n) {
        this.outStream = new PickleOutputStream(n);
    }

    public void initStream() {
        this.outStream = new PickleOutputStream();
    }

    public int lengthInBytes(int n) {
        return n <= KOPI20_LN_MAXV ? 1 : 5;
    }

    public int writeElementNull() throws SQLException {
        this.outStream.write(KOPI20_LN_ELNL);
        return 1;
    }

    public int writeAtomicNull() throws SQLException {
        this.outStream.write(KOPI20_LN_ATMN);
        return 1;
    }

    public int writeImmediatelyEmbeddedElementNull(byte by) throws SQLException {
        this.lengthBuffer[0] = (byte)KOPI20_LN_IEMN;
        this.lengthBuffer[1] = by;
        this.outStream.write(this.lengthBuffer, 0, 2);
        return 2;
    }

    public int writeLength(int n) throws SQLException {
        if (n <= KOPI20_LN_MAXV) {
            this.outStream.write((byte)n);
            return 1;
        }
        this.lengthBuffer[0] = (byte)KOPI20_LN_5BLN;
        this.lengthBuffer[1] = (byte)(n >> 24);
        this.lengthBuffer[2] = (byte)((n &= 0xFFFFFF) >> 16);
        this.lengthBuffer[3] = (byte)((n &= 0xFFFF) >> 8);
        this.lengthBuffer[4] = (byte)(n &= 0xFF);
        try {
            this.outStream.write(this.lengthBuffer);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        return 5;
    }

    public int writeLength(int n, boolean bl) throws SQLException {
        if (!bl) {
            return this.writeLength(n);
        }
        if (n <= KOPI20_LN_MAXV - 1) {
            this.outStream.write((byte)n + 1);
            return 1;
        }
        this.lengthBuffer[0] = (byte)KOPI20_LN_5BLN;
        this.lengthBuffer[1] = (byte)((n += 5) >> 24);
        this.lengthBuffer[2] = (byte)((n &= 0xFFFFFF) >> 16);
        this.lengthBuffer[3] = (byte)((n &= 0xFFFF) >> 8);
        this.lengthBuffer[4] = (byte)(n &= 0xFF);
        try {
            this.outStream.write(this.lengthBuffer);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        return 5;
    }

    public byte[] to5bLengthBytes_pctx(int n) throws SQLException {
        this.lengthBuffer[0] = (byte)KOPI20_LN_5BLN;
        this.lengthBuffer[1] = (byte)(n >> 24);
        this.lengthBuffer[2] = (byte)((n &= 0xFFFFFF) >> 16);
        this.lengthBuffer[3] = (byte)((n &= 0xFFFF) >> 8);
        this.lengthBuffer[4] = (byte)(n &= 0xFF);
        return this.lengthBuffer;
    }

    public int writeData(byte by) throws SQLException {
        this.outStream.write(by);
        return 1;
    }

    public int writeData(byte[] byArray) throws SQLException {
        try {
            this.outStream.write(byArray);
        }
        catch (IOException iOException) {
            DatabaseError.throwSqlException(iOException);
        }
        return byArray.length;
    }

    public void patchImageLen(int n, int n2) throws SQLException {
        byte[] byArray = this.to5bLengthBytes_pctx(n2);
        this.outStream.overwrite(n, byArray, 0, byArray.length);
    }

    public int writeImageHeader(boolean bl) throws SQLException {
        return this.writeImageHeader(KOPI20_LN_MAXV + 1, bl);
    }

    public int writeOpaqueImageHeader(int n) throws SQLException {
        int n2 = 2;
        this.lengthBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS | KOPI20_IF_NONL);
        this.lengthBuffer[1] = (byte)KOPI20_VERSION;
        this.outStream.write(this.lengthBuffer, 0, 2);
        return n2 += this.writeLength(n + 2, true);
    }

    public int writeImageHeader(int n, boolean bl) throws SQLException {
        int n2 = 2;
        this.lengthBuffer[0] = bl ? (byte)KOPI20_IF_IS81 : (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS);
        this.lengthBuffer[1] = (byte)KOPI20_VERSION;
        this.outStream.write(this.lengthBuffer, 0, 2);
        return n2 += this.writeLength(n);
    }

    public int writeCollImageHeader(int n) throws SQLException {
        return this.writeCollImageHeader(KOPI20_LN_MAXV + 1, n);
    }

    public int writeCollImageHeader(int n, int n2) throws SQLException {
        int n3 = 5;
        this.lengthBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_COLL);
        this.lengthBuffer[1] = (byte)KOPI20_VERSION;
        this.outStream.write(this.lengthBuffer, 0, 2);
        n3 += this.writeLength(n);
        this.lengthBuffer[0] = 1;
        this.lengthBuffer[1] = 1;
        this.outStream.write(this.lengthBuffer, 0, 2);
        this.lengthBuffer[0] = 0;
        this.outStream.write(this.lengthBuffer, 0, 1);
        return n3 += this.writeLength(n2);
    }

    public int writeCollImageHeader(byte[] byArray) throws SQLException {
        return this.writeCollImageHeader(KOPI20_LN_MAXV + 1, byArray);
    }

    public int writeCollImageHeader(int n, byte[] byArray) throws SQLException {
        int n2 = byArray.length;
        int n3 = 3 + n2;
        this.lengthBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_DEGN);
        this.lengthBuffer[1] = (byte)KOPI20_VERSION;
        this.outStream.write(this.lengthBuffer, 0, 2);
        n3 += this.writeLength(n);
        this.lengthBuffer[0] = 0;
        this.outStream.write(this.lengthBuffer, 0, 1);
        this.outStream.write(byArray, 0, n2);
        return n3 += this.writeLength(n2 + 1);
    }

    public byte[] stream2Bytes() throws SQLException {
        return this.outStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte readByte() throws SQLException {
        try {
            byte by = this.image[this.imageOffset];
            return by;
        }
        finally {
            ++this.imageOffset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readAndCheckVersion() throws SQLException {
        try {
            boolean bl = (this.image[this.imageOffset] & 0xFF) <= KOPI20_VERSION;
            return bl;
        }
        finally {
            ++this.imageOffset;
        }
    }

    public int readLength() throws SQLException {
        int n = this.image[this.imageOffset] & 0xFF;
        if (n > KOPI20_LN_MAXV) {
            if (n == KOPI20_LN_ELNL) {
                DatabaseError.throwSqlException(1, "Invalid null flag read");
            }
            n = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
            this.imageOffset += 5;
        } else {
            ++this.imageOffset;
        }
        return n;
    }

    public void skipLength() throws SQLException {
        int n = this.image[this.imageOffset] & 0xFF;
        this.imageOffset = n > KOPI20_LN_MAXV ? (this.imageOffset += 5) : ++this.imageOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readRestOfLength(byte by) throws SQLException {
        if ((by & 0xFF) != KOPI20_LN_5BLN) {
            return by & 0xFF;
        }
        try {
            int n = (((this.image[this.imageOffset] & 0xFF) * 256 + (this.image[this.imageOffset + 1] & 0xFF)) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF);
            return n;
        }
        finally {
            this.imageOffset += 4;
        }
    }

    public void skipRestOfLength(byte by) throws SQLException {
        if ((by & 0xFF) > KOPI20_LN_MAXV) {
            if ((by & 0xFF) == KOPI20_LN_5BLN) {
                this.imageOffset += 4;
            } else {
                DatabaseError.throwSqlException(1, "Invalid first length byte");
            }
        }
    }

    public int readLength(boolean bl) throws SQLException {
        int n = this.image[this.imageOffset] & 0xFF;
        if (n > KOPI20_LN_MAXV) {
            n = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
            if (bl) {
                n -= 5;
            }
            this.imageOffset += 5;
        } else {
            if (bl) {
                --n;
            }
            ++this.imageOffset;
        }
        return n;
    }

    public byte[] readPrefixSegment() throws SQLException {
        byte[] byArray = new byte[this.readLength()];
        System.arraycopy(this.image, this.imageOffset, byArray, 0, byArray.length);
        this.imageOffset += byArray.length;
        return byArray;
    }

    public byte[] readDataValue() throws SQLException {
        int n = this.image[this.imageOffset] & 0xFF;
        if (n == KOPI20_LN_ELNL) {
            ++this.imageOffset;
            return null;
        }
        if (n > KOPI20_LN_MAXV) {
            n = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
            this.imageOffset += 5;
        } else {
            ++this.imageOffset;
        }
        byte[] byArray = new byte[n];
        System.arraycopy(this.image, this.imageOffset, byArray, 0, byArray.length);
        this.imageOffset += byArray.length;
        return byArray;
    }

    public byte[] readBytes(int n) throws SQLException {
        byte[] byArray = new byte[n];
        System.arraycopy(this.image, this.imageOffset, byArray, 0, n);
        this.imageOffset += n;
        return byArray;
    }

    public byte[] read1ByteDataValue() throws SQLException {
        if ((this.image[this.imageOffset] & 0xFF) == KOPI20_LN_ELNL) {
            return null;
        }
        byte[] byArray = new byte[this.image[this.imageOffset] & 0xFF];
        System.arraycopy(this.image, this.imageOffset + 1, byArray, 0, byArray.length);
        this.imageOffset += byArray.length + 1;
        return byArray;
    }

    public byte[] readDataValue(byte by) throws SQLException {
        byte[] byArray = new byte[this.readRestOfLength(by)];
        System.arraycopy(this.image, this.imageOffset, byArray, 0, byArray.length);
        this.imageOffset += byArray.length;
        return byArray;
    }

    public byte[] readDataValue(int n) throws SQLException {
        byte[] byArray = new byte[n];
        System.arraycopy(this.image, this.imageOffset, byArray, 0, n);
        this.imageOffset += n;
        return byArray;
    }

    public void skipDataValue() throws SQLException {
        if ((this.image[this.imageOffset] & 0xFF) == KOPI20_LN_ELNL) {
            ++this.imageOffset;
        } else {
            this.skipBytes(this.readLength());
        }
    }

    public void skipDataValue(byte by) throws SQLException {
        this.skipBytes(this.readRestOfLength(by));
    }

    public void skipBytes(int n) throws SQLException {
        if (n > 0) {
            this.imageOffset += n;
        }
    }

    public int offset() throws SQLException {
        if (this.outStream != null) {
            return this.outStream.offset();
        }
        return this.imageOffset;
    }

    public int absoluteOffset() throws SQLException {
        return this.imageOffset;
    }

    public void skipTo(long l) throws SQLException {
        if (l > (long)this.imageOffset) {
            this.imageOffset = (int)l;
        }
    }

    public byte[] image() throws SQLException {
        return this.image;
    }

    public static boolean is81format(byte by) throws SQLException {
        return (by & 0xFF & KOPI20_IF_IS81) != 0;
    }

    public static boolean isCollectionImage_pctx(byte by) throws SQLException {
        return (by & 0xFF & KOPI20_IF_COLL) != 0;
    }

    public static boolean isDegenerateImage_pctx(byte by) throws SQLException {
        return (by & 0xFF & KOPI20_IF_DEGN) != 0;
    }

    public static boolean hasPrefix(byte by) throws SQLException {
        return (by & 0xFF & KOPI20_IF_NOPS) == 0;
    }

    public static boolean isAtomicNull(byte by) throws SQLException {
        return (by & 0xFF) == KOPI20_LN_ATMN;
    }

    public static boolean isImmediatelyEmbeddedNull(byte by) throws SQLException {
        return (by & 0xFF) == KOPI20_LN_IEMN;
    }

    public static boolean isElementNull(byte by) throws SQLException {
        return (by & 0xFF) == KOPI20_LN_ELNL;
    }
}

